/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeback.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.fin.ArMaterialEntryDisposer;
import kd.fi.arapcommon.service.fin.ArPlanEntryDisposer;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.writeback.WriteBackerFactory;
import kd.fi.arapcommon.service.writeback.bill.DisposerInfo;
import kd.fi.arapcommon.service.writeback.decorate.IFinEntryWriteBacker;

public class FinArLockWBServiceHelper {
    private static final Log logger = LogFactory.getLog(FinArLockWBServiceHelper.class);

    public static void directWriteBack(Set<Long> finArBillIds, Map<Long, DisposerInfo> disposerInfoMap) {
        FinArLockWBServiceHelper.writeBack(finArBillIds, disposerInfoMap, true);
    }

    public static void inverseWriteBack(Set<Long> finArBillIds, Map<Long, DisposerInfo> disposerInfoMap) {
        FinArLockWBServiceHelper.writeBack(finArBillIds, disposerInfoMap, false);
    }

    private static void writeBack(Set<Long> finArBillIds, Map<Long, DisposerInfo> disposerInfoMap, boolean isDirect) {
        Long orgId;
        DynamicObject finBill;
        DynamicObject[] arBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", FinArBillHandleHelper.getLockWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)finArBillIds.toArray())});
        logger.info("FinArLockWBServiceHelper.writeBack load bill size : " + arBills.length);
        if (arBills.length == 0) {
            return;
        }
        HashMap<Long, DynamicObject> arBillOldMap = new HashMap<Long, DynamicObject>(8);
        HashMap<Long, DynamicObject> arBillNewMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject arBill : arBills) {
            boolean bl = SettleVersionServiceHelper.isOldVersion(arBill);
            if (bl) {
                arBillOldMap.put(arBill.getLong("id"), arBill);
                continue;
            }
            arBillNewMap.put(arBill.getLong("id"), arBill);
        }
        Set<Long> orgIds = Arrays.stream(arBills).map(bill -> bill.getLong("org.id")).collect(Collectors.toSet());
        Map<Long, Integer> settleParamMap = ArApHelper.batchGetArSettleParam(orgIds);
        if (arBillOldMap.size() > 0) {
            logger.info("FinArLockWBServiceHelper.writeBack olddata");
            HashMap<Long, BigDecimal> planEntryWriteBackAmtMap = new HashMap<Long, BigDecimal>(8);
            ArMaterialEntryDisposer detailEntryDiposer = new ArMaterialEntryDisposer();
            ArPlanEntryDisposer arPlanEntryDisposer = new ArPlanEntryDisposer();
            for (Map.Entry<Long, DisposerInfo> entry : disposerInfoMap.entrySet()) {
                Long sourceId;
                DisposerInfo disposerInfo = entry.getValue();
                BigDecimal disposeAmt = disposerInfo.getDisposeAmt();
                if (disposeAmt.compareTo(BigDecimal.ZERO) == 0 || (finBill = (DynamicObject)arBillOldMap.get(sourceId = disposerInfo.getSourceId())) == null) continue;
                orgId = finBill.getLong("org.id");
                if (settleParamMap.get(orgId) == 1) {
                    planEntryWriteBackAmtMap.merge(sourceId, disposeAmt, (a, b) -> b.add((BigDecimal)a));
                    continue;
                }
                if (isDirect) {
                    detailEntryDiposer.saveDispose(finBill, disposeAmt);
                    continue;
                }
                detailEntryDiposer.deleteDispose(finBill, disposeAmt);
            }
            for (Map.Entry<Long, DisposerInfo> entry : planEntryWriteBackAmtMap.entrySet()) {
                if (isDirect) {
                    arPlanEntryDisposer.saveDispose((DynamicObject)arBillOldMap.get(entry.getKey()), (BigDecimal)((Object)entry.getValue()));
                    continue;
                }
                arPlanEntryDisposer.deleteDispose((DynamicObject)arBillOldMap.get(entry.getKey()), (BigDecimal)((Object)entry.getValue()));
            }
            SaveServiceHelper.save((DynamicObject[])arBillOldMap.values().toArray(new DynamicObject[0]));
        }
        if (arBillNewMap.size() > 0) {
            logger.info("FinArLockWBServiceHelper.writeBack newdata");
            HashMap<Long, BigDecimal> sourceEntryIdToWriteBackAmtMap = new HashMap<Long, BigDecimal>(8);
            for (Map.Entry entry : disposerInfoMap.entrySet()) {
                DisposerInfo disposerInfo = (DisposerInfo)entry.getValue();
                BigDecimal bigDecimal = disposerInfo.getDisposeAmt();
                if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) continue;
                Long sourceId = disposerInfo.getSourceId();
                Long sourceEntryId = disposerInfo.getSourceEntryId();
                DynamicObject finBill2 = (DynamicObject)arBillNewMap.get(sourceId);
                if (finBill2 == null) continue;
                sourceEntryIdToWriteBackAmtMap.merge(sourceEntryId, bigDecimal, (a, b) -> b.add((BigDecimal)a));
            }
            HashMap billToDimensionToNeedWriteBackAmtMap = new HashMap(8);
            HashMap hashMap = new HashMap(8);
            for (Map.Entry entry : arBillNewMap.entrySet()) {
                Object planEntry32;
                long dimensionId;
                BigDecimal writeBackAmt;
                DynamicObject finBill3 = (DynamicObject)entry.getValue();
                HashMap<Long, BigDecimal> dimensionToNeedWriteBackAmtMap = new HashMap<Long, BigDecimal>(8);
                billToDimensionToNeedWriteBackAmtMap.put(finBill3.getLong("id"), dimensionToNeedWriteBackAmtMap);
                HashMap<Long, List> needWriteBackEntriesByDimension = new HashMap<Long, List>(8);
                hashMap.put(finBill3.getLong("id"), needWriteBackEntriesByDimension);
                Long orgId2 = finBill3.getLong("org.id");
                if (settleParamMap.get(orgId2) == 1) {
                    Object detailEntry22;
                    DynamicObjectCollection detailEntries = finBill3.getDynamicObjectCollection("entry");
                    for (Object detailEntry22 : detailEntries) {
                        long entryId = detailEntry22.getLong("id");
                        writeBackAmt = (BigDecimal)sourceEntryIdToWriteBackAmtMap.get(entryId);
                        if (writeBackAmt == null || writeBackAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                        long dimensionId2 = detailEntry22.getLong("e_splitdimensionid");
                        dimensionToNeedWriteBackAmtMap.merge(dimensionId2, writeBackAmt, (a, b) -> b.add((BigDecimal)a));
                    }
                    Iterator planEntries = finBill3.getDynamicObjectCollection("planentity");
                    detailEntry22 = planEntries.iterator();
                    while (detailEntry22.hasNext()) {
                        DynamicObject planEntry2 = (DynamicObject)detailEntry22.next();
                        dimensionId = planEntry2.getLong("p_splitdimensionid");
                        if (dimensionToNeedWriteBackAmtMap.get(dimensionId) == null) continue;
                        List writeBackEntries = needWriteBackEntriesByDimension.getOrDefault(dimensionId, new ArrayList(8));
                        writeBackEntries.add(planEntry2);
                        needWriteBackEntriesByDimension.put(dimensionId, writeBackEntries);
                    }
                    continue;
                }
                DynamicObjectCollection planEntries = finBill3.getDynamicObjectCollection("planentity");
                for (Object planEntry32 : planEntries) {
                    long entryId = planEntry32.getLong("id");
                    writeBackAmt = (BigDecimal)sourceEntryIdToWriteBackAmtMap.get(entryId);
                    if (writeBackAmt == null || writeBackAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    long dimensionId3 = planEntry32.getLong("p_splitdimensionid");
                    dimensionToNeedWriteBackAmtMap.merge(dimensionId3, writeBackAmt, (a, b) -> b.add((BigDecimal)a));
                }
                DynamicObjectCollection detailEntries = finBill3.getDynamicObjectCollection("entry");
                planEntry32 = detailEntries.iterator();
                while (planEntry32.hasNext()) {
                    DynamicObject detailEntry = (DynamicObject)planEntry32.next();
                    dimensionId = detailEntry.getLong("e_splitdimensionid");
                    if (dimensionToNeedWriteBackAmtMap.get(dimensionId) == null) continue;
                    List writeBackEntries = needWriteBackEntriesByDimension.getOrDefault(dimensionId, new ArrayList(8));
                    writeBackEntries.add(detailEntry);
                    needWriteBackEntriesByDimension.put(dimensionId, writeBackEntries);
                }
            }
            IFinEntryWriteBacker detailEntryLockWriteBacker = WriteBackerFactory.getDetailEntryLockWriteBacker("ar_finarbill");
            IFinEntryWriteBacker iFinEntryWriteBacker = WriteBackerFactory.getPlanEntryLockWriteBacker("ar_finarbill");
            for (Map.Entry writeBackInfo : billToDimensionToNeedWriteBackAmtMap.entrySet()) {
                Long finBillId = (Long)writeBackInfo.getKey();
                finBill = (DynamicObject)arBillNewMap.get(finBillId);
                orgId = finBill.getLong("org.id");
                Map dimensionToNeedWriteBackAmtMap = (Map)writeBackInfo.getValue();
                Map dimensionToNeedWriteBackEntriesMap = (Map)hashMap.get(finBillId);
                for (Map.Entry dimensionToNeedWriteBackAmt : dimensionToNeedWriteBackAmtMap.entrySet()) {
                    List needWriteBackEntries;
                    Long dimensionId = (Long)dimensionToNeedWriteBackAmt.getKey();
                    BigDecimal writeBackAmt = (BigDecimal)dimensionToNeedWriteBackAmt.getValue();
                    if (writeBackAmt.compareTo(BigDecimal.ZERO) == 0 || (needWriteBackEntries = (List)dimensionToNeedWriteBackEntriesMap.get(dimensionId)).size() == 0) continue;
                    DynamicObjectCollection needWriteBackEntryColl = new DynamicObjectCollection();
                    needWriteBackEntryColl.addAll((Collection)needWriteBackEntries);
                    if (settleParamMap.get(orgId) == 1) {
                        if (isDirect) {
                            iFinEntryWriteBacker.directWriteBack(finBill, needWriteBackEntryColl, writeBackAmt);
                            continue;
                        }
                        iFinEntryWriteBacker.inverseWriteBack(finBill, needWriteBackEntryColl, writeBackAmt);
                        continue;
                    }
                    if (isDirect) {
                        detailEntryLockWriteBacker.directWriteBack(finBill, needWriteBackEntryColl, writeBackAmt);
                        continue;
                    }
                    detailEntryLockWriteBacker.inverseWriteBack(finBill, needWriteBackEntryColl, writeBackAmt);
                }
            }
            SaveServiceHelper.save((DynamicObject[])arBillNewMap.values().toArray(new DynamicObject[0]));
        }
    }
}

