/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeback.decorate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.writeback.base.EntryWriteBackParam;
import kd.fi.arapcommon.service.writeback.base.IEntryWriteBacker;
import kd.fi.arapcommon.service.writeback.base.OrdinalEntryWriteBacker;
import kd.fi.arapcommon.service.writeback.base.WriteBackCallBack;
import kd.fi.arapcommon.service.writeback.decorate.IFinEntryWriteBacker;

public class PlanEntrySettleWriteBacker
implements IFinEntryWriteBacker {
    private final IEntryWriteBacker writeBacker;
    private final BillModel billModel;

    public PlanEntrySettleWriteBacker(String entityNumber) {
        this.billModel = BillModelFactory.getModel(entityNumber);
        this.writeBacker = new OrdinalEntryWriteBacker();
        EntryWriteBackParam param = new EntryWriteBackParam();
        param.setEntryPriceTaxTotalKey(this.billModel.P_PLANPRICETAX);
        param.setEntryUnWriteBackKey(this.billModel.P_UNPLANSETTLEAMT);
        param.setEntryWriteBackKey(this.billModel.P_PLANSETTLEDAMT);
        param.setCurrencyKey(this.billModel.HEAD_CURRENCY);
        this.writeBacker.init(param);
    }

    @Override
    public void directWriteBack(DynamicObject finBill, BigDecimal writeBackAmt) {
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection(this.billModel.P_ENTRY);
        this.directWriteBack(finBill, planEntries, writeBackAmt);
    }

    @Override
    public void directWriteBack(DynamicObject finBill, DynamicObjectCollection planEntries, BigDecimal writeBackAmt) {
        this.writeBacker.directWriteBack(finBill, planEntries, writeBackAmt, new SettleWriteBackCallBack());
    }

    @Override
    public void inverseWriteBack(DynamicObject finBill, BigDecimal writeBackAmt) {
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection(this.billModel.P_ENTRY);
        this.inverseWriteBack(finBill, planEntries, writeBackAmt);
    }

    @Override
    public void inverseWriteBack(DynamicObject finBill, DynamicObjectCollection planEntries, BigDecimal writeBackAmt) {
        this.writeBacker.inverseWriteBack(finBill, planEntries, writeBackAmt, new SettleWriteBackCallBack());
    }

    class SettleWriteBackCallBack
    implements WriteBackCallBack {
        SettleWriteBackCallBack() {
        }

        @Override
        public void writeBackInitial(DynamicObject writeBackEntry) {
            writeBackEntry.set(((PlanEntrySettleWriteBacker)PlanEntrySettleWriteBacker.this).billModel.P_UNPLANSETTLELOCAMT, (Object)writeBackEntry.getBigDecimal(((PlanEntrySettleWriteBacker)PlanEntrySettleWriteBacker.this).billModel.P_PLANPRICETAXLOC));
            writeBackEntry.set(((PlanEntrySettleWriteBacker)PlanEntrySettleWriteBacker.this).billModel.P_PLANSETTLEDLOCAMT, (Object)BigDecimal.ZERO);
        }

        @Override
        public void writeBackFinish(DynamicObject writeBackEntry) {
            writeBackEntry.set(((PlanEntrySettleWriteBacker)PlanEntrySettleWriteBacker.this).billModel.P_PLANSETTLEDLOCAMT, (Object)writeBackEntry.getBigDecimal(((PlanEntrySettleWriteBacker)PlanEntrySettleWriteBacker.this).billModel.P_PLANPRICETAXLOC));
            writeBackEntry.set(((PlanEntrySettleWriteBacker)PlanEntrySettleWriteBacker.this).billModel.P_UNPLANSETTLELOCAMT, (Object)BigDecimal.ZERO);
        }

        @Override
        public void writeBacking(DynamicObject finBill, DynamicObject writeBackEntry) {
            BigDecimal localAmt = this.getLocalAmt(finBill, writeBackEntry.getBigDecimal(((PlanEntrySettleWriteBacker)PlanEntrySettleWriteBacker.this).billModel.P_PLANSETTLEDAMT));
            writeBackEntry.set(((PlanEntrySettleWriteBacker)PlanEntrySettleWriteBacker.this).billModel.P_PLANSETTLEDLOCAMT, (Object)writeBackEntry.getBigDecimal(((PlanEntrySettleWriteBacker)PlanEntrySettleWriteBacker.this).billModel.P_PLANSETTLEDLOCAMT).add(localAmt));
            writeBackEntry.set(((PlanEntrySettleWriteBacker)PlanEntrySettleWriteBacker.this).billModel.P_UNPLANSETTLELOCAMT, (Object)writeBackEntry.getBigDecimal(((PlanEntrySettleWriteBacker)PlanEntrySettleWriteBacker.this).billModel.P_UNPLANSETTLELOCAMT).subtract(localAmt));
        }

        private BigDecimal getLocalAmt(DynamicObject finBill, BigDecimal srcAmt) {
            int basePrecision = this.getPrecision(finBill);
            BigDecimal exchange = finBill.getBigDecimal(((PlanEntrySettleWriteBacker)PlanEntrySettleWriteBacker.this).billModel.HEAD_EXCHANGERATE);
            if ("1".equals(finBill.getString(((PlanEntrySettleWriteBacker)PlanEntrySettleWriteBacker.this).billModel.HEAD_QUOTATION))) {
                return srcAmt.divide(exchange, basePrecision, RoundingMode.HALF_UP);
            }
            return srcAmt.multiply(exchange).setScale(basePrecision, RoundingMode.HALF_UP);
        }

        private int getPrecision(DynamicObject finBill) {
            DynamicObject baseCurrency = finBill.getDynamicObject(((PlanEntrySettleWriteBacker)PlanEntrySettleWriteBacker.this).billModel.HEAD_BASECURRENCY);
            return baseCurrency == null ? 2 : baseCurrency.getInt("amtprecision");
        }
    }
}

