/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeback.decorate;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.writeback.base.EntryCalculateParam;
import kd.fi.arapcommon.service.writeback.base.IProportionCalculator;
import kd.fi.arapcommon.service.writeback.base.ProportionCalculator;
import kd.fi.arapcommon.service.writeback.decorate.IFinEntryWriteBacker;

public class PremiumProportionLockWriteBacker
implements IFinEntryWriteBacker {
    private final IProportionCalculator calculator;
    private final BillModel billModel;

    public PremiumProportionLockWriteBacker(String entityNumber) {
        this.billModel = BillModelFactory.getModel(entityNumber);
        this.calculator = new ProportionCalculator();
        EntryCalculateParam param = new EntryCalculateParam();
        param.setEntryPriceTaxTotalKey(this.billModel.E_PRICETAXTOTAL);
        param.setCurrencyKey(this.billModel.HEAD_CURRENCY);
        this.calculator.init(param);
    }

    @Override
    public void directWriteBack(DynamicObject finBill, BigDecimal writeBackAmt) {
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection(this.billModel.ENTRY);
        this.directWriteBack(finBill, detailEntries, writeBackAmt);
    }

    @Override
    public void directWriteBack(DynamicObject finBill, DynamicObjectCollection entries, BigDecimal writeBackAmt) {
        Map<Long, BigDecimal> entryIdToWriteBackAmt = this.calculator.loadEntryWriteBackAmtMap(finBill, entries, writeBackAmt);
        for (DynamicObject detailEntry : entries) {
            BigDecimal entryWriteBackAmt = entryIdToWriteBackAmt.get(detailEntry.getLong("id"));
            if (entryWriteBackAmt == null || entryWriteBackAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            detailEntry.set(this.billModel.E_UNLOCKAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_UNLOCKAMT).subtract(entryWriteBackAmt));
            detailEntry.set(this.billModel.E_LOCKEDAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_LOCKEDAMT).add(entryWriteBackAmt));
        }
    }

    @Override
    public void inverseWriteBack(DynamicObject finBill, BigDecimal writeBackAmt) {
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection(this.billModel.ENTRY);
        this.inverseWriteBack(finBill, detailEntries, writeBackAmt);
    }

    @Override
    public void inverseWriteBack(DynamicObject finBill, DynamicObjectCollection entries, BigDecimal writeBackAmt) {
        Map<Long, BigDecimal> entryIdToWriteBackAmt = this.calculator.loadEntryWriteBackAmtMap(finBill, entries, writeBackAmt);
        for (DynamicObject detailEntry : entries) {
            BigDecimal entryWriteBackAmt = entryIdToWriteBackAmt.get(detailEntry.getLong("id"));
            if (entryWriteBackAmt == null || entryWriteBackAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            detailEntry.set(this.billModel.E_UNLOCKAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_UNLOCKAMT).add(entryWriteBackAmt));
            detailEntry.set(this.billModel.E_LOCKEDAMT, (Object)detailEntry.getBigDecimal(this.billModel.E_LOCKEDAMT).subtract(entryWriteBackAmt));
        }
    }
}

