/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeback.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.fin.ApPlanEntryDisposer;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.writeback.WriteBackerFactory;
import kd.fi.arapcommon.service.writeback.decorate.IFinEntryWriteBacker;

public class ApTransferWBFinBillServiceHelper {
    private static final Log logger = LogFactory.getLog(ApTransferWBFinBillServiceHelper.class);

    public static void directWriteBack(DynamicObject[] sourceFinBills, List<DynamicObject> transferBills) {
        ApTransferWBFinBillServiceHelper.writeBack(sourceFinBills, transferBills, true);
    }

    public static void inverseWriteBack(DynamicObject[] sourceFinBills, List<DynamicObject> transferBills) {
        ApTransferWBFinBillServiceHelper.writeBack(sourceFinBills, transferBills, false);
    }

    public static void writeBack(DynamicObject[] sourceFinBills, List<DynamicObject> transferBills, boolean isDirect) {
        DynamicObjectCollection planEntries;
        BigDecimal curDisposeAmt;
        DynamicObjectCollection detailEntries;
        BigDecimal disposeAmt;
        DynamicObjectCollection planEntries2;
        HashMap<Long, BigDecimal> planDisposeAmtMap;
        BigDecimal curDisposeAmt2;
        BigDecimal disposeAmt2;
        long entryId;
        BigDecimal disposeAmt3;
        DynamicObjectCollection detailEntries2;
        HashMap<Long, BigDecimal> detailDisposeAmtMap;
        logger.info("ApTransferWBFinBillServiceHelper.writeBack start");
        if (transferBills.size() == 0 || sourceFinBills.length == 0) {
            return;
        }
        HashMap<Long, DynamicObject> apBillOldMap = new HashMap<Long, DynamicObject>(8);
        HashMap<Long, DynamicObject> apBillNewMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject apBill : sourceFinBills) {
            boolean isOldVersion = SettleVersionServiceHelper.isOldVersion(apBill);
            if (isOldVersion) {
                apBillOldMap.put(apBill.getLong("id"), apBill);
                continue;
            }
            apBillNewMap.put(apBill.getLong("id"), apBill);
        }
        if (apBillOldMap.size() > 0) {
            logger.info("ApTransferWBFinBillServiceHelper.writeBack olddata");
            detailDisposeAmtMap = new HashMap<Long, BigDecimal>(8);
            for (DynamicObject transferBill : transferBills) {
                detailEntries2 = transferBill.getDynamicObjectCollection("detailentry");
                for (DynamicObject detailEntry : detailEntries2) {
                    long sourceEntryId = detailEntry.getLong("e_sourcebillentryid");
                    disposeAmt3 = detailEntry.getBigDecimal("e_pricetaxtotal");
                    detailDisposeAmtMap.merge(sourceEntryId, disposeAmt3, (a, b) -> b.add((BigDecimal)a));
                }
            }
            Collection sourceApOldBills = apBillOldMap.values();
            long orgId = transferBills.get(0).getLong("org.id");
            int settleParam = ArApHelper.getApSettleParam(orgId);
            if (settleParam == 1) {
                logger.info("ApTransferWBFinBillServiceHelper.writeBack olddata settleparam : detail");
                ApPlanEntryDisposer planEntryDisposer = new ApPlanEntryDisposer();
                for (DynamicObject sourceApBill : sourceApOldBills) {
                    BigDecimal planDisposeAmt = BigDecimal.ZERO;
                    DynamicObjectCollection detailEntries3 = sourceApBill.getDynamicObjectCollection("detailentry");
                    Iterator iterator = detailEntries3.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject detailEntry = (DynamicObject)iterator.next();
                        entryId = detailEntry.getLong("id");
                        disposeAmt2 = (BigDecimal)detailDisposeAmtMap.get(entryId);
                        if (disposeAmt2 == null || disposeAmt2.compareTo(BigDecimal.ZERO) == 0) continue;
                        planDisposeAmt = planDisposeAmt.add(disposeAmt2);
                        curDisposeAmt2 = isDirect ? disposeAmt2 : disposeAmt2.negate();
                        detailEntry.set("unlockamt", (Object)detailEntry.getBigDecimal("unlockamt").subtract(curDisposeAmt2));
                        detailEntry.set("lockedamt", (Object)detailEntry.getBigDecimal("lockedamt").add(curDisposeAmt2));
                    }
                    if (isDirect) {
                        planEntryDisposer.saveDispose(sourceApBill, planDisposeAmt);
                        continue;
                    }
                    planEntryDisposer.deleteDispose(sourceApBill, planDisposeAmt);
                }
            } else {
                logger.info("ApTransferWBFinBillServiceHelper.writeBack olddata settleparam : plan");
                planDisposeAmtMap = new HashMap<Long, BigDecimal>(8);
                for (DynamicObject transferBill : transferBills) {
                    planEntries2 = transferBill.getDynamicObjectCollection("planentity");
                    for (DynamicObject planEntry : planEntries2) {
                        long sourceEntryId = planEntry.getLong("p_sourcebillentryid");
                        disposeAmt = planEntry.getBigDecimal("planpricetax");
                        planDisposeAmtMap.merge(sourceEntryId, disposeAmt, (a, b) -> b.add((BigDecimal)a));
                    }
                }
                for (DynamicObject sourceApBill : sourceApOldBills) {
                    Iterator detailEntry2;
                    detailEntries = sourceApBill.getDynamicObjectCollection("detailentry");
                    for (Iterator detailEntry2 : detailEntries) {
                        long entryId2 = detailEntry2.getLong("id");
                        disposeAmt = (BigDecimal)detailDisposeAmtMap.get(entryId2);
                        if (disposeAmt == null || disposeAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                        curDisposeAmt = isDirect ? disposeAmt : disposeAmt.negate();
                        detailEntry2.set("unlockamt", detailEntry2.getBigDecimal("unlockamt").subtract(curDisposeAmt));
                        detailEntry2.set("lockedamt", detailEntry2.getBigDecimal("lockedamt").add(curDisposeAmt));
                    }
                    planEntries = sourceApBill.getDynamicObjectCollection("planentity");
                    detailEntry2 = planEntries.iterator();
                    while (detailEntry2.hasNext()) {
                        DynamicObject planEntry = (DynamicObject)detailEntry2.next();
                        entryId = planEntry.getLong("id");
                        disposeAmt2 = (BigDecimal)planDisposeAmtMap.get(entryId);
                        if (disposeAmt2 == null || disposeAmt2.compareTo(BigDecimal.ZERO) == 0) continue;
                        curDisposeAmt2 = isDirect ? disposeAmt2 : disposeAmt2.negate();
                        planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(curDisposeAmt2));
                        planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(curDisposeAmt2));
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])sourceApOldBills.toArray(new DynamicObject[0]));
        }
        if (apBillNewMap.size() > 0) {
            logger.info("ApTransferWBFinBillServiceHelper.writeBack newdata");
            detailDisposeAmtMap = new HashMap(8);
            for (DynamicObject transferBill : transferBills) {
                detailEntries2 = transferBill.getDynamicObjectCollection("detailentry");
                for (DynamicObject detailEntry : detailEntries2) {
                    long sourceEntryId = detailEntry.getLong("e_sourcebillentryid");
                    disposeAmt3 = detailEntry.getBigDecimal("e_pricetaxtotal");
                    detailDisposeAmtMap.merge(sourceEntryId, disposeAmt3, (a, b) -> b.add((BigDecimal)a));
                }
            }
            Collection sourceApNewBills = apBillNewMap.values();
            long orgId = transferBills.get(0).getLong("org.id");
            int settleParam = ArApHelper.getApSettleParam(orgId);
            if (settleParam == 1) {
                logger.info("ApTransferWBFinBillServiceHelper.writeBack newdata settleparam : detail");
                IFinEntryWriteBacker planEntryLockWriteBacker = WriteBackerFactory.getPlanEntryLockWriteBacker("ap_finapbill");
                for (DynamicObject sourceApBill : sourceApNewBills) {
                    detailEntries = sourceApBill.getDynamicObjectCollection("detailentry");
                    HashMap dimensionToNeedWriteBackAmtMap = new HashMap(8);
                    for (DynamicObject detailEntry : detailEntries) {
                        long entryId3 = detailEntry.getLong("id");
                        BigDecimal disposeAmt4 = (BigDecimal)detailDisposeAmtMap.get(entryId3);
                        if (disposeAmt4 == null || disposeAmt4.compareTo(BigDecimal.ZERO) == 0) continue;
                        long dimensionId = detailEntry.getLong("e_splitdimensionid");
                        dimensionToNeedWriteBackAmtMap.merge(dimensionId, disposeAmt4, (a, b) -> b.add((BigDecimal)a));
                        BigDecimal curDisposeAmt3 = isDirect ? disposeAmt4 : disposeAmt4.negate();
                        detailEntry.set("unlockamt", (Object)detailEntry.getBigDecimal("unlockamt").subtract(curDisposeAmt3));
                        detailEntry.set("lockedamt", (Object)detailEntry.getBigDecimal("lockedamt").add(curDisposeAmt3));
                    }
                    HashMap<Long, List> dimensionToNeedWriteBackPlanEntriesMap = new HashMap<Long, List>(8);
                    DynamicObjectCollection planEntries3 = sourceApBill.getDynamicObjectCollection("planentity");
                    for (DynamicObject planEntry : planEntries3) {
                        long dimensionId = planEntry.getLong("p_splitdimensionid");
                        if (dimensionToNeedWriteBackAmtMap.get(dimensionId) == null) continue;
                        List writeBackEntries = dimensionToNeedWriteBackPlanEntriesMap.getOrDefault(dimensionId, new ArrayList(8));
                        writeBackEntries.add(planEntry);
                        dimensionToNeedWriteBackPlanEntriesMap.put(dimensionId, writeBackEntries);
                    }
                    for (Map.Entry dimensionToNeedWriteBackAmt : dimensionToNeedWriteBackAmtMap.entrySet()) {
                        Long dimensionId = (Long)dimensionToNeedWriteBackAmt.getKey();
                        BigDecimal planDisposeAmt = (BigDecimal)dimensionToNeedWriteBackAmt.getValue();
                        List needWriteBackEntries = (List)dimensionToNeedWriteBackPlanEntriesMap.get(dimensionId);
                        if (needWriteBackEntries.size() == 0) continue;
                        DynamicObjectCollection needWriteBackEntryColl = new DynamicObjectCollection();
                        needWriteBackEntryColl.addAll((Collection)needWriteBackEntries);
                        if (isDirect) {
                            planEntryLockWriteBacker.directWriteBack(sourceApBill, needWriteBackEntryColl, planDisposeAmt);
                            continue;
                        }
                        planEntryLockWriteBacker.inverseWriteBack(sourceApBill, needWriteBackEntryColl, planDisposeAmt);
                    }
                }
            } else {
                logger.info("ApTransferWBFinBillServiceHelper.writeBack newdata settleparam : plan");
                planDisposeAmtMap = new HashMap(8);
                for (DynamicObject transferBill : transferBills) {
                    planEntries2 = transferBill.getDynamicObjectCollection("planentity");
                    for (DynamicObject planEntry : planEntries2) {
                        long sourceEntryId = planEntry.getLong("p_sourcebillentryid");
                        disposeAmt = planEntry.getBigDecimal("planpricetax");
                        planDisposeAmtMap.merge(sourceEntryId, disposeAmt, (a, b) -> b.add((BigDecimal)a));
                    }
                }
                for (DynamicObject sourceApBill : sourceApNewBills) {
                    detailEntries = sourceApBill.getDynamicObjectCollection("detailentry");
                    for (Iterator detailEntry2 : detailEntries) {
                        long entryId4 = detailEntry2.getLong("id");
                        disposeAmt = (BigDecimal)detailDisposeAmtMap.get(entryId4);
                        if (disposeAmt == null || disposeAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                        curDisposeAmt = isDirect ? disposeAmt : disposeAmt.negate();
                        detailEntry2.set("unlockamt", detailEntry2.getBigDecimal("unlockamt").subtract(curDisposeAmt));
                        detailEntry2.set("lockedamt", detailEntry2.getBigDecimal("lockedamt").add(curDisposeAmt));
                        detailEntry2.set("e_fixlockedamt", detailEntry2.getBigDecimal("e_fixlockedamt").add(curDisposeAmt));
                    }
                    planEntries = sourceApBill.getDynamicObjectCollection("planentity");
                    for (DynamicObject planEntry : planEntries) {
                        entryId = planEntry.getLong("id");
                        disposeAmt2 = (BigDecimal)planDisposeAmtMap.get(entryId);
                        if (disposeAmt2 == null || disposeAmt2.compareTo(BigDecimal.ZERO) == 0) continue;
                        curDisposeAmt2 = isDirect ? disposeAmt2 : disposeAmt2.negate();
                        planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(curDisposeAmt2));
                        planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(curDisposeAmt2));
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])sourceApNewBills.toArray(new DynamicObject[0]));
        }
        logger.info("ApTransferWBFinBillServiceHelper.writeBack start");
    }
}

