/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeback.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.fin.ArPlanEntryDisposer;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.writeback.WriteBackerFactory;
import kd.fi.arapcommon.service.writeback.decorate.IFinEntryWriteBacker;

public class ArTransferWBFinBillServiceHelper {
    private static final Log logger = LogFactory.getLog(ArTransferWBFinBillServiceHelper.class);

    public static void directWriteBack(DynamicObject[] sourceFinBills, List<DynamicObject> transferBills) {
        ArTransferWBFinBillServiceHelper.writeBack(sourceFinBills, transferBills, true);
    }

    public static void inverseWriteBack(DynamicObject[] sourceFinBills, List<DynamicObject> transferBills) {
        ArTransferWBFinBillServiceHelper.writeBack(sourceFinBills, transferBills, false);
    }

    public static void writeBack(DynamicObject[] sourceFinBills, List<DynamicObject> transferBills, boolean isDirect) {
        DynamicObjectCollection planEntries;
        BigDecimal curDisposeAmt;
        DynamicObjectCollection detailEntries;
        BigDecimal disposeAmt;
        DynamicObjectCollection planEntries2;
        HashMap<Long, BigDecimal> planDisposeAmtMap;
        BigDecimal curDisposeAmt2;
        BigDecimal disposeAmt2;
        long entryId;
        BigDecimal disposeAmt3;
        DynamicObjectCollection detailEntries2;
        HashMap<Long, BigDecimal> detailDisposeAmtMap;
        logger.info("ArTransferWBFinBillServiceHelper.writeBack start");
        if (transferBills.size() == 0 || sourceFinBills.length == 0) {
            return;
        }
        HashMap<Long, DynamicObject> arBillOldMap = new HashMap<Long, DynamicObject>(8);
        HashMap<Long, DynamicObject> arBillNewMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject arBill : sourceFinBills) {
            boolean isOldVersion = SettleVersionServiceHelper.isOldVersion(arBill);
            if (isOldVersion) {
                arBillOldMap.put(arBill.getLong("id"), arBill);
                continue;
            }
            arBillNewMap.put(arBill.getLong("id"), arBill);
        }
        if (arBillOldMap.size() > 0) {
            logger.info("ArTransferWBFinBillServiceHelper.writeBack olddata");
            detailDisposeAmtMap = new HashMap<Long, BigDecimal>(8);
            for (DynamicObject transferBill : transferBills) {
                detailEntries2 = transferBill.getDynamicObjectCollection("entry");
                for (DynamicObject detailEntry : detailEntries2) {
                    long sourceEntryId = detailEntry.getLong("e_srcentryid");
                    disposeAmt3 = detailEntry.getBigDecimal("e_recamount");
                    detailDisposeAmtMap.merge(sourceEntryId, disposeAmt3, (a, b) -> b.add((BigDecimal)a));
                }
            }
            Collection sourceArOldBills = arBillOldMap.values();
            long orgId = transferBills.get(0).getLong("org.id");
            int settleParam = ArApHelper.getArSettleParam(orgId);
            if (settleParam == 1) {
                logger.info("ArTransferWBFinBillServiceHelper.writeBack olddata settleparam : detail");
                ArPlanEntryDisposer planEntryDisposer = new ArPlanEntryDisposer();
                for (DynamicObject sourceArBill : sourceArOldBills) {
                    BigDecimal planDisposeAmt = BigDecimal.ZERO;
                    DynamicObjectCollection detailEntries3 = sourceArBill.getDynamicObjectCollection("entry");
                    Iterator iterator = detailEntries3.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject detailEntry = (DynamicObject)iterator.next();
                        entryId = detailEntry.getLong("id");
                        disposeAmt2 = (BigDecimal)detailDisposeAmtMap.get(entryId);
                        if (disposeAmt2 == null || disposeAmt2.compareTo(BigDecimal.ZERO) == 0) continue;
                        planDisposeAmt = planDisposeAmt.add(disposeAmt2);
                        curDisposeAmt2 = isDirect ? disposeAmt2 : disposeAmt2.negate();
                        detailEntry.set("e_unlockamt", (Object)detailEntry.getBigDecimal("e_unlockamt").subtract(curDisposeAmt2));
                        detailEntry.set("e_lockedamt", (Object)detailEntry.getBigDecimal("e_lockedamt").add(curDisposeAmt2));
                    }
                    if (isDirect) {
                        planEntryDisposer.saveDispose(sourceArBill, planDisposeAmt);
                        continue;
                    }
                    planEntryDisposer.deleteDispose(sourceArBill, planDisposeAmt);
                }
            } else {
                logger.info("ArTransferWBFinBillServiceHelper.writeBack olddata settleparam : plan");
                planDisposeAmtMap = new HashMap<Long, BigDecimal>(8);
                for (DynamicObject transferBill : transferBills) {
                    planEntries2 = transferBill.getDynamicObjectCollection("planentity");
                    for (DynamicObject planEntry : planEntries2) {
                        long sourceEntryId = planEntry.getLong("p_sourcebillentryid");
                        disposeAmt = planEntry.getBigDecimal("planpricetax");
                        planDisposeAmtMap.merge(sourceEntryId, disposeAmt, (a, b) -> b.add((BigDecimal)a));
                    }
                }
                for (DynamicObject sourceArBill : sourceArOldBills) {
                    Iterator detailEntry2;
                    detailEntries = sourceArBill.getDynamicObjectCollection("entry");
                    for (Iterator detailEntry2 : detailEntries) {
                        long entryId2 = detailEntry2.getLong("id");
                        disposeAmt = (BigDecimal)detailDisposeAmtMap.get(entryId2);
                        if (disposeAmt == null || disposeAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                        curDisposeAmt = isDirect ? disposeAmt : disposeAmt.negate();
                        detailEntry2.set("e_unlockamt", detailEntry2.getBigDecimal("e_unlockamt").subtract(curDisposeAmt));
                        detailEntry2.set("e_lockedamt", detailEntry2.getBigDecimal("e_lockedamt").add(curDisposeAmt));
                    }
                    planEntries = sourceArBill.getDynamicObjectCollection("planentity");
                    detailEntry2 = planEntries.iterator();
                    while (detailEntry2.hasNext()) {
                        DynamicObject planEntry = (DynamicObject)detailEntry2.next();
                        entryId = planEntry.getLong("id");
                        disposeAmt2 = (BigDecimal)planDisposeAmtMap.get(entryId);
                        if (disposeAmt2 == null || disposeAmt2.compareTo(BigDecimal.ZERO) == 0) continue;
                        curDisposeAmt2 = isDirect ? disposeAmt2 : disposeAmt2.negate();
                        planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(curDisposeAmt2));
                        planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(curDisposeAmt2));
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])sourceArOldBills.toArray(new DynamicObject[0]));
        }
        if (arBillNewMap.size() > 0) {
            logger.info("ArTransferWBFinBillServiceHelper.writeBack newdata");
            detailDisposeAmtMap = new HashMap(8);
            for (DynamicObject transferBill : transferBills) {
                detailEntries2 = transferBill.getDynamicObjectCollection("entry");
                for (DynamicObject detailEntry : detailEntries2) {
                    long sourceEntryId = detailEntry.getLong("e_srcentryid");
                    disposeAmt3 = detailEntry.getBigDecimal("e_recamount");
                    detailDisposeAmtMap.merge(sourceEntryId, disposeAmt3, (a, b) -> b.add((BigDecimal)a));
                }
            }
            Collection sourceArNewBills = arBillNewMap.values();
            long orgId = transferBills.get(0).getLong("org.id");
            int settleParam = ArApHelper.getArSettleParam(orgId);
            if (settleParam == 1) {
                logger.info("ArTransferWBFinBillServiceHelper.writeBack newdata settleparam : detail");
                IFinEntryWriteBacker planEntryLockWriteBacker = WriteBackerFactory.getPlanEntryLockWriteBacker("ar_finarbill");
                for (DynamicObject sourceArBill : sourceArNewBills) {
                    detailEntries = sourceArBill.getDynamicObjectCollection("entry");
                    HashMap dimensionToNeedWriteBackAmtMap = new HashMap(8);
                    for (DynamicObject detailEntry : detailEntries) {
                        long entryId3 = detailEntry.getLong("id");
                        BigDecimal disposeAmt4 = (BigDecimal)detailDisposeAmtMap.get(entryId3);
                        if (disposeAmt4 == null || disposeAmt4.compareTo(BigDecimal.ZERO) == 0) continue;
                        long dimensionId = detailEntry.getLong("e_splitdimensionid");
                        dimensionToNeedWriteBackAmtMap.merge(dimensionId, disposeAmt4, (a, b) -> b.add((BigDecimal)a));
                        BigDecimal curDisposeAmt3 = isDirect ? disposeAmt4 : disposeAmt4.negate();
                        detailEntry.set("e_unlockamt", (Object)detailEntry.getBigDecimal("e_unlockamt").subtract(curDisposeAmt3));
                        detailEntry.set("e_lockedamt", (Object)detailEntry.getBigDecimal("e_lockedamt").add(curDisposeAmt3));
                    }
                    HashMap<Long, List> dimensionToNeedWriteBackPlanEntriesMap = new HashMap<Long, List>(8);
                    DynamicObjectCollection planEntries3 = sourceArBill.getDynamicObjectCollection("planentity");
                    for (DynamicObject planEntry : planEntries3) {
                        long dimensionId = planEntry.getLong("p_splitdimensionid");
                        if (dimensionToNeedWriteBackAmtMap.get(dimensionId) == null) continue;
                        List writeBackEntries = dimensionToNeedWriteBackPlanEntriesMap.getOrDefault(dimensionId, new ArrayList(8));
                        writeBackEntries.add(planEntry);
                        dimensionToNeedWriteBackPlanEntriesMap.put(dimensionId, writeBackEntries);
                    }
                    for (Map.Entry dimensionToNeedWriteBackAmt : dimensionToNeedWriteBackAmtMap.entrySet()) {
                        Long dimensionId = (Long)dimensionToNeedWriteBackAmt.getKey();
                        BigDecimal planDisposeAmt = (BigDecimal)dimensionToNeedWriteBackAmt.getValue();
                        List needWriteBackEntries = (List)dimensionToNeedWriteBackPlanEntriesMap.get(dimensionId);
                        if (needWriteBackEntries.size() == 0) continue;
                        DynamicObjectCollection needWriteBackEntryColl = new DynamicObjectCollection();
                        needWriteBackEntryColl.addAll((Collection)needWriteBackEntries);
                        if (isDirect) {
                            planEntryLockWriteBacker.directWriteBack(sourceArBill, needWriteBackEntryColl, planDisposeAmt);
                            continue;
                        }
                        planEntryLockWriteBacker.inverseWriteBack(sourceArBill, needWriteBackEntryColl, planDisposeAmt);
                    }
                }
            } else {
                logger.info("ArTransferWBFinBillServiceHelper.writeBack newdata settleparam : plan");
                planDisposeAmtMap = new HashMap(8);
                for (DynamicObject transferBill : transferBills) {
                    planEntries2 = transferBill.getDynamicObjectCollection("planentity");
                    for (DynamicObject planEntry : planEntries2) {
                        long sourceEntryId = planEntry.getLong("p_sourcebillentryid");
                        disposeAmt = planEntry.getBigDecimal("planpricetax");
                        planDisposeAmtMap.merge(sourceEntryId, disposeAmt, (a, b) -> b.add((BigDecimal)a));
                    }
                }
                for (DynamicObject sourceArBill : sourceArNewBills) {
                    detailEntries = sourceArBill.getDynamicObjectCollection("entry");
                    for (Iterator detailEntry2 : detailEntries) {
                        long entryId4 = detailEntry2.getLong("id");
                        disposeAmt = (BigDecimal)detailDisposeAmtMap.get(entryId4);
                        if (disposeAmt == null || disposeAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                        curDisposeAmt = isDirect ? disposeAmt : disposeAmt.negate();
                        detailEntry2.set("e_unlockamt", detailEntry2.getBigDecimal("e_unlockamt").subtract(curDisposeAmt));
                        detailEntry2.set("e_lockedamt", detailEntry2.getBigDecimal("e_lockedamt").add(curDisposeAmt));
                        detailEntry2.set("e_fixlockedamt", detailEntry2.getBigDecimal("e_fixlockedamt").add(curDisposeAmt));
                    }
                    planEntries = sourceArBill.getDynamicObjectCollection("planentity");
                    for (DynamicObject planEntry : planEntries) {
                        entryId = planEntry.getLong("id");
                        disposeAmt2 = (BigDecimal)planDisposeAmtMap.get(entryId);
                        if (disposeAmt2 == null || disposeAmt2.compareTo(BigDecimal.ZERO) == 0) continue;
                        curDisposeAmt2 = isDirect ? disposeAmt2 : disposeAmt2.negate();
                        planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(curDisposeAmt2));
                        planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(curDisposeAmt2));
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])sourceArNewBills.toArray(new DynamicObject[0]));
        }
        logger.info("ArTransferWBFinBillServiceHelper.writeBack start");
    }
}

