/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeback.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.enums.EntryWBTypeEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.writeback.WriteBackerFactory;
import kd.fi.arapcommon.service.writeback.base.EntryCalculateParam;
import kd.fi.arapcommon.service.writeback.base.ProportionCalculator;
import kd.fi.arapcommon.service.writeback.decorate.IFinEntryWriteBacker;
import kd.fi.arapcommon.writeback.entry.ArMaterialEntryWBService;
import kd.fi.arapcommon.writeback.entry.EntryWBParam;
import kd.fi.arapcommon.writeback.entry.PrePlanWBService;

public class FinArExitPremiumWBServiceHelper {
    public static void occupy(DynamicObject finArBill, BigDecimal premiumAmt) {
        FinArExitPremiumWBServiceHelper.writeBack(finArBill, premiumAmt, true);
    }

    public static void release(DynamicObject finArBill, BigDecimal premiumAmt) {
        FinArExitPremiumWBServiceHelper.writeBack(finArBill, premiumAmt, false);
    }

    private static void writeBack(DynamicObject finArBill, BigDecimal disposeAmount, boolean isDirect) {
        if (SettleVersionServiceHelper.isOldVersion(finArBill)) {
            PrePlanWBService planWBService = BeanFactory.getBean(PrePlanWBService.class, new Object[0]);
            ArMaterialEntryWBService materialWBService = BeanFactory.getBean(ArMaterialEntryWBService.class, new Object[0]);
            EntryWBParam param = new EntryWBParam();
            param.setWbType(EntryWBTypeEnum.PUSH.getValue());
            param.setForward(isDirect);
            param.setWbAmt(disposeAmount);
            materialWBService.execute(finArBill, param);
            planWBService.execute(finArBill, param);
        } else {
            int settleParam = ArApHelper.getArSettleParam(finArBill.getLong("org.id"));
            if (1 == settleParam) {
                DynamicObjectCollection detailEntries = finArBill.getDynamicObjectCollection("entry");
                ProportionCalculator calculator = new ProportionCalculator();
                EntryCalculateParam param = new EntryCalculateParam();
                param.setEntryPriceTaxTotalKey("e_recamount");
                param.setCurrencyKey("currency");
                calculator.init(param);
                HashMap<Long, BigDecimal> dimensionToNeedWriteBackAmtMap = new HashMap<Long, BigDecimal>(8);
                Map<Long, BigDecimal> entryIdToWriteBackAmt = calculator.loadEntryWriteBackAmtMap(finArBill, detailEntries, disposeAmount);
                for (DynamicObject detailEntry : detailEntries) {
                    BigDecimal entryWriteBackAmt = entryIdToWriteBackAmt.get(detailEntry.getLong("id"));
                    if (entryWriteBackAmt == null || entryWriteBackAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    long dimensionId = detailEntry.getLong("e_splitdimensionid");
                    dimensionToNeedWriteBackAmtMap.merge(dimensionId, entryWriteBackAmt, (a, b) -> b.add((BigDecimal)a));
                    BigDecimal curDisposeAmt = isDirect ? entryWriteBackAmt : entryWriteBackAmt.negate();
                    detailEntry.set("e_unlockamt", (Object)detailEntry.getBigDecimal("e_unlockamt").subtract(curDisposeAmt));
                    detailEntry.set("e_lockedamt", (Object)detailEntry.getBigDecimal("e_lockedamt").add(curDisposeAmt));
                }
                HashMap<Long, List> dimensionToNeedWriteBackPlanEntriesMap = new HashMap<Long, List>(8);
                DynamicObjectCollection planEntries = finArBill.getDynamicObjectCollection("planentity");
                for (DynamicObject planEntry : planEntries) {
                    long dimensionId = planEntry.getLong("p_splitdimensionid");
                    if (dimensionToNeedWriteBackAmtMap.get(dimensionId) == null) continue;
                    List writeBackEntries = dimensionToNeedWriteBackPlanEntriesMap.getOrDefault(dimensionId, new ArrayList(8));
                    writeBackEntries.add(planEntry);
                    dimensionToNeedWriteBackPlanEntriesMap.put(dimensionId, writeBackEntries);
                }
                IFinEntryWriteBacker planEntryLockWriteBacker = WriteBackerFactory.getPlanEntryLockWriteBacker("ar_finarbill");
                for (Map.Entry dimensionToNeedWriteBackAmt : dimensionToNeedWriteBackAmtMap.entrySet()) {
                    Long dimensionId = (Long)dimensionToNeedWriteBackAmt.getKey();
                    BigDecimal planDisposeAmt = (BigDecimal)dimensionToNeedWriteBackAmt.getValue();
                    List needWriteBackEntries = (List)dimensionToNeedWriteBackPlanEntriesMap.get(dimensionId);
                    if (needWriteBackEntries.size() == 0) continue;
                    DynamicObjectCollection needWriteBackEntryColl = new DynamicObjectCollection();
                    needWriteBackEntryColl.addAll((Collection)needWriteBackEntries);
                    if (isDirect) {
                        planEntryLockWriteBacker.directWriteBack(finArBill, needWriteBackEntryColl, planDisposeAmt);
                        continue;
                    }
                    planEntryLockWriteBacker.inverseWriteBack(finArBill, needWriteBackEntryColl, planDisposeAmt);
                }
            } else {
                DynamicObjectCollection planEntries = finArBill.getDynamicObjectCollection("planentity");
                ProportionCalculator calculator = new ProportionCalculator();
                EntryCalculateParam param = new EntryCalculateParam();
                param.setEntryPriceTaxTotalKey("planpricetax");
                param.setCurrencyKey("currency");
                calculator.init(param);
                HashMap<Long, BigDecimal> dimensionToNeedWriteBackAmtMap = new HashMap<Long, BigDecimal>(8);
                Map<Long, BigDecimal> entryIdToWriteBackAmt = calculator.loadEntryWriteBackAmtMap(finArBill, planEntries, disposeAmount);
                for (DynamicObject planEntry : planEntries) {
                    BigDecimal entryWriteBackAmt = entryIdToWriteBackAmt.get(planEntry.getLong("id"));
                    if (entryWriteBackAmt == null || entryWriteBackAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    long dimensionId = planEntry.getLong("p_splitdimensionid");
                    dimensionToNeedWriteBackAmtMap.merge(dimensionId, entryWriteBackAmt, (a, b) -> b.add((BigDecimal)a));
                    BigDecimal curDisposeAmt = isDirect ? entryWriteBackAmt : entryWriteBackAmt.negate();
                    planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(curDisposeAmt));
                    planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(curDisposeAmt));
                }
                HashMap<Long, List> dimensionToNeedWriteBackDetailEntriesMap = new HashMap<Long, List>(8);
                DynamicObjectCollection detailEntries = finArBill.getDynamicObjectCollection("entry");
                for (DynamicObject detailEntry : detailEntries) {
                    long dimensionId = detailEntry.getLong("e_splitdimensionid");
                    if (dimensionToNeedWriteBackAmtMap.get(dimensionId) == null) continue;
                    List writeBackEntries = dimensionToNeedWriteBackDetailEntriesMap.getOrDefault(dimensionId, new ArrayList(8));
                    writeBackEntries.add(detailEntry);
                    dimensionToNeedWriteBackDetailEntriesMap.put(dimensionId, writeBackEntries);
                }
                IFinEntryWriteBacker detailEntryLockWriteBacker = WriteBackerFactory.getDetailEntryLockWriteBacker("ar_finarbill");
                for (Map.Entry dimensionToNeedWriteBackAmt : dimensionToNeedWriteBackAmtMap.entrySet()) {
                    Long dimensionId = (Long)dimensionToNeedWriteBackAmt.getKey();
                    BigDecimal detailDisposeAmt = (BigDecimal)dimensionToNeedWriteBackAmt.getValue();
                    List needWriteBackEntries = (List)dimensionToNeedWriteBackDetailEntriesMap.get(dimensionId);
                    if (needWriteBackEntries.size() == 0) continue;
                    DynamicObjectCollection needWriteBackEntryColl = new DynamicObjectCollection();
                    needWriteBackEntryColl.addAll((Collection)needWriteBackEntries);
                    if (isDirect) {
                        detailEntryLockWriteBacker.directWriteBack(finArBill, needWriteBackEntryColl, detailDisposeAmt);
                        continue;
                    }
                    detailEntryLockWriteBacker.inverseWriteBack(finArBill, needWriteBackEntryColl, detailDisposeAmt);
                }
            }
        }
    }
}

