/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeoff;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.arapcommon.service.helper.RollBackDisposeRuleHelper;
import kd.fi.arapcommon.service.writeoff.AbstractRollBackDisposeRuleService;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinChargeAgainstDisposer
extends AbstractRollBackDisposeRuleService {
    private String entityName;

    @Override
    public void rollBack(DynamicObject[] targetEntities) {
        this.init(targetEntities);
        Set<Long> finSourceBillIds = this.listUsableSourceFinBillIds(targetEntities);
        if (EmptyUtils.isEmpty(finSourceBillIds)) {
            return;
        }
        RollBackDisposeRuleHelper.rollBack(this.entityName, finSourceBillIds.toArray(new Object[0]));
    }

    @Override
    public void dispose(DynamicObject[] targetEntities) {
        this.init(targetEntities);
        Set<Long> finSourceBillIds = this.listUsableSourceFinBillIds(targetEntities);
        if (EmptyUtils.isEmpty(finSourceBillIds)) {
            return;
        }
        RollBackDisposeRuleHelper.dispose(this.entityName, finSourceBillIds.toArray(new Object[0]));
    }

    private void init(DynamicObject[] targetEntities) {
        this.entityName = targetEntities[0].getDataEntityType().getName();
    }

    private Set<Long> listUsableSourceFinBillIds(DynamicObject[] targetEntities) {
        return Arrays.stream(targetEntities).map(entity -> entity.getLong("sourcebillid")).collect(Collectors.toSet());
    }
}

