/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeoff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.SettleRecordQueryHelper;

public class WriteOffHelper {
    public static boolean containWriteOff(ListSelectedRowCollection selectedRows, String entityName) {
        return WriteOffHelper.containProperty(selectedRows, entityName, "iswrittenoff");
    }

    public static boolean containProperty(ListSelectedRowCollection selectedRows, String entityName, String property) {
        int size = selectedRows.size();
        Object[] pks = new Object[size];
        for (int index = 0; index < size; ++index) {
            ListSelectedRow row = selectedRows.get(index);
            pks[index] = row.getPrimaryKeyValue();
        }
        QFilter filter = new QFilter("id", "in", (Object)pks);
        filter = filter.and(new QFilter(property, "=", (Object)Boolean.TRUE));
        return QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{filter});
    }

    public static void setWriteOffBill(DynamicObject[] entities) {
    }

    public static Map<String, Set<String>> getSettleBillNumberMap(Object[] finPks) {
        DynamicObject[] asstSettleRecords;
        DynamicObject[] mianSettleRecords;
        HashMap<String, Set<String>> settleBillNumberMap = new HashMap<String, Set<String>>(1);
        QFilter mainFilter = new QFilter("mainbillid", "in", (Object)finPks);
        mainFilter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        for (DynamicObject mianSettleRecord : mianSettleRecords = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)"billno,entry.billnum", (QFilter[])mainFilter.toArray())) {
            HashSet settleBillNumbers = (HashSet)settleBillNumberMap.get(mianSettleRecord.getString("billno"));
            DynamicObjectCollection settleEntry = mianSettleRecord.getDynamicObjectCollection("entry");
            Set billNumbers = settleEntry.stream().map(e -> e.getString("billnum")).collect(Collectors.toSet());
            if (settleBillNumbers != null) {
                settleBillNumbers.addAll(billNumbers);
                continue;
            }
            settleBillNumbers = new HashSet(2);
            settleBillNumbers.addAll(billNumbers);
            settleBillNumberMap.put(mianSettleRecord.getString("billno"), settleBillNumbers);
        }
        QFilter asstFilter = new QFilter("entry.billid", "in", (Object)finPks);
        asstFilter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        for (DynamicObject asstSettleRecord : asstSettleRecords = SettleRecordQueryHelper.getSettleRecords("ap_settlerecord", "billno,entry.billnum,entry.billid", "ap_settlerecord", finPks, asstFilter)) {
            DynamicObjectCollection settleEntry = asstSettleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : settleEntry) {
                if (!Arrays.asList(finPks).contains(entry.getLong("billid"))) continue;
                HashSet<String> settleBillNumbers = (HashSet<String>)settleBillNumberMap.get(entry.getString("billnum"));
                if (settleBillNumbers != null) {
                    settleBillNumbers.add(asstSettleRecord.getString("billno"));
                    continue;
                }
                settleBillNumbers = new HashSet<String>(2);
                settleBillNumbers.add(asstSettleRecord.getString("billno"));
                settleBillNumberMap.put(entry.getString("billnum"), settleBillNumbers);
            }
        }
        return settleBillNumberMap;
    }

    public static List<String> getOperationConfirmMessage(Map<String, Set<String>> settleBillNumberMap, boolean isAr) {
        ArrayList<String> msgs = new ArrayList<String>(1);
        for (Map.Entry<String, Set<String>> stringSetEntry : settleBillNumberMap.entrySet()) {
            StringBuilder message = new StringBuilder();
            if (isAr) {
                message.append(ResManager.loadKDString((String)"\u4e0e\u5e94\u6536\u5355%s\u8fdb\u884c\u7ed3\u7b97\u7684\u5355\u636e\uff1a", (String)"WriteOffHelper_1", (String)"fi-arapcommon", (Object[])new Object[]{stringSetEntry.getKey()}));
            } else {
                message.append(ResManager.loadKDString((String)"\u4e0e\u5e94\u4ed8\u5355%s\u8fdb\u884c\u7ed3\u7b97\u7684\u5355\u636e\uff1a", (String)"WriteOffHelper_2", (String)"fi-arapcommon", (Object[])new Object[]{stringSetEntry.getKey()}));
            }
            int i = 0;
            for (String settleBillNumber : stringSetEntry.getValue()) {
                if (i < 3) {
                    message.append(settleBillNumber);
                    if (i < 2 && i + 1 != stringSetEntry.getValue().size()) {
                        message.append('\u3001');
                    }
                } else {
                    message.append(ResManager.loadKDString((String)"\u2026\u2026\u66f4\u591a\u5355\u636e\u8bf7\u8054\u67e5\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"WriteOffHelper_3", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                ++i;
            }
            msgs.add(message.toString());
        }
        return msgs;
    }
}

