/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.writeoff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.concurrency.IBillConcurrencyCtrlStrategy;
import kd.fi.arapcommon.service.helper.CommonVerifyServiceHelper;
import kd.fi.arapcommon.vo.RedVerifyRecordParam;

public abstract class WrittenOffVerifyService {
    public static final Log logger = LogFactory.getLog(WrittenOffVerifyService.class);
    public String verifyRecordEntity;

    public Map<String, Object> generateRedVerifyRecord(Map<String, Object> param, String billEntityKey) {
        RedVerifyRecordParam verifyParam = new RedVerifyRecordParam();
        verifyParam.setOrgIds((List)param.get("writtenofforgids"));
        verifyParam.setSourcebillId(Long.parseLong(String.valueOf(param.get("writtenoffsourcebillid"))));
        verifyParam.setRemark(String.valueOf(param.get("writtenoffremark")));
        verifyParam.setBizDate((Date)param.get("writtenoffbizdate"));
        verifyParam.setBookDate((Date)param.get("writtenoffbookdate"));
        return this.finGenerateRedVerifyRecord(verifyParam, billEntityKey);
    }

    public Map<String, Object> finGenerateRedVerifyRecord(RedVerifyRecordParam param, String billEntityKey) {
        try (TXHandle tx = TX.required((String)"generateRedVerifyRecord");){
            HashMap<String, Object> rollBackMap = new HashMap<String, Object>(64);
            HashSet<Long> writtenOffSrcIdSet = new HashSet<Long>(1);
            writtenOffSrcIdSet.add(param.getSourcebillId());
            IBillConcurrencyCtrlStrategy ctrlStrategy = ConcurrencyCtrlUtil.addCtrl(billEntityKey, "writtenoffverify", writtenOffSrcIdSet, false);
            try {
                logger.info("generateRedVerifyRecord param is " + param + "\nbillEntityKey is " + billEntityKey);
                long begin = System.currentTimeMillis();
                Object[] verifyRecords = this.getVerifyRecord(param.getSourcebillId(), param.getOrgIds());
                if (!ObjectUtils.isEmpty((Object[])verifyRecords)) {
                    logger.info("verifyRecords is not null");
                    List<Long> redVerifyRecordIds = this.getBotpPushedRedVerifyRecordIds((DynamicObject[])verifyRecords, param.getRemark());
                    this.updateVerifyRecords((DynamicObject[])verifyRecords);
                    this.unVerify((DynamicObject[])verifyRecords, true);
                    HashSet<Long> verifyRecordIds = new HashSet<Long>(64);
                    Arrays.stream(verifyRecords).forEach(verifyRecord -> verifyRecordIds.add(verifyRecord.getLong("id")));
                    Map<String, Long> calMap = this.calDispatchService(param, verifyRecordIds, redVerifyRecordIds);
                    rollBackMap.put("redverifyrecordids", redVerifyRecordIds);
                    rollBackMap.put("verifyrecordids", new ArrayList<Long>(verifyRecordIds));
                    rollBackMap.put("calmap", calMap);
                    logger.info("generateRedVerifyRecord consum time: " + (System.currentTimeMillis() - begin) + "ms");
                }
            }
            catch (Exception e) {
                logger.info("generateRedVerifyRecord verify error is: " + e.getMessage());
                tx.markRollback();
                throw e;
            }
            finally {
                if (ctrlStrategy != null) {
                    ctrlStrategy.releaseCtrl();
                }
            }
            HashMap<String, Object> hashMap = rollBackMap;
            return hashMap;
        }
    }

    public Map<String, Object> writtenOffVerify(Map<String, Object> param, String billEntityKey) {
        logger.info("writtenOffVerify param is :" + param + "\nbillEntityKey is " + billEntityKey);
        RedVerifyRecordParam redVerifyRecordParam = new RedVerifyRecordParam();
        redVerifyRecordParam.setSourcebillId(Long.parseLong(String.valueOf(param.get("writtenoffsourcebillid"))));
        redVerifyRecordParam.setBillId(Long.parseLong(String.valueOf(param.get("writtenoffbillid"))));
        redVerifyRecordParam.setRemark(String.valueOf(param.get("writtenoffremark")));
        boolean isreturnbill = (Boolean)param.get("isreturnbill");
        return this.finWrittenOffVerify(redVerifyRecordParam, billEntityKey, isreturnbill);
    }

    public Map<String, Object> finWrittenOffVerify(RedVerifyRecordParam param, String billEntityKey, boolean isReturnBill) {
        try (TXHandle tx = TX.required((String)"writtenOffVerify");){
            logger.info("writtenOffVerify param is :" + param + "\nbillEntityKey is " + billEntityKey + "\nisReturnBill is " + isReturnBill);
            HashMap<String, Object> rollBackMap = new HashMap<String, Object>(64);
            HashSet<Long> writtenOffSrcIdSet = new HashSet<Long>(1);
            writtenOffSrcIdSet.add(param.getSourcebillId());
            IBillConcurrencyCtrlStrategy ctrlStrategy = ConcurrencyCtrlUtil.addCtrl(billEntityKey, "writtenoffverify", writtenOffSrcIdSet, false);
            try {
                long begin = System.currentTimeMillis();
                this.autoVerify(param, billEntityKey, isReturnBill);
                this.updateWrittenOffVerifyRecord(param.getSourcebillId(), param.getBillId(), param.getRemark());
                ArrayList<Long> srcBillIds = new ArrayList<Long>(1);
                srcBillIds.add(param.getSourcebillId());
                ArrayList<Long> billIds = new ArrayList<Long>(1);
                billIds.add(param.getBillId());
                rollBackMap.put("srcbillid", srcBillIds);
                rollBackMap.put("billid", billIds);
                logger.info("writtenOffVerify consum time : " + (System.currentTimeMillis() - begin) + "ms");
            }
            catch (Exception e) {
                logger.info("writtenoff verify error is: " + e.getMessage());
                tx.markRollback();
                throw e;
            }
            finally {
                if (ctrlStrategy != null) {
                    ctrlStrategy.releaseCtrl();
                }
            }
            HashMap<String, Object> hashMap = rollBackMap;
            return hashMap;
        }
    }

    private List<Long> getBotpPushedRedVerifyRecordIds(DynamicObject[] verifyRecords, String remark) {
        ArrayList<Long> verifyRecordIds = new ArrayList<Long>(verifyRecords.length);
        Arrays.stream(verifyRecords).forEach(verifyRecord -> verifyRecordIds.add(verifyRecord.getLong("id")));
        List<DynamicObject> redVerifyRecords = BOTPHelper.push(this.verifyRecordEntity, this.verifyRecordEntity, null, verifyRecordIds);
        ArrayList<Long> redVerifyRecordIds = new ArrayList<Long>(redVerifyRecords.size());
        Map<Long, List<DynamicObject>> redVerifyRecordMap = redVerifyRecords.stream().collect(Collectors.groupingBy(redVerifyRecord -> redVerifyRecord.getLong("org.id")));
        for (Map.Entry<Long, List<DynamicObject>> map : redVerifyRecordMap.entrySet()) {
            List<DynamicObject> redVerifyRecordList = map.getValue();
            Map<String, Integer> verifySeqMap = CommonVerifyServiceHelper.getVerifySeqMap(redVerifyRecordList.toArray(new DynamicObject[0]), this.verifyRecordEntity);
            for (DynamicObject redVerifyRecord2 : redVerifyRecordList) {
                redVerifyRecordIds.add(redVerifyRecord2.getLong("id"));
                long mainBillId = redVerifyRecord2.getLong("billid");
                DynamicObjectCollection entry = redVerifyRecord2.getDynamicObjectCollection("entry");
                long asstBillId = ((DynamicObject)entry.get(0)).getLong("e_billid");
                for (DynamicObject row : entry) {
                    row.set("e_writtenoffremark", (Object)remark);
                }
                redVerifyRecord2.set("verifyseq", (Object)verifySeqMap.get(mainBillId + "-" + asstBillId));
            }
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)this.verifyRecordEntity, (DynamicObject[])redVerifyRecords.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationHelper.assertResult(saveResult);
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)this.verifyRecordEntity, (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
        OperationHelper.assertResult(submitResult);
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)this.verifyRecordEntity, (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
        OperationHelper.assertResult(auditResult);
        logger.info("redVerifyRecordIds is " + redVerifyRecordIds);
        return redVerifyRecordIds;
    }

    protected abstract void unVerify(DynamicObject[] var1, boolean var2);

    protected abstract void autoVerifyById(String var1, List<Long> var2, List<Long> var3, boolean var4);

    private void autoVerify(RedVerifyRecordParam param, String billEntityKey, boolean isReturnBill) {
        ArrayList<Long> mainIds = new ArrayList<Long>(1);
        mainIds.add(param.getSourcebillId());
        ArrayList<Long> asstIds = new ArrayList<Long>(1);
        asstIds.add(param.getBillId());
        if (ObjectUtils.isEmpty(mainIds) || ObjectUtils.isEmpty(asstIds)) {
            logger.info("writtenoff autoVerify failure;return\nmainIds:" + mainIds + "\nassIds:" + asstIds);
            return;
        }
        this.autoVerifyById(billEntityKey, mainIds, asstIds, isReturnBill);
    }

    private DynamicObject[] getVerifyRecord(long writtenOffSrcId, List<Long> orgIds) {
        QFilter filterByMain = new QFilter("org", "in", orgIds);
        filterByMain.and(new QFilter("billid", "=", (Object)writtenOffSrcId));
        filterByMain.and(new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE));
        filterByMain.and(new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.FALSE));
        Object[] verifyRecordsByMain = BusinessDataServiceHelper.load((String)this.verifyRecordEntity, (String)this.getVerifyRecordSelects(), (QFilter[])filterByMain.toArray());
        QFilter filterByAsst = new QFilter("org", "in", orgIds);
        filterByAsst.and(new QFilter("entry.e_billid", "=", (Object)writtenOffSrcId));
        filterByAsst.and(new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE));
        filterByAsst.and(new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.FALSE));
        Object[] verifyRecordsByAsst = BusinessDataServiceHelper.load((String)this.verifyRecordEntity, (String)this.getVerifyRecordSelects(), (QFilter[])filterByAsst.toArray());
        return (DynamicObject[])ArrayUtils.addAll((Object[])verifyRecordsByMain, (Object[])verifyRecordsByAsst);
    }

    private void updateVerifyRecords(DynamicObject[] verifyRecords) {
        for (DynamicObject verifyRecord : verifyRecords) {
            DynamicObjectCollection entry = verifyRecord.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                row.set("e_hadwrittenoff", (Object)Boolean.TRUE);
            }
        }
        SaveServiceHelper.save((DynamicObject[])verifyRecords);
    }

    private Map<String, Long> calDispatchService(RedVerifyRecordParam param, Set<Long> verifyRecordIds, List<Long> redVerifyRecordIds) {
        HashMap<String, Long> calMap = new HashMap<String, Long>(64);
        DynamicObjectCollection redVerifyRecords = QueryServiceHelper.query((String)this.verifyRecordEntity, (String)"verifydate", (QFilter[])new QFilter[]{new QFilter("id", "in", redVerifyRecordIds)});
        Date maxVerifyDate = null;
        for (DynamicObject redVerifyRecord : redVerifyRecords) {
            Date verifydate = redVerifyRecord.getDate("verifydate");
            if (maxVerifyDate != null && (maxVerifyDate == null || verifydate == null || !maxVerifyDate.before(verifydate))) continue;
            maxVerifyDate = verifydate;
        }
        boolean systemCallParam = QueryServiceHelper.exists((String)"sbs_intersystemcallconf", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"KC0001"), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        logger.info("systemCallParam is " + systemCallParam);
        if (systemCallParam) {
            long end = System.currentTimeMillis();
            logger.info("CalChargeOffService param is " + param + "\nverifyRecordIds is " + verifyRecordIds);
            Map calChargeOffMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalChargeOffService", (String)"chargeOffWriteRecord", (Object[])new Object[]{verifyRecordIds, param.getBizDate(), param.getBookDate(), maxVerifyDate, param.getRemark()});
            logger.info("generateRedVerifyRecord calDispatchService consum time\uff1a" + (System.currentTimeMillis() - end) + "ms");
            for (Map.Entry map : calChargeOffMap.entrySet()) {
                calMap.put(String.valueOf(map.getKey()), (Long)map.getValue());
            }
        }
        return calMap;
    }

    private String getVerifyRecordSelects() {
        return "org,billid,billno,billtype,billentryid,qty,measureunit,verifyqty,verifybaseqty,payableamount,verifyamount,verifytype,verifyrelation,e_billtype,e_qty,e_measureunit,e_verifyqty,e_verifybaseqty,e_payableamount,e_verifyamount,e_billid,e_billno,e_billentryid,currency,e_currency,e_verifytaxamount,verifytaxamount,e_writtenoffremark,e_iswrittenoff,e_hadwrittenoff";
    }

    private void updateWrittenOffVerifyRecord(long mainId, long asstId, String remark) {
        if (!ObjectUtils.isEmpty((Object)remark)) {
            DynamicObject[] verifyRecords;
            for (DynamicObject verifyRecord : verifyRecords = BusinessDataServiceHelper.load((String)this.verifyRecordEntity, (String)"entry.e_writtenoffremark", (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)mainId), new QFilter("entry.e_billid", "=", (Object)asstId)})) {
                DynamicObjectCollection entry = verifyRecord.getDynamicObjectCollection("entry");
                for (DynamicObject row : entry) {
                    row.set("e_writtenoffremark", (Object)remark);
                }
            }
            SaveServiceHelper.save((DynamicObject[])verifyRecords);
        }
    }

    public void redVerifyRecordRollBack(Map<String, Object> rollBackMap) {
        try (TXHandle tx = TX.required((String)"redVerifyRecordRollBack");){
            try {
                logger.info("redVerifyRecordRollBack param is " + rollBackMap);
                List redVerifyRecordIds = (List)rollBackMap.get("redverifyrecordids");
                List verifyRecordIds = (List)rollBackMap.get("verifyrecordids");
                Map calMap = (Map)rollBackMap.get("calmap");
                if (!ObjectUtils.isEmpty((Object)verifyRecordIds)) {
                    DynamicObject[] updatedVerifyRecords;
                    for (DynamicObject updatedVerifyRecord : updatedVerifyRecords = BusinessDataServiceHelper.load((String)this.verifyRecordEntity, (String)"entry.e_hadwrittenoff,entry.e_writtenoffremark", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)verifyRecordIds)})) {
                        DynamicObjectCollection entry = updatedVerifyRecord.getDynamicObjectCollection("entry");
                        for (DynamicObject row : entry) {
                            row.set("e_hadwrittenoff", (Object)Boolean.FALSE);
                            row.set("e_writtenoffremark", null);
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])updatedVerifyRecords);
                }
                if (!ObjectUtils.isEmpty((Object)redVerifyRecordIds)) {
                    DynamicObject[] redVerifyRecords = BusinessDataServiceHelper.load((String)this.verifyRecordEntity, (String)this.getVerifyRecordSelects(), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)redVerifyRecordIds)});
                    this.unVerify(redVerifyRecords, true);
                    DeleteServiceHelper.delete((String)this.verifyRecordEntity, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)redVerifyRecordIds)});
                }
                if (!ObjectUtils.isEmpty((Object)calMap)) {
                    HashMap<Long, Long> calRollBackMap = new HashMap<Long, Long>(64);
                    for (Map.Entry entry : calMap.entrySet()) {
                        calRollBackMap.put(Long.parseLong(String.valueOf(entry.getKey())), (Long)entry.getValue());
                    }
                    this.chargeOffWriteRecord4RollBack(new HashSet<Long>(verifyRecordIds), calRollBackMap);
                }
            }
            catch (Exception e) {
                logger.info("redVerifyRecordRollBack error is: " + e.getMessage());
                tx.markRollback();
                throw e;
            }
        }
    }

    private void chargeOffWriteRecord4RollBack(Set<Long> writeOffIDSet, Map<Long, Long> calChargeOffMap) {
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalChargeOffService", (String)"chargeOffWriteRecord4RollBack", (Object[])new Object[]{writeOffIDSet, calChargeOffMap});
    }

    public void writtenOffVerifyRollBack(Map<String, Object> rollBackMap) {
        try (TXHandle tx = TX.required((String)"writtenOffVerifyRollBack");){
            try {
                logger.info("writtenOffVerifyRollBack param is " + rollBackMap);
                if (!ObjectUtils.isEmpty(rollBackMap)) {
                    List srcBillId = (List)rollBackMap.get("srcbillid");
                    List billId = (List)rollBackMap.get("billid");
                    DynamicObject[] verifyRecords = BusinessDataServiceHelper.load((String)this.verifyRecordEntity, (String)this.getVerifyRecordSelects(), (QFilter[])new QFilter[]{new QFilter("billid", "in", (Object)srcBillId), new QFilter("entry.e_billid", "in", (Object)billId)});
                    this.unVerify(verifyRecords, false);
                }
            }
            catch (Exception e) {
                logger.info("writtenOffVerifyRollBack error is: " + e.getMessage());
                tx.markRollback();
                throw e;
            }
        }
    }
}

