/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.task;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.arapcommon.enums.UpgradeExecuteStatusEnum;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.util.JsonUtils;

public class ArApRegularUpgradeTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ArApRegularUpgradeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        log.info("ArApRegularUpgradeTask in execute\u3002");
        QFilter qFilter = new QFilter("executestatus", "in", Arrays.asList(UpgradeExecuteStatusEnum.WAIT.getValue(), UpgradeExecuteStatusEnum.FAILED.getValue()));
        qFilter.and("isdefault", "=", (Object)Boolean.TRUE);
        qFilter.and("billstatus", "=", (Object)"C");
        Object[] upgradeConfigs = BusinessDataServiceHelper.load((String)"arap_upgradeconfig", (String)"id,billno,entryentity.e_executetimes", (QFilter[])new QFilter[]{qFilter});
        if (ObjectUtils.isEmpty((Object[])upgradeConfigs)) {
            return;
        }
        Set<Long> moreThreeTimesIds = this.getLessThreeTimesBillIds((DynamicObject[])upgradeConfigs);
        ThreadPools.executeOnceIncludeRequestContext((String)"ArApExecuteUpgradeOp.upgrade", () -> this.sendMessage(moreThreeTimesIds, map));
        Object[] configIds = (Long[])Arrays.stream(upgradeConfigs).filter(bill -> !moreThreeTimesIds.contains(bill.getLong("id"))).map(bill -> bill.getLong("id")).toArray(Long[]::new);
        log.info("ArApRegularUpgradeTask_configIds : " + Arrays.toString(configIds));
        if (!ObjectUtils.isEmpty((Object[])configIds)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isupgradetask", "true");
            OperationResult operate = OperationServiceHelper.executeOperate((String)"upgrade", (String)"arap_upgradeconfig", (Object[])configIds, (OperateOption)option);
            OperationHelper.assertResult(operate);
        }
    }

    private void sendMessage(Set<Long> moreThreeTimesIds, Map<String, Object> map) {
        log.info("ArApRegularUpgradeTask sendMessage prepare");
        if (moreThreeTimesIds.isEmpty() || ObjectUtils.isEmpty(map)) {
            return;
        }
        log.info("ArApRegularUpgradeTask begin to send message");
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("warning");
        messageInfo.setTitle(ResManager.loadKDString((String)"\u6d88\u606f\u4e2d\u5fc3\u6765\u4fe1\u3002", (String)"ArApRegularUpgradeTask_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        messageInfo.setContent(String.valueOf(map.get("content")));
        messageInfo.setSenderName(ResManager.loadKDString((String)"\u8d22\u52a1\u4e91", (String)"ArApRegularUpgradeTask_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        String userId = JsonUtils.getValueFromJson(String.valueOf(map.get("user")), "id");
        messageInfo.setUserIds(Collections.singletonList(Long.valueOf(userId)));
        messageInfo.setTag(ResManager.loadKDString((String)"\u5fc5\u8bfb", (String)"ArApRegularUpgradeTask_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        messageInfo.setNotifyType(MessageChannels.MC.getNumber());
        long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        log.info("\u5e94\u4ed8\u5e94\u4ed8\u5b9a\u65f6\u6267\u884c\u6570\u636e\u5347\u7ea7\u903b\u8f91\u8c03\u5ea6\u4f5c\u4e1a\u53d1\u9001\u6d88\u606fID:" + msgId);
    }

    private Set<Long> getLessThreeTimesBillIds(DynamicObject[] upgradeConfigs) {
        HashSet<Long> billIds = new HashSet<Long>(64);
        block0: for (DynamicObject upgradeConfig : upgradeConfigs) {
            DynamicObjectCollection entryEntity = upgradeConfig.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entryEntity) {
                if (row.getInt("e_executetimes") < 3) continue;
                billIds.add(upgradeConfig.getLong("id"));
                continue block0;
            }
        }
        return billIds;
    }
}

