/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.task;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class InventoryCostTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(InventoryCostTask.class);
    private static final String DAYS = "days";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("--begin execute inventory cost task--");
        int days = Integer.parseInt((String)map.get(DAYS));
        Instant endTime = Instant.now().minus(Duration.ofDays(days));
        QFilter[] filters = new QFilter("exectime", ">", (Object)Date.from(endTime)).and(new QFilter("issuccess", "=", (Object)Boolean.FALSE)).toArray();
        DynamicObjectCollection entities = QueryServiceHelper.query((String)"ap_serviceinvokelog", (String)"id", (QFilter[])filters);
        OperationServiceHelper.executeOperate((String)"reinvoke", (String)"ap_serviceinvokelog", (Object[])entities.stream().map(entity -> entity.getLong("id")).toArray(), (OperateOption)OperateOption.create());
        LOGGER.info("--end execute inventory cost task--");
    }
}

