/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.task;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.helper.OperationHelper;

public class RPASettleSchemeExecuteTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(RPASettleSchemeExecuteTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        logger.info(" RPASettleSchemeExecuteTask execute param: {}", paramMap);
        List schemeIds = (List)paramMap.get("schemeIds");
        String appId = (String)paramMap.get("appId");
        if (schemeIds.size() != 0) {
            for (Long schemeId : schemeIds) {
                this.executeScheme(schemeId, appId);
            }
        }
    }

    private void executeScheme(Long schemeId, String appId) {
        String schemeEntity = "ap".equals(appId) ? "ap_rpa_settlescheme" : "ar_rpa_settlescheme";
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)schemeEntity);
        if (scheme != null) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isManual", "false");
            OperationResult result = OperationServiceHelper.executeOperate((String)"dosettle", (String)schemeEntity, (Object[])new Object[]{schemeId}, (OperateOption)option);
            OperationHelper.assertResult(result);
        }
    }
}

