/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.tax;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.taxc.vo.TaxAmountLineVo;
import kd.bos.ext.taxc.vo.TaxAmountMaterialLineVo;
import kd.bos.ext.taxc.vo.TaxLineVo;
import kd.bos.ext.taxc.vo.TaxMaterialLineVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.business.price.AbstractPriceCalculator;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.helper.TaxHelper;
import kd.fi.arapcommon.tax.base.TaxCodeService;
import kd.fi.arapcommon.util.EmptyUtils;

public class BusTaxCodeServiceImpl
extends TaxCodeService {
    private static final Log LOG = LogFactory.getLog(BusTaxCodeServiceImpl.class);

    @Override
    public void setTax(DynamicObject[] billList) {
        this.initGlobalVariable(billList[0]);
        for (DynamicObject bill : billList) {
            List<TaxMaterialLineVo> taxCodeList = TaxHelper.listTaxCode(bill);
            if (EmptyUtils.isEmpty(taxCodeList)) continue;
            this.updateDetailEntryTaxCode(bill, taxCodeList);
            this.updateBillAmtByTaxRate(bill);
            this.updateTaxDetailEntryAmt(bill);
        }
    }

    private void updateTaxDetailEntryAmt(DynamicObject entity) {
        String entryName = TaxHelper.getBillDetailEntryName(entity.getDataEntityType().getName());
        DynamicObjectCollection detailEntryCollection = entity.getDynamicObjectCollection(entryName);
        detailEntryCollection.forEach(rowEntry -> LOG.info("row e_amount:" + rowEntry.getBigDecimal("e_amount")));
        List<TaxAmountMaterialLineVo> taxLineList = TaxHelper.listAllTaxLine(entity);
        LOG.info("TaxCodeConvertPlugin \u7a0e\u989d\u67e5\u8be2\u4fe1\u606f:" + taxLineList);
        if (EmptyUtils.isEmpty(taxLineList)) {
            return;
        }
        for (int i = 0; i < taxLineList.size(); ++i) {
            DynamicObject detailEntryRow = (DynamicObject)detailEntryCollection.get(i);
            this.setTaxDetailEntryTaxAmt(detailEntryRow, taxLineList.get(i).getTaxAmountLineVo());
        }
    }

    private void setTaxDetailEntryTaxAmt(DynamicObject detailEntryRow, List<TaxAmountLineVo> taxAmountLineVo) {
        DynamicObjectCollection taxDetailEntryCollection = detailEntryRow.getDynamicObjectCollection("subentryentity");
        for (int i = 0; i < taxAmountLineVo.size(); ++i) {
            DynamicObject taxDetailEntryRow = (DynamicObject)taxDetailEntryCollection.get(i);
            if (EmptyUtils.isEmpty(taxAmountLineVo.get(i))) continue;
            taxDetailEntryRow.set("s_tax", (Object)taxAmountLineVo.get(i).getTaxAmount());
        }
    }

    private void updateDetailEntryTaxCode(DynamicObject entity, List<TaxMaterialLineVo> taxCodeList) {
        Map<Long, DynamicObject> taxCodeIdMap = TaxHelper.getTaxCodeIdMap(taxCodeList);
        Map<Long, DynamicObject> taxCategoryIdMap = TaxHelper.getTaxCategoryIdMap(taxCodeList);
        Map<Long, DynamicObject> taxRateIdMap = TaxHelper.getTaxRateIdMap(taxCodeList);
        String entryName = TaxHelper.getBillDetailEntryName(this.entityName);
        DynamicObjectCollection detailEntryCollection = entity.getDynamicObjectCollection(entryName);
        for (int i = 0; i < detailEntryCollection.size(); ++i) {
            DynamicObject entry = (DynamicObject)detailEntryCollection.get(i);
            this.setDetailEntryTax(i, entry, taxCodeList.get(i).getTaxLineVos(), taxCodeIdMap, taxCategoryIdMap, taxRateIdMap);
        }
    }

    private void updateBillAmtByTaxRate(DynamicObject entity) {
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localAmt = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocalAmt = BigDecimal.ZERO;
        String entryName = TaxHelper.getBillDetailEntryName(this.entityName);
        DynamicObjectCollection detailEntryCollection = entity.getDynamicObjectCollection(entryName);
        boolean isIncludeTax = entity.getBoolean("isincludetax");
        BigDecimal exchangeRate = entity.getBigDecimal("exchangerate");
        int precision = entity.getInt("currency.amtprecision");
        int basePrecision = entity.getInt("basecurrency.amtprecision");
        for (int i = 0; i < detailEntryCollection.size(); ++i) {
            AbstractPriceCalculator calculator;
            DynamicObject entry = (DynamicObject)detailEntryCollection.get(i);
            BigDecimal taxRate = entry.getBigDecimal("e_taxrate");
            BigDecimal qty = entry.getBigDecimal("e_quantity");
            String discountMode = entry.getString("e_discountamount");
            BigDecimal discountRate = entry.getBigDecimal("e_discountrate");
            if (isIncludeTax) {
                BigDecimal taxUnitPrice = entry.getBigDecimal("e_taxunitprice");
                calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision);
            } else {
                BigDecimal unitPrice = entry.getBigDecimal("e_unitprice");
                calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision);
            }
            PriceLocalCalculator localCalculator = new PriceLocalCalculator(calculator, exchangeRate, basePrecision);
            localCalculator.calculate();
            BigDecimal entryTax = localCalculator.getTax();
            BigDecimal entryTaxLocalAmt = localCalculator.getTaxlocal();
            BigDecimal entryAmount = localCalculator.getAmount();
            BigDecimal entryLocalAmt = localCalculator.getAmountlocal();
            BigDecimal entryPriceTaxTotal = localCalculator.getPricetaxtotal();
            BigDecimal entryPriceTaxTotalBase = localCalculator.getPricetaxtotallocal();
            entry.set("e_unitprice", (Object)localCalculator.getUnitprice());
            entry.set("e_taxunitprice", (Object)localCalculator.getTaxunitprice());
            entry.set("e_actunitprice", (Object)localCalculator.getActunitprice());
            entry.set("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice());
            entry.set("e_amount", (Object)entryAmount);
            entry.set("e_localamt", (Object)localCalculator.getAmountlocal());
            entry.set("e_tax", (Object)localCalculator.getTax());
            entry.set("e_taxlocalamt", (Object)localCalculator.getTaxlocal());
            entry.set("e_discountamount", (Object)localCalculator.getDiscountamount());
            entry.set("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
            entry.set(this.isAr ? "e_recamount" : "e_pricetaxtotal", (Object)entryPriceTaxTotal);
            entry.set(this.isAr ? "e_reclocalamt" : "e_pricetaxtotalbase", (Object)entryPriceTaxTotalBase);
            if (this.isAr) {
                entry.set("e_unconfirmamt", (Object)entryAmount);
            }
            entry.set("e_uninvoicedqty", (Object)qty);
            entry.set("e_uninvoicedamt", (Object)entryPriceTaxTotal);
            entry.set("e_uninvoicedlocamt", (Object)entryPriceTaxTotalBase);
            entry.set("e_unwoffqty", (Object)qty);
            entry.set("e_unwoffamt", (Object)entryPriceTaxTotal);
            entry.set("e_unwofflocamt", (Object)entryPriceTaxTotalBase);
            priceTaxTotal = priceTaxTotal.add(entryPriceTaxTotal);
            priceTaxTotalBase = priceTaxTotalBase.add(entryPriceTaxTotalBase);
            amount = amount.add(entryAmount);
            localAmt = localAmt.add(entryLocalAmt);
            tax = tax.add(entryTax);
            taxLocalAmt = taxLocalAmt.add(entryTaxLocalAmt);
        }
        entity.set(this.isAr ? "recamount" : "pricetaxtotal", (Object)priceTaxTotal);
        entity.set(this.isAr ? "reclocalamt" : "pricetaxtotalbase", (Object)priceTaxTotalBase);
        entity.set("amount", (Object)amount);
        entity.set("localamt", (Object)localAmt);
        entity.set("tax", (Object)tax);
        entity.set("taxlocamt", (Object)taxLocalAmt);
        entity.set("uninvoicedamt", (Object)priceTaxTotal);
        entity.set("uninvoicedlocamt", (Object)priceTaxTotalBase);
        entity.set("unwoffamt", (Object)priceTaxTotal);
        entity.set("unwofflocamt", (Object)priceTaxTotalBase);
        this.updatePlanEntryAmt(entity, priceTaxTotal, priceTaxTotalBase);
    }

    private void setDetailEntryTax(int rowIndex, DynamicObject entryRowEntity, List<TaxLineVo> taxLineList, Map<Long, DynamicObject> taxCodeIdMap, Map<Long, DynamicObject> taxCategoryIdMap, Map<Long, DynamicObject> taxRateIdMap) {
        Optional<TaxLineVo> defaultTaxLine = taxLineList.stream().filter(line -> line.getDefaultTaxCode().compareTo(1) == 0).findAny();
        long taxCodeId = 0L;
        long taxRateId = 0L;
        if (defaultTaxLine.isPresent()) {
            taxCodeId = defaultTaxLine.get().getTaxCode();
            taxRateId = defaultTaxLine.get().getTaxRate();
            LOG.info("FinBatchCalculateTaxOp:\u5f53\u524d\u884c\u7a0e\u7801\u4fe1\u606f" + defaultTaxLine.get());
        }
        entryRowEntity.set("e_taxcode", (Object)taxCodeIdMap.get(taxCodeId));
        if (taxRateId > 0L) {
            DynamicObject taxRate = taxRateIdMap.get(taxRateId);
            entryRowEntity.set("taxrateid", (Object)taxRate);
            entryRowEntity.set("e_taxrate", (Object)(EmptyUtils.isEmpty(taxRate) ? BigDecimal.ZERO : taxRate.getBigDecimal("taxrate")));
        }
        DynamicObjectCollection taxDetailEntryCollection = entryRowEntity.getDynamicObjectCollection("subentryentity");
        taxDetailEntryCollection.clear();
        for (TaxLineVo taxLine : taxLineList) {
            if (EmptyUtils.isEmpty(taxLine)) continue;
            DynamicObject taxDetailEntryRow = taxDetailEntryCollection.addNew();
            taxDetailEntryRow.set("s_taxcode", (Object)taxCodeIdMap.get(taxLine.getTaxCode()));
            taxDetailEntryRow.set("s_taxcategory", (Object)taxCategoryIdMap.get(taxLine.getTaxType()));
            taxDetailEntryRow.set("s_taxrateid", (Object)taxRateIdMap.get(taxLine.getTaxRate()));
            taxDetailEntryRow.set("s_taxrate", (Object)taxLine.getTaxRatePercent());
            taxDetailEntryRow.set("s_isoffset", (Object)Boolean.valueOf(taxLine.getOffsetLogo()));
            taxDetailEntryRow.set("s_priority", (Object)taxLine.getOrder());
        }
    }

    private void updatePlanEntryAmt(DynamicObject entity, BigDecimal priceTaxTotal, BigDecimal priceTaxTotalLocal) {
        EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)this.entityName).findProperty("planentity");
        DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
        DynamicObject planEntry = new DynamicObject(dt);
        planEntry.set("planduedate", (Object)new Date());
        planEntry.set("planpricetax", (Object)priceTaxTotal);
        DynamicObject settlementType = entity.getDynamicObject("settlementtype");
        if (!ObjectUtils.isEmpty((Object)settlementType)) {
            planEntry.set("plansettletype", (Object)settlementType);
        }
        planEntry.set("planpricetaxloc", (Object)priceTaxTotalLocal);
        planEntry.set("p_uninvoicedamt", (Object)priceTaxTotal);
        planEntry.set("p_uninvoicedlocamt", (Object)priceTaxTotalLocal);
        entity.getDynamicObjectCollection("planentity").add((Object)planEntry);
    }
}

