/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.tax;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.taxc.vo.TaxAmountLineVo;
import kd.bos.ext.taxc.vo.TaxAmountMaterialLineVo;
import kd.bos.ext.taxc.vo.TaxLineVo;
import kd.bos.ext.taxc.vo.TaxMaterialLineVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.business.price.AbstractPriceCalculator;
import kd.fi.arapcommon.business.price.FXPriceLocalCalculator;
import kd.fi.arapcommon.business.price.FxCalculator;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.helper.TaxHelper;
import kd.fi.arapcommon.service.plan.FinPlanRowService;
import kd.fi.arapcommon.service.plan.PlanRow;
import kd.fi.arapcommon.tax.base.TaxCodeService;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinTaxCodeServiceImpl
extends TaxCodeService {
    private static final Log LOG = LogFactory.getLog(FinTaxCodeServiceImpl.class);
    private String quantityKey = "e_quantity";
    private String discountModeKey = "e_discountmode";
    private String discountRateKey = "e_discountrate";
    private String discountAmtKey = "e_discountamount";
    private String unitPriceKey = "e_unitprice";
    private String taxUnitPriceKey = "e_taxunitprice";
    private String recAmountKey = "e_recamount";

    @Override
    public void setTax(DynamicObject[] billList) {
        this.initGlobalVariable(billList[0]);
        this.dealFieldKey();
        for (DynamicObject bill : billList) {
            List<TaxMaterialLineVo> taxCodeList = TaxHelper.listTaxCode(bill);
            if (EmptyUtils.isEmpty(taxCodeList)) continue;
            this.updateDetailEntryTaxCode(bill, taxCodeList);
            this.updateBillAmt(bill);
            this.updateTaxDetailEntry(bill);
            this.updateBillAmt(bill);
        }
    }

    private void updateTaxDetailEntry(DynamicObject entity) {
        String entryName = TaxHelper.getBillDetailEntryName(entity.getDataEntityType().getName());
        DynamicObjectCollection detailEntryCollection = entity.getDynamicObjectCollection(entryName);
        detailEntryCollection.forEach(rowEntry -> LOG.info("row e_amount:" + rowEntry.getBigDecimal("e_amount")));
        String entityName = entity.getDataEntityType().getName();
        List<TaxAmountMaterialLineVo> taxLineList = TaxHelper.listAllTaxLine(entity);
        LOG.info("TaxCodeConvertPlugin \u7a0e\u989d\u67e5\u8be2\u4fe1\u606f:" + taxLineList);
        if (EmptyUtils.isEmpty(taxLineList)) {
            detailEntryCollection.forEach(detailEntryRow -> this.setDetailEntryRowAdjustAmt(entity, (DynamicObject)detailEntryRow));
            return;
        }
        for (int i = 0; i < taxLineList.size(); ++i) {
            DynamicObject detailEntryRow2 = (DynamicObject)detailEntryCollection.get(i);
            this.setTaxDetailEntryTaxAmt(detailEntryRow2, taxLineList.get(i).getTaxAmountLineVo());
            this.setDetailEntryRowAdjustAmt(entity, detailEntryRow2);
        }
    }

    private void setTaxDetailEntryTaxAmt(DynamicObject detailEntryRow, List<TaxAmountLineVo> taxAmountLineVo) {
        DynamicObjectCollection taxDetailEntryCollection = detailEntryRow.getDynamicObjectCollection("subentryentity");
        for (int i = 0; i < taxAmountLineVo.size(); ++i) {
            DynamicObject taxDetailEntryRow = (DynamicObject)taxDetailEntryCollection.get(i);
            if (EmptyUtils.isEmpty(taxAmountLineVo.get(i))) continue;
            taxDetailEntryRow.set("s_tax", (Object)taxAmountLineVo.get(i).getTaxAmount());
        }
    }

    private void setDetailEntryRowAdjustAmt(DynamicObject entity, DynamicObject detailEntryRow) {
        List taxDetailEntryCollection = detailEntryRow.getDynamicObjectCollection("subentryentity").stream().filter(entryRow -> entryRow.getBoolean("s_isoffset")).collect(Collectors.toList());
        BigDecimal offSetAmt = taxDetailEntryCollection.stream().map(entryRow -> entryRow.getBigDecimal("s_tax")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal exchangeRate = entity.getBigDecimal("exchangerate");
        detailEntryRow.set("e_adjustamount", (Object)offSetAmt.negate());
        detailEntryRow.set("e_adjustlocalamt", (Object)offSetAmt.negate().multiply(exchangeRate));
    }

    private void updateDetailEntryTaxCode(DynamicObject entity, List<TaxMaterialLineVo> taxCodeList) {
        String entryName = TaxHelper.getBillDetailEntryName(this.entityName);
        DynamicObjectCollection detailEntryCollection = entity.getDynamicObjectCollection(entryName);
        Map<Long, DynamicObject> taxCodeIdMap = TaxHelper.getTaxCodeIdMap(taxCodeList);
        Map<Long, DynamicObject> taxCategoryIdMap = TaxHelper.getTaxCategoryIdMap(taxCodeList);
        Map<Long, DynamicObject> taxRateIdMap = TaxHelper.getTaxRateIdMap(taxCodeList);
        for (int i = 0; i < detailEntryCollection.size(); ++i) {
            DynamicObject entry = (DynamicObject)detailEntryCollection.get(i);
            this.setDetailEntryTax(i, entry, taxCodeList.get(i).getTaxLineVos(), taxCodeIdMap, taxCategoryIdMap, taxRateIdMap);
        }
    }

    private void dealFieldKey() {
        if (!this.isAr) {
            this.quantityKey = "quantity";
            this.discountModeKey = "discountmode";
            this.discountRateKey = "discountrate";
            this.discountAmtKey = "discountamount";
            this.unitPriceKey = "price";
            this.taxUnitPriceKey = "pricetax";
            this.recAmountKey = "e_pricetaxtotal";
        }
    }

    private void updateBillAmt(DynamicObject entity) {
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localAmt = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocalAmt = BigDecimal.ZERO;
        BigDecimal adjustAmt = BigDecimal.ZERO;
        BigDecimal adjustAmtLocal = BigDecimal.ZERO;
        BigDecimal unInvoiceAmt = BigDecimal.ZERO;
        String entryName = TaxHelper.getBillDetailEntryName(this.entityName);
        DynamicObjectCollection detailEntryCollection = entity.getDynamicObjectCollection(entryName);
        boolean isIncludeTax = entity.getBoolean("isincludetax");
        BigDecimal exchangeRate = entity.getBigDecimal("exchangerate");
        int precision = entity.getInt("currency.amtprecision");
        int basePrecision = entity.getInt("basecurrency.amtprecision");
        boolean isBasedOnAmt = entity.getBoolean("payproperty.isbasedonamt");
        for (int i = 0; i < detailEntryCollection.size(); ++i) {
            AbstractPriceCalculator calculator;
            DynamicObject entry = (DynamicObject)detailEntryCollection.get(i);
            BigDecimal taxRate = entry.getBigDecimal(!this.isAr ? "taxrate" : "e_taxrate");
            BigDecimal qty = entry.getBigDecimal(this.quantityKey);
            String discountMode = entry.getString(this.discountModeKey);
            BigDecimal discountRate = entry.getBigDecimal(this.discountRateKey);
            BigDecimal entryAdjustAmount = entry.getBigDecimal("e_adjustamount");
            BigDecimal entryAdjustLocalAmt = entry.getBigDecimal("e_adjustlocalamt");
            String sourceBillType = entity.getString("sourcebilltype");
            if (isBasedOnAmt && ("ar_finarbill".equals(this.entityName) && "ar_busbill".equals(sourceBillType) || "ap_finapbill".equals(this.entityName) && "ap_busbill".equals(sourceBillType))) {
                if ("PERUNIT".equals(discountMode)) {
                    discountMode = "PERCENT";
                    entry.set(this.discountModeKey, (Object)discountMode);
                    discountRate = isIncludeTax ? discountRate.multiply(new BigDecimal(100)).divide(entry.getBigDecimal(this.taxUnitPriceKey), 4, RoundingMode.HALF_UP) : entry.getBigDecimal(this.discountAmtKey).multiply(new BigDecimal(100)).divide(entry.getBigDecimal(this.taxUnitPriceKey), 4, RoundingMode.HALF_UP);
                    entry.set(this.discountRateKey, (Object)discountRate);
                }
                BigDecimal entryPriceTaxTotal = entry.getBigDecimal(this.recAmountKey);
                calculator = new PriceTaxTotalCalculator(qty, entryPriceTaxTotal, taxRate, discountMode, discountRate, precision, entryAdjustAmount);
            } else if (isIncludeTax) {
                BigDecimal taxUnitPrice = entry.getBigDecimal(this.taxUnitPriceKey);
                calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision);
            } else {
                BigDecimal unitPrice = entry.getBigDecimal(this.unitPriceKey);
                calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision);
            }
            PriceLocalCalculator localCalculator = new PriceLocalCalculator(calculator, exchangeRate, basePrecision);
            localCalculator.calculate();
            BigDecimal entryTax = localCalculator.getTax();
            BigDecimal entryTaxLocalAmt = localCalculator.getTaxlocal();
            BigDecimal entryAmount = localCalculator.getAmount();
            BigDecimal entryLocalAmt = localCalculator.getAmountlocal();
            BigDecimal entryPriceTaxTotal = localCalculator.getPricetaxtotal();
            FxCalculator fxCalculator = new FxCalculator(entryTax, entryAmount, entryPriceTaxTotal, entryAdjustAmount, false, false, false, false, false, true);
            FXPriceLocalCalculator fxPriceLocalCalculator = new FXPriceLocalCalculator(fxCalculator, exchangeRate, basePrecision);
            fxPriceLocalCalculator.calculate();
            entryPriceTaxTotal = fxPriceLocalCalculator.getPricetaxtotal();
            BigDecimal entryPriceTaxTotalBase = fxPriceLocalCalculator.getPriceTaxTotalLocal();
            entry.set(this.unitPriceKey, (Object)localCalculator.getUnitprice());
            entry.set(this.taxUnitPriceKey, (Object)localCalculator.getTaxunitprice());
            entry.set(!this.isAr ? "actprice" : "e_actunitprice", (Object)localCalculator.getActunitprice());
            entry.set(!this.isAr ? "actpricetax" : "e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice());
            entry.set("e_amount", (Object)entryAmount);
            entry.set(!this.isAr ? "e_amountbase" : "e_localamt", (Object)localCalculator.getAmountlocal());
            entry.set("e_tax", (Object)localCalculator.getTax());
            entry.set(this.discountAmtKey, (Object)localCalculator.getDiscountamount());
            entry.set(!this.isAr ? "discountlocalamt" : "e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
            entry.set(this.recAmountKey, (Object)entryPriceTaxTotal);
            entry.set(!this.isAr ? "e_pricetaxtotalbase" : "e_reclocalamt", (Object)entryPriceTaxTotalBase);
            entry.set(!this.isAr ? "unverifyquantity" : "e_unverifyqty", (Object)qty);
            entry.set(!this.isAr ? "e_unverifyamount" : "e_unverifyamt", (Object)entryAmount);
            entry.set(!this.isAr ? "unlockamt" : "e_unlockamt", (Object)entryPriceTaxTotal);
            entry.set(!this.isAr ? "unsettleamt" : "e_unsettleamt", (Object)entryPriceTaxTotal);
            entry.set(!this.isAr ? "unsettleamtbase" : "e_unsettlelocalamt", (Object)entryPriceTaxTotalBase);
            entry.set("e_uninvoicedamt", (Object)entryPriceTaxTotal);
            if ("ar_finarbill".equals(this.entityName)) {
                entry.set("e_unconfirmamt", (Object)entryAmount);
                entry.set("e_uninvoicedqty", (Object)qty);
            }
            priceTaxTotal = priceTaxTotal.add(entryPriceTaxTotal);
            priceTaxTotalBase = priceTaxTotalBase.add(entryPriceTaxTotalBase);
            amount = amount.add(entryAmount);
            localAmt = localAmt.add(entryLocalAmt);
            tax = tax.add(entryTax);
            taxLocalAmt = taxLocalAmt.add(entryTaxLocalAmt);
            adjustAmt = adjustAmt.add(entryAdjustAmount);
            adjustAmtLocal = adjustAmtLocal.add(entryAdjustLocalAmt);
            unInvoiceAmt = unInvoiceAmt.add(entryPriceTaxTotal);
        }
        entity.set(!this.isAr ? "pricetaxtotal" : "recamount", (Object)priceTaxTotal);
        entity.set(!this.isAr ? "pricetaxtotalbase" : "reclocalamt", (Object)priceTaxTotalBase);
        entity.set("amount", (Object)amount);
        entity.set(!this.isAr ? "amountbase" : "localamt", (Object)localAmt);
        entity.set("tax", (Object)tax);
        entity.set("unverifyamount", (Object)amount);
        entity.set("unsettleamount", (Object)priceTaxTotal);
        entity.set(!this.isAr ? "unsettleamountbase" : "unsettlelocalamt", (Object)priceTaxTotalBase);
        entity.set("adjustamount", (Object)adjustAmt);
        entity.set("adjustlocalamt", (Object)adjustAmtLocal);
        entity.set("uninvoicedamt", (Object)unInvoiceAmt);
        FinPlanRowService planRowService = new FinPlanRowService();
        List<PlanRow> planList = planRowService.calculatePlanRows(entity);
        this.updateFinBillPlanEntity(planList, entity, basePrecision, precision);
    }

    private void setDetailEntryTax(int rowIndex, DynamicObject entryRowEntity, List<TaxLineVo> taxLineList, Map<Long, DynamicObject> taxCodeIdMap, Map<Long, DynamicObject> taxCategoryIdMap, Map<Long, DynamicObject> taxRateIdMap) {
        Optional<TaxLineVo> defaultTaxLine = taxLineList.stream().filter(line -> line.getDefaultTaxCode().compareTo(1) == 0).findAny();
        Long taxcodeid = 0L;
        Long taxrateid = 0L;
        if (defaultTaxLine.isPresent()) {
            taxcodeid = defaultTaxLine.get().getTaxCode();
            taxrateid = defaultTaxLine.get().getTaxRate();
            LOG.info("FinBatchCalculateTaxOp:\u5f53\u524d\u884c\u7a0e\u7801\u4fe1\u606f" + defaultTaxLine.get());
        }
        if (taxcodeid == 0L) {
            LOG.info("FinBatchCalculateTaxOp:\u7a0e\u7801\u63a5\u53e3\u8fd4\u56de\u4e3a0");
        }
        entryRowEntity.set("e_taxcode", (Object)taxCodeIdMap.get(taxcodeid));
        if (taxrateid != 0L) {
            entryRowEntity.set("taxrateid", (Object)taxRateIdMap.get(taxrateid));
            DynamicObject taxRate = BusinessDataServiceHelper.loadSingle((Object)taxrateid, (String)"bd_taxrate");
            if (EmptyUtils.isNotEmpty(taxRate)) {
                BigDecimal taxrate = taxRate.getBigDecimal("taxrate");
                entryRowEntity.set(!this.isAr ? "taxrate" : "e_taxrate", (Object)taxrate);
            }
        }
        DynamicObjectCollection taxDetailEntryCollection = entryRowEntity.getDynamicObjectCollection("subentryentity");
        taxDetailEntryCollection.clear();
        for (TaxLineVo taxLine : taxLineList) {
            if (EmptyUtils.isEmpty(taxLine)) continue;
            DynamicObject taxDetailEntryRow = taxDetailEntryCollection.addNew();
            taxDetailEntryRow.set("s_taxcode", (Object)taxCodeIdMap.get(taxLine.getTaxCode()));
            taxDetailEntryRow.set("s_taxcategory", (Object)taxCategoryIdMap.get(taxLine.getTaxType()));
            taxDetailEntryRow.set("s_taxrateid", (Object)taxRateIdMap.get(taxLine.getTaxRate()));
            taxDetailEntryRow.set("s_taxrate", (Object)taxLine.getTaxRatePercent());
            taxDetailEntryRow.set("s_isoffset", (Object)Boolean.valueOf(taxLine.getOffsetLogo()));
            taxDetailEntryRow.set("s_priority", (Object)taxLine.getOrder());
        }
    }

    private void updateFinBillPlanEntity(List<PlanRow> planRows, DynamicObject finBill, int basePrecision, int amtPrecision) {
        Date planMaxDueDate = null;
        DynamicObject settlementType = finBill.getDynamicObject("settlementtype");
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal amtLoc = BigDecimal.ZERO;
        BigDecimal rate = finBill.getBigDecimal("exchangerate");
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        planEntries.clear();
        EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)this.entityName).findProperty("planentity");
        DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
        for (int i = 0; i < planRows.size(); ++i) {
            DynamicObject planEntry = new DynamicObject(dt);
            PlanRow planRow = planRows.get(i);
            Date planDueDate = planRow.getDueDate();
            BigDecimal planAmt = planRow.getPlanAmt().setScale(amtPrecision, RoundingMode.HALF_UP);
            BigDecimal planAmtLoc = planAmt.multiply(rate).setScale(basePrecision, RoundingMode.HALF_UP);
            amt = amt.add(planAmt.setScale(amtPrecision, 4));
            amtLoc = amtLoc.add(planAmtLoc.setScale(basePrecision, 4));
            if (i == planRows.size() - 1) {
                BigDecimal priceLoc;
                BigDecimal price;
                BigDecimal priceTaxTotal = finBill.getBigDecimal(!this.isAr ? "pricetaxtotal" : "recamount");
                BigDecimal planPriceTaxLoc = finBill.getBigDecimal(!this.isAr ? "pricetaxtotalbase" : "reclocalamt");
                if (amt.compareTo(priceTaxTotal) > 0) {
                    price = amt.subtract(priceTaxTotal);
                    planAmt = planAmt.subtract(price);
                } else if (amt.compareTo(priceTaxTotal) < 0) {
                    price = priceTaxTotal.subtract(amt);
                    planAmt = planAmt.add(price);
                }
                if (amtLoc.compareTo(planPriceTaxLoc) > 0) {
                    priceLoc = amtLoc.subtract(planPriceTaxLoc);
                    planAmtLoc = planAmtLoc.subtract(priceLoc);
                } else if (amtLoc.compareTo(planPriceTaxLoc) < 0) {
                    priceLoc = planPriceTaxLoc.subtract(amtLoc);
                    planAmtLoc = planAmtLoc.add(priceLoc);
                }
            }
            planEntry.set("seq", (Object)(i + 1));
            planEntry.set("planpricetax", (Object)planAmt);
            planEntry.set("unplanlockamt", (Object)planAmt);
            planEntry.set("unplansettleamt", (Object)planAmt);
            planEntry.set("planpricetaxloc", (Object)planAmtLoc);
            planEntry.set("unplansettlelocamt", (Object)planAmtLoc);
            planEntry.set("planduedate", (Object)planDueDate);
            planEntry.set("plansettletype", (Object)settlementType);
            planEntry.getDataEntityState().setPushChanged(true);
            if (planMaxDueDate == null) {
                planMaxDueDate = planDueDate;
            } else if (planDueDate != null) {
                planMaxDueDate = planDueDate.after(planMaxDueDate) ? planDueDate : planMaxDueDate;
            }
            planEntries.add((Object)planEntry);
        }
        if (planMaxDueDate != null && finBill.getDate("duedate") == null) {
            finBill.set("duedate", planMaxDueDate);
        }
    }
}

