/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.toolkit;

import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.toolkit.IBuildBill;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractBuildBill
implements IBuildBill {
    private static final Log logger = LogFactory.getLog(AbstractBuildBill.class);
    protected String entityKey;
    protected BillModel m;

    public AbstractBuildBill(String entityKey) {
        this.entityKey = entityKey;
        this.m = BillModelFactory.getModel(entityKey);
    }

    @Override
    public List<Map<String, Object>> convert(DynamicObject tool, Long orgPk) {
        int billCount = tool.getInt("billcount");
        ArrayList<Map<String, Object>> impDatas = new ArrayList<Map<String, Object>>(billCount);
        for (int i = 0; i < billCount; ++i) {
            Map<String, Object> dataMap = this.buildBill(tool, orgPk);
            impDatas.add(dataMap);
        }
        return impDatas;
    }

    private Map<String, Object> buildBill(DynamicObject tool, Long orgPk) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        if (orgPk != null) {
            dataMap.put(this.m.HEAD_ORG, this.basedata(orgPk));
        } else {
            dataMap.put(this.m.HEAD_ORG, this.basedata(this.getMulDatabase(tool.getDynamicObjectCollection("org"))));
        }
        Date bizDate = tool.getDate("bizdate");
        dataMap.put(this.m.HEAD_BIZDATE, bizDate);
        dataMap.put(this.m.HEAD_DUEDATE, bizDate);
        dataMap.put(this.m.HEAD_BOOKDATE, bizDate);
        String asstacttype = tool.getString("asstacttype");
        dataMap.put(this.m.HEAD_ASSTACTTYPE, asstacttype);
        Long asstactPk = null;
        if ("bd_supplier".equals(asstacttype)) {
            asstactPk = this.getMulDatabase(tool.getDynamicObjectCollection("bd_supplier"));
        } else if ("bd_customer".equals(asstacttype)) {
            asstactPk = this.getMulDatabase(tool.getDynamicObjectCollection("bd_customer"));
        }
        dataMap.put(this.m.HEAD_ASSTACT, this.basedata(asstactPk));
        dataMap.put(this.m.HEAD_CURRENCY, this.basedata(this.getMulDatabase(tool.getDynamicObjectCollection("currency"))));
        dataMap.put(this.m.HEAD_ISINCLUDETAX, tool.getBoolean("isincludetax"));
        dataMap.put(this.m.HEAD_PAYMODE, "CREDIT");
        dataMap.put(this.m.HEAD_PAYPROPERTY, this.basedata(StringUtils.contains((String)this.entityKey, (String)"ar_") ? "1001" : "2001"));
        this.billProperty(dataMap, tool);
        int entryCount = tool.getInt("entrycount");
        ArrayList<Map<String, Object>> entries = new ArrayList<Map<String, Object>>(entryCount);
        for (int i = 0; i < entryCount; ++i) {
            Map<String, Object> entryMap = this.setEntry(tool);
            entries.add(entryMap);
        }
        dataMap.put(this.m.ENTRY, entries);
        return dataMap;
    }

    private Map<String, Object> setEntry(DynamicObject tool) {
        HashMap<String, Object> entryMap = new HashMap<String, Object>(4);
        entryMap.put(this.m.E_MATERIAL, this.basedata(this.getMulDatabase(tool.getDynamicObjectCollection("material"))));
        Long taxratePk = this.getMulDatabase(tool.getDynamicObjectCollection("taxrate"));
        if (EmptyUtils.isNotEmpty(taxratePk)) {
            entryMap.put(this.m.E_TAXRATEID, this.basedata(taxratePk));
        }
        entryMap.put(this.m.E_QUANTITY, this.getRandom("quantity", tool));
        if (tool.getBoolean("isincludetax")) {
            entryMap.put(this.m.E_TAXUNITPRICE, this.getRandom("price", tool));
        } else {
            entryMap.put(this.m.E_UNITPRICE, this.getRandom("price", tool));
        }
        return entryMap;
    }

    protected BigDecimal getRandom(String field, DynamicObject tool) {
        BigDecimal value;
        String qtyType = tool.getString(field + "type");
        if ("1".equals(qtyType)) {
            value = tool.getBigDecimal(field);
        } else {
            int min = tool.getBigDecimal(field + "_min").intValue();
            try {
                min = SecureRandom.getInstanceStrong().nextInt(min);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            value = new BigDecimal(min);
        }
        return value;
    }

    protected Long getMulDatabase(DynamicObjectCollection mul) {
        Long pk = null;
        if (!ObjectUtils.isEmpty((Object)mul)) {
            List pks = mul.stream().map(m -> m.getLong("fbasedataid_id")).collect(Collectors.toList());
            Collections.shuffle(pks);
            pk = (Long)pks.get(0);
        }
        return pk;
    }

    protected Map<String, Object> basedata(Long pk) {
        HashMap<String, Long> basedata = null;
        if (EmptyUtils.isNotEmpty(pk)) {
            basedata = new HashMap<String, Long>(1);
            basedata.put("id", pk);
        }
        return basedata;
    }

    protected Map<String, Object> basedata(String number) {
        HashMap<String, String> basedata = null;
        if (EmptyUtils.isNotEmpty(number)) {
            basedata = new HashMap<String, String>(1);
            basedata.put("number", number);
        }
        return basedata;
    }

    @Override
    public void doOperation(List<Long> successPks) {
        DynamicObject[] bills;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        long begin = System.currentTimeMillis();
        QFilter qFilter = new QFilter("id", "in", successPks);
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)this.entityKey, (String)this.m.HEAD_BILLSTATUS, (QFilter[])new QFilter[]{qFilter})) {
            bill.set(this.m.HEAD_BILLSTATUS, (Object)"C");
        }
        SaveServiceHelper.save((DynamicObject[])bills);
        long end = System.currentTimeMillis();
        logger.info("---doOperation.submit&audit---" + (end - begin) + "ms");
        this.billOperation(successPks, option);
        logger.info("---doOperation.billOperation---" + (System.currentTimeMillis() - end) + "ms");
    }

    protected abstract void billProperty(Map<String, Object> var1, DynamicObject var2);

    protected abstract void billOperation(List<Long> var1, OperateOption var2);
}

