/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.toolkit;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.ObjectUtils;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class BasedataService {
    private static String bankAccount = "622211115550";

    public Map<String, Object> addOrg(String name, int count) {
        Map<String, Object> resultMap = null;
        if (EmptyUtils.isNotEmpty(name) && count > 0) {
            ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(count);
            DecimalFormat df = new DecimalFormat(this.getPattern(count));
            for (int i = 1; i <= count; ++i) {
                OrgParam param = new OrgParam();
                param.setName(name + df.format(i));
                param.setOrgPatternId(1L);
                TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
                multiViewMap.put("10", this.getDutyView());
                multiViewMap.put("02", this.getDutyView());
                multiViewMap.put("03", this.getDutyView());
                multiViewMap.put("04", this.getDutyView());
                multiViewMap.put("05", this.getDutyView());
                multiViewMap.put("07", this.getDutyView());
                multiViewMap.put("08", this.getDutyView());
                multiViewMap.put("09", this.getDutyView());
                multiViewMap.put("11", this.getDutyView());
                multiViewMap.put("12", this.getDutyView());
                multiViewMap.put("06", this.getDutyView());
                param.setMultiViewMap(multiViewMap);
                paramList.add(param);
            }
            OrgUnitServiceHelper.addOrUpdate(paramList);
            List<Long> successPks = paramList.stream().filter(OrgParam::isSuccess).map(OrgParam::getId).collect(Collectors.toList());
            int successCnt = successPks.size();
            String message = String.format(ResManager.loadKDString((String)"\u5171\u521b\u5efa\u7ec4\u7ec7%1$s\u6761\uff0c\u5176\u4e2d\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"BasedataService_0", (String)"fi-arapcommon", (Object[])new Object[0]), count, successCnt, count - successCnt);
            resultMap = this.buildResultMap(count, successPks, message, count == successCnt);
        }
        return resultMap;
    }

    private Map<String, Object> buildResultMap(int subtotal, List<Long> successPks, String message, boolean success) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("subtotal", subtotal);
        resultMap.put("successPks", successPks);
        resultMap.put("message", message);
        resultMap.put("success", success);
        return resultMap;
    }

    private OrgDutyView getDutyView() {
        OrgDutyView dutyView = new OrgDutyView();
        dutyView.setParentId(100000L);
        return dutyView;
    }

    private String getPattern(int count) {
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < String.valueOf(count).length(); ++i) {
            pattern.append('0');
        }
        return pattern.toString();
    }

    public Map<String, Object> addSupplier(String name, int count) {
        Map<String, Object> resultMap = null;
        if (EmptyUtils.isNotEmpty(name) && count > 0) {
            resultMap = this.addCustSupp("bd_supplier", name, count);
        }
        return resultMap;
    }

    public Map<String, Object> addCustomer(String name, int count) {
        Map<String, Object> resultMap = null;
        if (EmptyUtils.isNotEmpty(name) && count > 0) {
            resultMap = this.addCustSupp("bd_customer", name, count);
        }
        return resultMap;
    }

    private Map<String, Object> addCustSupp(String entityKey, String name, int count) {
        ArrayList<Map<String, Object>> impDatas = new ArrayList<Map<String, Object>>(count);
        DecimalFormat df = new DecimalFormat(this.getPattern(count));
        for (int i = 1; i <= count; ++i) {
            String seqNo = df.format(i);
            Map<String, Object> dataMap = this.buildBasedata(entityKey, name, seqNo);
            impDatas.add(dataMap);
        }
        Map<String, Object> result = this.invokeSaveApi(entityKey, impDatas);
        List apiDatas = (List)result.get("data");
        List<Long> successPks = apiDatas.stream().filter(m -> (Boolean)m.get("success")).map(m -> (Long)m.get("id")).collect(Collectors.toList());
        int successCnt = 0;
        if (!ObjectUtils.isEmpty(successPks)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)entityKey, (Object[])successPks.toArray(), (OperateOption)option);
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)entityKey, (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
            successCnt = auditResult.getSuccessPkIds().size();
        }
        String message = null;
        message = "bd_supplier".equals(entityKey) ? String.format(ResManager.loadKDString((String)"\u5171\u521b\u5efa\u4f9b\u5e94\u5546%1$s\u6761\uff0c\u5176\u4e2d\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"BasedataService_1", (String)"fi-arapcommon", (Object[])new Object[0]), count, successCnt, count - successCnt) : String.format(ResManager.loadKDString((String)"\u5171\u521b\u5efa\u5ba2\u6237%1$s\u6761\uff0c\u5176\u4e2d\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"BasedataService_2", (String)"fi-arapcommon", (Object[])new Object[0]), count, successCnt, count - successCnt);
        return this.buildResultMap(count, successPks, message, count == successCnt);
    }

    private Map<String, Object> buildBasedata(String entityKey, String name, String seqNo) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        Map<String, Object> org = this.basedata("00");
        dataMap.put("org", org);
        dataMap.put("createorg", org);
        Map<String, Object> nameMap = this.mullang(name + seqNo);
        dataMap.put("name", nameMap);
        dataMap.put("simplename", nameMap);
        dataMap.put("type", "1");
        dataMap.put("group", this.basedata("waitgroup"));
        dataMap.put("bizfunction", ",1,2,3,4,");
        if ("bd_supplier".equals(entityKey)) {
            dataMap.put("enablevmi", Boolean.FALSE);
            dataMap.put("payhold", Boolean.FALSE);
            dataMap.put("purchasehold", Boolean.FALSE);
            dataMap.put("paymentunit", "1");
            dataMap.put("supplier_status", this.basedata("ZCGYS"));
        } else {
            dataMap.put("blockedorder", Boolean.FALSE);
            dataMap.put("blockedshipment", Boolean.FALSE);
            dataMap.put("consignment", Boolean.FALSE);
            dataMap.put("customerstatus", this.basedata("ZSKH"));
        }
        ArrayList<Map<String, Object>> entries = new ArrayList<Map<String, Object>>(1);
        Map<String, Object> entryMap = this.setBankEntry(entityKey, seqNo);
        entries.add(entryMap);
        dataMap.put("entry_bank", entries);
        return dataMap;
    }

    private Map<String, Object> setBankEntry(String entityKey, String seqNo) {
        HashMap<String, Object> entryMap = new HashMap<String, Object>(4);
        if ("bd_supplier".equals(entityKey)) {
            entryMap.put("bankaccount", bankAccount + seqNo);
            entryMap.put("accountname", this.mullang(ResManager.loadKDString((String)"\u62db\u5546\u94f6\u884c", (String)"BasedataService_3", (String)"fi-arapcommon", (Object[])new Object[0])));
            entryMap.put("commissionbearer", "1");
        } else {
            entryMap.put("bankaccount", "622611116666" + seqNo);
            entryMap.put("accountname", this.mullang(ResManager.loadKDString((String)"\u62db\u5546\u94f6\u884c\u5317\u4eac", (String)"BasedataService_4", (String)"fi-arapcommon", (Object[])new Object[0])));
        }
        entryMap.put("currency", this.basedata("CNY"));
        entryMap.put("isdefault_bank", Boolean.TRUE);
        entryMap.put("bank", this.basedata("308100005545"));
        return entryMap;
    }

    private Map<String, Object> basedata(String number) {
        HashMap<String, String> basedata = null;
        if (EmptyUtils.isNotEmpty(number)) {
            basedata = new HashMap<String, String>(1);
            basedata.put("number", number);
        }
        return basedata;
    }

    private Map<String, Object> mullang(String name) {
        HashMap<String, String> basedata = null;
        if (EmptyUtils.isNotEmpty(name)) {
            basedata = new HashMap<String, String>(1);
            basedata.put("zh_CN", name);
        }
        return basedata;
    }

    private Map<String, Object> invokeSaveApi(String entityKey, List<Map<String, Object>> datas) {
        HashMap<String, List<Map<String, Object>>> dataMap = new HashMap<String, List<Map<String, Object>>>(1);
        dataMap.put("datas", datas);
        String entityTypeId = FormMetadataCache.getFormConfig((String)entityKey).getEntityTypeId();
        AbstractOperateWebApi webApi = FormMetadataCache.getFormOperationApi((String)entityTypeId, (String)"save");
        webApi.initialize(entityKey, dataMap);
        return ApiResult.toMap((ApiResult)webApi.execute());
    }
}

