/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.toolkit;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;

public class BillModelToolEdit
extends AbstractFormPlugin {
    public static Map<String, String> mapping = new HashMap<String, String>(1);

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("compare".equals(key) && args.getOperationResult().isSuccess()) {
            this.doCompare();
        }
        if ("import".equals(key) && args.getOperationResult().isSuccess()) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("ap_billmodel_result");
            parameter.getCustomParams().put("common", this.getPageCache().get("common"));
            parameter.getCustomParams().put("obj1", this.getPageCache().get("obj1"));
            parameter.getCustomParams().put("obj2", this.getPageCache().get("obj2"));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "result"));
            this.getView().showForm(parameter);
        }
        if ("check".equals(key) && args.getOperationResult().isSuccess()) {
            this.doCheck();
        }
    }

    private void doCheck() {
        String entityKey = ((DynamicObject)this.getModel().getValue("entityobject1")).getString("number");
        BillModel bm = BillModelFactory.getModel(entityKey);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityKey);
        Field[] fields = bm.getClass().getFields();
        try {
            ArrayList<String> sucessList = new ArrayList<String>(8);
            ArrayList<String> errList = new ArrayList<String>(0);
            for (Field field : fields) {
                String fieldKey = (String)field.get(bm);
                if (fieldKey == null) continue;
                IDataEntityProperty prop = mainType.findProperty(fieldKey);
                if (ObjectUtils.isEmpty((Object)prop)) {
                    errList.add(fieldKey);
                    continue;
                }
                sucessList.add(fieldKey);
            }
            if (!errList.isEmpty()) {
                int total = sucessList.size() + errList.size();
                Map<String, Object> param = this.getOperationResult(total, errList);
                this.showOpResult(param);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5171\u68c0\u67e5 %s \u4e2a\u5c5e\u6027\uff0c \u68c0\u67e5\u6210\u529f\u3002", (String)"BillModelToolEdit_0", (String)"fi-arapcommon", (Object[])new Object[]{sucessList.size()}));
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private Map<String, Object> getOperationResult(int total, List<String> errList) {
        int failCnt = errList.size();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("operateName", ResManager.loadKDString((String)"\u68c0\u67e5", (String)"BillModelToolEdit_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        String title = String.format(ResManager.loadKDString((String)"\u5171\u68c0\u67e5 %1$s \u4e2a\u5c5e\u6027\uff0c\u5176\u4e2d  %2$s \u4e2a\u5c5e\u6027\u4e0d\u5b58\u5728\u3002", (String)"BillModelToolEdit_2", (String)"fi-ap-mservice", (Object[])new Object[0]), total, failCnt);
        param.put("title", title);
        StringBuilder errMsg = new StringBuilder();
        errMsg.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        for (String err : errList) {
            errMsg.append(err).append("<br/>");
        }
        errMsg.append("</div>");
        param.put("errorMsg", errMsg.toString());
        param.put("hasMore", Boolean.FALSE);
        return param;
    }

    private void showOpResult(Map<String, Object> customParam) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_operationresult");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getCustomParams().putAll(customParam);
        parameter.setShowTitle(false);
        this.getView().showForm(parameter);
    }

    private void doCompare() {
        IDataModel m = this.getModel();
        m.deleteEntryData("commonentry");
        m.deleteEntryData("e1diffentry");
        m.deleteEntryData("e2diffentry");
        String entityKey1 = ((DynamicObject)m.getValue("entityobject1")).getString("number");
        Map<String, List<String>> propMap1 = this.getObjProperties(entityKey1);
        String entityKey2 = ((DynamicObject)m.getValue("entityobject2")).getString("number");
        Map<String, List<String>> propMap2 = this.getObjProperties(entityKey2);
        Map<String, List<String>> commonMap = this.merge(propMap1, propMap2);
        if (!commonMap.isEmpty()) {
            this.fillCommonEntry(m, entityKey1, entityKey2, commonMap);
        }
        Map<String, List<String>> entity1Diffs = this.subtract(propMap1, commonMap);
        this.fillDiffEntry(m, entityKey1, entity1Diffs, "1");
        Map<String, List<String>> entity2Diffs = this.subtract(propMap2, commonMap);
        Map<String, List<String>> matchDiffs = this.match(entity1Diffs, entity2Diffs);
        this.fillDiffEntry(m, entityKey2, matchDiffs, "2");
    }

    private Map<String, List<String>> match(Map<String, List<String>> entity1Diffs, Map<String, List<String>> entity2Diffs) {
        HashMap<String, List<String>> matchMap = new HashMap<String, List<String>>(1);
        for (Map.Entry<String, List<String>> fEntry : entity1Diffs.entrySet()) {
            String fKey = fEntry.getKey();
            List<String> fList = fEntry.getValue();
            List<String> sList = entity2Diffs.get(fKey);
            ArrayList<String> mList = new ArrayList<String>(8);
            for (String fProp : fList) {
                String mProp = this.match(fProp, sList);
                if (mProp == null || mList.contains(mProp)) continue;
                mList.add(mProp);
            }
            List diffList = ListUtils.subtract(sList, mList);
            mList.addAll(diffList);
            matchMap.put(fKey, mList);
        }
        return matchMap;
    }

    private String match(String fProp, List<String> sList) {
        String match = null;
        for (String sProp : sList) {
            if (!fProp.contains(sProp) && !sProp.contains(fProp)) continue;
            match = sProp;
            break;
        }
        return match;
    }

    private Map<String, List<String>> subtract(Map<String, List<String>> propMap, Map<String, List<String>> commonMap) {
        HashMap<String, List<String>> diffMap = new HashMap<String, List<String>>(1);
        List headList = ListUtils.subtract(propMap.get("head"), commonMap.get("head"));
        diffMap.put("head", headList);
        for (Map.Entry<String, List<String>> cEntry : commonMap.entrySet()) {
            String key = cEntry.getKey();
            if ("head".equals(key)) continue;
            List<String> commonList = cEntry.getValue();
            for (Map.Entry<String, List<String>> pEntry : propMap.entrySet()) {
                String pKey = pEntry.getKey();
                if ("head".equals(pKey) || !key.equals(pKey)) continue;
                List<String> lst = pEntry.getValue();
                List diffList = ListUtils.subtract(lst, commonList);
                diffMap.put(key, diffList);
            }
        }
        return diffMap;
    }

    private Map<String, List<String>> merge(Map<String, List<String>> propMap1, Map<String, List<String>> propMap2) {
        HashMap<String, List<String>> commonMap = new HashMap<String, List<String>>(1);
        List headList = ListUtils.intersection(propMap1.get("head"), propMap2.get("head"));
        commonMap.put("head", headList);
        for (Map.Entry<String, List<String>> pEntry1 : propMap1.entrySet()) {
            String key1 = pEntry1.getKey();
            if ("head".equals(key1)) continue;
            List<String> lst1 = pEntry1.getValue();
            for (Map.Entry<String, List<String>> pEntry2 : propMap2.entrySet()) {
                String key2 = pEntry2.getKey();
                if ("head".equals(key2) || !key1.equals(key2)) continue;
                List<String> lst2 = pEntry2.getValue();
                List commonList = ListUtils.intersection(lst1, lst2);
                commonMap.put(key1, commonList);
            }
        }
        return commonMap;
    }

    private void fillDiffEntry(IDataModel m, String entityKey, Map<String, List<String>> diffMap, String objNum) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityKey);
        String entryKey = "e" + objNum + "diffentry";
        StringBuilder obj = new StringBuilder();
        for (Map.Entry<String, List<String>> dEntry : diffMap.entrySet()) {
            String key = dEntry.getKey();
            List<String> diffList = dEntry.getValue();
            if ("head".equals(key)) {
                this.setDiffHeadEnry(m, entryKey, mainType, diffList, objNum, obj);
                continue;
            }
            this.setDiffEntryPropEnry(m, entryKey, mainType, key, diffList, objNum, obj);
        }
        this.getPageCache().put("obj" + objNum, obj.toString());
    }

    private void setDiffHeadEnry(IDataModel m, String entryKey, MainEntityType mainType, List<String> diffList, String objNum, StringBuilder obj) {
        for (int i = 0; i < diffList.size(); ++i) {
            DynamicObject entry = m.getEntryRowEntity(entryKey, i);
            if (entry == null) {
                m.createNewEntryRow(entryKey);
            }
            String fieldKey = diffList.get(i);
            m.setValue("e" + objNum + "_property", (Object)fieldKey, i);
            IDataEntityProperty prop = mainType.findProperty(fieldKey);
            String displayName = prop.getDisplayName().getLocaleValue();
            m.setValue("e" + objNum + "_name", (Object)displayName, i);
            StringBuilder sb = new StringBuilder();
            sb.append("/** ").append(ResManager.loadKDString((String)"\u8868\u5934-", (String)"BillModelToolEdit_3", (String)"fi-arapcommon", (Object[])new Object[0])).append(displayName).append("  */\n");
            if (StringUtils.contains((CharSequence)displayName, (CharSequence)ResManager.loadKDString((String)"\u5e9f\u5f03", (String)"BillModelToolEdit_4", (String)"fi-arapcommon", (Object[])new Object[0]))) {
                sb.append("@Deprecated\n");
            }
            sb.append("public String HEAD_").append(fieldKey.toUpperCase()).append(" = \"").append(fieldKey).append("\";\n");
            obj.append((CharSequence)sb);
        }
    }

    private void setDiffEntryPropEnry(IDataModel m, String entryKey, MainEntityType mainType, String entryName, List<String> diffList, String objNum, StringBuilder obj) {
        String entryProp = this.getEntryKey(mainType, entryName);
        int count = m.getEntryRowCount(entryKey);
        for (int i = 0; i < diffList.size(); ++i) {
            int iRow = count + i;
            DynamicObject entry = m.getEntryRowEntity(entryKey, iRow);
            if (entry == null) {
                m.createNewEntryRow(entryKey);
            }
            String fieldKey = diffList.get(i);
            m.setValue("e" + objNum + "_property", (Object)fieldKey, iRow);
            IDataEntityProperty prop = mainType.findProperty(fieldKey);
            if (prop == null) {
                prop = mainType.findProperty(entryProp + "." + fieldKey);
            }
            String displayName = prop.getDisplayName().getLocaleValue();
            m.setValue("e" + objNum + "_name", (Object)displayName, iRow);
            StringBuilder sb = new StringBuilder();
            String annotation = "/** " + ResManager.loadKDString((String)"\u5206\u5f55-", (String)"BillModelToolEdit_5", (String)"fi-arapcommon", (Object[])new Object[0]);
            String prefix = "E_";
            if ("planentity".equals(entryName)) {
                prefix = "P_";
                annotation = "/** " + ResManager.loadKDString((String)"\u8ba1\u5212-", (String)"BillModelToolEdit_6", (String)"fi-arapcommon", (Object[])new Object[0]);
            }
            sb.append(annotation).append(displayName).append("  */\n");
            if (StringUtils.contains((CharSequence)displayName, (CharSequence)ResManager.loadKDString((String)"\u5e9f\u5f03", (String)"BillModelToolEdit_4", (String)"fi-arapcommon", (Object[])new Object[0]))) {
                sb.append("@Deprecated\n");
            }
            String javaField = StringUtils.replace((String)fieldKey, (String)"e_", (String)"");
            sb.append("public String ").append(prefix).append(javaField.toUpperCase()).append(" = \"").append(fieldKey).append("\";\n");
            obj.append((CharSequence)sb);
        }
    }

    private void fillCommonEntry(IDataModel m, String entityKey1, String entityKey2, Map<String, List<String>> commonMap) {
        MainEntityType mainType1 = EntityMetadataCache.getDataEntityType((String)entityKey1);
        MainEntityType mainType2 = EntityMetadataCache.getDataEntityType((String)entityKey2);
        StringBuilder common = new StringBuilder();
        for (Map.Entry<String, List<String>> cEntry : commonMap.entrySet()) {
            String key = cEntry.getKey();
            List<String> commonList = cEntry.getValue();
            if ("head".equals(key)) {
                this.setHeadEntry(m, mainType1, mainType2, commonList, common);
                continue;
            }
            this.setEntryPropEntry(m, mainType1, mainType2, key, commonList, common);
        }
        this.getPageCache().put("common", common.toString());
    }

    private void setEntryPropEntry(IDataModel m, MainEntityType mainType1, MainEntityType mainType2, String entryName, List<String> commonList, StringBuilder common) {
        String entryKey1 = this.getEntryKey(mainType1, entryName);
        String entryKey2 = this.getEntryKey(mainType2, entryName);
        int count = m.getEntryRowCount("commonentry");
        for (int i = 0; i < commonList.size(); ++i) {
            int iRow = count + i;
            DynamicObject entry = m.getEntryRowEntity("commonentry", iRow);
            if (entry == null) {
                m.createNewEntryRow("commonentry");
            }
            String fieldKey = commonList.get(i);
            m.setValue("e_property", (Object)fieldKey, iRow);
            IDataEntityProperty prop1 = mainType1.findProperty(fieldKey);
            if (prop1 == null) {
                prop1 = mainType1.findProperty(entryKey1 + "." + fieldKey);
            }
            String displayName1 = prop1.getDisplayName().getLocaleValue();
            m.setValue("e_obj1_name", (Object)displayName1, iRow);
            IDataEntityProperty prop2 = mainType2.findProperty(fieldKey);
            if (prop2 == null) {
                prop2 = mainType2.findProperty(entryKey2 + "." + fieldKey);
            }
            String displayName2 = prop2.getDisplayName().getLocaleValue();
            m.setValue("e_obj2_name", (Object)displayName2, iRow);
            StringBuilder sb = new StringBuilder();
            String dName = displayName1;
            String annotation = "/** " + ResManager.loadKDString((String)"\u5206\u5f55-", (String)"BillModelToolEdit_5", (String)"fi-arapcommon", (Object[])new Object[0]);
            String prefix = "E_";
            if ("planentity".equals(entryName)) {
                prefix = "P_";
                annotation = "/** " + ResManager.loadKDString((String)"\u8ba1\u5212-", (String)"BillModelToolEdit_6", (String)"fi-arapcommon", (Object[])new Object[0]);
            }
            if (!displayName1.equals(displayName2)) {
                dName = dName + "(" + mainType1.getName() + ") --- " + displayName2 + "(" + mainType2.getName() + ")";
            }
            sb.append(annotation).append(dName).append("  */\n");
            if (StringUtils.contains((CharSequence)dName, (CharSequence)ResManager.loadKDString((String)"\u5e9f\u5f03", (String)"BillModelToolEdit_4", (String)"fi-arapcommon", (Object[])new Object[0]))) {
                sb.append("@Deprecated\n");
            }
            String javaField = StringUtils.replace((String)fieldKey, (String)"e_", (String)"");
            sb.append("public String ").append(prefix).append(javaField.toUpperCase()).append(" = \"").append(fieldKey).append("\";\n");
            common.append((CharSequence)sb);
        }
    }

    private String getEntryKey(MainEntityType mainType1, String entryName) {
        String entryKey = null;
        if ("ap_finapbill".equals(mainType1.getName())) {
            entryKey = mapping.get(entryName);
            if (entryKey == null) {
                entryKey = entryName;
            }
        } else {
            entryKey = entryName;
        }
        return entryKey;
    }

    private void setHeadEntry(IDataModel m, MainEntityType mainType1, MainEntityType mainType2, List<String> commonList, StringBuilder common) {
        for (int i = 0; i < commonList.size(); ++i) {
            DynamicObject entry = m.getEntryRowEntity("commonentry", i);
            if (entry == null) {
                m.createNewEntryRow("commonentry");
            }
            String fieldKey = commonList.get(i);
            m.setValue("e_property", (Object)fieldKey, i);
            IDataEntityProperty prop1 = mainType1.findProperty(fieldKey);
            String displayName1 = prop1.getDisplayName().getLocaleValue();
            m.setValue("e_obj1_name", (Object)displayName1, i);
            IDataEntityProperty prop2 = mainType2.findProperty(fieldKey);
            String displayName2 = prop2.getDisplayName().getLocaleValue();
            m.setValue("e_obj2_name", (Object)displayName2, i);
            StringBuilder sb = new StringBuilder();
            String dName = displayName1;
            if (displayName1.equals(displayName2)) {
                sb.append("/** ").append(ResManager.loadKDString((String)"\u8868\u5934-", (String)"BillModelToolEdit_3", (String)"fi-arapcommon", (Object[])new Object[0])).append(dName).append("  */\n");
            } else {
                dName = dName + "(" + mainType1.getName() + ") --- " + displayName2 + "(" + mainType2.getName() + ")";
                sb.append("/** ").append(ResManager.loadKDString((String)"\u8868\u5934-", (String)"BillModelToolEdit_3", (String)"fi-arapcommon", (Object[])new Object[0])).append(dName).append("  */\n");
            }
            if (StringUtils.contains((CharSequence)dName, (CharSequence)ResManager.loadKDString((String)"\u5e9f\u5f03", (String)"BillModelToolEdit_4", (String)"fi-arapcommon", (Object[])new Object[0]))) {
                sb.append("@Deprecated\n");
            }
            sb.append("public String HEAD_").append(fieldKey.toUpperCase()).append(" = \"").append(fieldKey).append("\";\n");
            common.append((CharSequence)sb);
        }
    }

    private Map<String, List<String>> getObjProperties(String entityKey) {
        HashMap<String, List<String>> propMap = new HashMap<String, List<String>>(2);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityKey);
        DynamicPropertyCollection properties = (DynamicPropertyCollection)mainType.getProperties();
        ArrayList<String> headProps = new ArrayList<String>(8);
        for (IDataEntityProperty property : properties) {
            LocaleString displayName;
            String name = property.getName();
            if (property instanceof EntryProp) {
                if ("entry".equals(name) || "detailentry".equals(name)) {
                    this.setEntryProperties(propMap, "entry", property);
                    continue;
                }
                if ("planentity".equals(name)) {
                    this.setEntryProperties(propMap, name, property);
                    continue;
                }
                if (!"allocationentry".equals(name)) continue;
                continue;
            }
            if (!(property.getParent() instanceof MainEntityType) || (displayName = property.getDisplayName()) == null) continue;
            headProps.add(name);
        }
        if (!headProps.isEmpty()) {
            propMap.put("head", headProps);
        }
        return propMap;
    }

    private void setEntryProperties(Map<String, List<String>> propMap, String key, IDataEntityProperty property) {
        List<String> entryPropList = propMap.get(key);
        if (entryPropList == null) {
            entryPropList = new ArrayList<String>(8);
        }
        EntryProp entryProp = (EntryProp)property;
        EntryType entryType = (EntryType)entryProp.getDynamicCollectionItemPropertyType();
        DataEntityPropertyCollection entryProps = entryType.getProperties();
        for (IDataEntityProperty entryProperty : entryProps) {
            LocaleString displayName = entryProperty.getDisplayName();
            if (displayName == null) continue;
            entryPropList.add(entryProperty.getName());
        }
        propMap.put(key, entryPropList);
    }

    public List<String> getHeadList() {
        ArrayList<String> list = new ArrayList<String>(8);
        list.add("billno");
        list.add("billstatus");
        list.add("creator");
        list.add("modifier");
        list.add("auditor");
        list.add("auditdate");
        list.add("modifytime");
        list.add("createtime");
        list.add("org");
        list.add("bizdate");
        list.add("asstacttype");
        list.add("asstact");
        list.add("currency");
        list.add("exchangerate");
        list.add("basecurrency");
        list.add("exratetable");
        list.add("exratedate");
        list.add("quotation");
        list.add("billsrctype");
        list.add("remark");
        list.add("recorg");
        list.add("amount");
        list.add("salesorg");
        list.add("sourcebillid");
        list.add("localamt");
        list.add("salesgroup");
        list.add("salesman");
        list.add("sourcebilltype");
        list.add("biztypef7");
        list.add("imageno");
        list.add("lastupdateuser");
        list.add("lastupdatetime");
        list.add("biztype");
        return list;
    }

    public List<String> getEntryList() {
        ArrayList<String> list = new ArrayList<String>(8);
        list.add("seq");
        list.add("e_amount");
        list.add("e_tax");
        list.add("e_remark");
        list.add("e_baseunit");
        list.add("e_baseunitqty");
        list.add("corebillentryid");
        list.add("corebillid");
        list.add("project");
        list.add("taxrateid");
        list.add("e_vattax");
        list.add("e_assistantattr");
        list.add("e_materialversion");
        list.add("e_contract");
        list.add("e_invoicedamt");
        list.add("e_uninvoicedamt");
        list.add("e_creator");
        list.add("e_createtime");
        list.add("e_modifier");
        list.add("e_modifytime");
        list.add("e_taxcode");
        list.add("linetype");
        list.add("materialname");
        list.add("configuredcode");
        list.add("tracknumber");
        list.add("e_conbillentity");
        list.add("e_conbillnumber");
        list.add("e_conbillrownum");
        list.add("e_conbillid");
        list.add("e_conbillentryid");
        list.add("e_taxlocalamt");
        return list;
    }

    static {
        mapping.put("entry", "detailentry");
    }
}

