/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.toolkit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.toolkit.BuildBillFactory;
import kd.fi.arapcommon.toolkit.IBuildBill;

public class BuildBillService {
    private static final Log logger = LogFactory.getLog(BuildBillService.class);
    private String entityKey;

    public BuildBillService(String entityKey) {
        this.entityKey = entityKey;
    }

    public Map<String, Object> buildBill(DynamicObject tool, List<Long> orgPks) {
        Map<String, Object> resultMap = null;
        long begin = System.currentTimeMillis();
        IBuildBill iBuilder = BuildBillFactory.getService(this.entityKey);
        List<Object> billDatas = null;
        if (orgPks != null) {
            billDatas = new ArrayList(500);
            for (Long orgPk : orgPks) {
                billDatas.addAll(iBuilder.convert(tool, orgPk));
            }
        } else {
            billDatas = iBuilder.convert(tool, null);
        }
        long end = System.currentTimeMillis();
        logger.info("---build.convert---" + (end - begin) + "ms");
        try (TXHandle tx = TX.requiresNew((String)"bill.builder");){
            try {
                Map<String, Object> result = this.invokeSaveApi(this.entityKey, billDatas);
                logger.info("---build.saveApi---" + (System.currentTimeMillis() - end) + "ms");
                end = System.currentTimeMillis();
                List apiDatas = (List)result.get("data");
                List<Long> successPks = apiDatas.stream().filter(m -> (Boolean)m.get("success")).map(m -> (Long)m.get("id")).collect(Collectors.toList());
                if (!ObjectUtils.isEmpty(successPks)) {
                    iBuilder.doOperation(successPks);
                }
                logger.info("---build.doOperation---" + (System.currentTimeMillis() - end) + "ms");
            }
            catch (Exception ex) {
                tx.markRollback();
                throw ex;
            }
        }
        logger.info("---build.total.cost---" + (System.currentTimeMillis() - begin) + "ms");
        return resultMap;
    }

    private Map<String, Object> invokeSaveApi(String entityKey, List<Map<String, Object>> datas) {
        HashMap<String, List<Map<String, Object>>> dataMap = new HashMap<String, List<Map<String, Object>>>(1);
        dataMap.put("datas", datas);
        String entityTypeId = FormMetadataCache.getFormConfig((String)entityKey).getEntityTypeId();
        AbstractOperateWebApi webApi = FormMetadataCache.getFormOperationApi((String)entityTypeId, (String)"save");
        webApi.initialize(entityKey, dataMap);
        return ApiResult.toMap((ApiResult)webApi.execute());
    }
}

