/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.toolkit;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.fi.arapcommon.toolkit.BuildBillService;
import kd.fi.arapcommon.util.DateUtils;

public class BuildBillToolBuildOp
extends AbstractOperationServicePlugIn {
    private BuildBillService service;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject tool = e.getDataEntities()[0];
        String entityKey = tool.getDynamicObject("entityobject").getString("number");
        this.service = new BuildBillService(entityKey);
        Date endDate = DateUtils.truncateDate(DateUtils.parseDate("2022-08-01", "yyyy-MM-dd"));
        Date bizDate = tool.getDate("bizdate");
        DynamicObjectCollection orgs = tool.getDynamicObjectCollection("org");
        if (orgs.size() == 1) {
            this.buildTop10(tool, bizDate, endDate);
        } else {
            this.buildOther(tool, bizDate, endDate);
        }
    }

    private void buildOther(DynamicObject tool, Date bizDate, Date endDate) {
        int year = DateUtils.getYear(bizDate);
        int month = DateUtils.getMonth(bizDate);
        int day = DateUtils.getDay(bizDate);
        int count = 1;
        int MAX_MONTH = 24;
        List<Long> orgPks = tool.getDynamicObjectCollection("org").stream().map(m -> m.getLong("fbasedataid_id")).collect(Collectors.toList());
        for (int i = month; i < 13; ++i) {
            Date date;
            if (count > MAX_MONTH) continue;
            if (count > 1) {
                day = 1;
            }
            if ((date = DateUtils.getDate(year, i, day)).getTime() >= endDate.getTime()) break;
            this.executeOther(orgPks, tool, year, i, day);
            if (i == 12) {
                i = 0;
                ++year;
            }
            ++count;
        }
    }

    private void buildTop10(DynamicObject tool, Date bizDate, Date endDate) {
        int year = DateUtils.getYear(bizDate);
        int month = DateUtils.getMonth(bizDate);
        int day = DateUtils.getDay(bizDate);
        int count = 1;
        int MAX_MONTH = 24;
        for (int i = month; i < 13; ++i) {
            Date date;
            if (count > MAX_MONTH) continue;
            if (count > 1) {
                day = 1;
            }
            if ((date = DateUtils.getDate(year, i, day)).getTime() >= endDate.getTime()) break;
            this.execute(tool, year, i, day);
            if (i == 12) {
                i = 0;
                ++year;
            }
            ++count;
        }
    }

    private void execute(DynamicObject tool, int year, int month, int day) {
        Date bizDate;
        int i;
        Date date = DateUtils.getDate(year, month, day);
        int lastDay = DateUtils.getDay(DateUtils.getMaxMonthDate(date));
        for (i = day; i <= lastDay; ++i) {
            if (i > 30) continue;
            bizDate = DateUtils.getDate(year, month, i);
            tool.set("bizdate", (Object)bizDate);
            this.service.buildBill(tool, null);
        }
        if (lastDay < 30) {
            for (i = lastDay + 1; i <= 30; ++i) {
                bizDate = DateUtils.getDate(year, month, lastDay);
                tool.set("bizdate", (Object)bizDate);
                this.service.buildBill(tool, null);
            }
        }
    }

    private void executeOther(List<Long> orgPks, DynamicObject tool, int year, int month, int day) {
        Date date = DateUtils.getDate(year, month, day);
        int lastDay = DateUtils.getDay(DateUtils.getMaxMonthDate(date));
        int total = orgPks.size();
        int batchCnt = 50;
        for (int i = day; i <= lastDay; ++i) {
            if (i > 25) continue;
            Date bizDate = DateUtils.getDate(year, month, i);
            tool.set("bizdate", (Object)bizDate);
            for (int j = 0; j < total; j += batchCnt) {
                if (j % batchCnt != 0) continue;
                List<Long> subPks = null;
                subPks = j < total - batchCnt ? orgPks.subList(j, j + batchCnt) : orgPks.subList(j, total);
                if (subPks == null) continue;
                this.service.buildBill(tool, subPks);
            }
        }
    }
}

