/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.tx;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.fi.arapcommon.helper.SettingMapperHelper;

public class AsyncSettingManager {
    private static DistributeSessionlessCache cache = null;

    public void setEnableAsync(boolean enableAsync) {
        System.clearProperty("arap_async_runtimeexecute");
        SettingMapperHelper.saveOrUpdate("async", "enable", String.valueOf(enableAsync));
        AsyncSettingManager.getSessionlessCacheInstance().put("fi.ap.async.enable", (Object)String.valueOf(enableAsync));
    }

    public boolean isEnableAsync() {
        String runtimeExecuteTag = System.getProperty("arap_async_runtimeexecute");
        if ("true".equals(runtimeExecuteTag)) {
            return false;
        }
        if ("false".equals(runtimeExecuteTag)) {
            return true;
        }
        try {
            String enableSetting = (String)AsyncSettingManager.getSessionlessCacheInstance().get("fi.ap.async.enable");
            if ((enableSetting == null || enableSetting.isEmpty()) && ((enableSetting = SettingMapperHelper.getValue("async", "enable")) == null || enableSetting.isEmpty())) {
                this.setEnableAsync(true);
                return true;
            }
            return Boolean.parseBoolean(enableSetting);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public int getLogRetainDays() {
        try {
            String daysSetting = SettingMapperHelper.getValue("async", "logretaindays");
            if (daysSetting == null || daysSetting.isEmpty()) {
                return 10;
            }
            return Integer.parseInt(daysSetting);
        }
        catch (Exception e) {
            return 10;
        }
    }

    public void setLogRetainDays(int days) {
        if (days < 1) {
            throw new IllegalArgumentException("Async log should be retained more than one day.But it's " + days);
        }
        SettingMapperHelper.saveOrUpdate("async", "logretaindays", String.valueOf(days));
    }

    public static DistributeSessionlessCache getSessionlessCacheInstance() {
        if (cache == null) {
            cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("fi");
        }
        return cache;
    }
}

