/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.tx;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.arapcommon.tx.AsyncTx;

public class AsyncTxAlarmer {
    public static void sendMessage(AsyncTx tx) {
        ThreadPools.executeOnceIncludeRequestContext((String)"async_alarm", () -> {
            MessageInfo message = new MessageInfo();
            ArrayList<Long> receivers = new ArrayList<Long>();
            receivers.add(RequestContext.get().getCurrUserId());
            String entityName = AsyncTxAlarmer.getEntityName(tx.getGroup());
            String billNo = AsyncTxAlarmer.getBillNo(tx);
            String bizAction = tx.getAction();
            if ("audit".equals(bizAction)) {
                bizAction = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"AsyncTxAlarmer_0", (String)"fi-arapcommon", (Object[])new Object[0]);
            }
            String title = String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u7684\u201c%3$s\u201d \u540e\u53f0\u4efb\u52a1\u9519\u8bef\u3002", (String)"AsyncTxAlarmer_1", (String)"fi-arapcommon", (Object[])new Object[0]), entityName, billNo, bizAction);
            message.setTitle(title);
            message.setContent(tx.getErrorMessage());
            message.setUserIds(receivers);
            message.setSenderId(Long.valueOf(1L));
            message.setSendTime(new Date());
            message.setType("alarm");
            message.setTag(entityName);
            message.setNotifyType(MessageChannels.MC.getNumber());
            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
        });
    }

    public static void sendMessage(AsyncTx tx, Long userId) {
        ThreadPools.executeOnceIncludeRequestContext((String)"async_alarm", () -> {
            MessageInfo message = new MessageInfo();
            ArrayList<Long> receivers = new ArrayList<Long>();
            receivers.add(userId);
            String entityName = AsyncTxAlarmer.getEntityName(tx.getGroup());
            String billNo = AsyncTxAlarmer.getBillNo(tx);
            String bizAction = tx.getAction();
            if ("audit".equals(bizAction)) {
                bizAction = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"AsyncTxAlarmer_0", (String)"fi-arapcommon", (Object[])new Object[0]);
            }
            String title = String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u7684\u201c%3$s\u201d \u540e\u53f0\u4efb\u52a1\u9519\u8bef\u3002", (String)"AsyncTxAlarmer_1", (String)"fi-arapcommon", (Object[])new Object[0]), entityName, billNo, bizAction);
            message.setTitle(title);
            message.setContent(tx.getErrorMessage());
            message.setUserIds(receivers);
            message.setSenderId(Long.valueOf(1L));
            message.setSendTime(new Date());
            message.setType("alarm");
            message.setTag(entityName);
            message.setNotifyType(MessageChannels.MC.getNumber());
            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
        });
    }

    private static String getEntityName(String entityKey) {
        try {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
            return entityType.getDisplayName().getLocaleValue();
        }
        catch (Exception e) {
            return entityKey;
        }
    }

    private static String getBillNo(AsyncTx tx) {
        try {
            String xid = tx.getXid();
            QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(xid));
            DynamicObject bill = QueryServiceHelper.queryOne((String)tx.getGroup(), (String)"billno", (QFilter[])new QFilter[]{idFilter});
            return bill.getString("billno");
        }
        catch (Exception e) {
            return tx.getXid();
        }
    }
}

