/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.tx;

import java.io.PrintWriter;
import java.io.StringWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.TextProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.tx.AsyncTx;
import kd.fi.arapcommon.tx.AsyncTxAlarmer;
import kd.fi.arapcommon.tx.IAsyncExecutor;

public class AsyncTxService {
    public void execute(AsyncTx tx) {
        String executeClass = tx.getExecuteClass();
        try {
            IAsyncExecutor consumer = (IAsyncExecutor)Class.forName(executeClass).newInstance();
            consumer.execute(tx);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void executeWithTx(AsyncTx tx) {
        try (TXHandle txHandle = TX.required();){
            try {
                this.execute(tx);
                this.handleSuccess(tx);
            }
            catch (Exception e) {
                txHandle.markRollback();
                try (TXHandle excep = TX.requiresNew();){
                    this.handleException(tx, e);
                }
            }
        }
    }

    public void save(AsyncTx[] txs) {
        TextProp paramProp = (TextProp)MetadataServiceHelper.getDataEntityType((String)"arap_asynctx").getProperty("params");
        int maxLenth = paramProp.getMaxLenth();
        DynamicObject[] txObjs = new DynamicObject[txs.length];
        for (int i = 0; i < txs.length; ++i) {
            AsyncTx tx = txs[i];
            DynamicObject txObj = BusinessDataServiceHelper.newDynamicObject((String)"arap_asynctx");
            txObj.set("id", (Object)tx.getPk());
            txObj.set("group", (Object)tx.getGroup());
            txObj.set("action", (Object)tx.getAction());
            txObj.set("task", (Object)tx.getTask());
            txObj.set("xid", (Object)tx.getXid());
            txObj.set("executeclass", (Object)tx.getExecuteClass());
            String jsonParam = tx.getJsonParam();
            if (jsonParam != null && jsonParam.length() > maxLenth) {
                txObj.set("params", (Object)jsonParam.substring(0, maxLenth));
            } else {
                txObj.set("params", (Object)jsonParam);
            }
            txObj.set("params_tag", (Object)jsonParam);
            txObj.set("executetimes", (Object)tx.getExecuteTimes());
            txObj.set("errormessage", (Object)tx.getErrorMessage());
            txObj.set("createtime", (Object)tx.getCreateTime());
            txObj.set("state", (Object)tx.getState());
            txObjs[i] = txObj;
        }
        SaveServiceHelper.save((DynamicObject[])txObjs);
    }

    public void delete(AsyncTx tx) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"arap_asynctx");
        DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])new Long[]{tx.getPk()});
    }

    public AsyncTx[] query(String group, String[] xids) {
        QFilter groupFilter = new QFilter("group", "=", (Object)group);
        QFilter xidFilter = new QFilter("xid", "in", (Object)xids);
        QFilter[] filters = new QFilter[]{groupFilter, xidFilter};
        String selectors = "id,group,action,task,xid,executeclass,params,params_tag,createtime,executetimes,state";
        DynamicObjectCollection txObjs = QueryServiceHelper.query((String)"arap_asynctx", (String)selectors, (QFilter[])filters);
        AsyncTx[] txs = new AsyncTx[txObjs.size()];
        for (int i = 0; i < txObjs.size(); ++i) {
            AsyncTx asyncTx;
            DynamicObject txObj = (DynamicObject)txObjs.get(i);
            txs[i] = asyncTx = this.parseAsyncTx(txObj);
        }
        return txs;
    }

    public AsyncTx parseAsyncTx(DynamicObject txObj) {
        AsyncTx asyncTx = new AsyncTx();
        asyncTx.setPk(txObj.getLong("id"));
        asyncTx.setGroup(txObj.getString("group"));
        asyncTx.setAction(txObj.getString("action"));
        asyncTx.setTask(txObj.getString("task"));
        asyncTx.setXid(txObj.getString("xid"));
        asyncTx.setExecuteClass(txObj.getString("executeclass"));
        asyncTx.setCreateTime(txObj.getDate("createtime"));
        asyncTx.setExecuteTimes(txObj.getInt("executetimes"));
        asyncTx.setState(txObj.getString("state"));
        asyncTx.setJsonParam(txObj.getString("params_tag"));
        return asyncTx;
    }

    public void handleSuccess(AsyncTx tx) {
        DynamicObject txObj = BusinessDataServiceHelper.loadSingle((Object)tx.getPk(), (String)"arap_asynctx", (String)"executetimes,state");
        if (txObj != null) {
            txObj.set("state", (Object)"success");
            txObj.set("executetimes", (Object)(tx.getExecuteTimes() + 1));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{txObj});
        }
    }

    public void handleException(AsyncTx tx, Exception e) {
        String message = e.getMessage();
        DynamicObject txObj = BusinessDataServiceHelper.loadSingle((Object)tx.getPk(), (String)"arap_asynctx", (String)"executetimes,state,errormessage,errormessage_tag");
        if (txObj != null) {
            TextProp errMessageProp = (TextProp)txObj.getDataEntityType().getProperties().get((Object)"errormessage");
            int maxLenth = errMessageProp.getMaxLenth();
            if (message == null) {
                message = "Click to show detail!";
            } else if (message.length() > maxLenth) {
                message = message.substring(0, maxLenth);
            }
            txObj.set("state", (Object)"err");
            txObj.set("executetimes", (Object)(tx.getExecuteTimes() + 1));
            txObj.set("errormessage", (Object)message);
            txObj.set("errormessage_tag", (Object)this.getStackTraceMessage(e));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{txObj});
        }
        tx.setErrorMessage(message);
        AsyncTxAlarmer.sendMessage(tx);
    }

    public void handleException(AsyncTx tx, String errorMessgae) {
        try (TXHandle txHandle = TX.requiresNew();){
            DynamicObject txObj = BusinessDataServiceHelper.loadSingle((Object)tx.getPk(), (String)"arap_asynctx", (String)"executetimes,state,errormessage,errormessage_tag");
            if (txObj != null) {
                txObj.set("state", (Object)"err");
                txObj.set("executetimes", (Object)(tx.getExecuteTimes() + 1));
                txObj.set("errormessage", (Object)"error");
                txObj.set("errormessage_tag", (Object)errorMessgae);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{txObj});
            }
        }
    }

    private String getStackTraceMessage(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        e.printStackTrace(writer);
        writer.flush();
        return sw.toString();
    }
}

