/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.tx;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.tx.AsyncSettingManager;
import kd.fi.arapcommon.util.DateUtils;

public class AsyncTxTask
extends AbstractTask {
    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        this.clearHistoryTxs();
        this.rerunFaildTxs();
    }

    private void rerunFaildTxs() {
        QFilter filter = new QFilter("state", "=", (Object)"err").and(new QFilter("executetimes", "<=", (Object)5));
        DynamicObject[] txObjs = BusinessDataServiceHelper.load((String)"arap_asynctx", (String)"id", (QFilter[])new QFilter[]{filter});
        Object[] pks = new Long[txObjs.length];
        for (int i = 0; i < txObjs.length; ++i) {
            pks[i] = txObjs[i].getLong("id");
        }
        OperationServiceHelper.executeOperate((String)"execute", (String)"arap_asynctx", (Object[])pks, (OperateOption)OperateOption.create());
    }

    private void clearHistoryTxs() {
        AsyncSettingManager asyncSettingManager = new AsyncSettingManager();
        Date date = new Date();
        Date lastDay = DateUtils.getLastDay(date, asyncSettingManager.getLogRetainDays());
        QFilter statusFilters = new QFilter("state", "=", (Object)"success");
        QFilter timeFilter = new QFilter("createtime", "<", (Object)lastDay);
        DeleteServiceHelper.delete((String)"arap_asynctx", (QFilter[])new QFilter[]{statusFilters, timeFilter});
    }
}

