/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.Test;

public class EntityOperateServicePlugin
extends AbstractJUnitTestPlugIn {
    private final List<String> appList = Arrays.asList("ar", "ap");

    @TestMethod(value=1)
    @DisplayName(value="\u67e5\u8be2\u5e76\u8f93\u51fa\u5e94\u6536\u5e94\u4ed8\u5355\u636e\u64cd\u4f5c\u60c5\u51b5")
    @Test
    public void findOperateLogInfo() {
        DBRoute dbRoute = new DBRoute("sys.meta");
        StringBuilder sb = new StringBuilder();
        sb.append(" select t.fid,t.fbizappid, tpl.fname appname, tl.fname billname,t.fnumber billnumber,t.fdata ");
        sb.append(" from t_meta_entitydesign t,t_meta_entitydesign_l tl,t_meta_bizapp tp,t_meta_bizapp_l tpl ");
        sb.append(" where t.fid = tl.fid and t.fbizappid = tp.fid and tp.fid = tpl.fid and t.fenabled = '1' ");
        sb.append(" and tl.flocaleid = 'zh_CN' and tpl.flocaleid = 'zh_CN' ");
        sb.append(" and tp.fnumber in (");
        boolean flag = false;
        for (String appId : this.appList) {
            if (flag) {
                sb.append(",");
            }
            sb.append("'").append(appId).append("'");
            flag = true;
        }
        sb.append(")");
        Map<String, String> permMap = this.getPermitemMap();
        ArrayList<List<String>> opLogList = new ArrayList<List<String>>(100);
        opLogList.add(Arrays.asList("\u5e94\u7528\u540d\u79f0", "\u5143\u6570\u636e\u540d\u79f0", "\u5143\u6570\u636e\u7f16\u7801", "\u64cd\u4f5c\u540d\u79f0", "\u64cd\u4f5c\u7f16\u7801", "\u64cd\u4f5c\u7c7b\u578b", "\u662f\u5426\u6253\u64cd\u4f5c\u65e5\u5fd7", "\u64cd\u4f5c\u6743\u9650\u540d\u79f0", "\u64cd\u4f5c\u6743\u9650ID"));
        try (DataSet dataSet = DB.queryDataSet((String)"TableParase", (DBRoute)dbRoute, (String)sb.toString());){
            for (kd.bos.algo.Row row : dataSet) {
                String appname = row.getString("appname");
                String billname = row.getString("billname");
                String billnumber = row.getString("billnumber");
                String id = MetadataDao.getIdByNumber((String)billnumber, (MetaCategory)MetaCategory.Entity);
                EntityMetadata meta = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
                List operations = meta.getRootEntity().getOperations();
                if (operations == null || operations.isEmpty()) continue;
                for (Operation op : operations) {
                    String operateCode = op.getOperationType();
                    String logName = op.isLogEnable() ? "\u662f" : "\u5426";
                    String operateName = (String)op.getName().getItem("zh_CN");
                    String permission = op.getPermissionItemId();
                    opLogList.add(Arrays.asList(appname, billname, billnumber, operateName, op.getKey(), operateCode, logName, permMap.get(permission), permission));
                }
            }
        }
        this.output(opLogList);
    }

    private Map<String, String> getPermitemMap() {
        DBRoute dbRoute = new DBRoute("sys");
        HashMap<String, String> permMap = new HashMap<String, String>(1000);
        try (DataSet dataSet = DB.queryDataSet((String)"TableParase", (DBRoute)dbRoute, (String)"select t.fid,tl.fname from t_perm_permitem t,t_perm_permitem_l tl where t.fid=tl.fid and tl.flocaleid ='zh_CN'");){
            for (kd.bos.algo.Row row : dataSet) {
                permMap.put(row.getString("fid"), row.getString("fname"));
            }
        }
        return permMap;
    }

    private void output(List<List<String>> opLogList) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet0 = workbook.createSheet("arap_op_log");
        this.setSheetInfo(sheet0, opLogList);
        File file = new File("D:\\arap_op_log.xlsx");
        try (FileOutputStream outout = new FileOutputStream(file);){
            workbook.write((OutputStream)outout);
            outout.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setSheetInfo(Sheet sheet, List<List<String>> infoList) {
        for (int rowNum = 0; rowNum < infoList.size(); ++rowNum) {
            Row row = sheet.createRow(rowNum);
            List<String> rowList = infoList.get(rowNum);
            for (int index = 0; index < rowList.size(); ++index) {
                this.setCellValue(row, index, rowList.get(index));
            }
        }
    }

    private void setCellValue(Row row, int index, String value) {
        Cell cell = row.createCell(index);
        cell.setCellValue(value);
    }
}

