/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.check;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.unittest.framework.KDAssert;

public class BusBillTestChecker {
    private static final Log logger = LogFactory.getLog(BusBillTestChecker.class);

    public static void entryCheckByQty(DynamicObject busBill, BigDecimal expectedQty, int rowIndex) {
        BigDecimal qty = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_quantity");
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u6570\u91cf\u8ba1\u7b97\u9519\u8bef"), (int)expectedQty.compareTo(qty), (int)0);
    }

    public static void entryCheckByWoff(DynamicObject busBill, BigDecimal expectedQty, BigDecimal expectedAmt, BigDecimal expectedLocalAmt, int rowIndex) {
        BigDecimal unWoffQty = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_unwoffqty");
        logger.info("\u5355\u636e" + busBill.getString("billno") + "\u672a\u51b2\u56de\u6570\u91cf\u4e3a\uff1a" + unWoffQty);
        BigDecimal unWoffAmt = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_unwoffamt");
        BigDecimal unWoffLocamt = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_unwofflocamt");
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u672a\u51b2\u56de\u6570\u91cf\u8ba1\u7b97\u9519\u8bef"), (int)expectedQty.compareTo(unWoffQty), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u672a\u51b2\u56de\u91d1\u989d\u8ba1\u7b97\u9519\u8bef"), (int)expectedAmt.compareTo(unWoffAmt), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u672a\u51b2\u56de\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef"), (int)expectedLocalAmt.compareTo(unWoffLocamt), (int)0);
        boolean isWriteoff = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBoolean("e_iswriteoff");
        if (expectedQty.compareTo(BigDecimal.ZERO) == 0) {
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5df2\u51b2\u56de\u6807\u8bc6\u9519\u8bef"), (boolean)true, (boolean)isWriteoff);
        } else {
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5df2\u51b2\u56de\u6807\u8bc6\u9519\u8bef"), (boolean)false, (boolean)isWriteoff);
        }
    }

    public static void entryCheckByInvoice(DynamicObject busBill, BigDecimal expectedQty, BigDecimal expectedAmt, BigDecimal expectedLocalAmt, int rowIndex) {
        BigDecimal unInvoicedQty = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_uninvoicedqty");
        BigDecimal invoicedQty = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_invoicedqty");
        BigDecimal unInvoicedAmt = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_uninvoicedamt");
        BigDecimal invoicedAmt = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_invoicedamt");
        BigDecimal unInvoicedLocamt = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_uninvoicedlocamt");
        BigDecimal invoicedLocamt = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_invoicedlocamt");
        BigDecimal qty = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_quantity");
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        String billEntity = busBill.getDataEntityType().getName();
        if ("ar_busbill".equals(billEntity)) {
            priceTaxTotal = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_recamount");
            priceTaxTotalBase = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_reclocalamt");
        } else {
            priceTaxTotal = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_pricetaxtotal");
            priceTaxTotalBase = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_pricetaxtotalbase");
        }
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u672a\u5f00\u7968\u6570\u91cf\u8ba1\u7b97\u9519\u8bef"), (int)expectedQty.compareTo(unInvoicedQty), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5df2\u5f00\u7968\u6570\u91cf\u8ba1\u7b97\u9519\u8bef"), (int)qty.subtract(expectedQty).compareTo(invoicedQty), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u672a\u5f00\u7968\u91d1\u989d\u8ba1\u7b97\u9519\u8bef"), (int)expectedAmt.compareTo(unInvoicedAmt), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5df2\u5f00\u7968\u91d1\u989d\u8ba1\u7b97\u9519\u8bef"), (int)priceTaxTotal.subtract(expectedAmt).compareTo(invoicedAmt), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u672a\u5f00\u7968\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef"), (int)expectedLocalAmt.compareTo(unInvoicedLocamt), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5df2\u5f00\u7968\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef"), (int)priceTaxTotalBase.subtract(expectedLocalAmt).compareTo(invoicedLocamt), (int)0);
    }

    public static void entryCheckByAmt(DynamicObject busBill, BigDecimal expectedAmt, BigDecimal expectedLocalAmt, BigDecimal expectedTotalAmt, BigDecimal expectedTotalAmtBase, int rowIndex) {
        BigDecimal amount = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_amount");
        BigDecimal localAmt = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_localamt");
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        String billEntity = busBill.getDataEntityType().getName();
        if ("ar_busbill".equals(billEntity)) {
            priceTaxTotal = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_recamount");
            priceTaxTotalBase = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_reclocalamt");
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5e94\u6536\u91d1\u989d\u8ba1\u7b97\u9519\u8bef"), (int)expectedTotalAmt.compareTo(priceTaxTotal), (int)0);
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5e94\u6536\u91d1\u989d\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef"), (int)expectedTotalAmtBase.compareTo(priceTaxTotalBase), (int)0);
        } else {
            priceTaxTotal = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_pricetaxtotal");
            priceTaxTotalBase = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_pricetaxtotalbase");
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5e94\u4ed8\u91d1\u989d\u8ba1\u7b97\u9519\u8bef"), (int)expectedTotalAmt.compareTo(priceTaxTotal), (int)0);
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5e94\u4ed8\u91d1\u989d\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef"), (int)expectedTotalAmtBase.compareTo(priceTaxTotalBase), (int)0);
        }
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5206\u5f55\u91d1\u989d\u8ba1\u7b97\u9519\u8bef"), (int)expectedAmt.compareTo(amount), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u91d1\u989d\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef"), (int)expectedLocalAmt.compareTo(localAmt), (int)0);
    }

    public static void entryCheckByPrice(DynamicObject busBill, BigDecimal expectedUnitPrice, BigDecimal expectedTaxUnitPrice, BigDecimal expectedActUnitPrice, BigDecimal expectedActTaxUnitPrice, int rowIndex) {
        BigDecimal unitPrice = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_unitprice");
        BigDecimal taxUnitPrice = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_taxunitprice");
        BigDecimal actUnitPrice = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_actunitprice");
        BigDecimal actTaxUnitPrice = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_acttaxunitprice");
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5355\u4ef7\u8ba1\u7b97\u9519\u8bef"), (int)expectedUnitPrice.compareTo(unitPrice), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u542b\u7a0e\u5355\u4ef7\u8ba1\u7b97\u9519\u8bef"), (int)expectedTaxUnitPrice.compareTo(taxUnitPrice), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5b9e\u9645\u5355\u4ef7\u8ba1\u7b97\u9519\u8bef"), (int)expectedActUnitPrice.compareTo(actUnitPrice), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5b9e\u9645\u542b\u7a0e\u5355\u4ef7\u8ba1\u7b97\u9519\u8bef"), (int)expectedActTaxUnitPrice.compareTo(actTaxUnitPrice), (int)0);
    }

    public static void entryCheckByTax(DynamicObject busBill, BigDecimal expectedTax, BigDecimal expectedTaxLocalAmt, BigDecimal expectedDiscountAmt, BigDecimal expectedDiscountLocalAmt, int rowIndex) {
        BigDecimal tax = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_tax");
        BigDecimal taxLocalAmt = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_taxlocalamt");
        BigDecimal discountAmt = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_discountamount");
        BigDecimal discountLocalAmt = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_discountlocalamt");
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u7a0e\u989d\u8ba1\u7b97\u9519\u8bef"), (int)expectedTax.compareTo(tax), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u7a0e\u989d\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef"), (int)expectedTaxLocalAmt.compareTo(taxLocalAmt), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u6298\u6263\u989d\u8ba1\u7b97\u9519\u8bef"), (int)expectedDiscountAmt.compareTo(discountAmt), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u6298\u6263\u989d\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef"), (int)expectedDiscountLocalAmt.compareTo(discountLocalAmt), (int)0);
    }

    public static void headCheck(DynamicObject busBill) {
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localAmt = BigDecimal.ZERO;
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocAmt = BigDecimal.ZERO;
        BigDecimal unWoffAmt = BigDecimal.ZERO;
        BigDecimal unWoffLocalamt = BigDecimal.ZERO;
        BigDecimal invoicedAmt = BigDecimal.ZERO;
        BigDecimal invoicedLocalamt = BigDecimal.ZERO;
        BigDecimal unInvoicedAmt = BigDecimal.ZERO;
        BigDecimal unInvoicedLocalamt = BigDecimal.ZERO;
        String billEntity = busBill.getDataEntityType().getName();
        DynamicObjectCollection entry = busBill.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            BigDecimal entryTax = row.getBigDecimal("e_tax");
            BigDecimal entryTaxLocalAmt = row.getBigDecimal("e_taxlocalamt");
            BigDecimal entryLocalAmt = row.getBigDecimal("e_localamt");
            BigDecimal entryAmount = row.getBigDecimal("e_amount");
            BigDecimal entryUnwoffAmt = row.getBigDecimal("e_unwoffamt");
            BigDecimal entryUnwoffLocalamt = row.getBigDecimal("e_unwofflocamt");
            BigDecimal entryInvoicedAmt = row.getBigDecimal("e_invoicedamt");
            BigDecimal entryInvoicedLocalamt = row.getBigDecimal("e_invoicedlocamt");
            BigDecimal entryUninvoicedAmt = row.getBigDecimal("e_uninvoicedamt");
            BigDecimal entryUninvoicedLocalamt = row.getBigDecimal("e_uninvoicedlocamt");
            BigDecimal entryPriceTaxTotal = BigDecimal.ZERO;
            BigDecimal entryPriceTaxTotalBase = BigDecimal.ZERO;
            if ("ar_busbill".equals(billEntity)) {
                entryPriceTaxTotal = row.getBigDecimal("e_recamount");
                entryPriceTaxTotalBase = row.getBigDecimal("e_reclocalamt");
            } else {
                entryPriceTaxTotal = row.getBigDecimal("e_pricetaxtotal");
                entryPriceTaxTotalBase = row.getBigDecimal("e_pricetaxtotalbase");
            }
            amount = amount.add(entryAmount);
            localAmt = localAmt.add(entryLocalAmt);
            priceTaxTotal = priceTaxTotal.add(entryPriceTaxTotal);
            priceTaxTotalBase = priceTaxTotalBase.add(entryPriceTaxTotalBase);
            tax = tax.add(entryTax);
            taxLocAmt = taxLocAmt.add(entryTaxLocalAmt);
            unWoffAmt = unWoffAmt.add(entryUnwoffAmt);
            unWoffLocalamt = unWoffLocalamt.add(entryUnwoffLocalamt);
            invoicedAmt = invoicedAmt.add(entryInvoicedAmt);
            invoicedLocalamt = invoicedLocalamt.add(entryInvoicedLocalamt);
            unInvoicedAmt = unInvoicedAmt.add(entryUninvoicedAmt);
            unInvoicedLocalamt = unInvoicedLocalamt.add(entryUninvoicedLocalamt);
        }
        BigDecimal headAmt = busBill.getBigDecimal("amount");
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u8868\u5934\u91d1\u989d\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u5408\u8ba1\u4e0d\u76f8\u7b49"), (int)amount.compareTo(headAmt), (int)0);
        BigDecimal headLocalAmt = busBill.getBigDecimal("localamt");
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u8868\u5934\u91d1\u989d\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u5408\u8ba1\u4e0d\u76f8\u7b49"), (int)localAmt.compareTo(headLocalAmt), (int)0);
        BigDecimal headTax = busBill.getBigDecimal("tax");
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u8868\u5934\u7a0e\u989d\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u5408\u8ba1\u4e0d\u76f8\u7b49"), (int)tax.compareTo(headTax), (int)0);
        BigDecimal headTaxLocAmt = busBill.getBigDecimal("taxlocamt");
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u8868\u5934\u7a0e\u989d\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u5408\u8ba1\u4e0d\u76f8\u7b49"), (int)taxLocAmt.compareTo(headTaxLocAmt), (int)0);
        BigDecimal headUnwoffAmt = busBill.getBigDecimal("unwoffamt");
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u8868\u5934\u672a\u51b2\u56de\u91d1\u989d\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u5408\u8ba1\u4e0d\u76f8\u7b49"), (int)unWoffAmt.compareTo(headUnwoffAmt), (int)0);
        BigDecimal headUnwoffLocamt = busBill.getBigDecimal("unwofflocamt");
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u8868\u5934\u672a\u51b2\u56de\u91d1\u989d\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u5408\u8ba1\u4e0d\u76f8\u7b49"), (int)unWoffLocalamt.compareTo(headUnwoffLocamt), (int)0);
        BigDecimal headUninvoicedAmt = busBill.getBigDecimal("uninvoicedamt");
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u8868\u5934\u672a\u5f00\u7968\u91d1\u989d\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u5408\u8ba1\u4e0d\u76f8\u7b49"), (int)unInvoicedAmt.compareTo(headUninvoicedAmt), (int)0);
        BigDecimal headUninvoicedLocamt = busBill.getBigDecimal("uninvoicedlocamt");
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u8868\u5934\u672a\u5f00\u7968\u91d1\u989d\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u5408\u8ba1\u4e0d\u76f8\u7b49"), (int)unInvoicedLocalamt.compareTo(headUninvoicedLocamt), (int)0);
        BigDecimal headInvoicedAmt = busBill.getBigDecimal("invoicedamt");
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u8868\u5934\u5df2\u5f00\u7968\u91d1\u989d\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u5408\u8ba1\u4e0d\u76f8\u7b49"), (int)invoicedAmt.compareTo(headInvoicedAmt), (int)0);
        BigDecimal headInvoicedLocamt = busBill.getBigDecimal("invoicedlocamt");
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u8868\u5934\u5df2\u5f00\u7968\u91d1\u989d\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u5408\u8ba1\u4e0d\u76f8\u7b49"), (int)invoicedLocalamt.compareTo(headInvoicedLocamt), (int)0);
        BigDecimal headPriceTaxTotal = BigDecimal.ZERO;
        BigDecimal headPriceTaxTotalBase = BigDecimal.ZERO;
        if ("ar_busbill".equals(billEntity)) {
            headPriceTaxTotal = busBill.getBigDecimal("recamount");
            headPriceTaxTotalBase = busBill.getBigDecimal("reclocalamt");
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u8868\u5934\u5e94\u6536\u91d1\u989d\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u5408\u8ba1\u4e0d\u76f8\u7b49"), (int)priceTaxTotal.compareTo(headPriceTaxTotal), (int)0);
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u8868\u5934\u5e94\u6536\u91d1\u989d\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u5408\u8ba1\u4e0d\u76f8\u7b49"), (int)priceTaxTotalBase.compareTo(headPriceTaxTotalBase), (int)0);
        } else {
            headPriceTaxTotal = busBill.getBigDecimal("pricetaxtotal");
            headPriceTaxTotalBase = busBill.getBigDecimal("pricetaxtotalbase");
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u8868\u5934\u5e94\u4ed8\u91d1\u989d\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u5408\u8ba1\u4e0d\u76f8\u7b49"), (int)priceTaxTotal.compareTo(headPriceTaxTotal), (int)0);
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u8868\u5934\u5e94\u4ed8\u91d1\u989d\u6298\u672c\u5e01\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0e\u5206\u5f55\u5408\u8ba1\u4e0d\u76f8\u7b49"), (int)priceTaxTotalBase.compareTo(headPriceTaxTotalBase), (int)0);
        }
    }

    public static void busBillJournalCheck(DynamicObject busBill) {
        String billEntity = busBill.getDataEntityType().getName();
        String journalEntity = "ar_busbill".equals(billEntity) ? "ar_journal" : "ap_journal";
        DynamicObject journal = BusinessDataServiceHelper.loadSingleFromCache((String)journalEntity, (String)"estimatedamt,localestimatedamt,asstact,asstacttype,org,currency,basecurrency", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)busBill.getString("billno"))});
        String billno = busBill.getString("billno");
        DynamicObject asstact = busBill.getDynamicObject("asstact");
        DynamicObject org = busBill.getDynamicObject("org");
        DynamicObject currency = busBill.getDynamicObject("currency");
        DynamicObject baseCurrency = busBill.getDynamicObject("basecurrency");
        if ("ar_busbill".equals(billEntity)) {
            BigDecimal recAmount = busBill.getBigDecimal("recamount");
            BigDecimal recLocalamt = busBill.getBigDecimal("reclocalamt");
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a" + billno + "\u7684\u6682\u4f30\u5e94\u6536\u5355\u6d41\u6c34\u6682\u4f30\u91d1\u989d\u9519\u8bef"), (int)recAmount.compareTo(journal.getBigDecimal("estimatedamt")), (int)0);
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a" + billno + "\u7684\u6682\u4f30\u5e94\u6536\u5355\u6d41\u6c34\u6682\u4f30\u91d1\u989d\u6298\u672c\u5e01\u9519\u8bef"), (int)recLocalamt.compareTo(journal.getBigDecimal("localestimatedamt")), (int)0);
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a" + billno + "\u7684\u6682\u4f30\u5e94\u6536\u5355\u6d41\u6c34\u5f80\u6765\u6237\u9519\u8bef"), (asstact.getLong("id") == journal.getLong("asstact.id") ? 1 : 0) != 0, (boolean)true);
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a" + billno + "\u7684\u6682\u4f30\u5e94\u6536\u5355\u6d41\u6c34\u6838\u7b97\u4e3b\u4f53\u9519\u8bef"), (org.getLong("id") == journal.getLong("org.id") ? 1 : 0) != 0, (boolean)true);
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a" + billno + "\u7684\u6682\u4f30\u5e94\u6536\u5355\u6d41\u6c34\u5e01\u522b\u9519\u8bef"), (currency.getLong("id") == journal.getLong("currency.id") ? 1 : 0) != 0, (boolean)true);
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a" + billno + "\u7684\u6682\u4f30\u5e94\u6536\u5355\u6d41\u6c34\u672c\u4f4d\u5e01\u9519\u8bef"), (baseCurrency.getLong("id") == journal.getLong("basecurrency.id") ? 1 : 0) != 0, (boolean)true);
        } else {
            BigDecimal priceTaxTotal = busBill.getBigDecimal("pricetaxtotal");
            BigDecimal priceTaxTotalBase = busBill.getBigDecimal("pricetaxtotalbase");
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a" + billno + "\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u6d41\u6c34\u6682\u4f30\u91d1\u989d\u9519\u8bef"), (int)priceTaxTotal.compareTo(journal.getBigDecimal("estimatedamt")), (int)0);
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a" + billno + "\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u6d41\u6c34\u6682\u4f30\u91d1\u989d\u6298\u672c\u5e01\u9519\u8bef"), (int)priceTaxTotalBase.compareTo(journal.getBigDecimal("localestimatedamt")), (int)0);
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a" + billno + "\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u6d41\u6c34\u5f80\u6765\u6237\u9519\u8bef"), (asstact.getLong("id") == journal.getLong("asstact.id") ? 1 : 0) != 0, (boolean)true);
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a" + billno + "\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u6d41\u6c34\u6838\u7b97\u4e3b\u4f53\u9519\u8bef"), (org.getLong("id") == journal.getLong("org.id") ? 1 : 0) != 0, (boolean)true);
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a" + billno + "\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u6d41\u6c34\u5e01\u522b\u9519\u8bef"), (currency.getLong("id") == journal.getLong("currency.id") ? 1 : 0) != 0, (boolean)true);
            KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a" + billno + "\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u6d41\u6c34\u672c\u4f4d\u5e01\u9519\u8bef"), (baseCurrency.getLong("id") == journal.getLong("basecurrency.id") ? 1 : 0) != 0, (boolean)true);
        }
    }

    public static void busBillDeleteJournalCheck(String billno, boolean isAr) {
        String entity = isAr ? "ar_journal" : "ap_journal";
        boolean exists = QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a" + billno + "\u7684\u6682\u4f30\u5355\u636e\u6d41\u6c34\u5220\u9664\u5931\u8d25"), (boolean)false, (boolean)exists);
    }

    public static void confirmAmtCheck(DynamicObject busBill, BigDecimal expectedUnconfirmAmt, BigDecimal expectedConfirmedAmt, int rowIndex) {
        BigDecimal unconfirmAmt = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_unconfirmamt");
        BigDecimal confirmedAmt = ((DynamicObject)busBill.getDynamicObjectCollection("entry").get(rowIndex)).getBigDecimal("e_confirmedamt");
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u672a\u786e\u8ba4\u91d1\u989d\u8ba1\u7b97\u9519\u8bef"), (int)expectedUnconfirmAmt.compareTo(unconfirmAmt), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + busBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5df2\u786e\u8ba4\u91d1\u989d\u8ba1\u7b97\u9519\u8bef"), (int)expectedConfirmedAmt.compareTo(confirmedAmt), (int)0);
    }
}

