/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.check;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.unittest.framework.KDAssert;

public class CasRecBillTestChecker {
    public static void validateDetailLockAmt(DynamicObject detail, BigDecimal eLockAmt, BigDecimal eUnLockAmt) {
        KDAssert.assertEquals((String)"\u6536\u6b3e\u5355\u5206\u5f55\u5df2\u9501\u5b9a\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)eLockAmt.compareTo(detail.getBigDecimal("e_lockamt")));
        KDAssert.assertEquals((String)"\u6536\u6b3e\u5355\u5206\u5f55\u672a\u9501\u5b9a\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)eUnLockAmt.compareTo(detail.getBigDecimal("e_unlockamt")));
    }

    public static void validateDetailSettleAmt(DynamicObject detail, BigDecimal eSettledAmt, BigDecimal eSettledLocalAmt, BigDecimal eUnSettledAmt, BigDecimal eUnSettledLocalAmt) {
        KDAssert.assertEquals((String)"\u6536\u6b3e\u5355\u5206\u5f55\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)eSettledAmt.compareTo(detail.getBigDecimal("e_settledamt")));
        KDAssert.assertEquals((String)"\u6536\u6b3e\u5355\u5206\u5f55\u5df2\u7ed3\u7b97\u6298\u672c\u5e01\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)eSettledLocalAmt.compareTo(detail.getBigDecimal("e_settledlocalamt")));
        KDAssert.assertEquals((String)"\u6536\u6b3e\u5355\u5206\u5f55\u672a\u7ed3\u7b97\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)eUnSettledAmt.compareTo(detail.getBigDecimal("e_unsettledamt")));
        KDAssert.assertEquals((String)"\u6536\u6b3e\u5355\u5206\u5f55\u672a\u7ed3\u7b97\u6298\u672c\u5e01\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)eUnSettledLocalAmt.compareTo(detail.getBigDecimal("e_unsettledlocalamt")));
    }

    public static void validateBillLockAndSettleAmt(DynamicObject detail, BigDecimal eLockAmt, BigDecimal eUnLockAmt, BigDecimal eSettledAmt, BigDecimal eSettledLocalAmt, BigDecimal eUnSettledAmt, BigDecimal eUnSettledLocalAmt) {
        CasRecBillTestChecker.validateDetailLockAmt(detail, eLockAmt, eUnLockAmt);
        CasRecBillTestChecker.validateDetailSettleAmt(detail, eSettledAmt, eSettledLocalAmt, eUnSettledAmt, eUnSettledLocalAmt);
    }

    public static void validateInitialBill(DynamicObject casPayBill) {
        DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
        for (DynamicObject detail : entry) {
            BigDecimal eRecAmt = detail.getBigDecimal("e_receivableamt");
            BigDecimal eReLocalcAmt = detail.getBigDecimal("e_receivablelocamt");
            CasRecBillTestChecker.validateDetailLockAmt(detail, BigDecimal.ZERO, eRecAmt);
            CasRecBillTestChecker.validateDetailSettleAmt(detail, BigDecimal.ZERO, BigDecimal.ZERO, eRecAmt, eReLocalcAmt);
        }
    }

    public static void validateFinishBill(DynamicObject casPayBill) {
        KDAssert.assertEquals((String)"\u6536\u6b3e\u5355\u5206\u5f55\u72b6\u6001\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (String)"D", (String)casPayBill.getString("billstatus"));
        DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
        for (DynamicObject detail : entry) {
            BigDecimal eRecAmt = detail.getBigDecimal("e_receivableamt");
            BigDecimal eReLocalcAmt = detail.getBigDecimal("e_receivablelocamt");
            CasRecBillTestChecker.validateDetailLockAmt(detail, eRecAmt, BigDecimal.ZERO);
            CasRecBillTestChecker.validateDetailSettleAmt(detail, eRecAmt, eReLocalcAmt, BigDecimal.ZERO, BigDecimal.ZERO);
        }
    }

    public static void validateCasRecBillJournalData(DynamicObject casRecBill) {
        String selector = "org,asstacttype,asstact,currency,basecurrency,receivedamt,localreceivedamt,sourcebilltype";
        DynamicObject journal = BusinessDataServiceHelper.loadSingle((String)"ar_journal", (String)selector, (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)casRecBill.getLong("id"))});
        KDAssert.assertEquals((String)"\u6d41\u6c34\u4e0d\u5b58\u5728", (boolean)true, (journal != null ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u6838\u7b97\u4e3b\u4f53\u4e0e\u4ed8\u6b3e\u5904\u7406\u4e0d\u4e00\u81f4", (boolean)true, (casRecBill.getLong("org.id") == journal.getLong("org.id") ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u5f80\u6765\u7c7b\u578b\u4e0e\u4ed8\u6b3e\u5904\u7406\u4e0d\u4e00\u81f4", (boolean)true, (boolean)casRecBill.getString("payerformid").equals(journal.getString("asstacttype")));
        KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u5f80\u6765\u6237\u4e0e\u4ed8\u6b3e\u5904\u7406\u4e0d\u4e00\u81f4", (boolean)true, (casRecBill.getLong("payer") == journal.getLong("asstact.masterid") ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u5e01\u522b\u4e0e\u4ed8\u6b3e\u5904\u7406\u4e0d\u4e00\u81f4", (boolean)true, (casRecBill.getLong("currency.id") == journal.getLong("currency.id") ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u672c\u4f4d\u5e01\u4e0e\u4ed8\u6b3e\u5904\u7406\u4e0d\u4e00\u81f4", (boolean)true, (casRecBill.getLong("basecurrency.id") == journal.getLong("basecurrency.id") ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u9884\u4ed8\u91d1\u989d\u4e0e\u4ed8\u6b3e\u5904\u7406\u4e0d\u4e00\u81f4", (int)0, (int)casRecBill.getBigDecimal("actrecamt").compareTo(journal.getBigDecimal("receivedamt")));
        KDAssert.assertEquals((String)"\u6d41\u6c34\u7684\u9884\u4ed8\u91d1\u989d\u6298\u672c\u5e01\u4e0e\u4ed8\u6b3e\u5904\u7406\u4e0d\u4e00\u81f4", (int)0, (int)casRecBill.getBigDecimal("localamt").compareTo(journal.getBigDecimal("localreceivedamt")));
    }
}

