/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.check;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.util.EmptyUtils;

public class PayApplyBillTestChecker {
    public static void validatePayApplyPayStatus(DynamicObject payApply, String payStatus) {
        KDAssert.assertEquals((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u4ed8\u6b3e\u72b6\u6001\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (String)payStatus, (String)payApply.getString("paystatus"));
    }

    public static void validatePayApplyDetailLock(DynamicObject detail, BigDecimal ePaidAmt, BigDecimal eLockedAmt) {
        KDAssert.assertEquals((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u660e\u7ec6\u884c\u5df2\u4ed8\u6b3e\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)ePaidAmt.compareTo(detail.getBigDecimal("e_paidamt")));
        KDAssert.assertEquals((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u660e\u7ec6\u884c\u5df2\u9501\u5b9a\u91d1\u989d\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (int)0, (int)eLockedAmt.compareTo(detail.getBigDecimal("lockedAmt")));
        PayApplyBillTestChecker.validatePayApplyIsOverFull(detail);
    }

    public static void validatePayApplyIsOverFull(DynamicObject detail) {
        BigDecimal eApprovedAmt = detail.getBigDecimal("e_approvedamt");
        BigDecimal ePaidAmt = detail.getBigDecimal("e_paidamt");
        BigDecimal lockedAmt = detail.getBigDecimal("lockedamt");
        BigDecimal ePayAmount = detail.getBigDecimal("e_payamount");
        BigDecimal eApplyAmount = detail.getBigDecimal("e_applyamount");
        KDAssert.assertEquals((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5206\u5f55\u5df2\u4ed8\u6b3e\u91d1\u989d\u8d85\u989d\u53cd\u5199", (boolean)true, (eApprovedAmt.abs().compareTo(ePaidAmt.abs()) >= 0 ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5206\u5f55\u5df2\u9501\u5b9a\u91d1\u989d\u8d85\u989d\u53cd\u5199", (boolean)true, (eApprovedAmt.abs().compareTo(lockedAmt.abs()) >= 0 ? 1 : 0) != 0);
        if (EmptyUtils.isNotEmpty(ePayAmount)) {
            KDAssert.assertEquals((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5206\u5f55\u7533\u8bf7\u91d1\u989d\u8d85\u989d", (boolean)true, (ePayAmount.abs().compareTo(eApplyAmount.abs()) >= 0 ? 1 : 0) != 0);
            KDAssert.assertEquals((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5206\u5f55\u6838\u51c6\u91d1\u989d\u8d85\u989d", (boolean)true, (ePayAmount.abs().compareTo(eApprovedAmt.abs()) >= 0 ? 1 : 0) != 0);
        }
        KDAssert.assertEquals((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5206\u5f55\u6838\u51c6\u91d1\u989d,\u5df2\u4ed8\u6b3e\u91d1\u989d,\u5df2\u9501\u5b9a\u91d1\u989d,\u7533\u8bf7\u91d1\u989d\u7b26\u53f7\u65b9\u5411\u4e0d\u4e00\u81f4", (boolean)true, (eApprovedAmt.multiply(ePaidAmt).multiply(lockedAmt).multiply(eApplyAmount).compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0);
    }

    public static void validatorPayApply(DynamicObject payApply, String payStatus, BigDecimal ePaidAmtOne, BigDecimal eLockedAmtOne, BigDecimal ePaidAmtTwo, BigDecimal eLockedAmtTwo) {
        DynamicObjectCollection entry = payApply.getDynamicObjectCollection("entry");
        PayApplyBillTestChecker.validatePayApplyDetailLock((DynamicObject)entry.get(0), ePaidAmtOne, eLockedAmtOne);
        PayApplyBillTestChecker.validatePayApplyDetailLock((DynamicObject)entry.get(1), ePaidAmtTwo, eLockedAmtTwo);
        PayApplyBillTestChecker.validatePayApplyPayStatus(payApply, payStatus);
    }
}

