/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.check;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class RevCfmBillTestChecker {
    public static void validateDetailEntryVerify(DynamicObject detailEntryRow, BigDecimal expectedVerifyQty, BigDecimal expectedVerifyAmt, BigDecimal expectedUnVerifyQty, BigDecimal expectedUnVerifyAmt) {
        BigDecimal verifyQty = detailEntryRow.getBigDecimal("e_verifiedqty");
        RevCfmBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u6838\u9500\u6570\u91cf\u6821\u9a8c\u5931\u8d25", 0, expectedVerifyQty.compareTo(verifyQty));
        BigDecimal unVerifyQty = detailEntryRow.getBigDecimal("e_unverifyqty");
        RevCfmBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u672a\u6838\u9500\u6570\u91cf\u6821\u9a8c\u5931\u8d25", 0, expectedUnVerifyQty.compareTo(unVerifyQty));
        BigDecimal verifyAmt = detailEntryRow.getBigDecimal("e_verifiedamt");
        RevCfmBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u6838\u9500\u91d1\u989d\u6821\u9a8c\u5931\u8d25", 0, expectedVerifyAmt.compareTo(verifyAmt));
        BigDecimal unVerifyAmt = detailEntryRow.getBigDecimal("e_unverifyamt");
        RevCfmBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u672a\u6838\u9500\u91d1\u989d\u6821\u9a8c\u5931\u8d25", 0, expectedUnVerifyAmt.compareTo(unVerifyAmt));
    }

    private static void assertEquals(String message, Object expected, Object actual) {
        KDAssert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    public static void checkRevCfmExists(long billId, boolean expected) {
        boolean result = QueryServiceHelper.exists((String)"ar_revcfmbill", (Object)billId);
        RevCfmBillTestChecker.assertEquals("\u672a\u627e\u5230\u6536\u5165\u786e\u8ba4\u5355", expected, result);
    }

    public static void checkAutoRevCfmExists(long finBillId, boolean expected) {
        Map<String, HashSet<Long>> result = BOTPHelper.findTargetBills("ar_finarbill", finBillId);
        boolean exist = false;
        if (!EmptyUtils.isEmpty(result)) {
            exist = EmptyUtils.isNotEmpty(result.get("ar_revcfmbill"));
        }
        RevCfmBillTestChecker.assertEquals("\u672a\u81ea\u52a8\u751f\u6210\u6536\u5165\u786e\u8ba4\u5355", expected, exist);
    }

    public static void validateDetailEntryAmt(DynamicObject detailEntryRow, BigDecimal disCountAmt, BigDecimal unitPrice, BigDecimal taxUnitPrice, BigDecimal amount, BigDecimal localAmount, BigDecimal confirmAmt) {
        BigDecimal rowDisCountAmt = detailEntryRow.getBigDecimal("e_discountamount");
        RevCfmBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u6298\u6263\u989d\u6821\u9a8c\u5931\u8d25", 0, disCountAmt.compareTo(rowDisCountAmt));
        BigDecimal rowUnitPrice = detailEntryRow.getBigDecimal("e_actunitprice");
        RevCfmBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u5b9e\u9645\u5355\u4ef7\u6821\u9a8c\u5931\u8d25", 0, unitPrice.compareTo(rowUnitPrice));
        BigDecimal rowUnitTaxPrice = detailEntryRow.getBigDecimal("e_acttaxunitprice");
        RevCfmBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u5b9e\u9645\u542b\u7a0e\u5355\u4ef7\u6821\u9a8c\u5931\u8d25", 0, taxUnitPrice.compareTo(rowUnitTaxPrice));
        BigDecimal rowAmount = detailEntryRow.getBigDecimal("e_amount");
        RevCfmBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u91d1\u989d\u6821\u9a8c\u5931\u8d25", 0, amount.compareTo(rowAmount));
        BigDecimal rowLocalAmount = detailEntryRow.getBigDecimal("e_localamt");
        RevCfmBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u91d1\u989d\u6298\u672c\u5e01\u6821\u9a8c\u5931\u8d25", 0, localAmount.compareTo(rowLocalAmount));
        BigDecimal rowConfirmAmt = detailEntryRow.getBigDecimal("e_confirmamt");
        RevCfmBillTestChecker.assertEquals("\u660e\u7ec6\u884c\u786e\u8ba4\u91d1\u989d\u6821\u9a8c\u5931\u8d25", 0, confirmAmt.compareTo(rowConfirmAmt));
    }

    public static void validateHeadAmt(DynamicObject revCfmBill, BigDecimal amount, BigDecimal localAmount, BigDecimal confirmAmount, BigDecimal confirmLocalAmount, BigDecimal unVerifyAmount) {
        BigDecimal headAmount = revCfmBill.getBigDecimal("amount");
        RevCfmBillTestChecker.assertEquals("\u8868\u5934\u603b\u91d1\u989d\u6821\u9a8c\u5931\u8d25", 0, amount.compareTo(headAmount));
        BigDecimal headLocalAmount = revCfmBill.getBigDecimal("localamt");
        RevCfmBillTestChecker.assertEquals("\u8868\u5934\u603b\u91d1\u989d\u6298\u672c\u5e01\u6821\u9a8c\u5931\u8d25", 0, localAmount.compareTo(headLocalAmount));
        BigDecimal headConfirmAmount = revCfmBill.getBigDecimal("confirmamt");
        RevCfmBillTestChecker.assertEquals("\u8868\u5934\u786e\u8ba4\u91d1\u989d\u6821\u9a8c\u5931\u8d25", 0, confirmAmount.compareTo(headConfirmAmount));
        BigDecimal headConfirmLocalAmount = revCfmBill.getBigDecimal("confirmlocamt");
        RevCfmBillTestChecker.assertEquals("\u8868\u5934\u786e\u8ba4\u91d1\u989d\u6298\u672c\u5e01\u6821\u9a8c\u5931\u8d25", 0, confirmLocalAmount.compareTo(headConfirmLocalAmount));
        BigDecimal headUnVerifyAmount = revCfmBill.getBigDecimal("unverifyamt");
        RevCfmBillTestChecker.assertEquals("\u8868\u5934\u672a\u6838\u9500\u91d1\u989d\u6821\u9a8c\u5931\u8d25", 0, unVerifyAmount.compareTo(headUnVerifyAmount));
    }

    public static void validateVerifyRecord(long mainBillId, long asstBillId) {
        DynamicObjectCollection verifyRecords = QueryServiceHelper.query((String)"ar_verifyrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)mainBillId), new QFilter("entry.e_billid", "=", (Object)asstBillId)});
        KDAssert.assertEquals((String)"\u672a\u751f\u6210\u5bf9\u5e94\u6838\u9500\u8bb0\u5f55", (boolean)true, (verifyRecords.size() != 0 ? 1 : 0) != 0);
    }

    public static void entryCheckByArRevVerify(DynamicObject revCfmBill, BigDecimal e_recqty, BigDecimal e_unrecqty, BigDecimal e_recbaseqty, BigDecimal e_unrecbaseqty, BigDecimal e_recamt, BigDecimal e_unrecamt, int rowIndex) {
        DynamicObject entry = (DynamicObject)revCfmBill.getDynamicObjectCollection("entry").get(rowIndex);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + revCfmBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5df2\u5e94\u6536\u6570\u91cf\u8ba1\u7b97\u9519\u8bef"), (int)e_recqty.compareTo(entry.getBigDecimal("e_recqty")), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + revCfmBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u672a\u5e94\u6536\u6570\u91cf\u8ba1\u7b97\u9519\u8bef"), (int)e_unrecqty.compareTo(entry.getBigDecimal("e_unrecqty")), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + revCfmBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5df2\u5e94\u6536\u57fa\u672c\u6570\u91cf\u8ba1\u7b97\u9519\u8bef"), (int)e_recbaseqty.compareTo(entry.getBigDecimal("e_recbaseqty")), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + revCfmBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u672a\u5e94\u6536\u57fa\u672c\u6570\u91cf\u8ba1\u7b97\u9519\u8bef"), (int)e_unrecbaseqty.compareTo(entry.getBigDecimal("e_unrecbaseqty")), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + revCfmBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u5df2\u5e94\u6536\u91d1\u989d\u8ba1\u7b97\u9519\u8bef"), (int)e_recamt.compareTo(entry.getBigDecimal("e_recamt")), (int)0);
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + revCfmBill.getString("billno") + "\u7b2c" + (rowIndex + 1) + "\u884c\u5206\u5f55\u672a\u5e94\u6536\u91d1\u989d\u8ba1\u7b97\u9519\u8bef"), (int)e_unrecamt.compareTo(entry.getBigDecimal("e_unrecamt")), (int)0);
    }
}

