/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.check;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.unittest.framework.KDAssert;

public class SaleOrderBillTestChecker {
    public static void checkJoinAndAdd(DynamicObject entryInfo, BigDecimal joinQty, BigDecimal addQty, BigDecimal addAmt) {
        SaleOrderBillTestChecker.checkArJoinQty(entryInfo, joinQty);
        SaleOrderBillTestChecker.checkAddQtyAndAmt(entryInfo, addQty, addAmt);
    }

    public static void checkArJoinQty(DynamicObject entryInfo, BigDecimal qty) {
        BigDecimal arjoinqty = entryInfo.getBigDecimal("arjoinqty");
        KDAssert.assertEquals((String)String.format("\u5df2\u5173\u8054\u5e94\u6536\u6570\u91cf\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", arjoinqty, qty), (boolean)true, (arjoinqty.compareTo(qty) == 0 ? 1 : 0) != 0);
        BigDecimal basearjoinqty = entryInfo.getBigDecimal("basearjoinqty");
        KDAssert.assertEquals((String)String.format("\u5df2\u5173\u8054\u5e94\u6536\u57fa\u672c\u6570\u91cf\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", basearjoinqty, qty), (boolean)true, (basearjoinqty.compareTo(qty) == 0 ? 1 : 0) != 0);
    }

    public static void checkAddQtyAndAmt(DynamicObject entryInfo, BigDecimal addQty, BigDecimal addAmt) {
        BigDecimal joinpriceqty = entryInfo.getBigDecimal("joinpriceqty");
        KDAssert.assertEquals((String)String.format("\u7d2f\u8ba1\u5e94\u6536\u6570\u91cf\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", joinpriceqty, addQty), (boolean)true, (joinpriceqty.compareTo(addQty) == 0 ? 1 : 0) != 0);
        BigDecimal basearqty = entryInfo.getBigDecimal("basearqty");
        KDAssert.assertEquals((String)String.format("\u7d2f\u8ba1\u5e94\u6536\u57fa\u672c\u6570\u91cf\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", basearqty, addQty), (boolean)true, (basearqty.compareTo(addQty) == 0 ? 1 : 0) != 0);
        BigDecimal aramount = entryInfo.getBigDecimal("aramount");
        KDAssert.assertEquals((String)String.format("\u7d2f\u8ba1\u5e94\u6536\u91d1\u989d\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", aramount, addAmt), (boolean)true, (aramount.compareTo(addAmt) == 0 ? 1 : 0) != 0);
    }

    public static void checkConfirmQtyAndAmt(DynamicObject entryInfo, BigDecimal confirmQty, BigDecimal confirmBaseQty, BigDecimal confirmAmount) {
        BigDecimal actConfirmQty = entryInfo.getBigDecimal("confirmqty");
        KDAssert.assertEquals((String)String.format("\u7d2f\u8ba1\u786e\u8ba4\u6570\u91cf\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", actConfirmQty, confirmQty), (boolean)true, (actConfirmQty.compareTo(confirmQty) == 0 ? 1 : 0) != 0);
        BigDecimal actConfirmBaseQty = entryInfo.getBigDecimal("confirmbaseqty");
        KDAssert.assertEquals((String)String.format("\u7d2f\u8ba1\u786e\u8ba4\u57fa\u672c\u6570\u91cf\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", actConfirmBaseQty, confirmBaseQty), (boolean)true, (actConfirmBaseQty.compareTo(confirmBaseQty) == 0 ? 1 : 0) != 0);
        BigDecimal actConfirmAmt = entryInfo.getBigDecimal("confirmamount");
        KDAssert.assertEquals((String)String.format("\u7d2f\u8ba1\u786e\u8ba4\u91d1\u989d\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", actConfirmAmt, confirmAmount), (boolean)true, (actConfirmAmt.compareTo(confirmAmount) == 0 ? 1 : 0) != 0);
    }

    public static void checkHeadReceiptAmt(DynamicObject billInfo, BigDecimal addAmt) {
        BigDecimal receiptamount = billInfo.getBigDecimal("receiptamount");
        KDAssert.assertEquals((String)String.format("\u8868\u5934\u7d2f\u8ba1\u6536\u6b3e\u91d1\u989d\u4e0d\u6b63\u786e\u3002\u53d6\u503c[%s]\uff0c\u6bd4\u5bf9\u503c[%s]", receiptamount, addAmt), (boolean)true, (receiptamount.compareTo(addAmt) == 0 ? 1 : 0) != 0);
    }

    public static void validateHeadAddUpAmt(DynamicObject saleOrder, BigDecimal preReceivableAmt, BigDecimal receivableAmt) {
        BigDecimal headPreReceivableAmt = saleOrder.getBigDecimal("prereceiptamount");
        KDAssert.assertEquals((String)"\u8868\u5934\u7d2f\u8ba1\u9884\u6536\u6b3e\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", (int)0, (int)preReceivableAmt.compareTo(headPreReceivableAmt));
        BigDecimal headReceivableAmt = saleOrder.getBigDecimal("receiptamount");
        KDAssert.assertEquals((String)"\u8868\u5934\u7d2f\u8ba1\u6536\u6b3e\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", (int)0, (int)receivableAmt.compareTo(headReceivableAmt));
    }

    public static void validatePlanEntryAmt(DynamicObject planEntryRow, BigDecimal recAmount, BigDecimal relateReceiveAmt, BigDecimal actualRecAmt) {
        BigDecimal rowRecAmount = planEntryRow.getBigDecimal("r_recadvanceamount");
        KDAssert.assertEquals((String)"\u6536\u6b3e\u8ba1\u5212\u5e94\u6536\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", (int)0, (int)recAmount.compareTo(rowRecAmount));
        BigDecimal rowReceivableAmt = planEntryRow.getBigDecimal("r_remainamount");
        KDAssert.assertEquals((String)"\u6536\u6b3e\u8ba1\u5212\u5173\u8054\u6536\u6b3e\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", (int)0, (int)relateReceiveAmt.compareTo(rowReceivableAmt));
        BigDecimal rowActualRecAmt = planEntryRow.getBigDecimal("r_recamount");
        KDAssert.assertEquals((String)"\u8868\u5934\u7d2f\u8ba1\u6536\u6b3e\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", (int)0, (int)actualRecAmt.compareTo(rowActualRecAmt));
    }

    public static void checkAmt(Long salBillId_1, BigDecimal amt1, BigDecimal amt2, BigDecimal amt3, BigDecimal amt4, BigDecimal amt5, BigDecimal amt6) {
        DynamicObject salBillInfo_1 = BusinessDataServiceHelper.loadSingle((Object)salBillId_1, (String)"sm_salorder");
        DynamicObjectCollection billEntryCol_1 = salBillInfo_1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)billEntryCol_1.get(0), amt1, amt2, amt3);
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)billEntryCol_1.get(1), amt4, amt5, amt6);
    }
}

