/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.check;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import org.apache.commons.lang3.ObjectUtils;

public class VerifyRecordTestChecker {
    public static void verifyRecordCheck(DynamicObject mainBill, DynamicObject asstBill, boolean isAr) {
        long mainBillId = mainBill.getLong("id");
        long asstBillId = asstBill.getLong("id");
        String mainBillEntity = mainBill.getDynamicObjectType().getName();
        String asstBillEntity = asstBill.getDynamicObjectType().getName();
        String mainBillEntryEntity = VerifyRecordTestChecker.getBillEntryEntity(mainBillEntity);
        String asstBillEntryEntity = VerifyRecordTestChecker.getBillEntryEntity(asstBillEntity);
        String mainBillVerifyQtyEntity = VerifyRecordTestChecker.getBillVerifyQtyEntity(mainBillEntity);
        String mainBillVerifyBaseQtyEntity = VerifyRecordTestChecker.getBillVerifyBaseQtyEntity(mainBillEntity);
        String asstBillVerifyQtyEntity = VerifyRecordTestChecker.getBillVerifyQtyEntity(asstBillEntity);
        String asstBillVerifyBaseQtyEntity = VerifyRecordTestChecker.getBillVerifyBaseQtyEntity(asstBillEntity);
        String entity = isAr ? "ar_verifyrecord" : "ap_verifyrecord";
        DynamicObject[] verifyRecords = BusinessDataServiceHelper.load((String)entity, (String)VerifyRecordTestChecker.getVerifyRecordSelects(), (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)mainBillId), new QFilter("entry.e_billid", "=", (Object)asstBillId)});
        KDAssert.assertEquals((String)"\u672a\u751f\u6210\u6838\u9500\u8bb0\u5f55", (boolean)true, (!ObjectUtils.isEmpty((Object)verifyRecords) ? 1 : 0) != 0);
        KDAssert.assertEquals((String)"\u6838\u9500\u8bb0\u5f55\u751f\u6210\u4e0d\u6b63\u786e", (int)mainBill.getDynamicObjectCollection(mainBillEntryEntity).size(), (int)verifyRecords.length);
        HashMap<Long, BigDecimal> mainVerifyQtyMap = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> mainVerifyBaseQtyMap = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> asstVerifyQtyMap = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, BigDecimal> asstVerifyBaseQtyMap = new HashMap<Long, BigDecimal>(8);
        for (DynamicObject verifyRecord : verifyRecords) {
            long mainBillEntryId = verifyRecord.getLong("billentryid");
            BigDecimal mainVerifyQty = (BigDecimal)mainVerifyQtyMap.get(mainBillEntryId);
            mainVerifyQty = mainVerifyQty == null ? verifyRecord.getBigDecimal("verifyqty") : mainVerifyQty.add(verifyRecord.getBigDecimal("verifyqty"));
            mainVerifyQtyMap.put(mainBillEntryId, mainVerifyQty);
            BigDecimal mainVerifyBaseQty = (BigDecimal)mainVerifyBaseQtyMap.get(mainBillEntryId);
            mainVerifyBaseQty = mainVerifyBaseQty == null ? verifyRecord.getBigDecimal("verifybaseqty") : mainVerifyBaseQty.add(verifyRecord.getBigDecimal("verifybaseqty"));
            mainVerifyBaseQtyMap.put(mainBillEntryId, mainVerifyBaseQty);
            DynamicObjectCollection entry = verifyRecord.getDynamicObjectCollection("entry");
            long asstBillEntryId = ((DynamicObject)entry.get(0)).getLong("e_billentryid");
            BigDecimal asstVerifyQty = (BigDecimal)asstVerifyQtyMap.get(asstBillEntryId);
            asstVerifyQty = asstVerifyQty == null ? ((DynamicObject)entry.get(0)).getBigDecimal("e_verifyqty") : asstVerifyQty.add(((DynamicObject)entry.get(0)).getBigDecimal("e_verifyqty"));
            asstVerifyQtyMap.put(asstBillEntryId, asstVerifyQty);
            BigDecimal asstVerifyBaseQty = (BigDecimal)asstVerifyBaseQtyMap.get(asstBillEntryId);
            asstVerifyBaseQty = asstVerifyBaseQty == null ? ((DynamicObject)entry.get(0)).getBigDecimal("e_verifybaseqty") : asstVerifyBaseQty.add(((DynamicObject)entry.get(0)).getBigDecimal("e_verifybaseqty"));
            asstVerifyBaseQtyMap.put(asstBillEntryId, asstVerifyBaseQty);
        }
        DynamicObjectCollection mainBillRows = mainBill.getDynamicObjectCollection(mainBillEntryEntity);
        for (DynamicObject row : mainBillRows) {
            BigDecimal verifyQty = row.getBigDecimal(mainBillVerifyQtyEntity);
            BigDecimal mainBillVerifyQty = (BigDecimal)mainVerifyQtyMap.get(row.getLong("id"));
            if (mainBillVerifyQty == null) continue;
            KDAssert.assertEquals((String)("\u6838\u9500\u8bb0\u5f55\u4e3b\u65b9\u7684\u672c\u6b21\u6838\u9500\u6570\u91cf\uff1a" + mainBillVerifyQty + "\u4e0e\u5355\u636e\u5206\u5f55\u4e0a\u7684\u5df2\u6838\u9500\u6570\u91cf\uff1a" + verifyQty + "\u4e0d\u4e00\u81f4"), (int)0, (int)verifyQty.compareTo(mainBillVerifyQty));
            if (ObjectUtils.isEmpty((Object)mainBillVerifyBaseQtyEntity)) continue;
            BigDecimal verifyBaseQty = row.getBigDecimal(mainBillVerifyBaseQtyEntity);
            BigDecimal mainBillVerifyBaseQty = (BigDecimal)mainVerifyBaseQtyMap.get(row.getLong("id"));
            KDAssert.assertEquals((String)("\u6838\u9500\u8bb0\u5f55\u4e3b\u65b9\u7684\u672c\u6b21\u6838\u9500\u57fa\u672c\u6570\u91cf\uff1a" + mainBillVerifyBaseQty + "\u4e0e\u5355\u636e\u5206\u5f55\u4e0a\u7684\u5df2\u6838\u9500\u57fa\u672c\u6570\u91cf\uff1a" + verifyBaseQty + "\u4e0d\u4e00\u81f4"), (int)0, (int)verifyBaseQty.compareTo(mainBillVerifyBaseQty));
        }
        DynamicObjectCollection asstBillRows = asstBill.getDynamicObjectCollection(asstBillEntryEntity);
        for (DynamicObject row : asstBillRows) {
            BigDecimal verifyQty = row.getBigDecimal(asstBillVerifyQtyEntity);
            BigDecimal asstBillVerifyQty = (BigDecimal)asstVerifyQtyMap.get(row.getLong("id"));
            if (asstBillVerifyQty == null) continue;
            KDAssert.assertEquals((String)("\u6838\u9500\u8bb0\u5f55\u8f85\u65b9\u7684\u672c\u6b21\u6838\u9500\u6570\u91cf\uff1a" + asstBillVerifyQty + "\u4e0e\u5355\u636e\u5206\u5f55\u4e0a\u7684\u5df2\u6838\u9500\u6570\u91cf\uff1a" + verifyQty + "\u4e0d\u4e00\u81f4"), (int)0, (int)verifyQty.compareTo(asstBillVerifyQty));
            if (ObjectUtils.isEmpty((Object)asstBillVerifyBaseQtyEntity)) continue;
            BigDecimal verifyBaseQty = row.getBigDecimal(asstBillVerifyBaseQtyEntity);
            BigDecimal asstBillVerifyBaseQty = (BigDecimal)asstVerifyBaseQtyMap.get(row.getLong("id"));
            KDAssert.assertEquals((String)("\u6838\u9500\u8bb0\u5f55\u8f85\u65b9\u7684\u672c\u6b21\u6838\u9500\u57fa\u672c\u6570\u91cf\uff1a" + asstBillVerifyBaseQty + "\u4e0e\u5355\u636e\u5206\u5f55\u4e0a\u7684\u5df2\u6838\u9500\u57fa\u672c\u6570\u91cf\uff1a" + verifyBaseQty + "\u4e0d\u4e00\u81f4"), (int)0, (int)verifyBaseQty.compareTo(asstBillVerifyBaseQty));
        }
    }

    public static void verifyRecordCheck(long mainBillId, long mainBillEntryId, long asstBillId, long asstBillEntry, BigDecimal mainExpectVerifyQty, BigDecimal asstExpectVerifyQty, boolean isAr) {
        String entity = isAr ? "ar_verifyrecord" : "ap_verifyrecord";
        DynamicObject[] verifyRecords = BusinessDataServiceHelper.load((String)entity, (String)VerifyRecordTestChecker.getVerifyRecordSelects(), (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)mainBillId), new QFilter("billentryid", "=", (Object)mainBillEntryId), new QFilter("entry.e_billid", "=", (Object)asstBillId), new QFilter("entry.e_billentryid", "=", (Object)asstBillEntry)});
        DynamicObject verifyRecord = verifyRecords[0];
        KDAssert.assertEquals((String)"\u6838\u9500\u8bb0\u5f55\u4e3b\u65b9\u7684\u672c\u6b21\u6838\u9500\u6570\u91cf\u8ba1\u7b97\u9519\u8bef\u3002", (int)0, (int)mainExpectVerifyQty.compareTo(verifyRecord.getBigDecimal("verifyqty")));
        KDAssert.assertEquals((String)"\u6838\u9500\u8bb0\u5f55\u4e3b\u65b9\u7684\u672c\u6b21\u6838\u9500\u57fa\u672c\u6570\u91cf\u8ba1\u7b97\u9519\u8bef\u3002", (int)0, (int)mainExpectVerifyQty.compareTo(verifyRecord.getBigDecimal("verifybaseqty")));
        DynamicObject row = (DynamicObject)verifyRecord.getDynamicObjectCollection("entry").get(0);
        KDAssert.assertEquals((String)"\u6838\u9500\u8bb0\u5f55\u4e3b\u65b9\u7684\u672c\u6b21\u6838\u9500\u6570\u91cf\u8ba1\u7b97\u9519\u8bef\u3002", (int)0, (int)asstExpectVerifyQty.compareTo(row.getBigDecimal("e_verifyqty")));
        KDAssert.assertEquals((String)"\u6838\u9500\u8bb0\u5f55\u4e3b\u65b9\u7684\u672c\u6b21\u6838\u9500\u57fa\u672c\u6570\u91cf\u8ba1\u7b97\u9519\u8bef\u3002", (int)0, (int)asstExpectVerifyQty.compareTo(row.getBigDecimal("e_verifybaseqty")));
    }

    public static void redVerifyRecordCheck(long redMainBillId, long redAsstBillId, boolean isAr) {
        String entity = isAr ? "ar_verifyrecord" : "ap_verifyrecord";
        DynamicObject[] verifyRecords = BusinessDataServiceHelper.load((String)entity, (String)VerifyRecordTestChecker.getVerifyRecordSelects(), (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)redMainBillId), new QFilter("entry.e_billid", "=", (Object)redAsstBillId), new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.TRUE)});
        KDAssert.assertEquals((String)"\u51b2\u9500\u65f6\u672a\u53cd\u5199\u6838\u9500\u8bb0\u5f55\u7684\u88ab\u51b2\u9500\u6807\u8bc6", (boolean)true, (!ObjectUtils.isEmpty((Object)verifyRecords) ? 1 : 0) != 0);
        BigDecimal mainVerifyQty = BigDecimal.ZERO;
        BigDecimal mainVerifyBaseqty = BigDecimal.ZERO;
        BigDecimal asstVerifyQty = BigDecimal.ZERO;
        BigDecimal asstVerifyBaseqty = BigDecimal.ZERO;
        for (DynamicObject verifyRecord : verifyRecords) {
            mainVerifyQty = mainVerifyQty.add(verifyRecord.getBigDecimal("verifyqty"));
            mainVerifyBaseqty = mainVerifyBaseqty.add(verifyRecord.getBigDecimal("verifybaseqty"));
            DynamicObject row = (DynamicObject)verifyRecord.getDynamicObjectCollection("entry").get(0);
            asstVerifyQty = asstVerifyQty.add(row.getBigDecimal("e_verifyqty"));
            asstVerifyBaseqty = asstVerifyBaseqty.add(row.getBigDecimal("e_verifybaseqty"));
        }
        DynamicObject[] redVerifyRecords = BusinessDataServiceHelper.load((String)entity, (String)VerifyRecordTestChecker.getVerifyRecordSelects(), (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)redMainBillId), new QFilter("entry.e_billid", "=", (Object)redAsstBillId), new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.TRUE)});
        KDAssert.assertEquals((String)"\u51b2\u9500\u65f6\u672a\u751f\u6210\u7ea2\u5b57\u6838\u9500\u8bb0\u5f55", (boolean)true, (!ObjectUtils.isEmpty((Object)redVerifyRecords) ? 1 : 0) != 0);
        BigDecimal redMainVerifyQty = BigDecimal.ZERO;
        BigDecimal redMainVerifyBaseqty = BigDecimal.ZERO;
        BigDecimal redAsstVerifyQty = BigDecimal.ZERO;
        BigDecimal redAsstVerifyBaseqty = BigDecimal.ZERO;
        for (DynamicObject verifyRecord : redVerifyRecords) {
            redMainVerifyQty = redMainVerifyQty.add(verifyRecord.getBigDecimal("verifyqty"));
            redMainVerifyBaseqty = redMainVerifyBaseqty.add(verifyRecord.getBigDecimal("verifybaseqty"));
            DynamicObject row = (DynamicObject)verifyRecord.getDynamicObjectCollection("entry").get(0);
            redAsstVerifyQty = redAsstVerifyQty.add(row.getBigDecimal("e_verifyqty"));
            redAsstVerifyBaseqty = redAsstVerifyBaseqty.add(row.getBigDecimal("e_verifybaseqty"));
        }
        KDAssert.assertEquals((String)"\u751f\u6210\u7684\u7ea2\u5b57\u6838\u9500\u8bb0\u5f55\u7684\u4e3b\u65b9\u5df2\u6838\u9500\u6570\u91cf\u9519\u8bef", (int)0, (int)mainVerifyQty.add(redMainVerifyQty).compareTo(BigDecimal.ZERO));
        KDAssert.assertEquals((String)"\u751f\u6210\u7684\u7ea2\u5b57\u6838\u9500\u8bb0\u5f55\u7684\u4e3b\u65b9\u5df2\u6838\u9500\u57fa\u672c\u6570\u91cf\u9519\u8bef", (int)0, (int)mainVerifyBaseqty.add(redMainVerifyBaseqty).compareTo(BigDecimal.ZERO));
        KDAssert.assertEquals((String)"\u751f\u6210\u7684\u7ea2\u5b57\u6838\u9500\u8bb0\u5f55\u7684\u8f85\u65b9\u5df2\u6838\u9500\u6570\u91cf\u9519\u8bef", (int)0, (int)asstVerifyQty.add(redAsstVerifyQty).compareTo(BigDecimal.ZERO));
        KDAssert.assertEquals((String)"\u751f\u6210\u7684\u7ea2\u5b57\u6838\u9500\u8bb0\u5f55\u7684\u8f85\u65b9\u5df2\u6838\u9500\u57fa\u672c\u6570\u91cf\u9519\u8bef", (int)0, (int)asstVerifyBaseqty.add(redAsstVerifyBaseqty).compareTo(BigDecimal.ZERO));
    }

    private static String getVerifyRecordSelects() {
        return "org,billid,billno,billtype,billentryid,qty,measureunit,verifyqty,verifybaseqty,payableamount,verifyamount,verifytype,verifyrelation,e_billtype,e_qty,e_measureunit,e_verifyqty,e_verifybaseqty,e_payableamount,e_verifyamount,e_billid,e_billno,e_billentryid,currency,e_currency,e_verifytaxamount,verifytaxamount,e_writtenoffremark,e_iswrittenoff,e_hadwrittenoff";
    }

    private static String getBillEntryEntity(String billEntity) {
        if ("ap_finapbill".equals(billEntity)) {
            return "detailentry";
        }
        if ("ar_revcfmbill".equals(billEntity)) {
            return "entry";
        }
        return "billentry";
    }

    private static String getBillVerifyQtyEntity(String billEntity) {
        if ("ap_finapbill".equals(billEntity)) {
            return "verifyquantity";
        }
        if ("ar_revcfmbill".equals(billEntity)) {
            return "e_verifiedqty";
        }
        return "verifyqty";
    }

    private static String getBillVerifyBaseQtyEntity(String billEntity) {
        if ("ap_finapbill".equals(billEntity) || "ar_revcfmbill".equals(billEntity)) {
            return "";
        }
        return "verifybaseqty";
    }

    public static void checkVerifyRecordExists(long mainBillId, long asstBillId, boolean isAr, boolean expected) {
        QFilter filter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        if (mainBillId > 0L) {
            filter = new QFilter("billid", "=", (Object)mainBillId);
            filters.add(filter);
        }
        if (asstBillId > 0L) {
            filter = new QFilter("entry.e_billid", "=", (Object)asstBillId);
            filters.add(filter);
        }
        KDAssert.assertTrue((String)"\u4e3b\u8f85\u65b9\u5355\u636eID\u5168\u4e3aO", (filters.size() > 0 ? 1 : 0) != 0);
        String entityName = isAr ? "ar_verifyrecord" : "ap_verifyrecord";
        boolean result = QueryServiceHelper.exists((String)entityName, (QFilter[])filters.toArray(new QFilter[0]));
        if (expected) {
            KDAssert.assertTrue((String)"\u6838\u9500\u8bb0\u5f55\u662f\u5426\u5b58\u5728\u6821\u9a8c\u5f02\u5e38", (boolean)result);
        } else {
            KDAssert.assertFalse((String)"\u6838\u9500\u8bb0\u5f55\u662f\u5426\u5b58\u5728\u6821\u9a8c\u5f02\u5e38", (boolean)result);
        }
    }

    public static void checkVerifyRecord(boolean isMain, List<Long> mainBillIds, Long billId, Long billEntryId, BigDecimal expectVerifyQty, BigDecimal expectVerifyBaseQty, boolean expectExists, boolean isAr) {
        String entityName;
        String string = entityName = isAr ? "ar_verifyrecord" : "ap_verifyrecord";
        if (isMain) {
            QFilter filter = new QFilter("billid", "=", (Object)billId);
            filter.and(new QFilter("billentryid", "=", (Object)billEntryId));
            DynamicObject[] verifyRecords = BusinessDataServiceHelper.load((String)entityName, (String)"verifyqty, verifybaseqty", (QFilter[])new QFilter[]{filter});
            KDAssert.assertEquals((String)"\u6838\u9500\u8bb0\u5f55\u662f\u5426\u751f\u6210\u4e0d\u51c6\u786e", (boolean)expectExists, (verifyRecords.length > 0 ? 1 : 0) != 0);
            BigDecimal v_verifyqty = BigDecimal.ZERO;
            BigDecimal v_verifybaseqty = BigDecimal.ZERO;
            for (DynamicObject verifyRecord : verifyRecords) {
                v_verifyqty = v_verifyqty.add(verifyRecord.getBigDecimal("verifyqty"));
                v_verifybaseqty = v_verifybaseqty.add(verifyRecord.getBigDecimal("verifybaseqty"));
            }
            KDAssert.assertEquals((String)"\u4e3b\u65b9\u672c\u6b21\u6838\u9500\u6570\u91cf\u5408\u8ba1\u4e0e\u539f\u9500\u552e\u51fa\u5e93\u5355\u5206\u5f55\u5df2\u6838\u9500\u6570\u91cf\u4e0d\u4e00\u81f4", (boolean)false, (v_verifyqty.compareTo(expectVerifyQty) != 0 ? 1 : 0) != 0);
            KDAssert.assertEquals((String)"\u4e3b\u65b9\u672c\u6b21\u6838\u9500\u57fa\u672c\u6570\u91cf\u5408\u8ba1\u4e0e\u539f\u9500\u552e\u51fa\u5e93\u5355\u5206\u5f55\u5df2\u6838\u9500\u57fa\u672c\u6570\u91cf\u4e0d\u4e00\u81f4", (boolean)false, (v_verifybaseqty.compareTo(expectVerifyBaseQty) != 0 ? 1 : 0) != 0);
        } else {
            QFilter filter = new QFilter("billid", "in", mainBillIds);
            filter.and(new QFilter("entry.e_billid", "=", (Object)billId));
            filter.and(new QFilter("entry.e_billentryid", "=", (Object)billEntryId));
            DynamicObjectCollection verifyRecordCol = QueryServiceHelper.query((String)entityName, (String)"entry.e_verifyqty, entry.e_verifybaseqty", (QFilter[])new QFilter[]{filter});
            KDAssert.assertEquals((String)"\u6838\u9500\u8bb0\u5f55\u662f\u5426\u751f\u6210\u4e0d\u51c6\u786e", (boolean)expectExists, (verifyRecordCol.size() > 0 ? 1 : 0) != 0);
            BigDecimal v_verifyqty = BigDecimal.ZERO;
            BigDecimal v_verifybaseqty = BigDecimal.ZERO;
            for (DynamicObject verifyRecordInfo : verifyRecordCol) {
                v_verifyqty = v_verifyqty.add(verifyRecordInfo.getBigDecimal("entry.e_verifyqty"));
                v_verifybaseqty = v_verifybaseqty.add(verifyRecordInfo.getBigDecimal("entry.e_verifybaseqty"));
            }
            KDAssert.assertEquals((String)"\u8f85\u65b9\u672c\u6b21\u6838\u9500\u6570\u91cf\u5408\u8ba1\u4e0e\u539f\u9500\u552e\u51fa\u5e93\u5355\u5206\u5f55\u5df2\u6838\u9500\u6570\u91cf\u4e0d\u4e00\u81f4", (boolean)false, (v_verifyqty.compareTo(expectVerifyQty) != 0 ? 1 : 0) != 0);
            KDAssert.assertEquals((String)"\u8f85\u65b9\u672c\u6b21\u6838\u9500\u57fa\u672c\u6570\u91cf\u5408\u8ba1\u4e0e\u539f\u9500\u552e\u51fa\u5e93\u5355\u5206\u5f55\u5df2\u6838\u9500\u57fa\u672c\u6570\u91cf\u4e0d\u4e00\u81f4", (boolean)false, (v_verifybaseqty.compareTo(expectVerifyBaseQty) != 0 ? 1 : 0) != 0);
        }
    }
}

