/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.ApInvoiceBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.ApInvoiceBillDataVO;

public class ApInvoiceBillTestDataProvider {
    public static DynamicObject buildByHeadPriceTaxTotal(String billNo, BigDecimal priceTaxTotal) {
        ApInvoiceBillDataVO headVO = ApInvoiceBillDataVO.New().setBillNo(billNo).setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangeRate(BigDecimal.ONE);
        ApInvoiceBillDataDetailVO detail = ApInvoiceBillDataDetailVO.New();
        detail.setSeq(1).setPrice(priceTaxTotal).setQuantity(BigDecimal.ONE);
        return ApInvoiceBillTestDataProvider.buildByDetailAndHead(headVO, Collections.singletonList(detail));
    }

    public static DynamicObject buildByDetailAndHead(ApInvoiceBillDataVO billInfo, List<ApInvoiceBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"ap_invoice", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject invoice = ApInvoiceBillTestDataProvider.buildHeader(billInfo);
        DynamicObjectType dataEntityType = (DynamicObjectType)invoice.getDataEntityType();
        DynamicObjectType billEntryType = ((EntryProp)dataEntityType.getProperty("entry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection billEntries = invoice.getDynamicObjectCollection("entry");
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        for (ApInvoiceBillDataDetailVO entryInfo : entryInfoList) {
            BigDecimal price = entryInfo.getPrice();
            BigDecimal ePriceTaxTotal = price.multiply(entryInfo.getQuantity()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal eLocalAmount = ePriceTaxTotal.multiply(billInfo.getExchangeRate()).setScale(2, RoundingMode.HALF_UP);
            DynamicObject detail = new DynamicObject(billEntryType);
            detail.set("seq", (Object)entryInfo.getSeq());
            detail.set("material", (Object)BaseDataTestProvider.getMaterial());
            detail.set("measureunit", (Object)BaseDataTestProvider.getMaterial().getLong("baseunit.id"));
            detail.set("quantity", (Object)entryInfo.getQuantity());
            detail.set("price", (Object)entryInfo.getPrice());
            detail.set("e_amount", (Object)ePriceTaxTotal);
            detail.set("e_amountbase", (Object)eLocalAmount);
            detail.set("discountmode", (Object)"NULL");
            detail.set("e_pricetaxtotal", (Object)ePriceTaxTotal);
            detail.set("e_pricetaxtotalbase", (Object)eLocalAmount);
            detail.set("ispresent", (Object)Boolean.FALSE);
            detail.set("e_unrelatedamt", (Object)ePriceTaxTotal);
            detail.set("e_unmatchamt", (Object)ePriceTaxTotal);
            detail.set("e_unmatchqty", (Object)entryInfo.getQuantity());
            priceTaxTotal = priceTaxTotal.add(ePriceTaxTotal);
            priceTaxTotalBase = priceTaxTotalBase.add(eLocalAmount);
            billEntries.add((Object)detail);
        }
        invoice.set("pricetaxtotal", (Object)priceTaxTotal);
        invoice.set("pricetaxtotalbase", (Object)priceTaxTotalBase);
        invoice.set("amount", (Object)priceTaxTotal);
        invoice.set("amountbase", (Object)priceTaxTotalBase);
        invoice.set("unrelatedamt", (Object)priceTaxTotal);
        invoice.set("unmatchamt", (Object)priceTaxTotal);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
        return invoice;
    }

    private static DynamicObject buildHeader(ApInvoiceBillDataVO billInfo) {
        DynamicObject invoice = BusinessDataServiceHelper.newDynamicObject((String)"ap_invoice");
        String billNo = StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "AVT-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo();
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        invoice.set("org", (Object)org);
        invoice.set("payorg", (Object)org);
        invoice.set("billno", (Object)billNo);
        invoice.set("biztype", (Object)"PUR");
        invoice.set("issuedate", (Object)new Date());
        invoice.set("receivedate", (Object)new Date());
        invoice.set("invoicetype", (Object)"SP");
        invoice.set("invoicetypeview", (Object)"SP");
        invoice.set("billstatus", (Object)"C");
        invoice.set("buyer", (Object)org);
        invoice.set("asstacttype", (Object)"bd_supplier");
        invoice.set("receivablessupp", (Object)BaseDataTestProvider.getSupplier());
        invoice.set("asstact", (Object)BaseDataTestProvider.getSupplier());
        invoice.set("paymenttype", (Object)"CREDIT");
        invoice.set("currency", (Object)billInfo.getCurrency());
        invoice.set("basecurrency", (Object)BaseDataTestProvider.getCurrencyCNY());
        invoice.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        invoice.set("exratedate", (Object)new Date());
        invoice.set("exchangerate", (Object)billInfo.getExchangeRate());
        invoice.set("quotation", (Object)"0");
        return invoice;
    }

    public static DynamicObject createApInvoiceBill(String billNo, boolean isPlan, boolean isFirstCreat, boolean isDiffCurrency) {
        ApInvoiceBillDataVO headVO = ApInvoiceBillDataVO.New().setBillNo(billNo).setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangeRate(BigDecimal.ONE);
        if (isPlan) {
            headVO.setOrg(BaseDataTestProvider.getPlanInitOrg());
        }
        if (isDiffCurrency) {
            headVO.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id")).setExchangeRate(BigDecimal.valueOf(6.045));
        }
        List<ApInvoiceBillDataDetailVO> detailVOS = ApInvoiceBillTestDataProvider.structureApInvoiceDetailVO(isFirstCreat, false);
        return ApInvoiceBillTestDataProvider.buildByDetailAndHead(headVO, detailVOS);
    }

    public static DynamicObject createNegativeDataBill(String billno, boolean isPlan, boolean isDiffCurrency) {
        ApInvoiceBillDataVO headVO = ApInvoiceBillTestDataProvider.structureApInvoiceHeadVo(billno, isPlan, isDiffCurrency);
        List<ApInvoiceBillDataDetailVO> detailVOS = ApInvoiceBillTestDataProvider.structureApInvoiceDetailVO(false, true);
        return ApInvoiceBillTestDataProvider.buildByDetailAndHead(headVO, detailVOS);
    }

    public static ApInvoiceBillDataVO structureApInvoiceHeadVo(String billNo, boolean isPlanOrg, boolean isDiffCurrency) {
        ApInvoiceBillDataVO headVO = ApInvoiceBillDataVO.New();
        headVO.setOrg(BaseDataTestProvider.getDetailInitOrg()).setBillNo(billNo).setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangeRate(BigDecimal.ONE);
        if (isPlanOrg) {
            headVO.setOrg(BaseDataTestProvider.getPlanInitOrg());
        }
        if (isDiffCurrency) {
            headVO.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id")).setExchangeRate(BigDecimal.valueOf(6.045));
        }
        return headVO;
    }

    public static List<ApInvoiceBillDataDetailVO> structureApInvoiceDetailVO(boolean isFirstCreate, boolean isNegative) {
        ApInvoiceBillDataDetailVO detailVOOne = ApInvoiceBillDataDetailVO.New();
        ApInvoiceBillDataDetailVO detailVOTwo = ApInvoiceBillDataDetailVO.New();
        if (isNegative) {
            detailVOOne.setSeq(1).setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.ONE);
            detailVOTwo.setSeq(2).setPrice(BigDecimal.valueOf(40L)).setQuantity(BigDecimal.ONE.negate());
        } else if (isFirstCreate) {
            detailVOOne.setSeq(1).setPrice(BigDecimal.valueOf(70L)).setQuantity(BigDecimal.ONE);
            detailVOTwo.setSeq(2).setPrice(BigDecimal.valueOf(30L)).setQuantity(BigDecimal.ONE);
        } else {
            detailVOOne.setSeq(1).setPrice(BigDecimal.valueOf(60L)).setQuantity(BigDecimal.ONE);
            detailVOTwo.setSeq(2).setPrice(BigDecimal.valueOf(40L)).setQuantity(BigDecimal.ONE);
        }
        return Arrays.asList(detailVOOne, detailVOTwo);
    }
}

