/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.helper.ArApCommonTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.DynamicObjectUtils;
import kd.fi.arapcommon.util.DateUtils;

public class BaseDataPreparer {
    private static volatile boolean finished = false;
    private static final Lock lock = new ReentrantLock();
    private static final String unInitOrgNo = "UNITTESTORG-0001";
    private static final String detailInitOrgNo = "UNITTESTORG-0002";
    private static final String planInitOrgNo = "UNITTESTORG-0003";
    private static final String unInitOrgNo2 = "UNITTESTORG-0004";
    private static final String unInitOrgNo3 = "UNITTESTORG-0005";
    private static final String detailInitOrgNo2 = "UNITTESTORG-0006";
    private static final String planInitOrgNo2 = "UNITTESTORG-0007";
    private static final String intertemporalOrgNo = "UNITTESTORG-0008";
    private static final String adjExchOrgNo = "ADJEXCHORG-0001";
    private static final String adjExchOrg2No = "ADJEXCHORG-0002";
    private static final String badDebtOrgNo = "BADDEBTORG-0001";
    public static DynamicObject unInitOrg;
    public static DynamicObject unInitOrg2;
    public static DynamicObject unInitOrg3;
    public static DynamicObject detailInitOrg;
    public static DynamicObject detailInitOrg2;
    public static DynamicObject planInitOrg;
    public static DynamicObject planInitOrg2;
    public static DynamicObject adjExchOrg;
    public static DynamicObject adjExchOrg2;
    public static DynamicObject badDebtOrg;
    public static DynamicObject intertemporalOrg;
    public static DynamicObject bebank;
    public static DynamicObject customer;
    public static DynamicObject coordinationCustomer;
    public static DynamicObject supplier;
    public static DynamicObject coordinationSupplier;
    public static DynamicObject user;
    public static DynamicObject material;
    public static DynamicObject expenseItem;
    public static DynamicObject payProperty;
    public static DynamicObject payPropertyByAmtBenchmark;
    public static DynamicObject paymentType;
    public static DynamicObject currencyCNY;
    public static DynamicObject currencyUSD;
    public static DynamicObject extrateTable;
    public static DynamicObject taxRate;
    public static DynamicObject recProperty;
    public static DynamicObject recPropertyByAmtBenchmark;
    public static DynamicObject receivingType;
    public static DynamicObject period;
    public static DynamicObject policyType;
    public static DynamicObject measureUnits;
    public static DynamicObject periodType;

    public static void prepare() {
        if (finished) {
            return;
        }
        try {
            lock.lock();
            if (finished) {
                return;
            }
            BaseDataPreparer.preparePeriod();
            BaseDataPreparer.preparePolicyType();
            BaseDataPreparer.createCurrencyData();
            BaseDataPreparer.createMeasureUnits();
            BaseDataPreparer.prepareUnInitOrgData();
            BaseDataPreparer.prepareUnInitOrg2Data();
            BaseDataPreparer.prepareUnInitOrg3Data();
            BaseDataPreparer.prepareDetailInitOrgData();
            BaseDataPreparer.prepareDetailInitOrg2Data();
            BaseDataPreparer.preparePlanInitOrgData();
            BaseDataPreparer.preparePlanInitOrg2Data();
            BaseDataPreparer.prepareAdjExchOrg();
            BaseDataPreparer.prepareAdjExchOrg2();
            BaseDataPreparer.prepareBadDebtOrg();
            BaseDataPreparer.prepareIntertemporalOrg();
            BaseDataPreparer.prepareBank();
            BaseDataPreparer.prepareCustomer();
            BaseDataPreparer.prepareSupplier();
            BaseDataPreparer.prepareUser();
            BaseDataPreparer.prepareMaterial();
            BaseDataPreparer.prepareExpenseItem();
            BaseDataPreparer.preparePayProperty();
            BaseDataPreparer.preparePayPropertyByAmtBenchmark();
            BaseDataPreparer.preparePaymentType();
            BaseDataPreparer.prepareTaxRate();
            BaseDataPreparer.prepareRecProperty();
            BaseDataPreparer.prepareRecPropertyByAmtBenchmark();
            BaseDataPreparer.prepareReceivingType();
            BaseDataPreparer.prepareStdConfig();
            BaseDataPreparer.createImWareHouseData();
            BaseDataPreparer.createPurAndImMaterial();
            finished = true;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    private static void prepareUnInitOrgData() {
        BaseDataPreparer.prepareNeedOrg(unInitOrgNo, "\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u7ec4\u7ec7-\u672a\u521d\u59cb\u5316(\u5e94\u6536\u5e94\u4ed8\u4e13\u7528)", false, true);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)unInitOrgNo)};
        if (!QueryServiceHelper.exists((String)"bos_org", (QFilter[])filters)) {
            throw new KDBizException("\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002\u7ec4\u7ec7Number=UNITTESTORG-0001");
        }
        unInitOrg = ArApCommonTestHelper.loadSingle("bos_org", filters);
        BaseDataPreparer.checkOrgInitData(unInitOrg.getLong("id"), false);
    }

    private static void prepareUnInitOrg2Data() {
        BaseDataPreparer.prepareNeedOrg(unInitOrgNo2, "\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u7ec4\u7ec7-\u521d\u59cb\u5316\u4e13\u75281(\u5e94\u6536\u5e94\u4ed8\u4e13\u7528)", false, false);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)unInitOrgNo2)};
        if (!QueryServiceHelper.exists((String)"bos_org", (QFilter[])filters)) {
            throw new KDBizException("\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002\u7ec4\u7ec7Number=UNITTESTORG-0004");
        }
        unInitOrg2 = ArApCommonTestHelper.loadSingle("bos_org", filters);
    }

    private static void prepareUnInitOrg3Data() {
        BaseDataPreparer.prepareNeedOrg(unInitOrgNo3, "\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u7ec4\u7ec7-\u521d\u59cb\u5316\u4e13\u75282(\u5e94\u6536\u5e94\u4ed8\u4e13\u7528)", false, true);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)unInitOrgNo3)};
        if (!QueryServiceHelper.exists((String)"bos_org", (QFilter[])filters)) {
            throw new KDBizException("\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002\u7ec4\u7ec7Number=UNITTESTORG-0005");
        }
        unInitOrg3 = ArApCommonTestHelper.loadSingle("bos_org", filters);
    }

    private static void prepareDetailInitOrgData() {
        BaseDataPreparer.prepareNeedOrg(detailInitOrgNo, "\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u7ec4\u7ec7-\u521d\u59cb\u5316\uff08\u7269\u6599\u884c\uff09(\u5e94\u6536\u5e94\u4ed8\u4e13\u7528)", true, false);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)detailInitOrgNo)};
        if (!QueryServiceHelper.exists((String)"bos_org", (QFilter[])filters)) {
            throw new KDBizException("\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002\u7ec4\u7ec7Number=UNITTESTORG-0002");
        }
        detailInitOrg = ArApCommonTestHelper.loadSingle("bos_org", filters);
        BaseDataPreparer.checkOrgInitData(detailInitOrg.getLong("id"), true);
    }

    private static void prepareDetailInitOrg2Data() {
        BaseDataPreparer.prepareNeedOrg(detailInitOrgNo2, "\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u7ec4\u7ec7-\u5173\u8d26\u4e13\u75281(\u5e94\u6536\u5e94\u4ed8\u4e13\u7528)", true, false);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)detailInitOrgNo2)};
        if (!QueryServiceHelper.exists((String)"bos_org", (QFilter[])filters)) {
            throw new KDBizException("\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002\u7ec4\u7ec7Number=UNITTESTORG-0006");
        }
        detailInitOrg2 = ArApCommonTestHelper.loadSingle("bos_org", filters);
    }

    private static void preparePlanInitOrgData() {
        BaseDataPreparer.prepareNeedOrg(planInitOrgNo, "\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u7ec4\u7ec7-\u521d\u59cb\u5316\uff08\u8ba1\u5212\u884c\uff09(\u5e94\u6536\u5e94\u4ed8\u4e13\u7528)", true, true);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)planInitOrgNo)};
        if (!QueryServiceHelper.exists((String)"bos_org", (QFilter[])filters)) {
            throw new KDBizException("\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002\u7ec4\u7ec7Number=UNITTESTORG-0003");
        }
        planInitOrg = ArApCommonTestHelper.loadSingle("bos_org", filters);
        BaseDataPreparer.checkOrgInitData(planInitOrg.getLong("id"), true);
    }

    private static void preparePlanInitOrg2Data() {
        BaseDataPreparer.prepareNeedOrg(planInitOrgNo2, "\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u7ec4\u7ec7-\u5173\u8d26\u4e13\u75282(\u5e94\u6536\u5e94\u4ed8\u4e13\u7528)", true, true);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)planInitOrgNo2)};
        if (!QueryServiceHelper.exists((String)"bos_org", (QFilter[])filters)) {
            throw new KDBizException("\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002\u7ec4\u7ec7Number=UNITTESTORG-0007");
        }
        planInitOrg2 = ArApCommonTestHelper.loadSingle("bos_org", filters);
    }

    private static void prepareAdjExchOrg() {
        BaseDataPreparer.prepareNeedOrg(adjExchOrgNo, "\u5173\u8d26\u8c03\u6c47\u4e13\u7528\u7ec4\u7ec7-\u521d\u59cb\u5316", true, false);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)adjExchOrgNo)};
        if (!QueryServiceHelper.exists((String)"bos_org", (QFilter[])filters)) {
            throw new KDBizException("\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002\u7ec4\u7ec7Number=ADJEXCHORG-0001");
        }
        adjExchOrg = ArApCommonTestHelper.loadSingle("bos_org", filters);
        BaseDataPreparer.checkOrgInitData(adjExchOrg.getLong("id"), true);
    }

    private static void prepareAdjExchOrg2() {
        BaseDataPreparer.prepareNeedOrg(adjExchOrg2No, "\u8c03\u6c47\u4e13\u7528\u7ec4\u7ec72-\u521d\u59cb\u5316", true, false);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)adjExchOrg2No)};
        if (!QueryServiceHelper.exists((String)"bos_org", (QFilter[])filters)) {
            throw new KDBizException("\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002\u7ec4\u7ec7Number=ADJEXCHORG-0002");
        }
        adjExchOrg2 = ArApCommonTestHelper.loadSingle("bos_org", filters);
        BaseDataPreparer.checkOrgInitData(adjExchOrg2.getLong("id"), true);
    }

    private static void prepareBadDebtOrg() {
        BaseDataPreparer.prepareNeedOrg(badDebtOrgNo, "\u574f\u8d26\u8ba1\u63d0\u4e13\u7528\u7ec4\u7ec7", true, true);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)badDebtOrgNo)};
        if (!QueryServiceHelper.exists((String)"bos_org", (QFilter[])filters)) {
            throw new KDBizException("\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002\u7ec4\u7ec7Number=BADDEBTORG-0001");
        }
        badDebtOrg = ArApCommonTestHelper.loadSingle("bos_org", filters);
        BaseDataPreparer.checkOrgInitData(badDebtOrg.getLong("id"), true);
    }

    private static void prepareIntertemporalOrg() {
        BaseDataPreparer.prepareNeedOrg(intertemporalOrgNo, "\u5e94\u6536\u5e94\u4ed8\u8de8\u671f\u4e13\u7528\u7ec4\u7ec7-\u521d\u59cb\u5316\uff08\u5e94\u6536\u5e94\u4ed8\u4e13\u7528\uff09", true, true);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)intertemporalOrgNo)};
        if (!QueryServiceHelper.exists((String)"bos_org", (QFilter[])filters)) {
            throw new KDBizException("\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002\u7ec4\u7ec7Number=UNITTESTORG-0008");
        }
        intertemporalOrg = ArApCommonTestHelper.loadSingle("bos_org", filters);
        BaseDataPreparer.checkOrgInitData(intertemporalOrg.getLong("id"), true);
    }

    private static void prepareBank() {
        QFilter[] filters = new QFilter[]{new QFilter("name", "=", (Object)"\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u94f6\u884c")};
        if (!QueryServiceHelper.exists((String)"bd_bebank", (QFilter[])filters)) {
            DynamicObject bebank = BusinessDataServiceHelper.newDynamicObject((String)"bd_bebank");
            bebank.set("number", (Object)"bebank_arapunittest");
            bebank.set("name", (Object)"\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u94f6\u884c");
            bebank.set("country", (Object)1000001L);
            bebank.set("province", (Object)123L);
            bebank.set("provincetxt", (Object)"\u5317\u4eac\u5e02");
            bebank.set("city", (Object)124L);
            bebank.set("citytxt", (Object)"\u5317\u4eac");
            bebank.set("status", (Object)"C");
            bebank.set("enable", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bebank});
            DynamicObject temp = BusinessDataServiceHelper.loadSingle((String)"bd_bebank", (String)"id,masterid", (QFilter[])filters);
            temp.set("masterid", (Object)temp.getLong("id"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{temp});
        }
        bebank = ArApCommonTestHelper.loadSingle("bd_bebank", filters);
    }

    private static void prepareCustomer() {
        QFilter[] filters = new QFilter[]{new QFilter("internal_company", "=", (Object)0L), new QFilter("name", "=", (Object)"\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u4f9b\u5e94\u5546\u548c\u5ba2\u6237")};
        if (!QueryServiceHelper.exists((String)"bd_customer", (QFilter[])filters)) {
            BaseDataPreparer.createSupplierAndCustomer(planInitOrg, "\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u4f9b\u5e94\u5546\u548c\u5ba2\u6237", false);
        }
        customer = ArApCommonTestHelper.loadSingle("bd_customer", filters);
        filters = new QFilter[]{new QFilter("name", "=", (Object)"\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u5546\u52a1\u4f19\u4f34")};
        if (!QueryServiceHelper.exists((String)"bd_customer", (QFilter[])filters)) {
            BaseDataPreparer.createSupplierAndCustomer(planInitOrg, "\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u5546\u52a1\u4f19\u4f34", true);
        }
        coordinationCustomer = ArApCommonTestHelper.loadSingle("bd_customer", filters);
    }

    private static void prepareSupplier() {
        QFilter[] filters = new QFilter[]{new QFilter("internal_company", "=", (Object)0L), new QFilter("name", "=", (Object)"\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u4f9b\u5e94\u5546\u548c\u5ba2\u6237")};
        if (!QueryServiceHelper.exists((String)"bd_supplier", (QFilter[])filters)) {
            BaseDataPreparer.createSupplierAndCustomer(planInitOrg, "\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u4f9b\u5e94\u5546\u548c\u5ba2\u6237", false);
        }
        supplier = ArApCommonTestHelper.loadSingle("bd_supplier", filters);
        filters = new QFilter[]{new QFilter("name", "=", (Object)"\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u5546\u52a1\u4f19\u4f34")};
        if (!QueryServiceHelper.exists((String)"bd_supplier", (QFilter[])filters)) {
            BaseDataPreparer.createSupplierAndCustomer(planInitOrg, "\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u5546\u52a1\u4f19\u4f34", true);
        }
        coordinationSupplier = ArApCommonTestHelper.loadSingle("bd_supplier", filters);
    }

    private static void prepareMaterial() {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)"UNITTESTMATERIAL_001")};
        if (!QueryServiceHelper.exists((String)"bd_material", (QFilter[])filters)) {
            BaseDataPreparer.createMaterialData("UNITTESTMATERIAL_001", "\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u7269\u6599");
        }
        material = ArApCommonTestHelper.loadSingle("bd_material", filters);
    }

    private static void prepareUser() {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)"UNITTESTUSER_001")};
        if (!QueryServiceHelper.exists((String)"bos_user", (QFilter[])filters)) {
            BaseDataPreparer.createUserData("UNITTESTUSER_001", "\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u4eba\u5458");
        }
        user = ArApCommonTestHelper.loadSingle("bos_user", filters);
    }

    private static void prepareExpenseItem() {
        QFilter qFilter = new QFilter("number", "=", (Object)"UNITTESTEXPENSEITEM_001");
        if (!QueryServiceHelper.exists((String)"er_expenseitemedit", (QFilter[])new QFilter[]{qFilter})) {
            BaseDataPreparer.createExpenseItem("UNITTESTEXPENSEITEM_001", "\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u8d39\u7528\u9879\u76ee");
        }
        expenseItem = ArApCommonTestHelper.loadSingle("er_expenseitemedit", new QFilter[]{qFilter});
    }

    private static void preparePayProperty() {
        DynamicObject payProperty = BusinessDataServiceHelper.loadSingle((Object)503318221366006784L, (String)"ap_payproperty");
        if (payProperty == null) {
            throw new KDBizException("\u57fa\u7840\u8d44\u6599-\u5e94\u4ed8\u6b3e\u9879\u6027\u8d28\uff08\u6750\u6599\u91c7\u8d2d\uff09\u4e0d\u5b58\u5728");
        }
        BaseDataPreparer.payProperty = payProperty;
    }

    private static void preparePayPropertyByAmtBenchmark() {
        QFilter qFilter = new QFilter("isbasedonamt", "=", (Object)Boolean.TRUE);
        qFilter.and(new QFilter("number", "=", (Object)"UNITTESTAMTPROPERTY_001"));
        if (!QueryServiceHelper.exists((String)"ap_payproperty", (QFilter[])new QFilter[]{qFilter})) {
            BaseDataPreparer.createAmtPayProperty(false);
        }
        payPropertyByAmtBenchmark = ArApCommonTestHelper.loadSingle("ap_payproperty", new QFilter[]{qFilter});
    }

    private static void prepareRecProperty() {
        DynamicObject recProperty = BusinessDataServiceHelper.loadSingle((Object)503272215320499200L, (String)"ar_payproperty");
        if (recProperty == null) {
            throw new KDBizException("\u57fa\u7840\u8d44\u6599-\u5e94\u6536\u6b3e\u9879\u6027\u8d28\uff08\u4e00\u822c\u9500\u552e\uff09\u4e0d\u5b58\u5728");
        }
        BaseDataPreparer.recProperty = recProperty;
    }

    private static void prepareRecPropertyByAmtBenchmark() {
        QFilter qFilter = new QFilter("isbasedonamt", "=", (Object)Boolean.TRUE);
        qFilter.and(new QFilter("number", "=", (Object)"UNITTESTAMTPROPERTY_001"));
        if (!QueryServiceHelper.exists((String)"ar_payproperty", (QFilter[])new QFilter[]{qFilter})) {
            BaseDataPreparer.createAmtPayProperty(true);
        }
        recPropertyByAmtBenchmark = ArApCommonTestHelper.loadSingle("ar_payproperty", new QFilter[]{qFilter});
    }

    private static void preparePaymentType() {
        DynamicObject paymentType = BusinessDataServiceHelper.loadSingle((Object)180908615723421696L, (String)"cas_paymentbilltype");
        if (paymentType == null) {
            throw new KDBizException("\u57fa\u7840\u8d44\u6599-\u4ed8\u6b3e\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        BaseDataPreparer.paymentType = paymentType;
    }

    private static void preparePolicyType() {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)"1001")};
        if (!QueryServiceHelper.exists((String)"ar_policytype", (QFilter[])filters)) {
            throw new KDBizException("\u57fa\u7840\u8d44\u6599-\u653f\u7b56\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        policyType = ArApCommonTestHelper.loadSingle("ar_policytype", filters);
    }

    private static void prepareTaxRate() {
        DynamicObject taxRate = BusinessDataServiceHelper.loadSingle((Object)1L, (String)"bd_taxrate");
        if (taxRate == null) {
            throw new KDBizException("\u57fa\u7840\u8d44\u6599-\u7a0e\u7387\u4e0d\u5b58\u5728");
        }
        BaseDataPreparer.taxRate = taxRate;
    }

    private static void prepareReceivingType() {
        DynamicObject receivingType = BusinessDataServiceHelper.loadSingle((Object)180951994582732800L, (String)"cas_receivingbilltype");
        if (receivingType == null) {
            throw new KDBizException("\u57fa\u7840\u8d44\u6599-\u6536\u6b3e\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        BaseDataPreparer.receivingType = receivingType;
    }

    private static void prepareStdConfig() {
        String deleteSql = "DELETE FROM t_ap_stdconfig WHERE FID = 1508599651601788928;";
        String insertSql = "INSERT INTO t_ap_stdconfig(FID,FVALUE,FKEY,FDESC) VALUES (1508599651601788928,'true','allowBotpUsettle','\u5141\u8bb8\u81ea\u52a8\u7ed3\u7b97\u7684\u7ed3\u7b97\u8bb0\u5f55\u901a\u8fc7\u7ed3\u7b97\u8bb0\u5f55\u5217\u8868\u53cd\u7ed3\u7b97');";
        DB.execute((DBRoute)DBRouteConst.AP, (String)deleteSql);
        DB.execute((DBRoute)DBRouteConst.AP, (String)insertSql);
    }

    private static void preparePeriod() {
        BaseDataPreparer.createPeriod();
        QFilter filter = new QFilter("periodtype.number", "=", (Object)"UNITTESTPERIODTYPE_001");
        int year = Calendar.getInstance().get(1);
        filter.and("number", "=", (Object)(year + "1"));
        period = ArApCommonTestHelper.loadSingle("bd_period", new QFilter[]{filter});
    }

    private static void checkOrgInitData(long orgId, boolean isFinished) {
        BaseDataPreparer.checkOrgInitData(orgId, isFinished, true);
        BaseDataPreparer.checkOrgInitData(orgId, isFinished, false);
    }

    private static void checkOrgInitData(long orgId, boolean isFinished, boolean isAr) {
        DynamicObject initData = QueryServiceHelper.queryOne((String)(isAr ? "ar_init" : "ap_init"), (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        if (initData == null) {
            throw new KDBizException("\u521d\u59cb\u5316\u6570\u636e\u9519\u8bef\uff0c\u76ee\u6807\u7ec4\u7ec7\u7684\u521d\u59cb\u5316\u6570\u636e\u4e3a\u7a7a\u3002\u7ec4\u7ec7ID=" + orgId);
        }
        DynamicObject currency = (initData = BusinessDataServiceHelper.loadSingle((Object)initData.getLong("id"), (String)(isAr ? "ar_init" : "ap_init"))).getDynamicObject("standardcurrency");
        if (currency == null) {
            throw new KDBizException("\u521d\u59cb\u5316\u6570\u636e\u4e1a\u52a1\u4e3b\u5e01\u522b\u4e3a\u7a7a\u3002\u7ec4\u7ec7ID=" + orgId);
        }
        DynamicObject exrate = initData.getDynamicObject("exratetable");
        if (exrate == null) {
            throw new KDBizException("\u521d\u59cb\u5316\u6570\u636e\u6c47\u7387\u8868\u4e3a\u7a7a\u3002\u7ec4\u7ec7ID=" + orgId);
        }
        DynamicObject periodType = initData.getDynamicObject("periodtype");
        if (periodType == null) {
            throw new KDBizException("\u521d\u59cb\u5316\u6570\u636e\u671f\u95f4\u7c7b\u578b\u4e3a\u7a7a\u3002\u7ec4\u7ec7ID=" + orgId);
        }
        DynamicObject startPeriod = initData.getDynamicObject("startperiod");
        if (startPeriod == null) {
            throw new KDBizException("\u521d\u59cb\u5316\u6570\u636e\u542f\u7528\u671f\u95f4\u4e3a\u7a7a\u3002\u7ec4\u7ec7ID=" + orgId);
        }
        String settleModel = initData.getString("settlemodel");
        if (StringUtils.isEmpty((CharSequence)settleModel)) {
            throw new KDBizException("\u521d\u59cb\u5316\u6570\u636e\u7ed3\u7b97\u6a21\u578b\u4e3a\u7a7a\u3002\u7ec4\u7ec7ID=" + orgId);
        }
        Date startDate = initData.getDate("startdate");
        if (startDate == null) {
            throw new KDBizException("\u521d\u59cb\u5316\u6570\u636e\u542f\u7528\u65e5\u671f\u4e3a\u7a7a\u3002\u7ec4\u7ec7ID=" + orgId);
        }
        if (isFinished) {
            DynamicObject curPeriod = initData.getDynamicObject("curperiod");
            if (curPeriod == null) {
                throw new KDBizException("\u521d\u59cb\u5316\u6570\u636e\u5f53\u524d\u671f\u95f4\u4e3a\u7a7a\u3002\u7ec4\u7ec7ID=" + orgId);
            }
            Date currentDate = initData.getDate("currentdate");
            if (currentDate == null) {
                throw new KDBizException("\u521d\u59cb\u5316\u6570\u636e\u5f53\u524d\u65e5\u671f\u4e3a\u7a7a\u3002\u7ec4\u7ec7ID=" + orgId);
            }
            if (!initData.getBoolean("isfinishinit")) {
                throw new KDBizException("\u521d\u59cb\u5316\u6570\u636e\u521d\u59cb\u5316\u72b6\u6001\u4e3a\u672a\u521d\u59cb\u5316\u3002\u7ec4\u7ec7ID=" + orgId);
            }
        }
    }

    public static void setFinishedToFalse() {
        finished = false;
    }

    private static void prepareNeedOrg(String number, String name, boolean isFinishInit, boolean isPlan) {
        DynamicObject org;
        if (QueryServiceHelper.exists((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)})) {
            org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        } else {
            DynamicObject srcOrgId = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)"\u5355\u5143\u6d4b\u8bd5\u590d\u5236\u7ec4\u7ec7")});
            if (srcOrgId == null) {
                throw new KDBizException("\u8bf7\u5728\u5bf9\u5e94\u73af\u5883\u521b\u5efa\u7ec4\u7ec7\uff1a\u5355\u5143\u6d4b\u8bd5\u590d\u5236\u7ec4\u7ec7");
            }
            DynamicObject srcOrg = BusinessDataServiceHelper.loadSingle((Object)srcOrgId.getLong("id"), (String)"bos_org");
            org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
            HashSet<String> ignoreKeys = new HashSet<String>();
            ignoreKeys.add("number");
            ignoreKeys.add("name");
            ignoreKeys.add("simplename");
            ignoreKeys.add("id");
            ignoreKeys.add("masterid");
            DynamicObjectUtils.copy(srcOrg, org, ignoreKeys);
            org.set("number", (Object)number);
            org.set("name", (Object)name);
            DynamicObject parent = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)100000L)});
            org.set("parent", (Object)parent);
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"bos_org", (DynamicObject[])new DynamicObject[]{org}, (OperateOption)OperateOption.create());
            OperationHelper.assertResult(result);
            org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        }
        Date beginDate = period.getDate("begindate");
        long orgId = org.getLong("id");
        if (!QueryServiceHelper.exists((String)"ap_init", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)})) {
            DynamicObject apInit = BusinessDataServiceHelper.newDynamicObject((String)"ap_init");
            apInit.set("org", (Object)orgId);
            apInit.set("standardcurrency", (Object)currencyCNY);
            apInit.set("exratetable", (Object)extrateTable.getLong("id"));
            apInit.set("periodtype", (Object)periodType);
            apInit.set("billstatus", (Object)"C");
            apInit.set("startperiod", (Object)period.getLong("id"));
            apInit.set("startdate", (Object)beginDate);
            if (isFinishInit) {
                apInit.set("isfinishinit", (Object)Boolean.TRUE);
                apInit.set("currentdate", (Object)beginDate);
                apInit.set("curperiod", (Object)period.getLong("id"));
            }
            HashMap<String, Object> apArgs = new HashMap<String, Object>(2);
            if (isPlan) {
                apInit.set("settlemodel", (Object)"2");
                apArgs.put("ap_003", "2");
            } else {
                apInit.set("settlemodel", (Object)"1");
                apArgs.put("ap_003", "1");
            }
            SystemParameterHelper.setSystemParameter(false, orgId, apArgs);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{apInit});
        }
        if (!QueryServiceHelper.exists((String)"ar_init", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)})) {
            DynamicObject arInit = BusinessDataServiceHelper.newDynamicObject((String)"ar_init");
            arInit.set("org", (Object)orgId);
            arInit.set("policytype", (Object)policyType.getLong("id"));
            arInit.set("standardcurrency", (Object)currencyCNY);
            arInit.set("exratetable", (Object)extrateTable.getLong("id"));
            arInit.set("periodtype", (Object)periodType);
            arInit.set("startperiod", (Object)period.getLong("id"));
            arInit.set("baddebtpolicy", (Object)"allowance");
            arInit.set("billstatus", (Object)"C");
            arInit.set("startdate", (Object)beginDate);
            if (isFinishInit) {
                arInit.set("isfinishinit", (Object)Boolean.TRUE);
                arInit.set("currentdate", (Object)beginDate);
                arInit.set("curperiod", (Object)period.getLong("id"));
            }
            HashMap<String, Object> arArgs = new HashMap<String, Object>(2);
            if (isPlan) {
                arInit.set("settlemodel", (Object)"2");
                arArgs.put("ar_003", "2");
            } else {
                arInit.set("settlemodel", (Object)"1");
                arArgs.put("ar_003", "1");
            }
            SystemParameterHelper.setSystemParameter(true, orgId, arArgs);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{arInit});
        }
        if (!QueryServiceHelper.exists((String)"cas_cashmgtinit", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)})) {
            DynamicObject casInit = BusinessDataServiceHelper.newDynamicObject((String)"cas_cashmgtinit");
            casInit.set("org", (Object)orgId);
            casInit.set("startperiod", (Object)period.getLong("id"));
            casInit.set("currentperiod", (Object)period.getLong("id"));
            casInit.set("isfinishinit", (Object)Boolean.TRUE);
            casInit.set("standardcurrency", (Object)currencyCNY);
            casInit.set("exratetable", (Object)extrateTable.getLong("id"));
            casInit.set("periodtype", (Object)periodType);
            casInit.set("billstatus", (Object)"C");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{casInit});
        }
        if (!QueryServiceHelper.exists((String)"im_invstart", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)})) {
            DynamicObject invStart = BusinessDataServiceHelper.newDynamicObject((String)"im_invstart");
            DynamicObject warehouse = QueryServiceHelper.queryOne((String)"bd_warehouse", (String)"id", null);
            invStart.set("org", (Object)orgId);
            invStart.set("warehouse", (Object)warehouse.getLong("id"));
            invStart.set("initstatus", (Object)Character.valueOf('A'));
            invStart.set("startdate", (Object)DateUtils.parseDate("2008-08-08", "yyyy-MM-dd"));
            invStart.set("startstatus", (Object)Character.valueOf('B'));
            invStart.set("enable", (Object)Character.valueOf('1'));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invStart});
        }
    }

    private static void createSupplierAndCustomer(DynamicObject org, String name, boolean isCoor) {
        DeleteServiceHelper.delete((String)"bd_supplier", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)name)});
        DeleteServiceHelper.delete((String)"bd_customer", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)name)});
        DeleteServiceHelper.delete((String)"bd_bizpartner", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)name)});
        DynamicObject supplier = BusinessDataServiceHelper.newDynamicObject((String)"bd_supplier");
        supplier.set("number", (Object)(isCoor ? "supplier_coordination" : "supplier_arapunittest"));
        supplier.set("name", (Object)name);
        supplier.set("simplename", (Object)name);
        supplier.set("group", (Object)1L);
        supplier.set("bizfunction", (Object)",1,2,3,");
        supplier.set("type", (Object)"1");
        supplier.set("createorg", (Object)org.getLong("id"));
        if (isCoor) {
            supplier.set("internal_company", (Object)org.getLong("id"));
        }
        supplier.set("deliversupplierid", (Object)supplier.getLong("id"));
        supplier.set("invoicesupplierid", (Object)supplier.getLong("id"));
        supplier.set("receivingsupplierid", (Object)supplier.getLong("id"));
        DynamicObjectType dataEntityType = (DynamicObjectType)supplier.getDataEntityType();
        DynamicObjectType entryPropertyType = ((EntryProp)dataEntityType.getProperty("entry_bank")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection entries = supplier.getDynamicObjectCollection("entry_bank");
        DynamicObject entry = new DynamicObject(entryPropertyType);
        entries.add((Object)entry);
        entry.set("bankaccount", (Object)"1234554321");
        entry.set("accountname", (Object)"\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u94f6\u884c\u540d\u79f0");
        entry.set("bank", (Object)bebank.getLong("id"));
        entry.set("currency", (Object)currencyCNY.getLong("id"));
        supplier.set("status", (Object)"C");
        supplier.set("enable", (Object)"1");
        supplier.set("supplier_status", (Object)880835462149703680L);
        supplier.set("ctrlstrategy", (Object)"5");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supplier});
        QFilter filter = new QFilter("name", "=", (Object)name);
        DynamicObject temp = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{filter});
        temp.set("masterid", (Object)temp.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{temp});
        DynamicObject customer = BusinessDataServiceHelper.newDynamicObject((String)"bd_customer");
        customer.set("number", (Object)(isCoor ? "customer_coordination" : "customer_arapunittest"));
        customer.set("name", (Object)name);
        customer.set("simplename", (Object)name);
        customer.set("bizfunction", (Object)",1,2,3,");
        customer.set("type", (Object)"1");
        customer.set("createorg", (Object)org.getLong("id"));
        if (isCoor) {
            customer.set("internal_company", (Object)org.getLong("id"));
        }
        customer.set("group", (Object)1L);
        customer.set("delivercustomerid", (Object)customer.getLong("id"));
        customer.set("invoicecustomerid", (Object)customer.getLong("id"));
        customer.set("paymentcustomerid", (Object)customer.getLong("id"));
        DynamicObjectType customerDataEntityType = (DynamicObjectType)customer.getDataEntityType();
        DynamicObjectType customerPropertyType = ((EntryProp)customerDataEntityType.getProperty("entry_bank")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection customerEntries = customer.getDynamicObjectCollection("entry_bank");
        DynamicObject customerEntry = new DynamicObject(customerPropertyType);
        customerEntries.add((Object)customerEntry);
        customerEntry.set("bankaccount", (Object)"123456654321");
        customerEntry.set("accountname", (Object)"\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u94f6\u884c\u540d\u79f0");
        customerEntry.set("bank", (Object)bebank.getLong("id"));
        customerEntry.set("currency", (Object)currencyCNY.getLong("id"));
        customer.set("status", (Object)"C");
        customer.set("enable", (Object)"1");
        customer.set("customerstatus", (Object)1122390034075371520L);
        customer.set("ctrlstrategy", (Object)"5");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{customer});
        temp = BusinessDataServiceHelper.loadSingle((String)"bd_customer", (String)"id,masterid", (QFilter[])new QFilter[]{filter});
        temp.set("masterid", (Object)temp.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{temp});
        if (isCoor) {
            DynamicObject bizPartner = BusinessDataServiceHelper.newDynamicObject((String)"bd_bizpartner");
            bizPartner.set("number", (Object)"bizpartner_coordination");
            bizPartner.set("name", (Object)name);
            bizPartner.set("simplename", (Object)name);
            bizPartner.set("partnerrole", (Object)",1,2,");
            bizPartner.set("type", (Object)"1");
            bizPartner.set("internal_company", (Object)org.getLong("id"));
            bizPartner.set("iscustomer", (Object)Boolean.TRUE);
            bizPartner.set("issupplier", (Object)Boolean.TRUE);
            bizPartner.set("status", (Object)"C");
            bizPartner.set("enable", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizPartner});
            supplier = BusinessDataServiceHelper.loadSingle((Object)supplier.getLong("id"), (String)"bd_supplier");
            supplier.set("bizpartner", (Object)bizPartner.getLong("id"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supplier});
            customer = BusinessDataServiceHelper.loadSingle((Object)customer.getLong("id"), (String)"bd_customer");
            customer.set("bizpartner", (Object)bizPartner.getLong("id"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{customer});
        }
    }

    private static void createCurrencyData() {
        DynamicObject CNY = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"UNITTEST_CNY")});
        if (CNY == null) {
            CNY = BusinessDataServiceHelper.newDynamicObject((String)"bd_currency");
            CNY.set("number", (Object)"UNITTEST_CNY");
            CNY.set("name", (Object)"\u4eba\u6c11\u5e01\uff08\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\uff09");
            CNY.set("sign", (Object)Character.valueOf('\uffe5'));
            CNY.set("enable", (Object)Character.valueOf('1'));
            CNY.set("status", (Object)"C");
        } else {
            CNY = BusinessDataServiceHelper.loadSingle((Object)CNY.getLong("id"), (String)"bd_currency");
        }
        CNY.set("amtprecision", (Object)4);
        CNY.set("priceprecision", (Object)4);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{CNY});
        CNY.set("masterid", (Object)CNY.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{CNY});
        currencyCNY = CNY;
        DynamicObject USD = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"UNITTEST_USD")});
        if (USD == null) {
            USD = BusinessDataServiceHelper.newDynamicObject((String)"bd_currency");
            USD.set("number", (Object)"UNITTEST_USD");
            USD.set("name", (Object)"\u7f8e\u5143\uff08\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\uff09");
            USD.set("sign", (Object)Character.valueOf('$'));
            USD.set("enable", (Object)Character.valueOf('1'));
            USD.set("status", (Object)Character.valueOf('C'));
        } else {
            USD = BusinessDataServiceHelper.loadSingle((Object)USD.getLong("id"), (String)"bd_currency");
        }
        USD.set("amtprecision", (Object)2);
        USD.set("priceprecision", (Object)2);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{USD});
        USD.set("masterid", (Object)USD.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{USD});
        currencyUSD = USD;
        DynamicObject exRateTable = QueryServiceHelper.queryOne((String)"bd_exratetable", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"UNITTEST_RATETABLE")});
        if (exRateTable == null) {
            exRateTable = BusinessDataServiceHelper.newDynamicObject((String)"bd_exratetable");
            exRateTable.set("number", (Object)"UNITTEST_RATETABLE");
            exRateTable.set("name", (Object)"\u6c47\u7387\u8868\uff08\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\uff09");
            exRateTable.set("cur", (Object)CNY.getLong("id"));
            exRateTable.set("enable", (Object)Character.valueOf('1'));
            exRateTable.set("status", (Object)Character.valueOf('C'));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{exRateTable});
            exRateTable.set("masterid", (Object)exRateTable.getLong("id"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{exRateTable});
        }
        extrateTable = BusinessDataServiceHelper.loadSingle((Object)exRateTable.getLong("id"), (String)"bd_exratetable");
        QFilter filter = new QFilter("orgcur", "=", (Object)USD.getLong("id"));
        filter.and(new QFilter("cur", "=", (Object)CNY.getLong("id")));
        DynamicObject exRateTree = QueryServiceHelper.queryOne((String)"bd_exrate_tree", (String)"id", (QFilter[])new QFilter[]{filter});
        if (exRateTree == null) {
            exRateTree = BusinessDataServiceHelper.newDynamicObject((String)"bd_exrate_tree");
            exRateTree.set("orgcur", (Object)USD.getLong("id"));
            exRateTree.set("cur", (Object)CNY.getLong("id"));
            exRateTree.set("excval", (Object)BigDecimal.valueOf(6.3045));
            exRateTree.set("indirectexrate", (Object)BigDecimal.valueOf(0.1586));
            exRateTree.set("exctable", (Object)exRateTable.getLong("id"));
            exRateTree.set("effectdate", (Object)DateUtils.parseDate("2008-08-08", "yyyy-MM-dd"));
            exRateTree.set("exctype", (Object)Character.valueOf('2'));
            exRateTree.set("status", (Object)Character.valueOf('C'));
            exRateTree.set("enable", (Object)Character.valueOf('1'));
            exRateTree.set("convertmode", (Object)Character.valueOf('1'));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{exRateTree});
        }
    }

    private static void createImWareHouseData() {
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)detailInitOrgNo)});
        if (org != null) {
            DynamicObject wareHouse = QueryServiceHelper.queryOne((String)"bd_warehouse", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"UNITTEST_WAREHOUSE001")});
            if (wareHouse == null) {
                wareHouse = BusinessDataServiceHelper.newDynamicObject((String)"bd_warehouse");
                wareHouse.set("createorg", (Object)org.getLong("id"));
                wareHouse.set("number", (Object)"UNITTEST_WAREHOUSE001");
                wareHouse.set("name", (Object)"\u5355\u5143\u6d4b\u8bd5-\u521d\u59cb\u5316\u7269\u6599\u884c\u4ed3\u5e9301");
                wareHouse.set("ctrlstrategy", (Object)"5");
                wareHouse.set("enable", (Object)"1");
                wareHouse.set("status", (Object)"C");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{wareHouse});
            }
            wareHouse = BusinessDataServiceHelper.loadSingle((Object)wareHouse.getLong("id"), (String)"bd_warehouse");
            DynamicObject imWareHouse = QueryServiceHelper.queryOne((String)"im_warehousesetup", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)org.getLong("id")), new QFilter("warehouse", "=", (Object)wareHouse.getLong("id"))});
            if (imWareHouse == null) {
                imWareHouse = BusinessDataServiceHelper.newDynamicObject((String)"im_warehousesetup");
                imWareHouse.set("org", (Object)org.getLong("id"));
                imWareHouse.set("warehouse", (Object)wareHouse.getLong("id"));
                imWareHouse.set("initstatus", (Object)"B");
                imWareHouse.set("finishinitdate", (Object)new Date());
                imWareHouse.set("startdate", (Object)new Date());
                imWareHouse.set("startstatus", (Object)"B");
                imWareHouse.set("enable", (Object)"1");
                imWareHouse.set("isallowallneginv", (Object)Boolean.TRUE);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{imWareHouse});
            }
        }
    }

    private static void createMeasureUnits() {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)"UNITTESTUNITS_001")};
        if (!QueryServiceHelper.exists((String)"bd_measureunits", (QFilter[])filters)) {
            DynamicObject preMeasureUnits = ArApCommonTestHelper.loadSingle("bd_measureunits", null);
            CloneUtils cloneUtil = new CloneUtils(false, true);
            DynamicObject cloneMeasureUnits = (DynamicObject)cloneUtil.clone((IDataEntityBase)preMeasureUnits);
            cloneMeasureUnits.set("number", (Object)"UNITTESTUNITS_001");
            cloneMeasureUnits.set("name", (Object)"\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u8ba1\u91cf\u5355\u4f4d");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cloneMeasureUnits});
        }
        measureUnits = ArApCommonTestHelper.loadSingle("bd_measureunits", filters);
    }

    public static void createMaterialData(String number, String name) {
        CloneUtils cloneUtil = new CloneUtils(false, true);
        DynamicObject preMaterial = ArApCommonTestHelper.loadSingle("bd_material", new QFilter[]{new QFilter("configproperties", "!=", (Object)"2")});
        DynamicObject cloneMaterial = (DynamicObject)cloneUtil.clone((IDataEntityBase)preMaterial);
        cloneMaterial.set("createorg", (Object)detailInitOrg);
        cloneMaterial.set("number", (Object)number);
        cloneMaterial.set("name", (Object)name);
        cloneMaterial.set("status", (Object)Character.valueOf('A'));
        cloneMaterial.set("baseunit", (Object)measureUnits);
        cloneMaterial.set("modelnum", (Object)name);
        cloneMaterial.set("ctrlstrategy", (Object)"5");
        cloneMaterial.set("materialtype", (Object)"1");
        OperateOption option = OperateOption.create();
        OperationResult submit = OperationServiceHelper.executeOperate((String)"submit", (String)"bd_material", (DynamicObject[])new DynamicObject[]{cloneMaterial}, (OperateOption)option);
        OperationHelper.assertResult(submit);
        cloneMaterial = ArApCommonTestHelper.loadSingle("bd_material", new QFilter[]{new QFilter("number", "=", (Object)number)});
        OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"bd_material", (Object[])new Long[]{cloneMaterial.getLong("id")}, (OperateOption)option);
        OperationHelper.assertResult(audit);
    }

    public static void createUserData(String number, String name) {
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("name", (Object)name);
        user.set("number", (Object)number);
        user.set("username", (Object)name);
        user.set("phone", (Object)"17212341234");
        DynamicObjectCollection entryEntity = user.getDynamicObjectCollection("entryentity");
        DynamicObject addNew = entryEntity.addNew();
        addNew.set("dpt", (Object)detailInitOrg.getLong("id"));
        addNew.set("position", (Object)name);
        user.set("status", (Object)Character.valueOf('C'));
        user.set("enable", (Object)Character.valueOf('1'));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{user});
    }

    private static void createPeriod() {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)"UNITTESTPERIODTYPE_001")};
        DynamicObject tmpPeriodType = BusinessDataServiceHelper.loadSingle((String)"bd_period_type", (String)"number,name,generatetype,adjusttype,times,enable,status", (QFilter[])filters);
        if (tmpPeriodType == null) {
            tmpPeriodType = BusinessDataServiceHelper.newDynamicObject((String)"bd_period_type");
            tmpPeriodType.set("number", (Object)"UNITTESTPERIODTYPE_001");
            tmpPeriodType.set("name", (Object)"\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b");
            tmpPeriodType.set("generatetype", (Object)Character.valueOf('1'));
            tmpPeriodType.set("adjusttype", (Object)Character.valueOf('1'));
            tmpPeriodType.set("times", (Object)Character.valueOf('0'));
            tmpPeriodType.set("enable", (Object)Character.valueOf('1'));
            tmpPeriodType.set("status", (Object)Character.valueOf('C'));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tmpPeriodType});
        }
        periodType = ArApCommonTestHelper.loadSingle("bd_period_type", filters);
        int year = Calendar.getInstance().get(1);
        BaseDataPreparer.createPeriod(year - 1);
        BaseDataPreparer.createPeriod(year);
    }

    private static void createPeriod(int year) {
        QFilter[] filters1 = new QFilter[]{new QFilter("number", "=", (Object)("UNITTESTPERIODTREE_" + year))};
        DynamicObject periodTree = BusinessDataServiceHelper.loadSingle((String)"bd_periodoutline_tree", (String)"number,name,group,generatetype,outlinebegindate,outlineenddate,adjusttype,period,periodoutlinequarter,periodyear,enable,status", (QFilter[])filters1);
        if (periodTree == null) {
            periodTree = BusinessDataServiceHelper.newDynamicObject((String)"bd_periodoutline_tree");
            periodTree.set("number", (Object)("UNITTESTPERIODTREE_" + year));
            periodTree.set("name", (Object)("\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u4f1a\u8ba1\u671f\u95f4\u6811" + year));
            periodTree.set("group", (Object)periodType);
            periodTree.set("generatetype", (Object)Character.valueOf('1'));
            periodTree.set("outlinebegindate", (Object)DateUtils.parseDate(year + "-01-01", "yyyy-MM-dd"));
            periodTree.set("outlineenddate", (Object)DateUtils.parseDate(year + "-12-31", "yyyy-MM-dd"));
            periodTree.set("adjusttype", (Object)Character.valueOf('1'));
            periodTree.set("period", (Object)12);
            periodTree.set("periodoutlinequarter", (Object)4);
            periodTree.set("periodyear", (Object)year);
            periodTree.set("enable", (Object)Character.valueOf('1'));
            periodTree.set("status", (Object)Character.valueOf('C'));
        } else {
            periodTree.set("group", (Object)periodType);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{periodTree});
        periodTree = ArApCommonTestHelper.loadSingle("bd_periodoutline_tree", filters1);
        QFilter[] qFilters = new QFilter[]{new QFilter("periodoutline", "=", (Object)periodTree.getLong("id"))};
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])qFilters);
        Calendar calendar = Calendar.getInstance();
        if (periods.size() != 12) {
            ArrayList<DynamicObject> periodList = new ArrayList<DynamicObject>(12);
            DeleteServiceHelper.delete((String)"bd_period", (QFilter[])qFilters);
            for (int i = 0; i < 12; ++i) {
                String number = String.valueOf(year) + (i + 1);
                String name = "UNITTESTPERIOD" + number;
                DynamicObject createPeriod = BusinessDataServiceHelper.newDynamicObject((String)"bd_period");
                createPeriod.set("number", (Object)number);
                createPeriod.set("name", (Object)name);
                createPeriod.set("periodtype", (Object)periodType);
                createPeriod.set("periodyear", (Object)year);
                createPeriod.set("periodquarter", (Object)(i / 3 + 1));
                createPeriod.set("periodnumber", (Object)(i + 1));
                createPeriod.set("isadjustperiod", (Object)Boolean.FALSE);
                createPeriod.set("periodoutline", (Object)periodTree);
                calendar.set(1, year);
                calendar.set(2, i);
                int firstDay = calendar.getActualMinimum(5);
                calendar.set(5, firstDay);
                createPeriod.set("begindate", (Object)DateUtils.truncateDate(calendar.getTime()));
                int lastDay = calendar.getActualMaximum(5);
                calendar.set(5, lastDay);
                createPeriod.set("enddate", (Object)DateUtils.truncateDate(calendar.getTime()));
                periodList.add(createPeriod);
            }
            if (!periodList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])periodList.toArray(new DynamicObject[0]));
            }
        }
    }

    private static void createExpenseItem(String number, String name) {
        CloneUtils cloneUtil = new CloneUtils(false, true);
        QFilter qFilter = new QFilter("createorg", "=", (Object)100000L);
        qFilter.and(new QFilter("ctrlstrategy", "=", (Object)"5"));
        qFilter.and(new QFilter("isleaf", "=", (Object)Boolean.FALSE));
        DynamicObject expenseItem = ArApCommonTestHelper.loadSingle("er_expenseitemedit", new QFilter[]{qFilter});
        DynamicObject cloneExpenseItem = (DynamicObject)cloneUtil.clone((IDataEntityBase)expenseItem);
        cloneExpenseItem.set("number", (Object)number);
        cloneExpenseItem.set("name", (Object)name);
        cloneExpenseItem.set("fullname", (Object)name);
        cloneExpenseItem.set("isleaf", (Object)Boolean.TRUE);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cloneExpenseItem});
    }

    private static void createAmtPayProperty(boolean isAr) {
        DeleteServiceHelper.delete((String)(isAr ? "ar_payproperty" : "ap_payproperty"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"UNITTESTAMTPROPERTY_001")});
        DynamicObject payProperty = BusinessDataServiceHelper.newDynamicObject((String)(isAr ? "ar_payproperty" : "ap_payproperty"));
        payProperty.set("number", (Object)"UNITTESTAMTPROPERTY_001");
        payProperty.set("createorg", (Object)detailInitOrg);
        payProperty.set("org", (Object)detailInitOrg);
        payProperty.set("name", (Object)"\u91d1\u989d\u57fa\u51c6(\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u4e13\u7528)");
        payProperty.set("isbasedonamt", (Object)Boolean.TRUE);
        payProperty.set("description", (Object)"\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\u91d1\u989d\u57fa\u51c6\u6b3e\u9879\u6027\u8d28");
        payProperty.set("ctrlstrategy", (Object)"5");
        payProperty.set("status", (Object)"C");
        payProperty.set("enable", (Object)"1");
        payProperty.set("creator", (Object)user);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payProperty});
    }

    private static void createPurAndImMaterial() {
    }
}

