/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataVO;

public class CasRecBillTestDataProvider {
    public static DynamicObject buildByHeadPriceTaxTotal(BigDecimal amount) {
        return CasRecBillTestDataProvider.buildByHeadPriceTaxTotal("", amount);
    }

    public static DynamicObject buildByHeadPriceTaxTotal(String billNo, BigDecimal amount) {
        CasRecBillDataVO billInfo = CasRecBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setPricetaxTotal(amount).setBillNo(billNo);
        ArrayList<CasRecBillDataDetailVO> entryInfoList = new ArrayList<CasRecBillDataDetailVO>(1);
        entryInfoList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(amount));
        return CasRecBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, entryInfoList);
    }

    public static DynamicObject buildByEntryPriceTaxTotal(List<CasRecBillDataDetailVO> entryInfoList) {
        return CasRecBillTestDataProvider.buildByEntryPriceTaxTotal("", entryInfoList);
    }

    public static DynamicObject buildByEntryPriceTaxTotal(String billNo, DynamicObject org, List<CasRecBillDataDetailVO> entryInfoList) {
        CasRecBillDataVO billInfo = CasRecBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo).setOrg(org);
        return CasRecBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, entryInfoList);
    }

    public static DynamicObject buildByEntryPriceTaxTotal(String billNo, List<CasRecBillDataDetailVO> entryInfoList) {
        CasRecBillDataVO billInfo = CasRecBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo);
        return CasRecBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, entryInfoList);
    }

    public static DynamicObject buildByEntryPriceTaxTotal(CasRecBillDataVO billInfo, List<CasRecBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"cas_recbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject casBill = BusinessDataServiceHelper.newDynamicObject((String)"cas_recbill");
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        casBill.set("openorg", (Object)org);
        casBill.set("org", (Object)org);
        casBill.set("billno", (Object)(StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "RV-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo()));
        casBill.set("bizdate", (Object)new Date());
        casBill.set("currency", (Object)billInfo.getCurrency());
        casBill.set("basecurrency", (Object)BaseDataTestProvider.getCurrencyCNY());
        casBill.set("quotation", (Object)billInfo.getQuotation());
        casBill.set("exchangerate", (Object)billInfo.getExchangerate());
        casBill.set("payertype", (Object)"bd_customer");
        DynamicObject customer = billInfo.getAsstact() != null ? billInfo.getAsstact() : BaseDataTestProvider.getCustomer();
        casBill.set("customerf7", (Object)customer);
        casBill.set("payer", (Object)customer.getLong("id"));
        casBill.set("payerformid", (Object)"bd_customer");
        casBill.set("itempayertype", (Object)"bd_customer");
        casBill.set("payeraccformid", (Object)"other");
        casBill.set("payername", (Object)customer.getString("name"));
        casBill.set("payeracctbanknum", (Object)"test123");
        casBill.set("payerbankname", (Object)"test123");
        casBill.set("billstatus", (Object)billInfo.getStatus());
        casBill.set("biztype", (Object)"SalesRec");
        casBill.set("matchflag", (Object)"0");
        casBill.set("receivingtype", (Object)BaseDataTestProvider.getReceivingType());
        DynamicObjectType dataEntityType = (DynamicObjectType)casBill.getDataEntityType();
        DynamicObjectType entrydt = ((EntryProp)dataEntityType.getProperty("entry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection entry = casBill.getDynamicObjectCollection("entry");
        BigDecimal pricetaxTotalHeader = BigDecimal.ZERO;
        for (CasRecBillDataDetailVO entryInfo : entryInfoList) {
            DynamicObject row = new DynamicObject(entrydt);
            BigDecimal amount = entryInfo.getPriceTaxTotal().setScale(2, RoundingMode.HALF_UP);
            BigDecimal localAmount = amount.multiply(billInfo.getExchangerate()).setScale(2, RoundingMode.HALF_UP);
            row.set("seq", (Object)entryInfo.getSeq());
            row.set("e_settleorg", (Object)org);
            row.set("e_receivingtype", (Object)BaseDataTestProvider.getReceivingType());
            row.set("e_material", (Object)BaseDataTestProvider.getMaterial());
            row.set("e_receivableamt", (Object)amount);
            row.set("e_receivablelocamt", (Object)localAmount);
            row.set("e_actamt", (Object)amount);
            row.set("e_localamt", (Object)localAmount);
            row.set("e_unlockamt", (Object)amount);
            row.set("e_unsettledamt", (Object)amount);
            row.set("e_unsettledlocalamt", (Object)localAmount);
            row.set("e_corebilltype", (Object)"pm_purorderbill");
            row.set("e_corebillno", (Object)entryInfo.getCorebillno());
            row.set("e_corebillentryseq", (Object)entryInfo.getCorebillentryseq());
            pricetaxTotalHeader = pricetaxTotalHeader.add(amount);
            entry.add((Object)row);
        }
        casBill.set("actrecamt", (Object)pricetaxTotalHeader);
        casBill.set("localamt", (Object)pricetaxTotalHeader);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{casBill});
        return BusinessDataServiceHelper.loadSingle((Object)casBill.getLong("id"), (String)"cas_recbill");
    }

    public static DynamicObject[] loadData(Long[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"cas_recbill").getDynamicObjectType());
    }

    public static DynamicObject loadSingle(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"cas_recbill");
    }

    public static DynamicObject createCasRecBillByReturnMoney(String billNo, BigDecimal amount, boolean isPlan, boolean isDiffCurrency) {
        CasRecBillDataVO billInfo = CasRecBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setPricetaxTotal(amount).setBillNo(billNo);
        if (isPlan) {
            billInfo.setOrg(BaseDataTestProvider.getPlanInitOrg());
        }
        if (isDiffCurrency) {
            billInfo.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id")).setExchangerate(BigDecimal.valueOf(6.045));
        }
        ArrayList<CasRecBillDataDetailVO> entryInfoList = new ArrayList<CasRecBillDataDetailVO>(1);
        entryInfoList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(amount));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, entryInfoList);
        recBill.set("payertype", (Object)"bd_customer");
        recBill.set("f7_payer", (Object)BaseDataTestProvider.getSupplier());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recBill});
        return recBill;
    }
}

