/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurOrderBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.PurOrderBillDataVO;

public class OmOrderBillTestDataProvider {
    public static DynamicObject createOmOrderBill(String billNo, boolean isPlan, boolean isFirstCreat, boolean isDiffCurrency) {
        return OmOrderBillTestDataProvider.createOmOrderBill(billNo, isPlan, isFirstCreat, isDiffCurrency, false);
    }

    public static DynamicObject createOmOrderBill(String billNo, boolean isPlan, boolean isFirstCreat, boolean isDiffCurrency, boolean isStorage) {
        PurOrderBillDataVO headVO = PurOrderBillDataVO.New().setBillNo(billNo).setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangeRate(BigDecimal.ONE);
        if (isPlan) {
            headVO.setOrg(BaseDataTestProvider.getPlanInitOrg());
        }
        if (isDiffCurrency) {
            headVO.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id")).setExchangeRate(BigDecimal.valueOf(6.045));
        }
        PurOrderBillDataDetailVO detailOneVO = new PurOrderBillDataDetailVO().setSeq(1).setQuantity(BigDecimal.ONE).setPrice(BigDecimal.valueOf(70L));
        PurOrderBillDataDetailVO detailTwoVO = new PurOrderBillDataDetailVO().setSeq(2).setQuantity(BigDecimal.ONE).setPrice(BigDecimal.valueOf(30L));
        if (isFirstCreat) {
            detailOneVO.setPrice(BigDecimal.valueOf(60L));
            detailTwoVO.setPrice(BigDecimal.valueOf(40L));
        }
        if (isStorage) {
            detailOneVO.setLineTypeId(1194150915045641216L);
            detailTwoVO.setLineTypeId(1194150915045641216L);
        }
        return OmOrderBillTestDataProvider.buildByDetailAndHead(headVO, Arrays.asList(detailOneVO, detailTwoVO));
    }

    public static DynamicObject buildByDetailAndHead(PurOrderBillDataVO billInfo, List<PurOrderBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"pm_om_purorderbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject omOrderBill = OmOrderBillTestDataProvider.buildHeader(billInfo);
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        DynamicObjectType dataEntityType = (DynamicObjectType)omOrderBill.getDataEntityType();
        DynamicObjectType billEntryType = ((EntryProp)dataEntityType.getProperty("billentry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection billEntries = omOrderBill.getDynamicObjectCollection("billentry");
        BigDecimal priceTaxTotalHeader = BigDecimal.ZERO;
        int localPrecision = 2;
        DynamicObject currency = omOrderBill.getDynamicObject("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            localPrecision = currency.getInt("amtprecision");
        }
        DynamicObject material = BaseDataTestProvider.getMaterial();
        for (PurOrderBillDataDetailVO entryInfo : entryInfoList) {
            BigDecimal price = entryInfo.getPrice();
            BigDecimal priceTaxTotal = price.multiply(entryInfo.getQuantity()).setScale(localPrecision, RoundingMode.HALF_UP);
            BigDecimal localAmount = priceTaxTotal.multiply(billInfo.getExchangeRate()).setScale(localPrecision, RoundingMode.HALF_UP);
            DynamicObject detailEntry = new DynamicObject(billEntryType);
            detailEntry.set("seq", (Object)entryInfo.getSeq());
            detailEntry.set("linetype", (Object)entryInfo.getLineTypeId());
            detailEntry.set("material", (Object)material.getLong("id"));
            detailEntry.set("unit", (Object)material.getDynamicObject("baseunit"));
            detailEntry.set("baseunit", (Object)material.getDynamicObject("baseunit"));
            detailEntry.set("qty", (Object)entryInfo.getQuantity());
            detailEntry.set("baseqty", (Object)entryInfo.getQuantity());
            detailEntry.set("receiveqtydown", (Object)entryInfo.getQuantity());
            detailEntry.set("receivebaseqtydown", (Object)entryInfo.getQuantity());
            detailEntry.set("receiveqtyup", (Object)entryInfo.getQuantity());
            detailEntry.set("receivebaseqtyup", (Object)entryInfo.getQuantity());
            detailEntry.set("price", (Object)price);
            detailEntry.set("priceandtax", (Object)price);
            detailEntry.set("discounttype", (Object)"NULL");
            detailEntry.set("amount", (Object)priceTaxTotal);
            detailEntry.set("curamount", (Object)localAmount);
            detailEntry.set("amountandtax", (Object)priceTaxTotal);
            detailEntry.set("curamountandtax", (Object)localAmount);
            detailEntry.set("entryreqorg", (Object)org);
            detailEntry.set("entryreqdept", (Object)org);
            detailEntry.set("entryrecorg", (Object)org);
            detailEntry.set("entryrecdept", (Object)org);
            detailEntry.set("entrysettleorg", (Object)org);
            detailEntry.set("entrysettledept", (Object)org);
            detailEntry.set("entrypayorg", (Object)org);
            detailEntry.set("deliverdate", (Object)new Date());
            billEntries.add((Object)detailEntry);
            priceTaxTotalHeader = priceTaxTotalHeader.add(priceTaxTotal);
        }
        DynamicObjectType payEntryType = ((EntryProp)dataEntityType.getProperty("purbillentry_pay")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection payEntries = omOrderBill.getDynamicObjectCollection("purbillentry_pay");
        DynamicObject payEntryOne = new DynamicObject(payEntryType);
        payEntryOne.set("seq", (Object)1);
        payEntryOne.set("payname", (Object)BaseDataTestProvider.getPayProperty());
        payEntryOne.set("paydate", (Object)new Date());
        payEntryOne.set("payrate", (Object)BigDecimal.valueOf(10L));
        payEntryOne.set("payamount", (Object)priceTaxTotalHeader.multiply(BigDecimal.valueOf(0.1)));
        payEntryOne.set("isprepay", (Object)Boolean.TRUE);
        payEntries.add((Object)payEntryOne);
        DynamicObject payEntryTwo = new DynamicObject(payEntryType);
        payEntryTwo.set("seq", (Object)2);
        payEntryTwo.set("payname", (Object)BaseDataTestProvider.getPayProperty());
        payEntryTwo.set("paydate", (Object)new Date());
        payEntryTwo.set("payrate", (Object)BigDecimal.valueOf(30L));
        payEntryTwo.set("payamount", (Object)priceTaxTotalHeader.multiply(BigDecimal.valueOf(0.3)));
        payEntryTwo.set("isprepay", (Object)Boolean.TRUE);
        payEntries.add((Object)payEntryTwo);
        omOrderBill.set("totalamount", (Object)priceTaxTotalHeader);
        omOrderBill.set("totalallamount", (Object)priceTaxTotalHeader);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{omOrderBill});
        return omOrderBill;
    }

    private static DynamicObject buildHeader(PurOrderBillDataVO billInfo) {
        DynamicObject omOrderBill = BusinessDataServiceHelper.newDynamicObject((String)"pm_om_purorderbill");
        String billNo = StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "om-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo();
        omOrderBill.set("billno", (Object)billNo);
        omOrderBill.set("billtype", (Object)970978758402036736L);
        omOrderBill.set("biztype", (Object)422857170485263360L);
        DynamicObject transactOut = OmOrderBillTestDataProvider.getTransactOut();
        omOrderBill.set("transouttypeid", (Object)transactOut.getString("name"));
        omOrderBill.set("transactiontype", (Object)transactOut.getLong("id"));
        omOrderBill.set("biztime", (Object)new Date());
        omOrderBill.set("billstatus", (Object)"C");
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        omOrderBill.set("org", (Object)org);
        omOrderBill.set("dept", (Object)org);
        omOrderBill.set("supplier", (Object)BaseDataTestProvider.getSupplier());
        omOrderBill.set("invoicesupplier", (Object)BaseDataTestProvider.getSupplier());
        omOrderBill.set("receivesupplier", (Object)BaseDataTestProvider.getSupplier());
        omOrderBill.set("currency", (Object)BaseDataTestProvider.getCurrencyCNY());
        omOrderBill.set("settlecurrency", (Object)billInfo.getCurrency());
        omOrderBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        omOrderBill.set("exratedate", (Object)new Date());
        omOrderBill.set("exchangerate", (Object)billInfo.getExchangeRate());
        omOrderBill.set("paymode", (Object)"CREDIT");
        omOrderBill.set("settletype", (Object)900001L);
        omOrderBill.set("changestatus", (Object)"A");
        omOrderBill.set("ispayrate", (Object)Boolean.TRUE);
        omOrderBill.set("closestatus", (Object)"A");
        return omOrderBill;
    }

    private static DynamicObject getTransactOut() {
        DynamicObject transactOut = QueryServiceHelper.queryOne((String)"mpdm_transactout", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("transactiontype.id", "=", (Object)422857170485263360L)});
        if (transactOut == null) {
            transactOut = BusinessDataServiceHelper.newDynamicObject((String)"mpdm_transactout");
            transactOut.set("createorg", (Object)100000L);
            transactOut.set("number", (Object)"UNITTESTTRANSACTOUT001");
            transactOut.set("name", (Object)"\u7b80\u5355\u59d4\u5916\u4e8b\u52a1\u7c7b\u578b\uff08\u5e94\u6536\u5e94\u4ed8\u5355\u5143\u6d4b\u8bd5\u4e13\u7528\uff09");
            transactOut.set("transactiontype", (Object)422857170485263360L);
            transactOut.set("status", (Object)Boolean.TRUE);
            transactOut.set("enable", (Object)Boolean.TRUE);
            transactOut.set("ctrlstrategy", (Object)"5");
            transactOut.set("feedtype", (Object)"A");
            transactOut.set("materialsource", (Object)"A");
            transactOut.set("deduction", (Object)"A");
            transactOut.set("backflushtime", (Object)"A");
            transactOut.set("warehouscontrol", (Object)"A");
            transactOut.set("warehousrang", (Object)"A");
            transactOut.set("controlscope", (Object)"A");
            transactOut.set("returncontrol", (Object)"A");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{transactOut});
        }
        return transactOut;
    }
}

