/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PaidBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.PaidBillDataVO;

public class PaidBillTestDataProvider {
    public static DynamicObject buildByHeadPriceTaxTotal(BigDecimal amount) {
        return PaidBillTestDataProvider.buildByHeadPriceTaxTotal("", amount);
    }

    public static DynamicObject buildByHeadPriceTaxTotal(String billNo, DynamicObject org, BigDecimal amount) {
        PaidBillDataVO billInfo = PaidBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setPricetaxTotal(amount).setBillNo(billNo).setOrg(org);
        ArrayList<PaidBillDataDetailVO> entryInfoList = new ArrayList<PaidBillDataDetailVO>(1);
        entryInfoList.add(PaidBillDataDetailVO.New().setPriceTaxTotal(amount));
        return PaidBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, entryInfoList);
    }

    public static DynamicObject buildByHeadPriceTaxTotal(String billNo, BigDecimal amount) {
        PaidBillDataVO billInfo = PaidBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setPricetaxTotal(amount).setBillNo(billNo);
        ArrayList<PaidBillDataDetailVO> entryInfoList = new ArrayList<PaidBillDataDetailVO>(1);
        entryInfoList.add(PaidBillDataDetailVO.New().setPriceTaxTotal(amount));
        return PaidBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, entryInfoList);
    }

    public static DynamicObject buildByEntryPriceTaxTotal(List<PaidBillDataDetailVO> entryInfoList) {
        return PaidBillTestDataProvider.buildByEntryPriceTaxTotal("", entryInfoList);
    }

    public static DynamicObject buildByEntryPriceTaxTotal(String billNo, List<PaidBillDataDetailVO> entryInfoList) {
        PaidBillDataVO billInfo = PaidBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo);
        return PaidBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, entryInfoList);
    }

    public static DynamicObject buildByEntryPriceTaxTotal(String billNo, DynamicObject org, List<PaidBillDataDetailVO> entryInfoList) {
        PaidBillDataVO billInfo = PaidBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo).setOrg(org);
        return PaidBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, entryInfoList);
    }

    public static DynamicObject buildByEntryPriceTaxTotal(PaidBillDataVO billInfo, List<PaidBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"ap_paidbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject payBill = BusinessDataServiceHelper.newDynamicObject((String)"ap_paidbill");
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        payBill.set("org", (Object)org);
        payBill.set("payorg", (Object)org);
        payBill.set("billno", (Object)(StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "PAID-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo()));
        payBill.set("bizdate", (Object)new Date());
        payBill.set("biztype", (Object)"10");
        payBill.set("currency", (Object)billInfo.getCurrency());
        payBill.set("basecurrency", (Object)BaseDataTestProvider.getCurrencyCNY());
        payBill.set("exchangerate", (Object)billInfo.getExchangerate());
        payBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        payBill.set("payeetype", (Object)"bd_supplier");
        payBill.set("payee", (Object)BaseDataTestProvider.getSupplier());
        payBill.set("payeename", (Object)BaseDataTestProvider.getSupplier().getString("name"));
        payBill.set("billstatus", (Object)"C");
        payBill.set("paymenttype", (Object)BaseDataTestProvider.getPaymentType());
        DynamicObjectType dataEntityType = (DynamicObjectType)payBill.getDataEntityType();
        DynamicObjectType entrydt = ((EntryProp)dataEntityType.getProperty("entry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection entry = payBill.getDynamicObjectCollection("entry");
        BigDecimal pricetaxTotalHeader = BigDecimal.ZERO;
        BigDecimal priceTaxTotalLocalHeader = BigDecimal.ZERO;
        for (PaidBillDataDetailVO entryInfo : entryInfoList) {
            DynamicObject row = new DynamicObject(entrydt);
            BigDecimal amount = entryInfo.getPriceTaxTotal().setScale(2, RoundingMode.HALF_UP);
            BigDecimal localAmount = amount.multiply(billInfo.getExchangerate()).setScale(2, RoundingMode.HALF_UP);
            row.set("seq", (Object)entryInfo.getSeq());
            row.set("e_material", (Object)BaseDataTestProvider.getMaterial());
            row.set("e_actamt", (Object)amount);
            row.set("e_localamt", (Object)localAmount);
            row.set("e_unlockamt", (Object)amount);
            row.set("e_unsettledamt", (Object)amount);
            row.set("e_corebilltype", (Object)entryInfo.getCorebilltype());
            row.set("e_corebillno", (Object)entryInfo.getCorebillno());
            row.set("e_corebillentryseq", (Object)entryInfo.getCorebillentryseq());
            pricetaxTotalHeader = pricetaxTotalHeader.add(amount);
            priceTaxTotalLocalHeader = priceTaxTotalLocalHeader.add(localAmount);
            entry.add((Object)row);
        }
        payBill.set("actpayamt", (Object)pricetaxTotalHeader);
        payBill.set("localamt", (Object)priceTaxTotalLocalHeader);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payBill});
        return payBill;
    }

    public static DynamicObject[] loadData(Long[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"ap_paidbill").getDynamicObjectType());
    }

    public static DynamicObject loadSingle(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"ap_paidbill");
    }
}

