/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurOrderBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.PurOrderBillDataVO;

public class PmAcceptBillTestDataProvider {
    public static DynamicObject createPmAcceptBill(String billNo, boolean isPlan, boolean isDiffCurrency) {
        PurOrderBillDataVO headVO = PurOrderBillDataVO.New().setBillNo(billNo).setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangeRate(BigDecimal.ONE);
        if (isPlan) {
            headVO.setOrg(BaseDataTestProvider.getPlanInitOrg());
        }
        if (isDiffCurrency) {
            headVO.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id")).setExchangeRate(BigDecimal.valueOf(6.045));
        }
        PurOrderBillDataDetailVO detailOneVO = new PurOrderBillDataDetailVO().setSeq(1).setQuantity(BigDecimal.ONE).setPrice(BigDecimal.valueOf(70L));
        PurOrderBillDataDetailVO detailTwoVO = new PurOrderBillDataDetailVO().setSeq(2).setQuantity(BigDecimal.ONE).setPrice(BigDecimal.valueOf(30L));
        return PmAcceptBillTestDataProvider.buildByDetailAndHead(headVO, Arrays.asList(detailOneVO, detailTwoVO));
    }

    public static DynamicObject buildByDetailAndHead(PurOrderBillDataVO billInfo, List<PurOrderBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"pm_puracceptbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject pmAcceptBill = PmAcceptBillTestDataProvider.buildHeader(billInfo);
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        DynamicObjectType dataEntityType = (DynamicObjectType)pmAcceptBill.getDataEntityType();
        DynamicObjectType billEntryType = ((EntryProp)dataEntityType.getProperty("billentry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection billEntries = pmAcceptBill.getDynamicObjectCollection("billentry");
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalAllAmount = BigDecimal.ZERO;
        int localPrecision = 2;
        DynamicObject currency = pmAcceptBill.getDynamicObject("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            localPrecision = currency.getInt("amtprecision");
        }
        QFilter qFilter = new QFilter("masterid.configproperties", "!=", (Object)"2");
        List allMaterialId = QueryServiceHelper.queryPrimaryKeys((String)"bd_materialpurchaseinfo", (QFilter[])new QFilter[]{qFilter}, (String)"id", (int)5000);
        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialinventoryinfo", (QFilter[])new QFilter[]{new QFilter("masterid.id", "in", (Object)allMaterialId)});
        for (PurOrderBillDataDetailVO entryInfo : entryInfoList) {
            BigDecimal price = entryInfo.getPrice();
            BigDecimal priceTaxTotal = price.multiply(entryInfo.getQuantity()).setScale(localPrecision, RoundingMode.HALF_UP);
            DynamicObject detailEntry = new DynamicObject(billEntryType);
            detailEntry.set("invoicesupplier", (Object)BaseDataTestProvider.getSupplier());
            detailEntry.set("seq", (Object)entryInfo.getSeq());
            detailEntry.set("linetype", (Object)entryInfo.getLineTypeId());
            detailEntry.set("material", (Object)material.getLong("id"));
            long unitId = material.getLong("masterid.baseunit.id");
            detailEntry.set("unit", (Object)unitId);
            detailEntry.set("baseunit", (Object)unitId);
            detailEntry.set("qty", (Object)entryInfo.getQuantity());
            detailEntry.set("baseqty", (Object)entryInfo.getQuantity());
            detailEntry.set("price", (Object)price);
            detailEntry.set("priceandtax", (Object)price);
            detailEntry.set("discounttype", (Object)"NULL");
            detailEntry.set("amount", (Object)priceTaxTotal);
            detailEntry.set("amountandtax", (Object)priceTaxTotal);
            detailEntry.set("entryreqorg", (Object)org);
            detailEntry.set("entrysettleorg", (Object)org);
            billEntries.add((Object)detailEntry);
            totalAmount = totalAmount.add(priceTaxTotal);
            totalAllAmount = totalAllAmount.add(priceTaxTotal);
        }
        pmAcceptBill.set("totalamount", (Object)totalAmount);
        pmAcceptBill.set("totalallamount", (Object)totalAllAmount);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pmAcceptBill});
        return pmAcceptBill;
    }

    private static DynamicObject buildHeader(PurOrderBillDataVO billInfo) {
        DynamicObject purOrderBill = BusinessDataServiceHelper.newDynamicObject((String)"pm_puracceptbill");
        String billNo = StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "pm-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo();
        purOrderBill.set("billno", (Object)billNo);
        purOrderBill.set("billtype", (Object)1220255824560014336L);
        purOrderBill.set("biztype", (Object)744833764588533760L);
        purOrderBill.set("biztime", (Object)new Date());
        purOrderBill.set("bookdate", (Object)new Date());
        purOrderBill.set("billstatus", (Object)"C");
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        purOrderBill.set("org", (Object)org);
        purOrderBill.set("recdept", (Object)org);
        purOrderBill.set("purorg", (Object)org);
        purOrderBill.set("purdept", (Object)org);
        purOrderBill.set("supplier", (Object)BaseDataTestProvider.getSupplier());
        purOrderBill.set("currency", (Object)BaseDataTestProvider.getCurrencyCNY());
        purOrderBill.set("settlecurrency", (Object)billInfo.getCurrency());
        purOrderBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        purOrderBill.set("exratedate", (Object)new Date());
        purOrderBill.set("exchangerate", (Object)billInfo.getExchangeRate());
        purOrderBill.set("paymode", (Object)"CREDIT");
        purOrderBill.set("settletype", (Object)900001L);
        return purOrderBill;
    }
}

