/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurOrderBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.PurOrderBillDataVO;

public class PurOrderBillTestDataProvider {
    public static DynamicObject createPurOrderBill(String billNo, boolean isPlan, boolean isFirstCreat, boolean isDiffCurrency) {
        return PurOrderBillTestDataProvider.createPurOrderBill(billNo, isPlan, isFirstCreat, isDiffCurrency, false);
    }

    public static DynamicObject createPurOrderBill(String billNo, boolean isPlan, boolean isFirstCreat, boolean isDiffCurrency, boolean isStorage) {
        PurOrderBillDataVO headVO = PurOrderBillDataVO.New().setBillNo(billNo).setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangeRate(BigDecimal.ONE);
        if (isPlan) {
            headVO.setOrg(BaseDataTestProvider.getPlanInitOrg());
        }
        if (isDiffCurrency) {
            headVO.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id")).setExchangeRate(BigDecimal.valueOf(6.045));
        }
        PurOrderBillDataDetailVO detailOneVO = new PurOrderBillDataDetailVO().setSeq(1).setQuantity(BigDecimal.ONE).setPrice(BigDecimal.valueOf(70L));
        PurOrderBillDataDetailVO detailTwoVO = new PurOrderBillDataDetailVO().setSeq(2).setQuantity(BigDecimal.ONE).setPrice(BigDecimal.valueOf(30L));
        if (isFirstCreat) {
            detailOneVO.setPrice(BigDecimal.valueOf(60L));
            detailTwoVO.setPrice(BigDecimal.valueOf(40L));
        }
        if (isStorage) {
            detailOneVO.setLineTypeId(1194150915045641216L);
            detailTwoVO.setLineTypeId(1194150915045641216L);
        }
        return PurOrderBillTestDataProvider.buildByDetailAndHead(headVO, Arrays.asList(detailOneVO, detailTwoVO));
    }

    public static DynamicObject buildByDetailAndHead(PurOrderBillDataVO billInfo, List<PurOrderBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"pm_purorderbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject purOrderBill = PurOrderBillTestDataProvider.buildHeader(billInfo);
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        DynamicObjectType dataEntityType = (DynamicObjectType)purOrderBill.getDataEntityType();
        DynamicObjectType billEntryType = ((EntryProp)dataEntityType.getProperty("billentry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection billEntries = purOrderBill.getDynamicObjectCollection("billentry");
        BigDecimal priceTaxTotalHeader = BigDecimal.ZERO;
        int localPrecision = 2;
        DynamicObject currency = purOrderBill.getDynamicObject("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            localPrecision = currency.getInt("amtprecision");
        }
        QFilter qFilter = new QFilter("masterid.configproperties", "!=", (Object)"2");
        qFilter.and(new QFilter("createorg", "=", (Object)100000L));
        qFilter.and(new QFilter("ctrlstrategy", "=", (Object)"5"));
        DynamicObjectCollection materialpurchaseinfos = QueryServiceHelper.query((String)"bd_materialpurchaseinfo", (String)"id,masterid.id", (QFilter[])new QFilter[]{qFilter}, (String)"id", (int)128);
        Set allMaterialId = materialpurchaseinfos.stream().map(info -> info.getLong("masterid.id")).collect(Collectors.toSet());
        KDAssert.assertEquals((String)"\u8bf7\u7ef4\u62a4\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\uff0c\u9700\u8981\u6839\u7ec4\u7ec7\u521b\u5efa\u7684\u975e\u914d\u7f6e\u4ef6\u7269\u6599\u3002", (boolean)true, (allMaterialId.size() > 0 ? 1 : 0) != 0);
        QFilter filter = new QFilter("masterid.id", "in", allMaterialId);
        filter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject materialinventoryinfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialinventoryinfo", (QFilter[])new QFilter[]{filter});
        KDAssert.assertEquals((String)"\u8bf7\u7ef4\u62a4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\uff0c\u9700\u8981\u6839\u7ec4\u7ec7\u521b\u5efa\u7684\u975e\u914d\u7f6e\u4ef6\u7269\u6599\u6709\u5bf9\u5e94\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u3002", (boolean)false, (boolean)ObjectUtils.isEmpty((Object)materialinventoryinfo));
        for (PurOrderBillDataDetailVO entryInfo : entryInfoList) {
            BigDecimal price = entryInfo.getPrice();
            BigDecimal priceTaxTotal = price.multiply(entryInfo.getQuantity()).setScale(localPrecision, RoundingMode.HALF_UP);
            BigDecimal localAmount = priceTaxTotal.multiply(billInfo.getExchangeRate()).setScale(localPrecision, RoundingMode.HALF_UP);
            DynamicObject detailEntry = new DynamicObject(billEntryType);
            detailEntry.set("seq", (Object)entryInfo.getSeq());
            detailEntry.set("linetype", (Object)entryInfo.getLineTypeId());
            detailEntry.set("expenseitem", (Object)BaseDataTestProvider.getExpenseItem());
            detailEntry.set("material", (Object)materialinventoryinfo.getLong("id"));
            long unitId = materialinventoryinfo.getLong("masterid.baseunit.id");
            detailEntry.set("unit", (Object)unitId);
            detailEntry.set("baseunit", (Object)unitId);
            detailEntry.set("qty", (Object)entryInfo.getQuantity());
            detailEntry.set("baseqty", (Object)entryInfo.getQuantity());
            detailEntry.set("receiveqtydown", (Object)entryInfo.getQuantity());
            detailEntry.set("receivebaseqtydown", (Object)entryInfo.getQuantity());
            detailEntry.set("receiveqtyup", (Object)entryInfo.getQuantity());
            detailEntry.set("receivebaseqtyup", (Object)entryInfo.getQuantity());
            detailEntry.set("price", (Object)price);
            detailEntry.set("priceandtax", (Object)price);
            detailEntry.set("discounttype", (Object)"NULL");
            detailEntry.set("amount", (Object)priceTaxTotal);
            detailEntry.set("curamount", (Object)localAmount);
            detailEntry.set("amountandtax", (Object)priceTaxTotal);
            detailEntry.set("curamountandtax", (Object)localAmount);
            detailEntry.set("entryreqorg", (Object)org);
            detailEntry.set("entryreqdept", (Object)org);
            detailEntry.set("entryrecorg", (Object)org);
            detailEntry.set("entryrecdept", (Object)org);
            detailEntry.set("entrysettleorg", (Object)org);
            detailEntry.set("entrysettledept", (Object)org);
            detailEntry.set("entrypayorg", (Object)org);
            detailEntry.set("deliverdate", (Object)new Date());
            billEntries.add((Object)detailEntry);
            priceTaxTotalHeader = priceTaxTotalHeader.add(priceTaxTotal);
        }
        DynamicObjectType payEntryType = ((EntryProp)dataEntityType.getProperty("purbillentry_pay")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection payEntries = purOrderBill.getDynamicObjectCollection("purbillentry_pay");
        DynamicObject payEntryOne = new DynamicObject(payEntryType);
        payEntryOne.set("seq", (Object)1);
        payEntryOne.set("payname", (Object)BaseDataTestProvider.getPayProperty());
        payEntryOne.set("paydate", (Object)new Date());
        payEntryOne.set("payrate", (Object)BigDecimal.valueOf(10L));
        payEntryOne.set("payamount", (Object)priceTaxTotalHeader.multiply(BigDecimal.valueOf(0.1)));
        payEntryOne.set("isprepay", (Object)Boolean.TRUE);
        payEntries.add((Object)payEntryOne);
        DynamicObject payEntryTwo = new DynamicObject(payEntryType);
        payEntryTwo.set("seq", (Object)2);
        payEntryTwo.set("payname", (Object)BaseDataTestProvider.getPayProperty());
        payEntryTwo.set("paydate", (Object)new Date());
        payEntryTwo.set("payrate", (Object)BigDecimal.valueOf(30L));
        payEntryTwo.set("payamount", (Object)priceTaxTotalHeader.multiply(BigDecimal.valueOf(0.3)));
        payEntryTwo.set("isprepay", (Object)Boolean.TRUE);
        payEntries.add((Object)payEntryTwo);
        purOrderBill.set("totalamount", (Object)priceTaxTotalHeader);
        purOrderBill.set("totalallamount", (Object)priceTaxTotalHeader);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{purOrderBill});
        return purOrderBill;
    }

    private static DynamicObject buildHeader(PurOrderBillDataVO billInfo) {
        DynamicObject purOrderBill = BusinessDataServiceHelper.newDynamicObject((String)"pm_purorderbill");
        String billNo = StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "pur-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo();
        purOrderBill.set("billno", (Object)billNo);
        purOrderBill.set("billtype", (Object)539008795674673152L);
        purOrderBill.set("biztype", (Object)422857170485263360L);
        purOrderBill.set("biztime", (Object)new Date());
        purOrderBill.set("billstatus", (Object)"C");
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        purOrderBill.set("org", (Object)org);
        purOrderBill.set("dept", (Object)org);
        purOrderBill.set("supplier", (Object)BaseDataTestProvider.getSupplier());
        purOrderBill.set("invoicesupplier", (Object)BaseDataTestProvider.getSupplier());
        purOrderBill.set("receivesupplier", (Object)BaseDataTestProvider.getSupplier());
        purOrderBill.set("currency", (Object)BaseDataTestProvider.getCurrencyCNY());
        purOrderBill.set("settlecurrency", (Object)billInfo.getCurrency());
        purOrderBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        purOrderBill.set("exratedate", (Object)new Date());
        purOrderBill.set("exchangerate", (Object)billInfo.getExchangeRate());
        purOrderBill.set("paymode", (Object)"CREDIT");
        purOrderBill.set("settletype", (Object)900001L);
        purOrderBill.set("changestatus", (Object)"A");
        purOrderBill.set("ispayrate", (Object)Boolean.TRUE);
        purOrderBill.set("closestatus", (Object)"A");
        return purOrderBill;
    }
}

