/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.ReceivedBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.ReceivedBillDataVO;

public class ReceivedBillTestDataProvider {
    public static DynamicObject buildByHeadPriceTaxTotal(BigDecimal amount) {
        return ReceivedBillTestDataProvider.buildByHeadPriceTaxTotal("", amount);
    }

    public static DynamicObject buildByHeadPriceTaxTotal(String billNo, BigDecimal amount) {
        ReceivedBillDataVO billInfo = ReceivedBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setPricetaxTotal(amount).setBillNo(billNo);
        ArrayList<ReceivedBillDataDetailVO> entryInfoList = new ArrayList<ReceivedBillDataDetailVO>(1);
        entryInfoList.add(ReceivedBillDataDetailVO.New().setPriceTaxTotal(amount));
        return ReceivedBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, entryInfoList);
    }

    public static DynamicObject buildByHeadPriceTaxTotal(String billNo, DynamicObject org, BigDecimal amount) {
        ReceivedBillDataVO billInfo = ReceivedBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setPricetaxTotal(amount).setBillNo(billNo).setOrg(org);
        ArrayList<ReceivedBillDataDetailVO> entryInfoList = new ArrayList<ReceivedBillDataDetailVO>(1);
        entryInfoList.add(ReceivedBillDataDetailVO.New().setPriceTaxTotal(amount));
        return ReceivedBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, entryInfoList);
    }

    public static DynamicObject buildByEntryPriceTaxTotal(List<ReceivedBillDataDetailVO> entryInfoList) {
        return ReceivedBillTestDataProvider.buildByEntryPriceTaxTotal("", entryInfoList);
    }

    public static DynamicObject buildByEntryPriceTaxTotal(String billNo, List<ReceivedBillDataDetailVO> entryInfoList) {
        ReceivedBillDataVO billInfo = ReceivedBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo);
        return ReceivedBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, entryInfoList);
    }

    public static DynamicObject buildByEntryPriceTaxTotal(String billNo, DynamicObject org, List<ReceivedBillDataDetailVO> entryInfoList) {
        ReceivedBillDataVO billInfo = ReceivedBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo).setOrg(org);
        return ReceivedBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, entryInfoList);
    }

    public static DynamicObject buildByEntryPriceTaxTotal(ReceivedBillDataVO billInfo, List<ReceivedBillDataDetailVO> entryInfoList) {
        if (StringUtils.isNotEmpty((CharSequence)billInfo.getBillNo())) {
            DeleteServiceHelper.delete((String)"ar_receivedbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billInfo.getBillNo())});
        }
        DynamicObject payBill = BusinessDataServiceHelper.newDynamicObject((String)"ar_receivedbill");
        DynamicObject org = billInfo.getOrg() == null ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        payBill.set("org", (Object)org);
        payBill.set("recorg", (Object)org);
        payBill.set("billno", (Object)(StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "RV-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo()));
        payBill.set("bizdate", (Object)new Date());
        payBill.set("currency", (Object)billInfo.getCurrency());
        payBill.set("basecurrency", (Object)BaseDataTestProvider.getCurrencyCNY());
        payBill.set("exchangerate", (Object)billInfo.getExchangerate());
        payBill.set("asstacttype", (Object)"bd_customer");
        payBill.set("asstact", (Object)BaseDataTestProvider.getCustomer());
        payBill.set("billstatus", (Object)"C");
        payBill.set("rectype", (Object)BaseDataTestProvider.getReceivingType());
        DynamicObjectType dataEntityType = (DynamicObjectType)payBill.getDataEntityType();
        DynamicObjectType entrydt = ((EntryProp)dataEntityType.getProperty("entry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection entry = payBill.getDynamicObjectCollection("entry");
        BigDecimal pricetaxTotalHeader = BigDecimal.ZERO;
        for (ReceivedBillDataDetailVO entryInfo : entryInfoList) {
            DynamicObject row = new DynamicObject(entrydt);
            BigDecimal amount = entryInfo.getPriceTaxTotal().setScale(2, RoundingMode.HALF_UP);
            BigDecimal localAmount = amount.multiply(billInfo.getExchangerate()).setScale(2, RoundingMode.HALF_UP);
            row.set("seq", (Object)entryInfo.getSeq());
            row.set("e_material", (Object)BaseDataTestProvider.getMaterial());
            row.set("e_amount", (Object)amount);
            row.set("e_localamount", (Object)localAmount);
            row.set("e_unsettledamt", (Object)amount);
            pricetaxTotalHeader = pricetaxTotalHeader.add(amount);
            entry.add((Object)row);
        }
        payBill.set("recamount", (Object)pricetaxTotalHeader);
        payBill.set("localamount", (Object)pricetaxTotalHeader);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payBill});
        return payBill;
    }

    public static DynamicObject[] loadData(Long[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"ar_receivedbill").getDynamicObjectType());
    }

    public static DynamicObject loadSingle(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"ar_receivedbill");
    }
}

