/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.dataprovider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.SaleOrderBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.SaleOrderBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.SaleOrderTestHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class SaleOrderBillTestDataProvider {
    private static final String ENTITY_NAME = "sm_salorder";

    public static DynamicObject buildByDetailEntry(SaleOrderBillDataVO billInfo, List<SaleOrderBillDataDetailVO> entries) {
        if (StringUtils.isNotEmpty(billInfo.getBillNo())) {
            SaleOrderBillTestDataProvider.deleteHistoryBill(billInfo.getBillNo());
        }
        DynamicObject saleOrderBill = SaleOrderBillTestDataProvider.buildHead(billInfo);
        SaleOrderBillTestDataProvider.buildDetailEntry(saleOrderBill, entries);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleOrderBill});
        return saleOrderBill;
    }

    private static void buildDetailEntry(DynamicObject saleOrderBill, List<SaleOrderBillDataDetailVO> entries) {
        DynamicObjectType dataEntityType = (DynamicObjectType)saleOrderBill.getDataEntityType();
        DynamicObjectType detailEntryType = ((EntryProp)dataEntityType.getProperty("billentry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection detailEntries = saleOrderBill.getDynamicObjectCollection("billentry");
        int seq = 1;
        int precision = saleOrderBill.getDynamicObject("currency").getInt("amtprecision");
        BigDecimal exchangeRate = saleOrderBill.getBigDecimal("exchangerate");
        BigDecimal headTaxAmount = BigDecimal.ZERO;
        BigDecimal headAmount = BigDecimal.ZERO;
        BigDecimal headLocalAmount = BigDecimal.ZERO;
        BigDecimal headRecAmount = BigDecimal.ZERO;
        BigDecimal headLocalRecAmount = BigDecimal.ZERO;
        for (SaleOrderBillDataDetailVO detailVO : entries) {
            DynamicObject detailEntry = new DynamicObject(detailEntryType);
            BigDecimal amount = detailVO.getPrice().multiply(detailVO.getQuantity()).setScale(precision, RoundingMode.HALF_UP);
            detailEntry.set("seq", (Object)seq++);
            long lineType = 1194153085623127040L;
            long billType = saleOrderBill.getLong("billtype");
            if (billType == 587483350172726272L) {
                lineType = 1194150915045641216L;
            }
            detailEntry.set("linetype", (Object)lineType);
            detailEntry.set("producttype", (Object)"standard");
            QFilter filter = new QFilter("masterid.ctrlstrategy", "=", (Object)"5");
            filter.and(new QFilter("masterid.configproperties", "!=", (Object)"2"));
            List allMaterialId = QueryServiceHelper.queryPrimaryKeys((String)"bd_materialsalinfo", (QFilter[])new QFilter[]{filter}, (String)"id", (int)5000);
            DynamicObject materialInventoryInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialinventoryinfo", (QFilter[])new QFilter[]{new QFilter("masterid.id", "in", (Object)allMaterialId)});
            DynamicObject material = materialInventoryInfo.getDynamicObject("masterid");
            detailEntry.set("materialmasterid", (Object)material);
            detailEntry.set("material", (Object)material.getLong("id"));
            detailEntry.set("materialname", (Object)material.getString("name"));
            detailEntry.set("materialversion", (Object)material.getLocaleString("modelnum"));
            long unitId = material.getLong("baseunit.id");
            detailEntry.set("unit", (Object)unitId);
            detailEntry.set("qty", (Object)detailVO.getQuantity());
            detailEntry.set("baseunit", (Object)unitId);
            detailEntry.set("baseqty", (Object)detailVO.getQuantity());
            detailEntry.set("price", (Object)detailVO.getPrice());
            detailEntry.set("taxrateid", (Object)detailVO.getTaxRate());
            if (EmptyUtils.isNotEmpty(detailVO.getTaxRate())) {
                detailEntry.set("taxrate", (Object)detailVO.getTaxRate().getBigDecimal("taxrate"));
            }
            BigDecimal rowTax = detailEntry.getBigDecimal("price").multiply(detailEntry.getBigDecimal("taxrate").divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP)).setScale(precision, RoundingMode.HALF_UP);
            detailEntry.set("taxamount", (Object)rowTax);
            detailEntry.set("curtaxamount", (Object)rowTax.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP));
            detailEntry.set("priceandtax", (Object)detailEntry.getBigDecimal("price").add(rowTax));
            detailEntry.set("discounttype", (Object)detailVO.getDiscountType());
            detailEntry.set("discountrate", (Object)detailVO.getDiscountRate());
            BigDecimal discountAmt = detailEntry.getBigDecimal("discountrate").multiply(amount).divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP).setScale(precision, RoundingMode.HALF_UP);
            detailEntry.set("discountamount", (Object)discountAmt);
            detailEntry.set("amount", (Object)amount.subtract(discountAmt));
            detailEntry.set("curamount", (Object)detailEntry.getBigDecimal("amount").multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP));
            detailEntry.set("amountandtax", (Object)detailEntry.getBigDecimal("amount").add(detailEntry.getBigDecimal("taxamount")));
            detailEntry.set("curamountandtax", (Object)detailEntry.getBigDecimal("amountandtax").multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP));
            detailEntry.set("salesorg", (Object)saleOrderBill.getDynamicObject("org"));
            detailEntry.set("e_stockorg", (Object)saleOrderBill.getDynamicObject("org"));
            detailEntry.set("entrysettleorg", (Object)saleOrderBill.getDynamicObject("org"));
            detailEntry.set("settledept", (Object)saleOrderBill.getDynamicObject("org"));
            detailEntry.set("deliverydate", (Object)new Date());
            detailEntry.set("deliverqtyup", (Object)detailVO.getQuantity());
            detailEntry.set("deliverbaseqtyup", (Object)detailVO.getQuantity());
            detailEntry.set("rowclosestatus", (Object)"A");
            detailEntry.set("rowterminatestatus", (Object)"A");
            detailEntry.set("ownertype", (Object)"bos_org");
            detailEntry.set("owner", (Object)saleOrderBill.getDynamicObject("org"));
            detailEntry.set("producttype", (Object)"standard");
            headTaxAmount = headTaxAmount.add(detailEntry.getBigDecimal("taxamount"));
            headAmount = headAmount.add(detailEntry.getBigDecimal("amount"));
            headLocalAmount = headLocalAmount.add(detailEntry.getBigDecimal("curamount"));
            headRecAmount = headRecAmount.add(detailEntry.getBigDecimal("amountandtax"));
            headLocalRecAmount = headLocalRecAmount.add(detailEntry.getBigDecimal("curamountandtax"));
            detailEntries.add((Object)detailEntry);
        }
        DynamicObjectType planEntityType = (DynamicObjectType)saleOrderBill.getDataEntityType();
        DynamicObjectType planEntryType = ((EntryProp)planEntityType.getProperty("recplanentry")).getDynamicCollectionItemPropertyType();
        DynamicObjectCollection planEntries = saleOrderBill.getDynamicObjectCollection("recplanentry");
        DynamicObject planEntry = new DynamicObject(planEntryType);
        planEntry.set("r_recadvancerate", (Object)BigDecimal.valueOf(100L));
        planEntry.set("r_duedate", (Object)new Date());
        planEntry.set("r_recadvanceamount", (Object)headRecAmount);
        planEntry.set("r_recsettleorg", (Object)saleOrderBill.getDynamicObject("org"));
        planEntry.set("r_needrecadvance", (Object)Boolean.TRUE);
        planEntries.add((Object)planEntry);
        saleOrderBill.set("totaltaxamount", (Object)headTaxAmount);
        saleOrderBill.set("totalamount", (Object)headAmount);
        saleOrderBill.set("curtotalamount", (Object)headLocalAmount);
        saleOrderBill.set("totalallamount", (Object)headRecAmount);
        saleOrderBill.set("curtotalallamount", (Object)headLocalRecAmount);
    }

    private static DynamicObject buildHead(SaleOrderBillDataVO billInfo) {
        DynamicObject saleOrderBill = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        String billNo = kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)billInfo.getBillNo()) ? "SM-" + DBServiceHelper.genGlobalLongId() : billInfo.getBillNo();
        DynamicObject org = EmptyUtils.isEmpty(billInfo.getOrg()) ? BaseDataTestProvider.getDetailInitOrg() : billInfo.getOrg();
        DynamicObject currency = EmptyUtils.isEmpty(billInfo.getCurrency()) ? BaseDataTestProvider.getCurrencyCNY() : billInfo.getCurrency();
        saleOrderBill.set("billno", (Object)billNo);
        long billType = 939764363726684160L;
        long bizType = 691917066026067968L;
        if ("sm_SalesOrder_STD_BT_S".equals(billInfo.getBillType())) {
            billType = 587483350172726272L;
            bizType = 422876630176775168L;
        }
        saleOrderBill.set("billtype", (Object)billType);
        saleOrderBill.set("biztype", (Object)bizType);
        saleOrderBill.set("bizdate", (Object)new Date());
        saleOrderBill.set("billstatus", (Object)billInfo.getBillStatus());
        saleOrderBill.set("comment", (Object)"SALE-ORDER-TEST");
        saleOrderBill.set("billcretype", (Object)"2");
        saleOrderBill.set("org", (Object)org);
        saleOrderBill.set("dept", (Object)org);
        saleOrderBill.set("operator", (Object)RequestContext.get().getCurrUserId());
        DynamicObject customer = SaleOrderTestHelper.getCustomer();
        saleOrderBill.set("customer", (Object)customer);
        saleOrderBill.set("settlecustomer", (Object)customer);
        saleOrderBill.set("payingcustomer", (Object)customer);
        saleOrderBill.set("currency", (Object)currency);
        saleOrderBill.set("settlecurrency", (Object)currency);
        saleOrderBill.set("exratetable", (Object)BaseDataTestProvider.getExtrateTable());
        saleOrderBill.set("exratedate", (Object)new Date());
        saleOrderBill.set("exchangerate", (Object)billInfo.getExchangeRate());
        saleOrderBill.set("paymode", (Object)billInfo.getPayMode());
        saleOrderBill.set("istax", (Object)billInfo.isTax());
        saleOrderBill.set("settleorg", (Object)org);
        saleOrderBill.set("closestatus", (Object)"A");
        saleOrderBill.set("changestatus", (Object)"A");
        DynamicObject settleType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (QFilter[])new QFilter[]{new QFilter("settlementtype", "=", (Object)"8")});
        saleOrderBill.set("settletype", (Object)settleType);
        return saleOrderBill;
    }

    private static void deleteHistoryBill(String billNo) {
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
    }

    public static DynamicObject createAR022SaleOrderBill(SaleOrderBillDataVO header, BigDecimal[] expectedEntryQty, BigDecimal[] expectedEntryPrice) {
        ArrayList<SaleOrderBillDataDetailVO> detailRows = new ArrayList<SaleOrderBillDataDetailVO>(16);
        for (int i = 0; i < expectedEntryQty.length; ++i) {
            SaleOrderBillDataDetailVO detailVO = new SaleOrderBillDataDetailVO();
            detailVO.setQuantity(expectedEntryQty[i]);
            detailVO.setPrice(expectedEntryPrice[i]);
            detailRows.add(detailVO);
        }
        return SaleOrderBillTestDataProvider.buildByDetailEntry(header, detailRows);
    }
}

