/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.BusApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.BusArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.BusApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.BusApBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.BusArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.BusArBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;

public class BusBillTestHelper {
    private static final String ENTRY = "entry";

    public static DynamicObject getAuditBusApBill(String billNo, boolean isAmtBenchMark, boolean isUSD, BigDecimal[] qtys, BigDecimal[] prices) {
        BusApBillDataVO billInfo = new BusApBillDataVO();
        billInfo.setBillStatus("A");
        billInfo.setBillNo(billNo);
        if (isUSD) {
            billInfo.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id"));
            billInfo.setExchangerate(BigDecimal.valueOf(6.5));
        } else {
            billInfo.setExchangerate(BigDecimal.ONE);
        }
        if (isAmtBenchMark) {
            billInfo.setPayProperty(BaseDataTestProvider.getPayPropertyByAmtBenchmark());
        }
        ArrayList<BusApBillDataDetailVO> entryInfoList = new ArrayList<BusApBillDataDetailVO>(qtys.length);
        for (int i = 0; i < qtys.length; ++i) {
            BusApBillDataDetailVO entryInfo = new BusApBillDataDetailVO();
            entryInfo.setQuantity(qtys[i]);
            entryInfo.setPrice(prices[i]);
            entryInfoList.add(entryInfo);
        }
        DynamicObject busApBill = BusApBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryInfoList);
        long busApBillId = busApBill.getLong("id");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busApBill});
        BusBillTestHelper.executeOperation("submit", "ap_busbill", new Object[]{busApBillId});
        BusBillTestHelper.executeOperation("audit", "ap_busbill", new Object[]{busApBillId});
        return BusinessDataServiceHelper.loadSingle((Object)busApBillId, (String)"ap_busbill");
    }

    public static DynamicObject getAuditBusArBill(String billNo, boolean isAmtBenchMark, boolean isUSD, BigDecimal[] qtys, BigDecimal[] prices) {
        BusArBillDataVO billInfo = new BusArBillDataVO();
        billInfo.setBillStatus("A");
        billInfo.setBillNo(billNo);
        if (isUSD) {
            billInfo.setExchangerate(BigDecimal.valueOf(6.5));
            billInfo.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id"));
        } else {
            billInfo.setExchangerate(BigDecimal.ONE);
        }
        if (isAmtBenchMark) {
            billInfo.setPayProperty(BaseDataTestProvider.getRecPropertyAmtBenchmark());
        }
        ArrayList<BusArBillDataDetailVO> entryInfoList = new ArrayList<BusArBillDataDetailVO>(qtys.length);
        for (int i = 0; i < qtys.length; ++i) {
            BusArBillDataDetailVO entryInfo = new BusArBillDataDetailVO();
            entryInfo.setQuantity(qtys[i]);
            entryInfo.setPrice(prices[i]);
            entryInfoList.add(entryInfo);
        }
        DynamicObject busArBill = BusArBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryInfoList);
        long busArBillId = busArBill.getLong("id");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busArBill});
        BusBillTestHelper.executeOperation("submit", "ar_busbill", new Object[]{busArBillId});
        BusBillTestHelper.executeOperation("audit", "ar_busbill", new Object[]{busArBillId});
        return BusinessDataServiceHelper.loadSingle((Object)busArBillId, (String)"ar_busbill");
    }

    public static long getBusArBillView(IListView listView, SimulatorTestHelper util, long orgId, String billNo, boolean isAmtBenchMark, boolean isUSD, BigDecimal[] qtys, BigDecimal[] prices, long[] taxrateIds) {
        String param = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[],[{\"FieldName\":[\"billtype.id\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"bizdate\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"billstatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"org.id\"],\"Value\":[\"" + orgId + "\"],\"Compare\":[\"\"]}],\"entry\"],\"postData\":[{},[]]}]";
        util.invokeAction((IFormView)listView, param);
        IFormView busBillView = util.clickBarItemReturnChildView((IFormView)listView, "tblnew", "new");
        IDataModel model = busBillView.getModel();
        model.setValue("billno", (Object)billNo);
        model.setValue("asstact", (Object)BaseDataTestProvider.getCustomer());
        model.setValue("recorg", (Object)orgId);
        if (isAmtBenchMark) {
            model.setValue("payproperty", (Object)BaseDataTestProvider.getRecPropertyAmtBenchmark());
        } else {
            model.setValue("payproperty", (Object)BaseDataTestProvider.getRecProperty());
        }
        if (isUSD) {
            model.setValue("currency", (Object)BaseDataTestProvider.getCurrencyUSD());
            model.setValue("exchangerate", (Object)6.5);
        } else {
            model.setValue("currency", (Object)BaseDataTestProvider.getCurrencyCNY());
            model.setValue("exchangerate", (Object)1);
        }
        model.batchCreateNewEntryRow(ENTRY, qtys.length - 1);
        for (int i = 0; i < qtys.length; ++i) {
            model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), i);
            model.setValue("e_unitprice", (Object)prices[i], i);
            model.setValue("e_quantity", (Object)qtys[i], i);
            model.setValue("taxrateid", (Object)taxrateIds[i], i);
        }
        OperationResult saveResult = busBillView.invokeOperation("submit");
        OperationHelper.assertResult(saveResult);
        OperationResult auditResult = busBillView.invokeOperation("audit");
        OperationHelper.assertResult(auditResult);
        DynamicObject busBill = busBillView.getModel().getDataEntity(true);
        return busBill.getLong("id");
    }

    public static IFormView getQtyBenchmarkBusArBillViewBy4row(IListView listView, SimulatorTestHelper util, long orgId) {
        String param = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[],[{\"FieldName\":[\"billtype.id\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"bizdate\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"billstatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"org.id\"],\"Value\":[\"" + orgId + "\"],\"Compare\":[\"\"]}],\"entry\"],\"postData\":[{},[]]}]";
        util.invokeAction((IFormView)listView, param);
        IFormView busBillView = util.clickBarItemReturnChildView((IFormView)listView, "tblnew", "new");
        IDataModel model = busBillView.getModel();
        model.setValue("asstact", (Object)BaseDataTestProvider.getCustomer());
        model.setValue("recorg", (Object)orgId);
        model.setValue("payproperty", (Object)BaseDataTestProvider.getRecProperty());
        model.setValue("currency", (Object)BaseDataTestProvider.getCurrencyCNY());
        model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 0);
        model.setValue("e_unitprice", (Object)BigDecimal.valueOf(10L), 0);
        model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 0);
        model.setValue("taxrateid", (Object)1L, 0);
        model.createNewEntryRow(ENTRY);
        model.setValue("isincludetax", (Object)Boolean.TRUE);
        model.setValue("ispricetotal", (Object)Boolean.FALSE);
        model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 1);
        model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 1);
        model.setValue("e_taxunitprice", (Object)BigDecimal.valueOf(22.6), 1);
        model.setValue("taxrateid", (Object)1L, 1);
        model.setValue("e_discountmode", (Object)"PERCENT", 1);
        model.setValue("e_discountrate", (Object)BigDecimal.valueOf(10L), 1);
        model.createNewEntryRow(ENTRY);
        model.setValue("isincludetax", (Object)Boolean.FALSE);
        model.setValue("ispricetotal", (Object)Boolean.TRUE);
        model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 2);
        model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 2);
        model.setValue("e_amount", (Object)BigDecimal.valueOf(300L), 2);
        model.setValue("taxrateid", (Object)1L, 2);
        model.setValue("e_discountmode", (Object)"PERUNIT", 2);
        model.setValue("e_discountrate", (Object)BigDecimal.valueOf(10L), 2);
        model.createNewEntryRow(ENTRY);
        model.setValue("isincludetax", (Object)Boolean.TRUE);
        model.setValue("ispricetotal", (Object)Boolean.TRUE);
        model.setValue("e_discountmode", (Object)"TOTAL", 3);
        model.setValue("e_discountamount", (Object)BigDecimal.valueOf(226L), 3);
        model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 3);
        model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 3);
        model.setValue("taxrateid", (Object)1L, 3);
        model.setValue("e_recamount", (Object)BigDecimal.valueOf(452L), 3);
        model.setValue("isincludetax", (Object)Boolean.FALSE);
        model.setValue("ispricetotal", (Object)Boolean.FALSE);
        OperationResult saveResult = busBillView.invokeOperation("submit");
        OperationHelper.assertResult(saveResult);
        OperationResult auditResult = busBillView.invokeOperation("audit");
        OperationHelper.assertResult(auditResult);
        return busBillView;
    }

    public static IFormView getQtyBenchmarkBusArBillViewBy2row(IListView listView, SimulatorTestHelper util, long orgId) {
        String param = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[],[{\"FieldName\":[\"billtype.id\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"bizdate\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"billstatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"org.id\"],\"Value\":[\"" + orgId + "\"],\"Compare\":[\"\"]}],\"entry\"],\"postData\":[{},[]]}]";
        util.invokeAction((IFormView)listView, param);
        IFormView busBillView = util.clickBarItemReturnChildView((IFormView)listView, "tblnew", "new");
        IDataModel model = busBillView.getModel();
        model.setValue("asstact", (Object)BaseDataTestProvider.getCustomer());
        model.setValue("recorg", (Object)orgId);
        model.setValue("payproperty", (Object)BaseDataTestProvider.getRecProperty());
        model.setValue("currency", (Object)BaseDataTestProvider.getCurrencyCNY());
        model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 0);
        model.setValue("e_unitprice", (Object)BigDecimal.valueOf(10L), 0);
        model.setValue("e_quantity", (Object)BigDecimal.valueOf(10L), 0);
        model.setValue("taxrateid", (Object)1L, 0);
        model.createNewEntryRow(ENTRY);
        model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 1);
        model.setValue("e_quantity", (Object)BigDecimal.valueOf(-5L), 1);
        model.setValue("e_unitprice", (Object)BigDecimal.valueOf(10L), 1);
        model.setValue("taxrateid", (Object)1L, 1);
        OperationResult saveResult = busBillView.invokeOperation("submit");
        OperationHelper.assertResult(saveResult);
        OperationResult auditResult = busBillView.invokeOperation("audit");
        OperationHelper.assertResult(auditResult);
        return busBillView;
    }

    public static IFormView getQtyBenchmarkTailDiffData(IListView listView, SimulatorTestHelper util, long orgId) {
        String param = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[],[{\"FieldName\":[\"billtype.id\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"bizdate\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"billstatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"org.id\"],\"Value\":[\"" + orgId + "\"],\"Compare\":[\"\"]}],\"entry\"],\"postData\":[{},[]]}]";
        util.invokeAction((IFormView)listView, param);
        IFormView busBillView = util.clickBarItemReturnChildView((IFormView)listView, "tblnew", "new");
        IDataModel model = busBillView.getModel();
        model.setValue("ispricetotal", (Object)Boolean.TRUE);
        model.setValue("isincludetax", (Object)Boolean.TRUE);
        model.setValue("asstact", (Object)BaseDataTestProvider.getCustomer());
        model.setValue("recorg", (Object)orgId);
        model.setValue("payproperty", (Object)BaseDataTestProvider.getRecProperty());
        model.setValue("currency", (Object)1L);
        model.setValue("exratetable", (Object)346173531320483840L);
        model.setValue("exchangerate", (Object)1);
        model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 0);
        model.setValue("e_quantity", (Object)BigDecimal.valueOf(5L), 0);
        model.setValue("e_recamount", (Object)BigDecimal.valueOf(100L), 0);
        model.setValue("taxrateid", (Object)1L, 0);
        OperationResult saveResult = busBillView.invokeOperation("submit");
        OperationHelper.assertResult(saveResult);
        OperationResult auditResult = busBillView.invokeOperation("audit");
        OperationHelper.assertResult(auditResult);
        return busBillView;
    }

    public static IFormView getAmtBenchmarkBusArBillViewBy1row(IListView listView, SimulatorTestHelper util, long orgId, BigDecimal price) {
        String param = "[{\"key\":\"filtercontainerap\",\"methodName\":\"commonSearch\",\"args\":[[],[{\"FieldName\":[\"billtype.id\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"bizdate\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"billstatus\"],\"Value\":[\"\"],\"Compare\":[\"\"]},{\"FieldName\":[\"org.id\"],\"Value\":[\"" + orgId + "\"],\"Compare\":[\"\"]}],\"entry\"],\"postData\":[{},[]]}]";
        util.invokeAction((IFormView)listView, param);
        IFormView busBillView = util.clickBarItemReturnChildView((IFormView)listView, "tblnew", "new");
        IDataModel model = busBillView.getModel();
        model.setValue("asstact", (Object)BaseDataTestProvider.getCustomer());
        model.setValue("recorg", (Object)orgId);
        model.setValue("payproperty", (Object)BaseDataTestProvider.getRecPropertyAmtBenchmark());
        model.setValue("currency", (Object)BaseDataTestProvider.getCurrencyCNY());
        model.createNewEntryRow(ENTRY);
        model.setValue("e_material", (Object)BaseDataTestProvider.getMaterial(), 0);
        model.setValue("e_unitprice", (Object)price, 0);
        model.setValue("e_quantity", (Object)BigDecimal.valueOf(1L), 0);
        OperationResult saveResult = busBillView.invokeOperation("submit");
        OperationHelper.assertResult(saveResult);
        OperationResult auditResult = busBillView.invokeOperation("audit");
        OperationHelper.assertResult(auditResult);
        return busBillView;
    }

    public static void executeOperation(String operation, String billEntity, Object[] ids) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("mutex_writeback", "false");
        operateOption.setVariableValue("WF", "false");
        OperationResult result = OperationServiceHelper.executeOperate((String)operation, (String)billEntity, (Object[])ids, (OperateOption)operateOption);
        OperationHelper.assertResult(result);
    }

    public static void executeOperation(String operation, String billEntity, DynamicObject[] bills) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("mutex_writeback", "false");
        operateOption.setVariableValue("WF", "false");
        OperationResult result = OperationServiceHelper.executeOperate((String)operation, (String)billEntity, (DynamicObject[])bills, (OperateOption)operateOption);
        OperationHelper.assertResult(result);
    }

    public static DynamicObject[] pushBusApBill(String sourceEntity, List<Long> srcIds, String billNo) {
        return BusBillTestHelper.pushBusApBill(BigDecimal.valueOf(999999L), sourceEntity, srcIds, billNo);
    }

    public static DynamicObject[] pushBusApBill(String sourceEntity, List<Long> srcIds, String billStatus, String billNo) {
        return BusBillTestHelper.pushBusApBill(BigDecimal.valueOf(999999L), sourceEntity, srcIds, billStatus, billNo);
    }

    public static DynamicObject[] pushBusApBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String billNo) {
        return BusBillTestHelper.pushBusApBill(deleteAmt, sourceEntity, srcIds, "C", billNo);
    }

    public static DynamicObject[] fullPushBusApBill(String sourceEntity, List<Long> srcIds, String billNo) {
        return BusBillTestHelper.pushBusApBill(null, sourceEntity, srcIds, "C", billNo);
    }

    public static DynamicObject[] pushBusApBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String billStatus, String billNo) {
        return BusBillTestHelper.pushBusApBill(deleteAmt, sourceEntity, srcIds, billStatus, billNo, null);
    }

    public static DynamicObject[] pushBusApBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String billStatus, String billNo, String roleId) {
        List<DynamicObject> busApBills = BOTPHelper.push(sourceEntity, "ap_busbill", roleId, srcIds);
        DynamicObject[] busApBillArray = busApBills.toArray(new DynamicObject[0]);
        DynamicObject busApBill = busApBillArray[0];
        if (deleteAmt != null && BigDecimal.ZERO.compareTo(deleteAmt) != 0) {
            int precision = busApBill.getDynamicObject("basecurrency").getInt("amtprecision");
            BigDecimal headAmt = BigDecimal.ZERO;
            BigDecimal headLocalAmt = BigDecimal.ZERO;
            DynamicObjectCollection entry = busApBill.getDynamicObjectCollection(ENTRY);
            for (int i = entry.size() - 1; i >= 0; --i) {
                DynamicObject detail = (DynamicObject)entry.get(i);
                if (deleteAmt.compareTo(detail.getBigDecimal("e_pricetaxtotal")) == 0) {
                    entry.remove(i);
                    continue;
                }
                BigDecimal changeAmt = detail.getBigDecimal("e_pricetaxtotal").divide(BigDecimal.valueOf(2L));
                BigDecimal changeLocalAmt = changeAmt.multiply(busApBill.getBigDecimal("exchangerate")).setScale(precision, RoundingMode.HALF_UP);
                BigDecimal changeQty = detail.getBigDecimal("e_quantity").divide(BigDecimal.valueOf(2L));
                BigDecimal changeBaseQty = detail.getBigDecimal("e_baseunitqty").divide(BigDecimal.valueOf(2L));
                detail.set("e_quantity", (Object)changeQty);
                detail.set("e_baseunitqty", (Object)changeBaseQty);
                detail.set("e_amount", (Object)changeAmt);
                detail.set("e_localamt", (Object)changeLocalAmt);
                detail.set("e_pricetaxtotal", (Object)changeAmt);
                detail.set("e_pricetaxtotalbase", (Object)changeLocalAmt);
                detail.set("e_unwoffqty", (Object)changeQty);
                detail.set("e_unwoffamt", (Object)changeAmt);
                detail.set("e_unwofflocamt", (Object)changeLocalAmt);
                detail.set("e_uninvoicedqty", (Object)changeQty);
                detail.set("e_uninvoicedamt", (Object)changeAmt);
                detail.set("e_uninvoicedlocamt", (Object)changeLocalAmt);
                detail.set("e_unwoffnotaxamt", (Object)changeAmt);
                detail.set("e_unwoffnotaxlocamt", (Object)changeLocalAmt);
                headAmt = headAmt.add(changeAmt);
                headLocalAmt = headLocalAmt.add(changeLocalAmt);
            }
            busApBill.set("pricetaxtotal", (Object)headAmt);
            busApBill.set("pricetaxtotalbase", (Object)headLocalAmt);
            busApBill.set("amount", (Object)headAmt);
            busApBill.set("localamt", (Object)headLocalAmt);
            busApBill.set("unwoffamt", (Object)headAmt);
            busApBill.set("unwofflocamt", (Object)headLocalAmt);
            busApBill.set("uninvoicedamt", (Object)headAmt);
            busApBill.set("uninvoicedlocamt", (Object)headLocalAmt);
            busApBill.set("unwoffnotaxamt", (Object)headAmt);
            busApBill.set("unwoffnotaxlocamt", (Object)headLocalAmt);
        }
        BusBillTestHelper.executeOperation("save", "ap_busbill", busApBillArray);
        Object[] busApIds = (Long[])Arrays.stream(busApBillArray).map(bill -> bill.getLong("id")).toArray(Long[]::new);
        if ("B".equals(billStatus) || "C".equals(billStatus)) {
            busApBillArray = BusinessDataServiceHelper.load((Object[])busApIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ap_busbill"));
            BusBillTestHelper.fillValueInBusApBill(busApBillArray);
            BusBillTestHelper.executeOperation("submit", "ap_busbill", busApIds);
        }
        if ("C".equals(billStatus)) {
            BusBillTestHelper.executeOperation("audit", "ap_busbill", busApIds);
        }
        busApBillArray = BusinessDataServiceHelper.load((Object[])busApIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ap_busbill"));
        if (billNo != null) {
            busApBill.set("billno", (Object)billNo);
        }
        SaveServiceHelper.save((DynamicObject[])busApBillArray);
        return busApBillArray;
    }

    private static void fillValueInBusApBill(DynamicObject[] busApBillArray) {
        for (DynamicObject busApBill : busApBillArray) {
            busApBill.set("payproperty", (Object)BaseDataTestProvider.getPayProperty());
            DynamicObjectCollection entry = busApBill.getDynamicObjectCollection(ENTRY);
            entry.forEach(detail -> detail.set("e_expenseitem", (Object)BaseDataTestProvider.getExpenseItem()));
        }
        SaveServiceHelper.save((DynamicObject[])busApBillArray);
    }

    public static DynamicObject setDetailEntryQtyAndPrice(DynamicObject busBill, Set<Long> deleteSrcEntryIds, BigDecimal[] expectedQty, BigDecimal[] expectedPrice, boolean isAr) {
        BusBillTestHelper.removeDetailEntryRow(busBill, deleteSrcEntryIds);
        BusBillTestHelper.setDetailEntryQtyAndPrice(busBill, expectedQty, expectedPrice, isAr);
        return busBill;
    }

    private static void removeDetailEntryRow(DynamicObject busBill, Set<Long> deleteSrcEntryIds) {
        DynamicObjectCollection detailEntries = busBill.getDynamicObjectCollection(ENTRY);
        Iterator detailEntryIterator = detailEntries.iterator();
        while (detailEntryIterator.hasNext()) {
            DynamicObject detailEntryRow = (DynamicObject)detailEntryIterator.next();
            long srcEntryId = detailEntryRow.getLong("e_srcentryid");
            if (!deleteSrcEntryIds.contains(srcEntryId)) continue;
            detailEntryIterator.remove();
        }
    }

    public static DynamicObject setDetailEntryQtyAndPrice(DynamicObject busBill, BigDecimal[] expectedQty, BigDecimal[] expectedPrice, boolean isAr) {
        DynamicObjectCollection detailEntries = busBill.getDynamicObjectCollection(ENTRY);
        KDAssert.assertEquals((String)"\u660e\u7ec6\u5206\u5f55\u884c\u6570\u4e0e\u671f\u671b\u6570\u91cf\u6570\u7ec4\u4e0d\u4e00\u81f4", (int)detailEntries.size(), (int)expectedQty.length);
        KDAssert.assertEquals((String)"\u660e\u7ec6\u5206\u5f55\u884c\u6570\u4e0e\u671f\u671b\u5355\u4ef7\u6570\u7ec4\u4e0d\u4e00\u81f4", (int)detailEntries.size(), (int)expectedPrice.length);
        BigDecimal exchangeRate = busBill.getBigDecimal("exchangerate");
        int precision = busBill.getDynamicObject("currency").getInt("amtprecision");
        BigDecimal headAmount = BigDecimal.ZERO;
        BigDecimal headLocalAmount = BigDecimal.ZERO;
        BigDecimal headTaxAmt = BigDecimal.ZERO;
        BigDecimal headTaxLocalAmt = BigDecimal.ZERO;
        BigDecimal headRecAmount = BigDecimal.ZERO;
        BigDecimal headRecLocalAmount = BigDecimal.ZERO;
        for (int i = 0; i < detailEntries.size(); ++i) {
            DynamicObject detailEntryRow = (DynamicObject)detailEntries.get(i);
            BigDecimal amount = expectedQty[i].multiply(expectedPrice[i]).setScale(precision, RoundingMode.HALF_UP);
            BigDecimal localAmount = amount.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
            BigDecimal taxAmt = detailEntryRow.getBigDecimal("e_taxrate").divide(BigDecimal.valueOf(100L), precision, RoundingMode.HALF_UP).multiply(expectedPrice[i]).setScale(precision, RoundingMode.HALF_UP);
            BigDecimal taxLocalAmt = taxAmt.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
            BigDecimal recAmount = amount.add(taxAmt);
            BigDecimal recLocalAmount = recAmount.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
            detailEntryRow.set("e_quantity", (Object)expectedQty[i]);
            detailEntryRow.set("e_baseunitqty", (Object)expectedQty[i]);
            detailEntryRow.set("e_unitprice", (Object)expectedPrice[i]);
            detailEntryRow.set("e_actunitprice", (Object)expectedPrice[i]);
            detailEntryRow.set("e_acttaxunitprice", (Object)expectedPrice[i].add(taxAmt));
            detailEntryRow.set("e_tax", (Object)taxAmt);
            detailEntryRow.set("e_taxlocalamt", (Object)taxLocalAmt);
            detailEntryRow.set("e_amount", (Object)amount);
            detailEntryRow.set("e_localamt", (Object)localAmount);
            detailEntryRow.set(isAr ? "e_recamount" : "e_pricetaxtotal", (Object)recAmount);
            detailEntryRow.set(isAr ? "e_reclocalamt" : "e_pricetaxtotalbase", (Object)recLocalAmount);
            detailEntryRow.set("e_unwoffqty", (Object)expectedQty[i]);
            detailEntryRow.set("e_unwoffamt", (Object)recAmount);
            detailEntryRow.set("e_unwofflocamt", (Object)recLocalAmount);
            detailEntryRow.set("e_uninvoicedqty", (Object)expectedQty[i]);
            detailEntryRow.set("e_uninvoicedamt", (Object)recAmount);
            detailEntryRow.set("e_uninvoicedlocamt", (Object)recLocalAmount);
            if (isAr) {
                detailEntryRow.set("e_unconfirmamt", (Object)recAmount);
            }
            headAmount = headAmount.add(amount);
            headLocalAmount = headLocalAmount.add(localAmount);
            headRecAmount = headRecAmount.add(recAmount);
            headRecLocalAmount = headRecLocalAmount.add(recLocalAmount);
            headTaxAmt = headTaxAmt.add(taxAmt);
            headTaxLocalAmt = headTaxLocalAmt.add(taxLocalAmt);
        }
        busBill.set("amount", (Object)headAmount);
        busBill.set("localamt", (Object)headLocalAmount);
        busBill.set(isAr ? "recamount" : "pricetaxtotal", (Object)headRecAmount);
        busBill.set(isAr ? "reclocalamt" : "pricetaxtotalbase", (Object)headRecLocalAmount);
        busBill.set("tax", (Object)headTaxAmt);
        busBill.set("taxlocamt", (Object)headTaxLocalAmt);
        busBill.set("unwoffamt", (Object)headRecAmount);
        busBill.set("unwofflocamt", (Object)headRecLocalAmount);
        busBill.set("uninvoicedamt", (Object)headRecAmount);
        busBill.set("uninvoicedlocamt", (Object)headRecLocalAmount);
        return busBill;
    }

    public static DynamicObject[] pushBusArBill(String sourceEntity, List<Long> srcIds, String billNo) {
        return BusBillTestHelper.pushBusArBill(BigDecimal.valueOf(999999L), sourceEntity, srcIds, billNo);
    }

    public static DynamicObject[] pushBusArBill(String sourceEntity, List<Long> srcIds, String billStatus, String billNo) {
        return BusBillTestHelper.pushBusArBill(BigDecimal.valueOf(999999L), sourceEntity, srcIds, billStatus, billNo);
    }

    public static DynamicObject[] pushBusArBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String billNo) {
        return BusBillTestHelper.pushBusArBill(deleteAmt, sourceEntity, srcIds, "C", billNo);
    }

    public static DynamicObject[] fullPushBusArBill(String sourceEntity, List<Long> srcIds, String billNo) {
        return BusBillTestHelper.pushBusArBill(null, sourceEntity, srcIds, "C", billNo);
    }

    public static DynamicObject[] pushBusArBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String billStatus, String billNo) {
        return BusBillTestHelper.pushBusArBill(deleteAmt, sourceEntity, srcIds, billStatus, billNo, null);
    }

    public static DynamicObject[] pushBusArBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String billStatus, String billNo, String roleId) {
        List<DynamicObject> busArBills = BOTPHelper.push(sourceEntity, "ar_busbill", roleId, srcIds);
        List busArBillIds = busArBills.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        DynamicObject[] busArBillArray = busArBills.toArray(new DynamicObject[0]);
        DynamicObject busArBill = busArBillArray[0];
        busArBill.getDynamicObjectCollection(ENTRY).forEach(row -> row.set("e_unconfirmamt", (Object)row.getBigDecimal("e_amount")));
        if (deleteAmt != null && BigDecimal.ZERO.compareTo(deleteAmt) != 0) {
            int precision = busArBill.getDynamicObject("basecurrency").getInt("amtprecision");
            BigDecimal headAmt = BigDecimal.ZERO;
            BigDecimal headLocalAmt = BigDecimal.ZERO;
            DynamicObjectCollection entry = busArBill.getDynamicObjectCollection(ENTRY);
            for (int i = entry.size() - 1; i >= 0; --i) {
                DynamicObject detail = (DynamicObject)entry.get(i);
                if (deleteAmt.compareTo(detail.getBigDecimal("e_recamount")) == 0) {
                    entry.remove(i);
                    continue;
                }
                BigDecimal changeAmt = detail.getBigDecimal("e_recamount").divide(BigDecimal.valueOf(2L));
                BigDecimal changeLocalAmt = changeAmt.multiply(busArBill.getBigDecimal("exchangerate")).setScale(precision, RoundingMode.HALF_UP);
                BigDecimal changeQty = detail.getBigDecimal("e_quantity").divide(BigDecimal.valueOf(2L));
                detail.set("e_quantity", (Object)changeQty);
                detail.set("e_amount", (Object)changeAmt);
                detail.set("e_localamt", (Object)changeLocalAmt);
                detail.set("e_unwoffnotaxamt", (Object)changeAmt);
                detail.set("e_unwoffnotaxlocamt", (Object)changeLocalAmt);
                detail.set("e_recamount", (Object)changeAmt);
                detail.set("e_reclocalamt", (Object)changeLocalAmt);
                detail.set("e_unwoffqty", (Object)changeQty);
                detail.set("e_unwoffamt", (Object)changeAmt);
                detail.set("e_unwofflocamt", (Object)changeLocalAmt);
                detail.set("e_uninvoicedqty", (Object)changeQty);
                detail.set("e_uninvoicedamt", (Object)changeAmt);
                detail.set("e_uninvoicedlocamt", (Object)changeLocalAmt);
                detail.set("e_unconfirmamt", (Object)changeAmt);
                headAmt = headAmt.add(changeAmt);
                headLocalAmt = headLocalAmt.add(changeLocalAmt);
            }
            busArBill.set("recamount", (Object)headAmt);
            busArBill.set("reclocalamt", (Object)headLocalAmt);
            busArBill.set("amount", (Object)headAmt);
            busArBill.set("localamt", (Object)headLocalAmt);
            busArBill.set("unwoffamt", (Object)headAmt);
            busArBill.set("unwofflocamt", (Object)headLocalAmt);
            busArBill.set("uninvoicedamt", (Object)headAmt);
            busArBill.set("uninvoicedlocamt", (Object)headLocalAmt);
            busArBill.set("unwoffnotaxamt", (Object)headAmt);
            busArBill.set("unwoffnotaxlocamt", (Object)headLocalAmt);
        }
        busArBill.set("billno", (Object)billNo);
        BusBillTestHelper.executeOperation("save", "ar_busbill", busArBillArray);
        if ("B".equals(billStatus) || "C".equals(billStatus)) {
            BusBillTestHelper.fillValueInBusArBill(busArBillArray);
            BusBillTestHelper.executeOperation("submit", "ar_busbill", busArBillIds.toArray());
        }
        SaveServiceHelper.update((DynamicObject[])busArBillArray);
        if ("C".equals(billStatus)) {
            Object[] busApIds = (Long[])Arrays.stream(busArBillArray).map(bill -> bill.getLong("id")).toArray(Long[]::new);
            BusBillTestHelper.executeOperation("audit", "ar_busbill", busApIds);
        }
        return busArBillArray;
    }

    private static void fillValueInBusArBill(DynamicObject[] busArBillArray) {
        for (DynamicObject busArBill : busArBillArray) {
            busArBill.set("payproperty", (Object)BaseDataTestProvider.getRecProperty());
            DynamicObjectCollection entry = busArBill.getDynamicObjectCollection(ENTRY);
            entry.forEach(detail -> detail.set("e_expenseitem", (Object)BaseDataTestProvider.getExpenseItem()));
        }
        SaveServiceHelper.update((DynamicObject[])busArBillArray);
    }
}

