/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.CasRecBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataVO;

public class CasRecTestHelper {
    public static DynamicObject createCasRecBill(String billNo, List<BigDecimal> listAmt, boolean isDetailSettle) {
        DynamicObject org = isDetailSettle ? BaseDataTestProvider.getDetailInitOrg() : BaseDataTestProvider.getPlanInitOrg();
        CasRecBillDataVO billInfo = CasRecBillDataVO.New().setOrg(org).setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo(billNo);
        ArrayList<CasRecBillDataDetailVO> entryInfoList = new ArrayList<CasRecBillDataDetailVO>(listAmt.size());
        for (BigDecimal amt : listAmt) {
            CasRecBillDataDetailVO entryInfo = CasRecBillDataDetailVO.New().setPriceTaxTotal(amt);
            entryInfoList.add(entryInfo);
        }
        DynamicObject casRecBillInfo = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal(billInfo, entryInfoList);
        return casRecBillInfo;
    }

    public static DynamicObject setEntryAmt(DynamicObject casRecBill, BigDecimal[] expectedAmtArray, BigDecimal[] expectedDiscountArray, BigDecimal[] expectedChargeArray) {
        DynamicObjectCollection detailEntries = casRecBill.getDynamicObjectCollection("entry");
        BigDecimal exchangeRate = casRecBill.getBigDecimal("exchangerate");
        BigDecimal headTotalRecAmt = BigDecimal.ZERO;
        BigDecimal headTotalChargeAmt = BigDecimal.ZERO;
        int precision = casRecBill.getDynamicObject("currency").getInt("amtprecision");
        for (int i = 0; i < detailEntries.size(); ++i) {
            DynamicObject detailEntryRow = (DynamicObject)detailEntries.get(i);
            BigDecimal amount = expectedAmtArray[i];
            BigDecimal localAmt = expectedAmtArray[i].multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
            BigDecimal discountAmt = expectedDiscountArray[i];
            BigDecimal chargeAmt = expectedChargeArray[i];
            BigDecimal actAmt = amount.subtract(discountAmt).subtract(chargeAmt);
            BigDecimal actLocalAmt = actAmt.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
            detailEntryRow.set("e_receivableamt", (Object)amount);
            detailEntryRow.set("e_receivablelocamt", (Object)localAmt);
            detailEntryRow.set("e_actamt", (Object)actAmt);
            detailEntryRow.set("e_localamt", (Object)actLocalAmt);
            detailEntryRow.set("e_unlockamt", (Object)amount);
            detailEntryRow.set("e_unsettledamt", (Object)amount);
            detailEntryRow.set("e_unsettledlocalamt", (Object)localAmt);
            detailEntryRow.set("e_discountamt", (Object)discountAmt);
            detailEntryRow.set("e_discountlocamt", (Object)discountAmt.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP));
            detailEntryRow.set("e_fee", (Object)chargeAmt);
            headTotalRecAmt = headTotalRecAmt.add(actAmt);
            headTotalChargeAmt = headTotalChargeAmt.add(chargeAmt);
        }
        DynamicObjectCollection settleEntries = casRecBill.getDynamicObjectCollection("detailinfo_entry");
        BigDecimal rowRecAmt = BigDecimal.ZERO;
        if (settleEntries.size() > 0) {
            rowRecAmt = headTotalRecAmt.divide(BigDecimal.valueOf(settleEntries.size()), 2, RoundingMode.HALF_UP);
        }
        for (DynamicObject settleEntryRow : settleEntries) {
            settleEntryRow.set("recamount", (Object)rowRecAmt);
        }
        DynamicObjectCollection journalEntries = casRecBill.getDynamicObjectCollection("infoentry");
        BigDecimal rowRecAmt1 = BigDecimal.ZERO;
        if (journalEntries.size() > 0) {
            rowRecAmt1 = headTotalRecAmt.divide(BigDecimal.valueOf(journalEntries.size()), 2, RoundingMode.HALF_UP);
        }
        for (DynamicObject journalEntryRow : journalEntries) {
            journalEntryRow.set("cdm_amount", (Object)rowRecAmt1);
            journalEntryRow.set("bei_creditamount", (Object)rowRecAmt1);
        }
        casRecBill.set("inneraccountamount", (Object)headTotalRecAmt);
        casRecBill.set("actrecamt", (Object)headTotalRecAmt);
        casRecBill.set("fee", (Object)headTotalChargeAmt);
        return casRecBill;
    }

    public static void setRecEntryAmt(DynamicObject entryIfno, BigDecimal recAmt) {
        entryIfno.set("e_receivableamt", (Object)recAmt);
        entryIfno.set("e_receivablelocamt", (Object)recAmt);
        entryIfno.set("e_actamt", (Object)recAmt);
        entryIfno.set("e_localamt", (Object)recAmt);
        entryIfno.set("e_unlockamt", (Object)recAmt);
        entryIfno.set("e_unsettledamt", (Object)recAmt);
        entryIfno.set("e_unsettledlocalamt", (Object)recAmt);
    }

    public static DynamicObject[] pushRecBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String recBillNo) {
        return CasRecTestHelper.pushRecBill(deleteAmt, sourceEntity, srcIds, "D", recBillNo, null);
    }

    public static DynamicObject[] fullPushRecBill(String sourceEntity, List<Long> srcIds, String payBillNo) {
        return CasRecTestHelper.pushRecBill(null, sourceEntity, srcIds, "D", payBillNo, null);
    }

    public static DynamicObject[] pushRecBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String recStatus, String recBillNo, BigDecimal exchangeRate) {
        List<DynamicObject> casRecBills = BOTPHelper.push(sourceEntity, "cas_recbill", srcIds);
        DynamicObject[] casRecBillArray = casRecBills.toArray(new DynamicObject[0]);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"cas_recbill", (DynamicObject[])casRecBillArray, (OperateOption)option);
        OperationHelper.assertResult(saveResult);
        Object[] recBillIds = (Long[])Arrays.stream(casRecBillArray).map(bill -> bill.getLong("id")).toArray(Long[]::new);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cas_recbill");
        casRecBillArray = BusinessDataServiceHelper.load((Object[])recBillIds, (DynamicObjectType)entityType);
        if (exchangeRate != null && BigDecimal.ZERO.compareTo(exchangeRate) != 0) {
            CasRecTestHelper.remedyNoSameRateCasPayBillData(casRecBillArray, exchangeRate);
        }
        if (deleteAmt != null && BigDecimal.ZERO.compareTo(deleteAmt) != 0) {
            DynamicObject[] casRecBill = casRecBillArray[0];
            DynamicObjectCollection casRecEntry = casRecBill.getDynamicObjectCollection("entry");
            BigDecimal actRecAmt = BigDecimal.ZERO;
            BigDecimal localAmt = BigDecimal.ZERO;
            int precision = casRecBill.getInt("basecurrency.amtprecision");
            for (int i = casRecEntry.size() - 1; i >= 0; --i) {
                DynamicObject casRecRow = (DynamicObject)casRecEntry.get(i);
                if (deleteAmt.compareTo(casRecRow.getBigDecimal("e_receivableamt")) == 0) {
                    casRecEntry.remove(i);
                    continue;
                }
                BigDecimal changeAmt = casRecRow.getBigDecimal("e_receivableamt").divide(BigDecimal.valueOf(2L));
                BigDecimal changeLocalAmt = changeAmt.multiply(casRecBill.getBigDecimal("exchangerate")).setScale(precision, RoundingMode.HALF_UP);
                casRecRow.set("e_receivableamt", (Object)changeAmt);
                casRecRow.set("e_receivablelocamt", (Object)changeLocalAmt);
                casRecRow.set("e_actamt", (Object)changeAmt);
                casRecRow.set("e_localamt", (Object)changeLocalAmt);
                casRecRow.set("e_unlockamt", (Object)changeAmt);
                casRecRow.set("e_unsettledamt", (Object)changeAmt);
                casRecRow.set("e_unsettledlocalamt", (Object)changeLocalAmt);
                actRecAmt = actRecAmt.add(changeAmt);
                localAmt = localAmt.add(casRecRow.getBigDecimal("e_localamt"));
            }
            casRecBill.set("actrecamt", (Object)actRecAmt);
            casRecBill.set("localamt", (Object)localAmt);
        }
        saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"cas_recbill", (DynamicObject[])casRecBillArray, (OperateOption)option);
        OperationHelper.assertResult(saveResult);
        for (DynamicObject recBill : casRecBillArray = BusinessDataServiceHelper.load((Object[])recBillIds, (DynamicObjectType)entityType)) {
            if (recBillNo != null) {
                recBill.set("billno", (Object)recBillNo);
            }
            if ("D".equals(recStatus)) {
                recBill.set("billstatus", (Object)"C");
                continue;
            }
            recBill.set("billstatus", (Object)recStatus);
        }
        SaveServiceHelper.save((DynamicObject[])casRecBillArray);
        if ("D".equals(recStatus)) {
            OperationResult recResult = OperationServiceHelper.executeOperate((String)"receivingrec", (String)"cas_recbill", (Object[])recBillIds, (OperateOption)option);
            OperationHelper.assertResult(recResult);
            KDAssert.assertEquals((String)"\u6536\u6b3e\u5355\u786e\u8ba4\u6536\u6b3e\u5931\u8d25", (boolean)true, (boolean)recResult.isSuccess());
            casRecBillArray = BusinessDataServiceHelper.load((Object[])recBillIds, (DynamicObjectType)entityType);
            Arrays.stream(casRecBillArray).forEach(CasRecBillTestChecker::validateCasRecBillJournalData);
        }
        return casRecBillArray;
    }

    protected static DynamicObject[] remedyNoSameRateCasPayBillData(DynamicObject[] casRecBills, BigDecimal exchangeRate) {
        for (DynamicObject casRecBill : casRecBills) {
            casRecBill.set("exchangerate", (Object)exchangeRate);
            BigDecimal localAmt = BigDecimal.ZERO;
            DynamicObjectCollection detailEntry = casRecBill.getDynamicObjectCollection("entry");
            int precision = casRecBill.getInt("basecurrency.amtprecision");
            for (DynamicObject detail : detailEntry) {
                BigDecimal ePayableLocAmt = detail.getBigDecimal("e_receivableamt").multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
                detail.set("e_receivablelocamt", (Object)ePayableLocAmt);
                BigDecimal eDiscountLocAmt = detail.getBigDecimal("e_discountamt").multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
                detail.set("e_discountlocamt", (Object)eDiscountLocAmt);
                BigDecimal eLocalAmt = detail.getBigDecimal("e_actamt").multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
                detail.set("e_localamt", (Object)eLocalAmt);
                localAmt = localAmt.add(eLocalAmt);
                detail.set("e_unsettledlocalamt", (Object)ePayableLocAmt);
            }
            casRecBill.set("localamt", (Object)localAmt);
        }
        return casRecBills;
    }

    public static void cancelRenoteOrRefund(long recBillId) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("revId", String.valueOf(recBillId));
        OperationResult recResult = OperationServiceHelper.executeOperate((String)"cancelrefund", (String)"cas_recbill", (Object[])new Long[]{recBillId}, (OperateOption)option);
        OperationHelper.assertResult(recResult);
    }
}

