/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.helper;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;

public class LiquidateBillTestHelper {
    public static DynamicObject[] fullPushLiquidateBill(String sourceEntity, List<Long> srcIds, String billStatus, boolean isAr) {
        String entityName = isAr ? "ar_liquidation" : "ap_liquidation";
        List<DynamicObject> liquidateBills = BOTPHelper.push(sourceEntity, entityName, srcIds);
        for (DynamicObject liquidateBill : liquidateBills) {
            liquidateBill.set("billno", (Object)("liqui_" + System.currentTimeMillis()));
        }
        OperateOption option = OperateOption.create();
        Object[] liquidateBillIds = (Long[])liquidateBills.stream().map(bill -> bill.getLong("id")).toArray(Long[]::new);
        OperationResult submit = OperationServiceHelper.executeOperate((String)"submit", (String)entityName, (DynamicObject[])liquidateBills.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationHelper.assertResult(submit);
        if ("C".equals(billStatus)) {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)entityName, (Object[])liquidateBillIds, (OperateOption)option);
            OperationHelper.assertResult(operationResult);
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        return BusinessDataServiceHelper.load((Object[])liquidateBillIds, (DynamicObjectType)entityType);
    }
}

