/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.util.EmptyUtils;

public class PayApplyBillTestHelper {
    public static DynamicObject[] pushPayApplyBill(String sourceEntity, List<Long> srcIds, String applyNo) {
        return PayApplyBillTestHelper.pushPayApplyBill(sourceEntity, srcIds, "C", applyNo);
    }

    public static DynamicObject[] pushPayApplyBill(String sourceEntity, List<Long> srcIds, String billStatus, String applyNo) {
        return PayApplyBillTestHelper.pushPayApplyBill(BigDecimal.valueOf(999999L), sourceEntity, srcIds, billStatus, applyNo);
    }

    public static DynamicObject[] pushPayApplyBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String applyNo) {
        return PayApplyBillTestHelper.pushPayApplyBill(deleteAmt, sourceEntity, srcIds, "C", applyNo);
    }

    public static DynamicObject[] fullPushPayApply(String sourceEntity, List<Long> srcIds, String applyNo) {
        return PayApplyBillTestHelper.pushPayApplyBill(null, sourceEntity, srcIds, "C", applyNo);
    }

    public static DynamicObject[] pushPayApplyBill(BigDecimal deleteAmt, String sourceEntity, List<Long> srcIds, String billStatus, String applyNo) {
        List<DynamicObject> applyBills = BOTPHelper.push(sourceEntity, "ap_payapply", srcIds);
        DynamicObject[] applyBillArray = applyBills.toArray(new DynamicObject[0]);
        DynamicObject applyBill = applyBillArray[0];
        DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
        if (deleteAmt != null && BigDecimal.ZERO.compareTo(deleteAmt) != 0) {
            int precision = applyBill.getDynamicObject("settlecurrency").getInt("amtprecision");
            BigDecimal headAmt = BigDecimal.ZERO;
            BigDecimal headLocalAmt = BigDecimal.ZERO;
            for (int i = entry.size() - 1; i >= 0; --i) {
                DynamicObject row = (DynamicObject)entry.get(i);
                if (deleteAmt.compareTo(row.getBigDecimal("e_payamount")) == 0) {
                    entry.remove(i);
                    continue;
                }
                BigDecimal changeAmt = row.getBigDecimal("e_payamount").divide(BigDecimal.valueOf(2L));
                BigDecimal changeLocalAmt = changeAmt.multiply(applyBill.getBigDecimal("exchangerate")).setScale(precision, RoundingMode.HALF_UP);
                row.set("e_applyamount", (Object)changeAmt);
                row.set("e_approvedamt", (Object)changeAmt);
                row.set("e_appseleamount", (Object)changeLocalAmt);
                row.set("e_approvedseleamt", (Object)changeLocalAmt);
                headAmt = headAmt.add(changeAmt);
                headLocalAmt = headLocalAmt.add(changeLocalAmt);
            }
            applyBill.set("applyamount", (Object)headAmt);
            applyBill.set("approvalamount", (Object)headAmt);
            applyBill.set("appseleamount", (Object)headLocalAmt);
            applyBill.set("aprseleamount", (Object)headLocalAmt);
        }
        PayApplyBillTestHelper.fillValueInPayApply(applyBillArray);
        OperateOption option = OperateOption.create();
        OperationResult save = OperationServiceHelper.executeOperate((String)"save", (String)"ap_payapply", (DynamicObject[])applyBillArray, (OperateOption)option);
        OperationHelper.assertResult(save);
        Object[] applyIds = (Long[])Arrays.stream(applyBillArray).map(apply -> apply.getLong("id")).toArray(Long[]::new);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ap_payapply");
        if (EmptyUtils.isNotEmpty(applyNo)) {
            applyBillArray = BusinessDataServiceHelper.load((Object[])applyIds, (DynamicObjectType)entityType);
            applyBillArray[0].set("billno", (Object)applyNo);
            SaveServiceHelper.save((DynamicObject[])applyBillArray);
        }
        if ("B".equals(billStatus) || "C".equals(billStatus)) {
            OperationResult submit = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_payapply", (Object[])applyIds, (OperateOption)option);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            OperationHelper.assertResult(submit);
        }
        if ("C".equals(billStatus)) {
            OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_payapply", (Object[])applyIds, (OperateOption)option);
            OperationHelper.assertResult(audit);
        }
        return BusinessDataServiceHelper.load((Object[])applyIds, (DynamicObjectType)entityType);
    }

    public static void changeApprovedAmt(DynamicObject[] applyBills) {
        BigDecimal approvalamount = BigDecimal.ZERO;
        BigDecimal aprseleamount = BigDecimal.ZERO;
        DynamicObjectCollection entry = applyBills[0].getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            BigDecimal changeAmt = row.getBigDecimal("e_approvedamt").divide(BigDecimal.valueOf(2L));
            BigDecimal changeLocalAmt = row.getBigDecimal("e_approvedseleamt").divide(BigDecimal.valueOf(2L));
            row.set("e_approvedamt", (Object)changeAmt);
            row.set("e_approvedseleamt", (Object)changeLocalAmt);
            approvalamount = approvalamount.add(changeAmt);
            aprseleamount = aprseleamount.add(changeLocalAmt);
        }
        applyBills[0].set("approvalamount", (Object)approvalamount);
        applyBills[0].set("aprseleamount", (Object)aprseleamount);
        OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_payapply", (DynamicObject[])applyBills, (OperateOption)OperateOption.create());
        KDAssert.assertEquals((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)audit.isSuccess());
    }

    public static DynamicObject setEntryAmt(DynamicObject payApplyBill, BigDecimal[] expectedEntryAmtArray) {
        DynamicObjectCollection detailEntries = payApplyBill.getDynamicObjectCollection("entry");
        BigDecimal exchangeRate = payApplyBill.getBigDecimal("exchangerate");
        BigDecimal headTotalApplyAmt = BigDecimal.ZERO;
        BigDecimal headTotalApplyLocalAmt = BigDecimal.ZERO;
        for (int i = 0; i < detailEntries.size(); ++i) {
            DynamicObject detailEntryRow = (DynamicObject)detailEntries.get(i);
            BigDecimal applyAmt = expectedEntryAmtArray[i];
            BigDecimal applyLocalAmt = applyAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
            detailEntryRow.set("e_applyamount", (Object)applyAmt);
            detailEntryRow.set("e_appseleamount", (Object)applyLocalAmt);
            detailEntryRow.set("e_approvedamt", (Object)applyAmt);
            detailEntryRow.set("e_approvedseleamt", (Object)applyLocalAmt);
            headTotalApplyAmt = headTotalApplyAmt.add(applyAmt);
            headTotalApplyLocalAmt = headTotalApplyLocalAmt.add(applyLocalAmt);
        }
        payApplyBill.set("applyamount", (Object)headTotalApplyAmt);
        payApplyBill.set("appseleamount", (Object)headTotalApplyLocalAmt);
        payApplyBill.set("approvalamount", (Object)headTotalApplyAmt);
        payApplyBill.set("aprseleamount", (Object)headTotalApplyLocalAmt);
        return payApplyBill;
    }

    private static void fillValueInPayApply(DynamicObject[] payApplys) {
        for (DynamicObject payApply : payApplys) {
            DynamicObject settleOrg = payApply.getDynamicObject("settleorg");
            payApply.set("applyorg", (Object)settleOrg);
            payApply.set("payorg", (Object)settleOrg);
            payApply.set("purorg", (Object)settleOrg);
            DynamicObjectCollection entry = payApply.getDynamicObjectCollection("entry");
            String sourceBillType = payApply.getString("sourcebilltype");
            DynamicObject casPaymentBillType = "pm_purorderbill".equals(sourceBillType) ? BusinessDataServiceHelper.loadSingleFromCache((Object)180908838558385152L, (String)"cas_paymentbilltype") : (sourceBillType.contains("ap_") || sourceBillType.contains("ar_") ? BaseDataTestProvider.getPaymentType() : BusinessDataServiceHelper.loadSingleFromCache((Object)180909827147451392L, (String)"cas_paymentbilltype"));
            entry.forEach(row -> row.set("e_paymenttype", (Object)casPaymentBillType));
        }
    }
}

