/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.PurOrderBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurOrderBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.PurOrderBillDataVO;

public class PurOrderBillTestHelper {
    public static DynamicObject getAuditStatusPurOrderBill(BigDecimal[] qtys, BigDecimal[] prices, boolean isUSD, boolean isStorage) {
        ArrayList<PurOrderBillDataDetailVO> entryInfoList = new ArrayList<PurOrderBillDataDetailVO>(qtys.length);
        PurOrderBillDataVO billInfo = new PurOrderBillDataVO();
        if (isUSD) {
            billInfo.setCurrency(BaseDataTestProvider.getCurrencyUSD().getLong("id"));
            billInfo.setExchangeRate(BigDecimal.valueOf(6.5));
        } else {
            billInfo.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id"));
            billInfo.setExchangeRate(BigDecimal.ONE);
        }
        for (int i = 0; i < qtys.length; ++i) {
            PurOrderBillDataDetailVO purOrderDetailVo = new PurOrderBillDataDetailVO();
            purOrderDetailVo.setSeq(i + 1);
            purOrderDetailVo.setQuantity(qtys[i]);
            purOrderDetailVo.setPrice(prices[i]);
            if (isStorage) {
                purOrderDetailVo.setLineTypeId(1194150915045641216L);
            }
            entryInfoList.add(purOrderDetailVo);
        }
        DynamicObject purOrderBill = PurOrderBillTestDataProvider.buildByDetailAndHead(billInfo, entryInfoList);
        purOrderBill = BusinessDataServiceHelper.loadSingle((Object)purOrderBill.getPkValue(), (String)"pm_purorderbill");
        return purOrderBill;
    }
}

