/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class RevCfmTestHelper {
    public static DynamicObject setByHeadConfirmPercent(DynamicObject revCfmBill, BigDecimal percent) {
        revCfmBill.set("confirmway", (Object)"RATE");
        revCfmBill.set("confirmrate", (Object)percent);
        BigDecimal headTotalConfirmAmt = BigDecimal.ZERO;
        BigDecimal headTotalConfirmLocalAmt = BigDecimal.ZERO;
        BigDecimal headTotalUnVerifyAmt = BigDecimal.ZERO;
        DynamicObjectCollection detailEntries = revCfmBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailEntryRow : detailEntries) {
            BigDecimal expectedQty = detailEntryRow.getBigDecimal("e_quantity").multiply(percent.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
            BigDecimal expectedAmt = detailEntryRow.getBigDecimal("e_amount").multiply(percent.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
            BigDecimal expectedLocalAmt = detailEntryRow.getBigDecimal("e_localamt").multiply(percent.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
            detailEntryRow.set("e_unverifyqty", (Object)expectedQty);
            detailEntryRow.set("e_unverifyamt", (Object)expectedAmt);
            detailEntryRow.set("e_confirmrate", (Object)percent);
            detailEntryRow.set("e_confirmamt", (Object)expectedAmt);
            detailEntryRow.set("e_confirmqty", (Object)expectedQty);
            headTotalConfirmAmt = headTotalConfirmAmt.add(expectedAmt);
            headTotalConfirmLocalAmt = headTotalConfirmLocalAmt.add(expectedLocalAmt);
            headTotalUnVerifyAmt = headTotalUnVerifyAmt.add(expectedAmt);
        }
        revCfmBill.set("confirmamt", (Object)headTotalConfirmAmt);
        revCfmBill.set("confirmlocamt", (Object)headTotalConfirmLocalAmt);
        revCfmBill.set("unverifyamt", (Object)headTotalUnVerifyAmt);
        return revCfmBill;
    }

    public static DynamicObject setByHeadConfirmAmt(DynamicObject revCfmBill, BigDecimal[] confirmAmtArray) {
        revCfmBill.set("confirmway", (Object)"AMOUNT");
        BigDecimal headTotalConfirmAmt = BigDecimal.ZERO;
        BigDecimal headTotalConfirmLocalAmt = BigDecimal.ZERO;
        BigDecimal headTotalUnVerifyAmt = BigDecimal.ZERO;
        BigDecimal headConfirmPercent = BigDecimal.ZERO;
        DynamicObjectCollection detailEntries = revCfmBill.getDynamicObjectCollection("entry");
        for (int i = 0; i < detailEntries.size(); ++i) {
            DynamicObject detailEntryRow = (DynamicObject)detailEntries.get(i);
            BigDecimal percent = confirmAmtArray[i].divide(detailEntryRow.getBigDecimal("e_amount"), 10, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
            BigDecimal expectedQty = detailEntryRow.getBigDecimal("e_quantity").multiply(percent.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
            BigDecimal expectedLocalAmt = detailEntryRow.getBigDecimal("e_localamt").multiply(percent.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
            detailEntryRow.set("e_unverifyqty", (Object)expectedQty);
            detailEntryRow.set("e_unverifyamt", (Object)confirmAmtArray[i]);
            detailEntryRow.set("e_confirmrate", (Object)percent);
            detailEntryRow.set("e_confirmamt", (Object)confirmAmtArray[i]);
            detailEntryRow.set("e_confirmqty", (Object)expectedQty);
            headTotalConfirmAmt = headTotalConfirmAmt.add(confirmAmtArray[i]);
            headTotalConfirmLocalAmt = headTotalConfirmLocalAmt.add(expectedLocalAmt);
            headTotalUnVerifyAmt = headTotalUnVerifyAmt.add(confirmAmtArray[i]);
            headConfirmPercent = headConfirmPercent.add(percent);
        }
        revCfmBill.set("confirmamt", (Object)headTotalConfirmAmt);
        revCfmBill.set("confirmlocamt", (Object)headTotalConfirmLocalAmt);
        revCfmBill.set("unverifyamt", (Object)headTotalUnVerifyAmt);
        revCfmBill.set("confirmrate", (Object)headConfirmPercent.divide(BigDecimal.valueOf(detailEntries.size()), 2, RoundingMode.HALF_UP));
        return revCfmBill;
    }

    public static void checkRevCfmExist(long billId, boolean expected) {
        boolean result = QueryServiceHelper.exists((String)"ar_revcfmbill", (Object)billId);
        if (expected) {
            KDAssert.assertTrue((String)"\u4e0b\u6e38\u672a\u627e\u5230\u6536\u5165\u786e\u8ba4\u5355", (boolean)result);
        } else {
            KDAssert.assertFalse((String)"\u4e0b\u6e38\u672a\u627e\u5230\u6536\u5165\u786e\u8ba4\u5355", (boolean)result);
        }
    }

    public static void checkAutoRevCfmExist(long finBillId, boolean expected) {
        Map<String, HashSet<Long>> result = BOTPHelper.findTargetBills("ar_finarbill", finBillId);
        boolean exist = false;
        if (!EmptyUtils.isEmpty(result)) {
            exist = EmptyUtils.isNotEmpty(result.get("ar_revcfmbill"));
        }
        if (expected) {
            KDAssert.assertTrue((String)"\u672a\u81ea\u52a8\u751f\u6210\u6536\u5165\u786e\u8ba4\u5355", (boolean)exist);
        } else {
            KDAssert.assertFalse((String)"\u672a\u81ea\u52a8\u751f\u6210\u6536\u5165\u786e\u8ba4\u5355", (boolean)exist);
        }
    }
}

