/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.framework.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.SaleOrderBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.SaleOrderBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.SaleOrderBillDataVO;

public class SaleOrderTestHelper {
    public static DynamicObject createSaleOrder(String billNo, DynamicObject taxRate, BigDecimal qty_1, BigDecimal price_1, BigDecimal qty_2, BigDecimal price_2) {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        SaleOrderBillDataVO saleInfo = new SaleOrderBillDataVO();
        saleInfo.setBillNo(billNo);
        saleInfo.setOrg(org);
        ArrayList<SaleOrderBillDataDetailVO> saleEntries = new ArrayList<SaleOrderBillDataDetailVO>();
        SaleOrderBillDataDetailVO saleEntryInfo_1 = new SaleOrderBillDataDetailVO();
        saleEntryInfo_1.setQuantity(qty_1);
        saleEntryInfo_1.setPrice(price_1);
        saleEntryInfo_1.setTaxRate(taxRate);
        saleEntries.add(saleEntryInfo_1);
        SaleOrderBillDataDetailVO saleEntryInfo_2 = new SaleOrderBillDataDetailVO();
        saleEntryInfo_2.setQuantity(qty_2);
        saleEntryInfo_2.setPrice(price_2);
        saleEntryInfo_2.setTaxRate(taxRate);
        saleEntries.add(saleEntryInfo_2);
        DynamicObject sale = SaleOrderBillTestDataProvider.buildByDetailEntry(saleInfo, saleEntries);
        return sale;
    }

    public static DynamicObject getCustomer() {
        QFilter filter = new QFilter("ctrlstrategy", "=", (Object)"5");
        DynamicObject selectOne = QueryServiceHelper.queryOne((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{filter});
        if (selectOne == null) {
            throw new KDBizException("\u57fa\u7840\u8d44\u6599-\u5ba2\u6237\u4e0d\u5b58\u5728");
        }
        DynamicObject customer = BusinessDataServiceHelper.loadSingle((Object)selectOne.getLong("id"), (String)"bd_customer");
        return customer;
    }

    public static DynamicObject createSaleOrderByPlanOrg(String billNo, DynamicObject taxRate, BigDecimal qty_1, BigDecimal price_1, BigDecimal qty_2, BigDecimal price_2) {
        SaleOrderBillDataVO saleInfo = new SaleOrderBillDataVO();
        saleInfo.setBillNo(billNo);
        saleInfo.setOrg(BaseDataTestProvider.getPlanInitOrg());
        ArrayList<SaleOrderBillDataDetailVO> saleEntries = new ArrayList<SaleOrderBillDataDetailVO>();
        SaleOrderBillDataDetailVO saleEntryInfo_1 = new SaleOrderBillDataDetailVO();
        saleEntryInfo_1.setQuantity(qty_1);
        saleEntryInfo_1.setPrice(price_1);
        saleEntryInfo_1.setTaxRate(taxRate);
        saleEntries.add(saleEntryInfo_1);
        SaleOrderBillDataDetailVO saleEntryInfo_2 = new SaleOrderBillDataDetailVO();
        saleEntryInfo_2.setQuantity(qty_2);
        saleEntryInfo_2.setPrice(price_2);
        saleEntryInfo_2.setTaxRate(taxRate);
        saleEntries.add(saleEntryInfo_2);
        DynamicObject sale = SaleOrderBillTestDataProvider.buildByDetailEntry(saleInfo, saleEntries);
        return sale;
    }

    public static void deleteBill(String entityName, String ... billnos) {
        ArrayList<String> billNoList = new ArrayList<String>(billnos.length);
        for (int i = 0; i < billnos.length; ++i) {
            billNoList.add(billnos[i]);
        }
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter("billno", "in", billNoList)});
    }

    public static DynamicObject createSaleOrder(String billNo, String billTypeNumber, DynamicObject taxRate, BigDecimal qty_1, BigDecimal price_1, BigDecimal qty_2, BigDecimal price_2) {
        SaleOrderBillDataVO saleInfo = new SaleOrderBillDataVO();
        saleInfo.setBillNo(billNo);
        saleInfo.setBillType(billTypeNumber);
        ArrayList<SaleOrderBillDataDetailVO> saleEntries = new ArrayList<SaleOrderBillDataDetailVO>();
        SaleOrderBillDataDetailVO saleEntryInfo_1 = new SaleOrderBillDataDetailVO();
        saleEntryInfo_1.setQuantity(qty_1);
        saleEntryInfo_1.setPrice(price_1);
        saleEntryInfo_1.setTaxRate(taxRate);
        saleEntries.add(saleEntryInfo_1);
        SaleOrderBillDataDetailVO saleEntryInfo_2 = new SaleOrderBillDataDetailVO();
        saleEntryInfo_2.setQuantity(qty_2);
        saleEntryInfo_2.setPrice(price_2);
        saleEntryInfo_2.setTaxRate(taxRate);
        saleEntries.add(saleEntryInfo_2);
        DynamicObject sale = SaleOrderBillTestDataProvider.buildByDetailEntry(saleInfo, saleEntries);
        return sale;
    }
}

