/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.basic;

import java.util.HashSet;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.fi.arapcommon.service.concurrency.BillConcuControlParam;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.concurrency.IBillConcurrencyCtrlStrategy;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import org.junit.Test;

public class ConcurrencyCtrlUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u5355\u7ebf\u7a0b-\u540c\u4e1a\u52a1-\u5bf9\u540c\u4e00\u6279\u5355\u636e\u91cd\u590d\u52a0\u9501-\u975e\u4e8b\u52a1")
    @Test
    public void testCase1() {
        HashSet<Long> billIds = new HashSet<Long>(2);
        billIds.add(1L);
        billIds.add(2L);
        BillConcuControlParam param = new BillConcuControlParam("ap_finapbill", "unittest", billIds, false);
        IBillConcurrencyCtrlStrategy ctrlStrategy = ConcurrencyCtrlUtil.addCtrl(param);
        ctrlStrategy.releaseCtrl();
        ctrlStrategy = ConcurrencyCtrlUtil.addCtrl(param);
        ctrlStrategy.releaseCtrl();
        ctrlStrategy = ConcurrencyCtrlUtil.addCtrl(param);
        try {
            ConcurrencyCtrlUtil.addCtrl(param);
        }
        catch (Exception e) {
            KDException kde = (KDException)e;
            ConcurrencyCtrlUnitTest.assertEquals((String)"unittest_datamutex", (String)kde.getErrorCode().getCode());
        }
        ctrlStrategy.releaseCtrl();
        ConcurrencyCtrlUnitTest.assertEquals((int)1, (int)1);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5355\u7ebf\u7a0b-\u540c\u4e1a\u52a1-\u5bf9\u540c\u4e00\u6279\u5355\u636e\u91cd\u590d\u52a0\u9501-\u4e8b\u52a1")
    @Test
    public void testCase2() {
        ConcurrencyCtrlUnitTest.assertEquals((int)1, (int)1);
        try (TXHandle tx = TX.required((String)"testCase2");){
            HashSet<Long> billIds = new HashSet<Long>(2);
            billIds.add(21L);
            billIds.add(22L);
            BillConcuControlParam param = new BillConcuControlParam("ap_finapbill", "unittest", billIds, false);
            ConcurrencyCtrlUtil.addCtrlInTX(param);
            ConcurrencyCtrlUtil.addCtrlInTX(param);
            HashSet<Long> billIds2 = new HashSet<Long>(2);
            billIds2.add(23L);
            billIds2.add(22L);
            BillConcuControlParam param2 = new BillConcuControlParam("ap_finapbill", "settle", billIds2, false);
            ConcurrencyCtrlUtil.addCtrlInTX(param2);
        }
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5355\u7ebf\u7a0b-\u4e0d\u540c\u4e1a\u52a1-\u975e\u4e8b\u52a1")
    @Test
    public void testCase3() {
        ConcurrencyCtrlUnitTest.assertEquals((int)1, (int)1);
        HashSet<Long> billIds = new HashSet<Long>(1);
        billIds.add(1L);
        BillConcuControlParam param = new BillConcuControlParam("ap_finapbill", "unittest-1", billIds, false);
        IBillConcurrencyCtrlStrategy ctrlStrategy = ConcurrencyCtrlUtil.addCtrl(param);
        ctrlStrategy.releaseCtrl();
        billIds.clear();
        billIds.add(1L);
        BillConcuControlParam param2 = new BillConcuControlParam("ap_finapbill", "unittest-2", billIds, false);
        IBillConcurrencyCtrlStrategy ctrlStrategy2 = ConcurrencyCtrlUtil.addCtrl(param2);
        ctrlStrategy2.releaseCtrl();
        ConcurrencyCtrlUnitTest.assertEquals((int)1, (int)1);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u5355\u7ebf\u7a0b-\u4e0d\u540c\u4e1a\u52a1-\u4e8b\u52a1")
    @Test
    public void testCase4() {
        ConcurrencyCtrlUnitTest.assertEquals((int)1, (int)1);
        try (TXHandle tx = TX.required((String)"testCase4");){
            HashSet<Long> billIds = new HashSet<Long>(1);
            billIds.add(1L);
            BillConcuControlParam param = new BillConcuControlParam("ap_finapbill", "unittest-1", billIds, false);
            ConcurrencyCtrlUtil.addCtrlInTX(param);
            billIds.clear();
            billIds.add(1L);
            BillConcuControlParam param2 = new BillConcuControlParam("ap_finapbill", "unittest-2", billIds, false);
            ConcurrencyCtrlUtil.addCtrlInTX(param2);
            ConcurrencyCtrlUnitTest.assertEquals((int)1, (int)1);
        }
    }

    @TestMethod(value=5)
    @DisplayName(value="\u591a\u7ebf\u7a0b-\u540c\u4e1a\u52a1-\u975e\u4e8b\u52a1")
    @Test
    public void testCase5() {
        ThreadPool pool = ThreadPools.newFixedThreadPool((String)"testCase5", (int)2, (String)"ap");
        pool.execute(() -> {
            try {
                HashSet<Long> billIds = new HashSet<Long>(1);
                billIds.add(51L);
                BillConcuControlParam param = new BillConcuControlParam("ap_finapbill", "unittest", billIds, false);
                IBillConcurrencyCtrlStrategy ctrlStrategy = ConcurrencyCtrlUtil.addCtrl(param);
                ctrlStrategy.releaseCtrl();
            }
            catch (Exception e) {
                KDException kde = (KDException)e;
                ConcurrencyCtrlUnitTest.assertEquals((String)"unittest_datamutex", (String)kde.getErrorCode().getCode());
            }
        });
        pool.execute(() -> {
            try {
                HashSet<Long> billIds = new HashSet<Long>(1);
                billIds.add(51L);
                BillConcuControlParam param = new BillConcuControlParam("ap_finapbill", "unittest", billIds, false);
                IBillConcurrencyCtrlStrategy ctrlStrategy = ConcurrencyCtrlUtil.addCtrl(param);
                ctrlStrategy.releaseCtrl();
            }
            catch (Exception e) {
                KDException kde = (KDException)e;
                ConcurrencyCtrlUnitTest.assertEquals((String)"unittest_datamutex", (String)kde.getErrorCode().getCode());
            }
        });
        ConcurrencyCtrlUnitTest.assertEquals((int)1, (int)1);
        pool.close();
    }

    @TestMethod(value=6)
    @DisplayName(value="\u591a\u7ebf\u7a0b-\u540c\u4e1a\u52a1-\u4e8b\u52a1")
    @Test
    public void testCase6() {
        ThreadPool pool = ThreadPools.newFixedThreadPool((String)"testCase6", (int)2, (String)"ap");
        pool.execute(() -> {
            try (TXHandle tx = TX.required((String)"testCase6");){
                HashSet<Long> billIds = new HashSet<Long>(1);
                billIds.add(61L);
                BillConcuControlParam param = new BillConcuControlParam("ap_finapbill", "unittest", billIds, false);
                ConcurrencyCtrlUtil.addCtrlInTX(param);
            }
            catch (Exception e) {
                KDException kde = (KDException)e;
                ConcurrencyCtrlUnitTest.assertEquals((String)"unittest_datamutex", (String)kde.getErrorCode().getCode());
            }
        });
        pool.execute(() -> {
            try (TXHandle tx = TX.required((String)"testCase6");){
                HashSet<Long> billIds = new HashSet<Long>(1);
                billIds.add(61L);
                BillConcuControlParam param = new BillConcuControlParam("ap_finapbill", "unittest", billIds, false);
                ConcurrencyCtrlUtil.addCtrlInTX(param);
            }
            catch (Exception e) {
                KDException kde = (KDException)e;
                ConcurrencyCtrlUnitTest.assertEquals((String)"unittest_datamutex", (String)kde.getErrorCode().getCode());
            }
        });
        ConcurrencyCtrlUnitTest.assertEquals((int)1, (int)1);
        pool.close();
    }

    @TestMethod(value=7)
    @DisplayName(value="\u5355\u7ebf\u7a0b-\u7ed3\u7b97\u4e1a\u52a1-\u4e8b\u52a1")
    @Test
    public void testCase7() {
        try (TXHandle tx = TX.required((String)"testCase7");){
            try {
                ConcurrencyCtrlUnitTest.assertEquals((int)1, (int)1);
                HashSet<Long> billIds = new HashSet<Long>(2);
                billIds.add(71L);
                billIds.add(72L);
                CommonSettleServiceHelper.settleAddMutexCtrlInTX(billIds, "ap_finapbill", false);
                CommonSettleServiceHelper.settleAddMutexCtrlInTX(billIds, "ap_finapbill", false);
                HashSet<Long> asstBillIds = new HashSet<Long>(2);
                asstBillIds.add(72L);
                asstBillIds.add(73L);
                CommonSettleServiceHelper.settleAddMutexCtrlInTX(billIds, "ap_finapbill", asstBillIds, "ap_finapbill", false);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    @TestMethod(value=8)
    @DisplayName(value="\u591a\u7ebf\u7a0b-\u7ed3\u7b97\u4e1a\u52a1-\u4e8b\u52a1")
    @Test
    public void testCase8() {
        ThreadPool pool = ThreadPools.newFixedThreadPool((String)"testCase8", (int)2, (String)"ap");
        pool.submit(() -> {
            try (TXHandle tx = TX.required((String)"testCase8");){
                HashSet<Long> billIds = new HashSet<Long>(2);
                billIds.add(81L);
                billIds.add(82L);
                HashSet<Long> asstBillIds = new HashSet<Long>(2);
                asstBillIds.add(82L);
                asstBillIds.add(83L);
                CommonSettleServiceHelper.settleAddMutexCtrlInTX(billIds, "ap_finapbill", asstBillIds, "ap_finapbill", false);
            }
            catch (Exception e) {
                KDException kde = (KDException)e;
                ConcurrencyCtrlUnitTest.assertEquals((String)"settle_datamutex", (String)kde.getErrorCode().getCode());
            }
            return null;
        });
        pool.submit(() -> {
            try (TXHandle tx = TX.required((String)"testCase8");){
                HashSet<Long> billIds = new HashSet<Long>(2);
                billIds.add(83L);
                billIds.add(84L);
                HashSet<Long> asstBillIds = new HashSet<Long>(2);
                asstBillIds.add(85L);
                asstBillIds.add(86L);
                CommonSettleServiceHelper.settleAddMutexCtrlInTX(billIds, "ap_finapbill", asstBillIds, "ap_finapbill", false);
            }
            catch (Exception e) {
                KDException kde = (KDException)e;
                ConcurrencyCtrlUnitTest.assertEquals((String)"settle_datamutex", (String)kde.getErrorCode().getCode());
            }
            return null;
        });
        ConcurrencyCtrlUnitTest.assertEquals((int)1, (int)1);
        pool.close();
    }
}

