/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.BusApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.BusArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasPayBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.PaidBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.PayApplyBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.BusApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.BusArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.PaidBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.PayApplyBillDataDetailVO;
import org.junit.Test;

public class BaseDataUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u57fa\u7840\u6570\u636e\u6d4b\u8bd5")
    @Test
    public void testBaseData() {
        DynamicObject unInitOrg = BaseDataTestProvider.getUnInitOrg();
        BaseDataUnitTest.assertEquals((String)"APORG-0001", (String)unInitOrg.getString("number"));
        DynamicObject detailInitOrg = BaseDataTestProvider.getDetailInitOrg();
        BaseDataUnitTest.assertEquals((String)"APORG-0002", (String)detailInitOrg.getString("number"));
        DynamicObject planInitOrg = BaseDataTestProvider.getPlanInitOrg();
        BaseDataUnitTest.assertEquals((String)"APORG-0003", (String)planInitOrg.getString("number"));
        BaseDataTestProvider.getCustomer();
        BaseDataTestProvider.getSupplier();
        BaseDataTestProvider.getMaterial();
        BaseDataTestProvider.getExpenseItem();
        BaseDataTestProvider.getPayProperty();
        BaseDataTestProvider.getPaymentType();
        BaseDataTestProvider.getCurrencyCNY();
        BaseDataTestProvider.getCurrencyUSD();
        BaseDataTestProvider.getExtrateTable();
        BaseDataTestProvider.getTaxRate();
        BaseDataTestProvider.getRecProperty();
        BaseDataTestProvider.getReceivingType();
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u4ed8\u5355\u63d0\u4f9b\u7c7b\u6d4b\u8bd5")
    @Test
    public void testFinApData() {
        DynamicObject apBill0 = FinApBillTestDataProvider.buildByHeadPriceTaxTotal(BigDecimal.valueOf(100L));
        this.checkApBill(new BigDecimal("100.00"), FinApBillTestDataProvider.loadSingle(apBill0.getLong("id")));
        DynamicObject apBill1 = FinApBillTestDataProvider.buildByHeadPriceTaxTotal("FinApDataTest-001", BigDecimal.valueOf(200L));
        BaseDataUnitTest.assertEquals((String)"FinApDataTest-001", (String)apBill1.getString("billno"));
        this.checkApBill(new BigDecimal("200.00"), FinApBillTestDataProvider.loadSingle(apBill1.getLong("id")));
        DynamicObject apBill2 = FinApBillTestDataProvider.buildByHeadPriceTaxTotal("FinApDataTest-002", BaseDataTestProvider.getPlanInitOrg(), BigDecimal.valueOf(1000L));
        BaseDataUnitTest.assertEquals((String)"FinApDataTest-002", (String)apBill2.getString("billno"));
        BaseDataUnitTest.assertEquals((String)"APORG-0003", (String)apBill2.getDynamicObject("org").getString("number"));
        this.checkApBill(new BigDecimal("1000.00"), FinApBillTestDataProvider.loadSingle(apBill2.getLong("id")));
        ArrayList<FinApBillDataDetailVO> entryInfoList = new ArrayList<FinApBillDataDetailVO>(2);
        entryInfoList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(120L)).setQuantity(BigDecimal.valueOf(5L)));
        entryInfoList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(200L)).setQuantity(BigDecimal.valueOf(3L)));
        DynamicObject apBill3 = FinApBillTestDataProvider.buildByPriceAndQuantity(entryInfoList);
        this.checkApBill(new BigDecimal("1200.00"), FinApBillTestDataProvider.loadSingle(apBill3.getLong("id")));
        DynamicObject tailData = FinApBillTestDataProvider.buildTailData("FinApDataTest-taildata");
        this.checkApBill(new BigDecimal("3.00"), FinApBillTestDataProvider.loadSingle(tailData.getLong("id")));
    }

    @TestMethod(value=3)
    @DisplayName(value="\u4ed8\u6b3e\u5355\u63d0\u4f9b\u7c7b\u6d4b\u8bd5")
    @Test
    public void testCasPayData() {
        DynamicObject payBill0 = CasPayBillTestDataProvider.buildByHeadPriceTaxTotal(new BigDecimal("100.00"));
        this.checkPayBill(new BigDecimal("100.00"), CasPayBillTestDataProvider.loadSingle(payBill0.getLong("id")));
        DynamicObject payBill1 = CasPayBillTestDataProvider.buildByHeadPriceTaxTotal("CasPayDataTest-001", new BigDecimal("200.00"));
        BaseDataUnitTest.assertEquals((String)"CasPayDataTest-001", (String)payBill1.getString("billno"));
        this.checkPayBill(new BigDecimal("200.00"), CasPayBillTestDataProvider.loadSingle(payBill1.getLong("id")));
        ArrayList<CasPayBillDataDetailVO> entryInfoList = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(new BigDecimal("200.00")));
        entryInfoList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(new BigDecimal("300.00")));
        DynamicObject payBill2 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal(entryInfoList);
        this.checkPayBill(new BigDecimal("500.00"), CasPayBillTestDataProvider.loadSingle(payBill2.getLong("id")));
    }

    @TestMethod(value=4)
    @DisplayName(value="\u5e94\u6536\u5355\u63d0\u4f9b\u7c7b\u6d4b\u8bd5")
    @Test
    public void testFinArData() {
        DynamicObject arBill0 = FinArBillTestDataProvider.buildByHeadPriceTaxTotal(BigDecimal.valueOf(100L));
        this.checkArBill(new BigDecimal("100.00"), FinArBillTestDataProvider.loadSingle(arBill0.getLong("id")));
        DynamicObject arBill1 = FinArBillTestDataProvider.buildByHeadPriceTaxTotal("FinArDataTest-001", BigDecimal.valueOf(200L));
        BaseDataUnitTest.assertEquals((String)"FinArDataTest-001", (String)arBill1.getString("billno"));
        this.checkArBill(new BigDecimal("200.00"), FinArBillTestDataProvider.loadSingle(arBill1.getLong("id")));
        DynamicObject arBill2 = FinArBillTestDataProvider.buildByHeadPriceTaxTotal("FinArDataTest-002", BaseDataTestProvider.getPlanInitOrg(), BigDecimal.valueOf(1000L));
        BaseDataUnitTest.assertEquals((String)"FinArDataTest-002", (String)arBill2.getString("billno"));
        BaseDataUnitTest.assertEquals((String)"APORG-0003", (String)arBill2.getDynamicObject("org").getString("number"));
        this.checkArBill(new BigDecimal("1000.00"), FinArBillTestDataProvider.loadSingle(arBill2.getLong("id")));
        ArrayList<FinArBillDataDetailVO> entryInfoList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(120L)).setQuantity(BigDecimal.valueOf(5L)));
        entryInfoList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(200L)).setQuantity(BigDecimal.valueOf(3L)));
        DynamicObject arBill3 = FinArBillTestDataProvider.buildByPriceAndQuantity(entryInfoList);
        this.checkArBill(new BigDecimal("1200.00"), FinArBillTestDataProvider.loadSingle(arBill3.getLong("id")));
        DynamicObject tailData = FinArBillTestDataProvider.buildTailData("FinApDataTest-taildata");
        this.checkArBill(new BigDecimal("3.00"), FinArBillTestDataProvider.loadSingle(tailData.getLong("id")));
    }

    @TestMethod(value=5)
    @DisplayName(value="\u6536\u6b3e\u5355\u63d0\u4f9b\u7c7b\u6d4b\u8bd5")
    @Test
    public void testCasRecData() {
        DynamicObject recBill0 = CasRecBillTestDataProvider.buildByHeadPriceTaxTotal(new BigDecimal("100.00"));
        this.checkRecBill(new BigDecimal("100.00"), CasRecBillTestDataProvider.loadSingle(recBill0.getLong("id")));
        DynamicObject recBill1 = CasRecBillTestDataProvider.buildByHeadPriceTaxTotal("CasRecDataTest-001", new BigDecimal("200.00"));
        BaseDataUnitTest.assertEquals((String)"CasRecDataTest-001", (String)recBill1.getString("billno"));
        this.checkRecBill(new BigDecimal("200.00"), CasRecBillTestDataProvider.loadSingle(recBill1.getLong("id")));
        ArrayList<CasRecBillDataDetailVO> entryInfoList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(new BigDecimal("200.00")));
        entryInfoList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(new BigDecimal("300.00")));
        DynamicObject casBill2 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal(entryInfoList);
        this.checkRecBill(new BigDecimal("500.00"), CasRecBillTestDataProvider.loadSingle(casBill2.getLong("id")));
    }

    @TestMethod(value=6)
    @DisplayName(value="\u6682\u4f30\u5e94\u4ed8\u5355\u63d0\u4f9b\u7c7b\u6d4b\u8bd5")
    @Test
    public void testBusApData() {
        DynamicObject apBill0 = BusApBillTestDataProvider.buildByHeadPriceTaxTotal(BigDecimal.valueOf(100L));
        this.checkBusApBill(new BigDecimal("100.00"), BusApBillTestDataProvider.loadSingle(apBill0.getLong("id")));
        DynamicObject apBill1 = BusApBillTestDataProvider.buildByHeadPriceTaxTotal("BusApDataTest-001", BigDecimal.valueOf(200L));
        BaseDataUnitTest.assertEquals((String)"BusApDataTest-001", (String)apBill1.getString("billno"));
        this.checkBusApBill(new BigDecimal("200.00"), BusApBillTestDataProvider.loadSingle(apBill1.getLong("id")));
        DynamicObject apBill2 = BusApBillTestDataProvider.buildByHeadPriceTaxTotal("BusApDataTest-002", BaseDataTestProvider.getPlanInitOrg(), BigDecimal.valueOf(1000L));
        BaseDataUnitTest.assertEquals((String)"BusApDataTest-002", (String)apBill2.getString("billno"));
        this.checkBusApBill(new BigDecimal("1000.00"), BusApBillTestDataProvider.loadSingle(apBill2.getLong("id")));
        ArrayList<BusApBillDataDetailVO> entryInfoList = new ArrayList<BusApBillDataDetailVO>(2);
        entryInfoList.add(BusApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(120L)).setQuantity(BigDecimal.valueOf(5L)));
        entryInfoList.add(BusApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(200L)).setQuantity(BigDecimal.valueOf(3L)));
        DynamicObject apBill3 = BusApBillTestDataProvider.buildByPriceAndQuantity(entryInfoList);
        this.checkBusApBill(new BigDecimal("1200.00"), BusApBillTestDataProvider.loadSingle(apBill3.getLong("id")));
    }

    @TestMethod(value=7)
    @DisplayName(value="\u6682\u4f30\u5e94\u6536\u5355\u63d0\u4f9b\u7c7b\u6d4b\u8bd5")
    @Test
    public void testBusArData() {
        DynamicObject apBill0 = BusArBillTestDataProvider.buildByHeadPriceTaxTotal(BigDecimal.valueOf(100L));
        this.checkBusArBill(new BigDecimal("100.00"), BusArBillTestDataProvider.loadSingle(apBill0.getLong("id")));
        DynamicObject apBill1 = BusArBillTestDataProvider.buildByHeadPriceTaxTotal("BusArDataTest-001", BigDecimal.valueOf(200L));
        BaseDataUnitTest.assertEquals((String)"BusArDataTest-001", (String)apBill1.getString("billno"));
        this.checkBusArBill(new BigDecimal("200.00"), BusArBillTestDataProvider.loadSingle(apBill1.getLong("id")));
        DynamicObject apBill2 = BusArBillTestDataProvider.buildByHeadPriceTaxTotal("BusArDataTest-002", BaseDataTestProvider.getPlanInitOrg(), BigDecimal.valueOf(1000L));
        BaseDataUnitTest.assertEquals((String)"BusArDataTest-002", (String)apBill2.getString("billno"));
        this.checkBusArBill(new BigDecimal("1000.00"), BusArBillTestDataProvider.loadSingle(apBill2.getLong("id")));
        ArrayList<BusArBillDataDetailVO> entryInfoList = new ArrayList<BusArBillDataDetailVO>(2);
        entryInfoList.add(BusArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(120L)).setQuantity(BigDecimal.valueOf(5L)));
        entryInfoList.add(BusArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(200L)).setQuantity(BigDecimal.valueOf(3L)));
        DynamicObject apBill3 = BusArBillTestDataProvider.buildByPriceAndQuantity(entryInfoList);
        this.checkBusArBill(new BigDecimal("1200.00"), BusArBillTestDataProvider.loadSingle(apBill3.getLong("id")));
    }

    @TestMethod(value=8)
    @DisplayName(value="\u4ed8\u6b3e\u7533\u8bf7\u5355\u63d0\u4f9b\u7c7b\u6d4b\u8bd5")
    @Test
    public void testPayApplyData() {
        DynamicObject payBill0 = PayApplyBillTestDataProvider.buildByHeadPriceTaxTotal(new BigDecimal("100.00"));
        this.checkPayApplyBill(new BigDecimal("100.00"), PayApplyBillTestDataProvider.loadSingle(payBill0.getLong("id")));
        DynamicObject payBill1 = PayApplyBillTestDataProvider.buildByHeadPriceTaxTotal("PayApplyDataTest-001", new BigDecimal("200.00"));
        BaseDataUnitTest.assertEquals((String)"PayApplyDataTest-001", (String)payBill1.getString("billno"));
        this.checkPayApplyBill(new BigDecimal("200.00"), PayApplyBillTestDataProvider.loadSingle(payBill1.getLong("id")));
        ArrayList<PayApplyBillDataDetailVO> entryInfoList = new ArrayList<PayApplyBillDataDetailVO>(2);
        entryInfoList.add(PayApplyBillDataDetailVO.New().setPriceTaxTotal(new BigDecimal("200.00")));
        entryInfoList.add(PayApplyBillDataDetailVO.New().setPriceTaxTotal(new BigDecimal("300.00")));
        DynamicObject payBill2 = PayApplyBillTestDataProvider.buildByEntryAmount(entryInfoList);
        this.checkPayApplyBill(new BigDecimal("500.00"), PayApplyBillTestDataProvider.loadSingle(payBill2.getLong("id")));
    }

    @TestMethod(value=9)
    @DisplayName(value="\u671f\u521d\u9884\u4ed8\u5355\u63d0\u4f9b\u7c7b\u6d4b\u8bd5")
    @Test
    public void testPaidData() {
        DynamicObject payBill0 = PaidBillTestDataProvider.buildByHeadPriceTaxTotal(new BigDecimal("100.00"));
        this.checkPaidBill(new BigDecimal("100.00"), PaidBillTestDataProvider.loadSingle(payBill0.getLong("id")));
        DynamicObject payBill1 = PaidBillTestDataProvider.buildByHeadPriceTaxTotal("PaidDataTest-001", new BigDecimal("200.00"));
        BaseDataUnitTest.assertEquals((String)"PaidDataTest-001", (String)payBill1.getString("billno"));
        this.checkPaidBill(new BigDecimal("200.00"), PaidBillTestDataProvider.loadSingle(payBill1.getLong("id")));
        ArrayList<PaidBillDataDetailVO> entryInfoList = new ArrayList<PaidBillDataDetailVO>(2);
        entryInfoList.add(PaidBillDataDetailVO.New().setPriceTaxTotal(new BigDecimal("200.00")));
        entryInfoList.add(PaidBillDataDetailVO.New().setPriceTaxTotal(new BigDecimal("300.00")));
        DynamicObject payBill2 = PaidBillTestDataProvider.buildByEntryPriceTaxTotal(entryInfoList);
        this.checkPaidBill(new BigDecimal("500.00"), PaidBillTestDataProvider.loadSingle(payBill2.getLong("id")));
    }

    private void checkApBill(BigDecimal expectedAmt, DynamicObject bill) {
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("pricetaxtotal"));
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("amount"));
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("unsettleamount"));
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("unverifyamount"));
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("uninvoicedamt"));
        DynamicObjectCollection detailEntries = bill.getDynamicObjectCollection("detailentry");
        BigDecimal remainDetailTotalAmt = BigDecimal.ZERO;
        BigDecimal remainDetailLocalTotalAmt = BigDecimal.ZERO;
        for (DynamicObject detailEntry : detailEntries) {
            BigDecimal priceTaxTotal = detailEntry.getBigDecimal("e_pricetaxtotal");
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, detailEntry.getBigDecimal("e_amount"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, detailEntry.getBigDecimal("unlockamt"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, detailEntry.getBigDecimal("unsettleamt"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, detailEntry.getBigDecimal("e_unverifyamount"));
            BigDecimal priceTaxLocalTotal = detailEntry.getBigDecimal("e_pricetaxtotalbase");
            BaseDataUnitTest.assertAmtEquals(priceTaxLocalTotal, detailEntry.getBigDecimal("unsettleamtbase"));
            remainDetailTotalAmt = remainDetailTotalAmt.add(priceTaxTotal);
            remainDetailLocalTotalAmt = remainDetailLocalTotalAmt.add(priceTaxLocalTotal);
        }
        DynamicObjectCollection planEntries = bill.getDynamicObjectCollection("planentity");
        BigDecimal remainPlanTotalAmt = BigDecimal.ZERO;
        BigDecimal remainPlanLocalTotalAmt = BigDecimal.ZERO;
        for (DynamicObject planEntry : planEntries) {
            BigDecimal priceTaxTotal = planEntry.getBigDecimal("planpricetax");
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, planEntry.getBigDecimal("unplanlockamt"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, planEntry.getBigDecimal("unplansettleamt"));
            BigDecimal priceTaxLocalTotal = planEntry.getBigDecimal("planpricetaxloc");
            BaseDataUnitTest.assertAmtEquals(priceTaxLocalTotal, planEntry.getBigDecimal("unplansettlelocamt"));
            remainPlanTotalAmt = remainPlanTotalAmt.add(priceTaxTotal);
            remainPlanLocalTotalAmt = remainPlanLocalTotalAmt.add(priceTaxLocalTotal);
        }
        BigDecimal headLocalAmt = bill.getBigDecimal("pricetaxtotalbase");
        BaseDataUnitTest.assertAmtEquals(expectedAmt, remainDetailTotalAmt);
        BaseDataUnitTest.assertAmtEquals(headLocalAmt, remainDetailLocalTotalAmt);
        BaseDataUnitTest.assertAmtEquals(expectedAmt, remainPlanTotalAmt);
        BaseDataUnitTest.assertAmtEquals(headLocalAmt, remainPlanLocalTotalAmt);
    }

    private void checkPayBill(BigDecimal expectedAmt, DynamicObject bill) {
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("actpayamt"));
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
        BigDecimal remainTotalAmt = BigDecimal.ZERO;
        for (DynamicObject entry : entries) {
            BigDecimal priceTaxTotal = entry.getBigDecimal("e_payableamt");
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, entry.getBigDecimal("e_actamt"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, entry.getBigDecimal("e_unlockamt"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, entry.getBigDecimal("e_unsettledamt"));
            BigDecimal priceTaxLocalTotal = entry.getBigDecimal("e_payablelocamt");
            BaseDataUnitTest.assertAmtEquals(priceTaxLocalTotal, entry.getBigDecimal("e_unsettledlocalamt"));
            remainTotalAmt = remainTotalAmt.add(priceTaxTotal);
        }
        BaseDataUnitTest.assertAmtEquals(expectedAmt, remainTotalAmt);
    }

    private void checkArBill(BigDecimal expectedAmt, DynamicObject bill) {
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("recamount"));
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("amount"));
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("unsettleamount"));
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("unverifyamount"));
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("uninvoicedamt"));
        DynamicObjectCollection detailEntries = bill.getDynamicObjectCollection("entry");
        BigDecimal remainDetailTotalAmt = BigDecimal.ZERO;
        BigDecimal remainDetailLocalTotalAmt = BigDecimal.ZERO;
        for (DynamicObject detailEntry : detailEntries) {
            BigDecimal priceTaxTotal = detailEntry.getBigDecimal("e_recamount");
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, detailEntry.getBigDecimal("e_amount"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, detailEntry.getBigDecimal("e_unlockamt"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, detailEntry.getBigDecimal("e_unsettleamt"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, detailEntry.getBigDecimal("e_unverifyamt"));
            BigDecimal priceTaxLocalTotal = detailEntry.getBigDecimal("e_reclocalamt");
            BaseDataUnitTest.assertAmtEquals(priceTaxLocalTotal, detailEntry.getBigDecimal("e_unsettlelocalamt"));
            remainDetailTotalAmt = remainDetailTotalAmt.add(priceTaxTotal);
            remainDetailLocalTotalAmt = remainDetailLocalTotalAmt.add(priceTaxLocalTotal);
        }
        DynamicObjectCollection planEntries = bill.getDynamicObjectCollection("planentity");
        BigDecimal remainPlanTotalAmt = BigDecimal.ZERO;
        BigDecimal remainPlanLocalTotalAmt = BigDecimal.ZERO;
        for (DynamicObject planEntry : planEntries) {
            BigDecimal priceTaxTotal = planEntry.getBigDecimal("planpricetax");
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, planEntry.getBigDecimal("unplanlockamt"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, planEntry.getBigDecimal("unplansettleamt"));
            BigDecimal priceTaxLocalTotal = planEntry.getBigDecimal("planpricetaxloc");
            BaseDataUnitTest.assertAmtEquals(priceTaxLocalTotal, planEntry.getBigDecimal("unplansettlelocamt"));
            remainPlanTotalAmt = remainPlanTotalAmt.add(priceTaxTotal);
            remainPlanLocalTotalAmt = remainPlanLocalTotalAmt.add(priceTaxLocalTotal);
        }
        BigDecimal headLocalAmt = bill.getBigDecimal("reclocalamt");
        BaseDataUnitTest.assertAmtEquals(expectedAmt, remainDetailTotalAmt);
        BaseDataUnitTest.assertAmtEquals(headLocalAmt, remainDetailLocalTotalAmt);
        BaseDataUnitTest.assertAmtEquals(expectedAmt, remainPlanTotalAmt);
        BaseDataUnitTest.assertAmtEquals(headLocalAmt, remainPlanLocalTotalAmt);
    }

    private void checkRecBill(BigDecimal expectedAmt, DynamicObject bill) {
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("actrecamt"));
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
        BigDecimal remainTotalAmt = BigDecimal.ZERO;
        for (DynamicObject entry : entries) {
            BigDecimal priceTaxTotal = entry.getBigDecimal("e_receivableamt");
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, entry.getBigDecimal("e_actamt"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, entry.getBigDecimal("e_unlockamt"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, entry.getBigDecimal("e_unsettledamt"));
            BigDecimal priceTaxLocalTotal = entry.getBigDecimal("e_receivablelocamt");
            BaseDataUnitTest.assertAmtEquals(priceTaxLocalTotal, entry.getBigDecimal("e_unsettledlocalamt"));
            remainTotalAmt = remainTotalAmt.add(priceTaxTotal);
        }
        BaseDataUnitTest.assertAmtEquals(expectedAmt, remainTotalAmt);
    }

    private void checkBusApBill(BigDecimal expectedAmt, DynamicObject bill) {
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("pricetaxtotal"));
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("amount"));
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("unwoffamt"));
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("uninvoicedamt"));
        DynamicObjectCollection detailEntries = bill.getDynamicObjectCollection("entry");
        BigDecimal remainDetailTotalAmt = BigDecimal.ZERO;
        BigDecimal remainDetailLocalTotalAmt = BigDecimal.ZERO;
        for (DynamicObject detailEntry : detailEntries) {
            BigDecimal priceTaxTotal = detailEntry.getBigDecimal("e_pricetaxtotal");
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, detailEntry.getBigDecimal("e_amount"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, detailEntry.getBigDecimal("e_uninvoicedamt"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, detailEntry.getBigDecimal("e_unwoffamt"));
            BigDecimal priceTaxLocalTotal = detailEntry.getBigDecimal("e_pricetaxtotalbase");
            BaseDataUnitTest.assertAmtEquals(priceTaxLocalTotal, detailEntry.getBigDecimal("e_uninvoicedlocamt"));
            BaseDataUnitTest.assertAmtEquals(priceTaxLocalTotal, detailEntry.getBigDecimal("e_unwofflocamt"));
            remainDetailTotalAmt = remainDetailTotalAmt.add(priceTaxTotal);
            remainDetailLocalTotalAmt = remainDetailLocalTotalAmt.add(priceTaxLocalTotal);
        }
        BigDecimal headLocalAmt = bill.getBigDecimal("pricetaxtotalbase");
        BaseDataUnitTest.assertAmtEquals(expectedAmt, remainDetailTotalAmt);
        BaseDataUnitTest.assertAmtEquals(headLocalAmt, remainDetailLocalTotalAmt);
    }

    private void checkBusArBill(BigDecimal expectedAmt, DynamicObject bill) {
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("recamount"));
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("amount"));
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("unwoffamt"));
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("uninvoicedamt"));
        DynamicObjectCollection detailEntries = bill.getDynamicObjectCollection("entry");
        BigDecimal remainDetailTotalAmt = BigDecimal.ZERO;
        BigDecimal remainDetailLocalTotalAmt = BigDecimal.ZERO;
        for (DynamicObject detailEntry : detailEntries) {
            BigDecimal priceTaxTotal = detailEntry.getBigDecimal("e_recamount");
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, detailEntry.getBigDecimal("e_amount"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, detailEntry.getBigDecimal("e_uninvoicedamt"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, detailEntry.getBigDecimal("e_unwoffamt"));
            BigDecimal priceTaxLocalTotal = detailEntry.getBigDecimal("e_reclocalamt");
            BaseDataUnitTest.assertAmtEquals(priceTaxLocalTotal, detailEntry.getBigDecimal("e_uninvoicedlocamt"));
            BaseDataUnitTest.assertAmtEquals(priceTaxLocalTotal, detailEntry.getBigDecimal("e_unwofflocamt"));
            remainDetailTotalAmt = remainDetailTotalAmt.add(priceTaxTotal);
            remainDetailLocalTotalAmt = remainDetailLocalTotalAmt.add(priceTaxLocalTotal);
        }
        BigDecimal headLocalAmt = bill.getBigDecimal("reclocalamt");
        BaseDataUnitTest.assertAmtEquals(expectedAmt, remainDetailTotalAmt);
        BaseDataUnitTest.assertAmtEquals(headLocalAmt, remainDetailLocalTotalAmt);
    }

    private void checkPayApplyBill(BigDecimal expectedAmt, DynamicObject bill) {
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("applyamount"));
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("approvalamount"));
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
        BigDecimal remainTotalAmt = BigDecimal.ZERO;
        for (DynamicObject entry : entries) {
            BigDecimal priceTaxTotal = entry.getBigDecimal("e_payamount");
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, entry.getBigDecimal("e_applyamount"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, entry.getBigDecimal("e_approvedamt"));
            remainTotalAmt = remainTotalAmt.add(priceTaxTotal);
        }
        BaseDataUnitTest.assertAmtEquals(expectedAmt, remainTotalAmt);
    }

    private void checkPaidBill(BigDecimal expectedAmt, DynamicObject bill) {
        BaseDataUnitTest.assertAmtEquals(expectedAmt, bill.getBigDecimal("actpayamt"));
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
        BigDecimal remainTotalAmt = BigDecimal.ZERO;
        BigDecimal remainTotalLocalAmt = BigDecimal.ZERO;
        for (DynamicObject entry : entries) {
            BigDecimal priceTaxTotal = entry.getBigDecimal("e_actamt");
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, entry.getBigDecimal("e_unlockamt"));
            BaseDataUnitTest.assertAmtEquals(priceTaxTotal, entry.getBigDecimal("e_unsettledamt"));
            BigDecimal priceTaxLocalTotal = entry.getBigDecimal("e_localamt");
            BaseDataUnitTest.assertAmtEquals(priceTaxLocalTotal, entry.getBigDecimal("e_unsettledlocalamt"));
            remainTotalAmt = remainTotalAmt.add(priceTaxTotal);
            remainTotalLocalAmt = remainTotalLocalAmt.add(priceTaxLocalTotal);
        }
        BaseDataUnitTest.assertAmtEquals(expectedAmt, remainTotalAmt);
        BaseDataUnitTest.assertAmtEquals(remainTotalLocalAmt, bill.getBigDecimal("localamt"));
    }

    private static void assertAmtEquals(BigDecimal expectedAmt, BigDecimal actualAmt) {
        BaseDataUnitTest.assertEquals((boolean)true, (expectedAmt.compareTo(actualAmt.setScale(2, RoundingMode.HALF_UP)) == 0 ? 1 : 0) != 0);
    }
}

