/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.math.BigDecimal;
import java.util.Collections;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import org.junit.Test;

public class AP016_001_ApFinWriteOffTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u8d22\u52a1\u5e94\u4ed8\uff08\u51b2\u9500\uff09\uff08\u6b63\u8d1f\u5206\u5f55\u5f02\u5e01\u522b\u6570\u636e\uff09")
    @Test
    public void ApFinUnitTest_001() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill("AP016_001_apfin_1", true, true, false);
        this.executeWriteOffAndValidate(finBill);
        finBill = FinApBillTestDataProvider.createFinApBill("AP016_001_apfin_2", true, true, true);
        this.executeWriteOffAndValidate(finBill);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u8d22\u52a1\u5e94\u4ed8\uff08\u51b2\u9500\uff09\uff08\u7269\u6599\u884c,\u4eba\u6c11\u5e01\uff0c0\u91d1\u989d\u6570\u636e\uff09")
    @Test
    public void ApFinUnitTest_002() {
        FinApBillDataVO headVo = FinApBillTestDataProvider.structureFinApHeadVo("AP016_001_apfin_2", false, true, false);
        FinApBillDataDetailVO detailVo = FinApBillDataDetailVO.New().setMaterial(BaseDataTestProvider.getMaterial()).setQuantity(BigDecimal.ONE).setPrice(BigDecimal.ZERO);
        DynamicObject finBill = FinApBillTestDataProvider.buildByPriceAndQuantity(headVo, Collections.singletonList(detailVo));
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(finBill.getLong("id"));
        long writeOffBillId = writeOffBill.getLong("id");
        finBill = BusinessDataServiceHelper.loadSingle((Object)finBill.getLong("id"), (String)"ap_finapbill");
        FinApBillTestChecker.validateFinishApFin(finBill, true, true);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBillId}, (OperateOption)OperateOption.create());
        AP016_001_ApFinWriteOffTest.assertEquals((String)"\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)unAudit.isSuccess());
        finBill = BusinessDataServiceHelper.loadSingle((Object)finBill.getLong("id"), (String)"ap_finapbill");
        FinApBillTestChecker.validateFinishApFin(finBill, true, false);
    }

    private void executeWriteOffAndValidate(DynamicObject finBill) {
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(finBill.getLong("id"));
        FinApBillTestChecker.validateFinishApFin(writeOffBill, true, true);
        finBill = BusinessDataServiceHelper.loadSingle((Object)finBill.getLong("id"), (String)"ap_finapbill");
        long writeOffBillId = writeOffBill.getLong("id");
        FinApBillTestChecker.validateFinishApFin(finBill, true, true);
        FinApBillTestChecker.validateApFinVerifyRecordData(finBill.getLong("id"), writeOffBillId);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finBill.getLong("id")}, new Long[]{writeOffBillId}, false);
        OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBillId}, (OperateOption)OperateOption.create());
        AP016_001_ApFinWriteOffTest.assertEquals((String)"\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u5931\u8d25", (boolean)true, (boolean)unAudit.isSuccess());
        finBill = BusinessDataServiceHelper.loadSingle((Object)finBill.getLong("id"), (String)"ap_finapbill");
        FinApBillTestChecker.validateInitialApFin(finBill);
    }
}

