/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.apfin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.PayApplyBillTestHelper;
import org.junit.Test;

public class AP016_007_ApFin2PayApplyTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deleteApplys = Arrays.asList("AP016_007_apply_1", "AP016_007_apply_2", "AP016_007_apply_3");
        DeleteServiceHelper.delete((String)"ap_payapply", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteApplys)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u7533\u8bf7(\u7269\u6599\u884c\u4e0b\u63a8)")
    @Test
    public void ApFinUnitTest_007_1() {
        DynamicObject finBillOne = FinApBillTestDataProvider.createFinApBill(false, true, false, true, "AP016_007_apfin_1");
        DynamicObject finBillTwo = FinApBillTestDataProvider.createFinApBill(false, false, false, true, "AP016_007_apfin_2");
        long pkOne = finBillOne.getLong("id");
        long pkTwo = finBillTwo.getLong("id");
        DynamicObject[] applyBills_1 = PayApplyBillTestHelper.pushPayApplyBill(BigDecimal.valueOf(70L), "ap_finapbill", Arrays.asList(pkOne, pkTwo), "AP016_007_apply_1");
        finBillOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_finapbill");
        this.validateApFinDetailLockAmt(finBillOne, BigDecimal.ZERO, BigDecimal.valueOf(70L), BigDecimal.valueOf(15L), BigDecimal.valueOf(15L));
        this.validateApFinPlanLockAmt(finBillOne, BigDecimal.valueOf(15L), BigDecimal.valueOf(55L), BigDecimal.ZERO, BigDecimal.valueOf(30L));
        finBillTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_finapbill");
        this.validateApFinDetailLockAmt(finBillTwo, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        this.validateApFinPlanLockAmt(finBillTwo, BigDecimal.valueOf(50L), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(40L));
        DynamicObject[] applyBills_2 = PayApplyBillTestHelper.fullPushPayApply("ap_finapbill", Arrays.asList(pkOne, pkTwo), "AP016_007_apply_2");
        finBillOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_finapbill");
        this.validateApFinDetailLockAmt(finBillOne, BigDecimal.valueOf(70L), BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.ZERO);
        this.validateApFinPlanLockAmt(finBillOne, BigDecimal.valueOf(70L), BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.ZERO);
        finBillTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_finapbill");
        this.validateApFinDetailLockAmt(finBillTwo, BigDecimal.valueOf(60L), BigDecimal.ZERO, BigDecimal.valueOf(40L), BigDecimal.ZERO);
        this.validateApFinPlanLockAmt(finBillTwo, BigDecimal.valueOf(60L), BigDecimal.ZERO, BigDecimal.valueOf(40L), BigDecimal.ZERO);
        this.deletePayApply(applyBills_1);
        finBillOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_finapbill");
        this.validateApFinDetailLockAmt(finBillOne, BigDecimal.valueOf(70L), BigDecimal.ZERO, BigDecimal.valueOf(15L), BigDecimal.valueOf(15L));
        this.validateApFinPlanLockAmt(finBillOne, BigDecimal.valueOf(70L), BigDecimal.ZERO, BigDecimal.valueOf(15L), BigDecimal.valueOf(15L));
        finBillTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_finapbill");
        this.validateApFinDetailLockAmt(finBillTwo, BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        this.validateApFinPlanLockAmt(finBillTwo, BigDecimal.valueOf(50L), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(40L));
        this.deletePayApply(applyBills_2);
        finBillOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_finapbill");
        finBillTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_finapbill");
        FinApBillTestChecker.validateInitialApFin(finBillOne);
        FinApBillTestChecker.validateInitialApFin(finBillTwo);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u7533\u8bf7(\u8ba1\u5212\u884c\u4e0b\u63a8)")
    @Test
    public void ApFinUnitTest_007_2() {
        DynamicObject finBillOne = FinApBillTestDataProvider.createFinApBill(true, true, false, true, "AP016_007_apfin_3");
        DynamicObject finBillTwo = FinApBillTestDataProvider.createFinApBill(true, false, false, true, "AP016_007_apfin_4");
        long pkOne = finBillOne.getLong("id");
        long pkTwo = finBillTwo.getLong("id");
        DynamicObject[] applyBills = PayApplyBillTestHelper.pushPayApplyBill(BigDecimal.valueOf(60L), "ap_finapbill", Arrays.asList(pkOne, pkTwo), "B", "AP016_007_apply_3");
        finBillOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_finapbill");
        this.validateApFinDetailLockAmt(finBillOne, BigDecimal.valueOf(35L), BigDecimal.valueOf(35L), BigDecimal.valueOf(15L), BigDecimal.valueOf(15L));
        this.validateApFinPlanLockAmt(finBillOne, BigDecimal.valueOf(35L), BigDecimal.valueOf(35L), BigDecimal.valueOf(15L), BigDecimal.valueOf(15L));
        finBillTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_finapbill");
        this.validateApFinDetailLockAmt(finBillTwo, BigDecimal.valueOf(12L), BigDecimal.valueOf(48L), BigDecimal.valueOf(8L), BigDecimal.valueOf(32L));
        this.validateApFinPlanLockAmt(finBillTwo, BigDecimal.ZERO, BigDecimal.valueOf(60L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
        PayApplyBillTestHelper.changeApprovedAmt(applyBills);
        finBillOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_finapbill");
        this.validateApFinDetailLockAmt(finBillOne, BigDecimal.valueOf(17.5), BigDecimal.valueOf(52.5), BigDecimal.valueOf(7.5), BigDecimal.valueOf(22.5));
        this.validateApFinPlanLockAmt(finBillOne, BigDecimal.valueOf(17.5), BigDecimal.valueOf(52.5), BigDecimal.valueOf(7.5), BigDecimal.valueOf(22.5));
        finBillTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_finapbill");
        this.validateApFinDetailLockAmt(finBillTwo, BigDecimal.valueOf(6.0), BigDecimal.valueOf(54.0), BigDecimal.valueOf(4.0), BigDecimal.valueOf(36.0));
        this.validateApFinPlanLockAmt(finBillTwo, BigDecimal.ZERO, BigDecimal.valueOf(60L), BigDecimal.valueOf(10.0), BigDecimal.valueOf(30.0));
        this.deletePayApply(applyBills);
        finBillOne = BusinessDataServiceHelper.loadSingle((Object)pkOne, (String)"ap_finapbill");
        finBillTwo = BusinessDataServiceHelper.loadSingle((Object)pkTwo, (String)"ap_finapbill");
        FinApBillTestChecker.validateInitialApFin(finBillOne);
        FinApBillTestChecker.validateInitialApFin(finBillTwo);
    }

    private void validateApFinDetailLockAmt(DynamicObject finBill, BigDecimal lockOne, BigDecimal unlockOne, BigDecimal lockTwo, BigDecimal unlockTwo) {
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
        DynamicObject rowOne = (DynamicObject)detailEntry.get(0);
        FinApBillTestChecker.validateApFinDetailLockAmt(rowOne, lockOne, unlockOne);
        DynamicObject rowTwo = (DynamicObject)detailEntry.get(1);
        FinApBillTestChecker.validateApFinDetailLockAmt(rowTwo, lockTwo, unlockTwo);
    }

    private void validateApFinPlanLockAmt(DynamicObject finBill, BigDecimal lockOne, BigDecimal unlockOne, BigDecimal lockTwo, BigDecimal unlockTwo) {
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        DynamicObject rowOne = (DynamicObject)planEntity.get(0);
        FinApBillTestChecker.validateApFinPlanLockAmt(rowOne, lockOne, unlockOne);
        DynamicObject rowTwo = (DynamicObject)planEntity.get(1);
        FinApBillTestChecker.validateApFinPlanLockAmt(rowTwo, lockTwo, unlockTwo);
    }

    private void deletePayApply(DynamicObject[] applys) {
        Object[] applyIds = (Long[])Arrays.stream(applys).map(payBill -> payBill.getLong("id")).toArray(Long[]::new);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_payapply", (Object[])applyIds, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"ap_payapply", (Object[])applyIds, (OperateOption)option);
    }
}

